#if !defined(__ROBAKI_H)
#define __ROBAKI_H

#include "pla_skl.h"

extern int gracz_umiejetnosci;


#define ZAKAZ_PG  1
#define ZAKAZ_PD  2
#define ZAKAZ_LD  4
#define ZAKAZ_LG  8
#define ZAKAZ_G   0x10
#define ZAKAZ_P   0x20
#define ZAKAZ_D   0x40
#define ZAKAZ_L   0x80


struct TMostki12
  {
  private:
  unsigned short int mwlky;
  public:
    int dx[12], dy[12], dind[12], puste1[12], puste2[12], puste3[12];
  int nie_nasza1a[8], nie_nasza2a[8], nie_nasza1b[8], nie_nasza2b[8];
  TMostki12()
    {
    dx[0]=-1; dx[1]=1; dx[2]=2; dx[3]=2; dx[4]=1; dx[5]=-1; dx[6]=-2; dx[7]=-2;
    dy[0]=-2; dy[1]=-2; dy[2]=-1; dy[3]=1; dy[4]=2; dy[5]=2; dy[6]=1; dy[7]=-1;
    dx[8]=0;  dx[9]=2;  dx[10]=0;  dx[11]=-2;
    dy[8]=-2; dy[9]=0;  dy[10]=2;  dy[11]=0;
    mwlky=0;
    };
  void Inicjuj();
};

extern TMostki12 most12;

void ZnajdzMostki12(krint *mostki, unsigned char *rozgr2, unsigned char *rozgr3,
		    TDwaUC marg_min, TDwaUC marg_max, int ktory_gracz);

class TPoziom;

class TRobaki {
  friend class TPoziom;  // naprawde tylko TPoziom::OcenBMsciezki
  // wskazniki:
  krint *robaki, *nast_kropka_robaka;    // skladowe (musza miec wlkx4wlky4 el.)
  krint *polaczenia;                     // listy (moga miec nieco mniej niz wlkx4wlky4 el.
  krint *polaczenia_odl;                 // lista  (polaczenia odlegle)
  krint *straty, *dolne_kropki;          // tablice indeksowane
  unsigned char *na_pewno_bezp;          //    numerami robakow
  int ost_nr_robaka, ile_polaczen2;      // ile_polaczen2 = liczba polaczen x 2
  int ile_polaczen_odl3;                 // ile_polaczen_odl4 = liczba polaczen odleglych x 3
  // tablice:
  krint *robaki_tab, *nast_kropka_robaka_tab;
  //  krint *lista_naszych_tab, *lista_naszych;
  //  int   ile_naszych;
  krint *polaczenia_tab, *polaczenia_odl_tab;
  krint *straty_tab, *dolne_kropki_tab;
  unsigned char *na_pewno_bezp_tab;
  // zmienne dla UsunKropke():
  int ind_robaka, zap_wart_npbezp, zap_indeks, zap_dolna, sposob_odtw;
  // zmienne ustawiane (raz na zawsze) na zewnatrz klasy:
  int czyje;   // czyje sa te robaki
  int maska_sstopu;
  //  
  void DodajRobaka(const unsigned char *rozgrywka, const unsigned char *rozgr2, 
		   const unsigned char *rozgr3, const unsigned char *plansz_p,
		   krint *stos, int indeks);
  void DodajOdlPol_pion(unsigned char *rozgrywka, unsigned int indeks);
  void DodajOdlPol_poziom(unsigned char *rozgrywka, unsigned int indeks);
  void DodajPolaczenia(unsigned char *rozgrywka, unsigned int indeks);
  void SkopiujPotrzebne(krint *poprz);
  void SkopiujPotrzebneOdl(unsigned char *rozgrywka, krint *poprz_odl);
  int ZakazanePomiedzy(unsigned char *zakazane, unsigned int k1, unsigned int k2);
public:
  static int waga_kropki;   // parametr poziomu 12
  void Przydziel();
  void Zwolnij();
  void UstawCzyje(int kto, int niska_ocena_duzych_brz);
  void Inicjuj(unsigned char *rozgrywka, unsigned char *rozgr2, unsigned char *rozgr3, 
	       unsigned char *plansz_p);
  void DodajKropke(TRobaki &poprz, unsigned char *rozgrywka, unsigned char *rozgr2,
		   unsigned char *rozgr3, unsigned char *plansz_p, unsigned int indeks,
		   int byl_stop, int byl_sstop);
  void UaktualnijGleb();
  void UsunKropke();
  void OdtworzKropke();
  int  ZnajdzRobakiMatki(unsigned char *plansz_p, unsigned char *zakazane, 
			 unsigned char *bezpieczne,
			 TDwaUC marg3_min, TDwaUC marg3_max,
			 krint *goradol, krint *stratyskl);
  int  ZnajdzRobakiMatki(unsigned char *plansz_p, unsigned char *zakazane, 
			 unsigned char *bezpieczne,
			 TDwaUC marg3_min, TDwaUC marg3_max,
			 krint *goradol, krint *stratyskl,
			 krint *polaczony_z, krint *dolne_m);
  void UstawZakazane(unsigned char *zakazane, const unsigned char *rozgr3, const krint *skl_tab) const;
  //  friend void TPoziom::OcenBMsciezki(unsigned char *rozgrywka, TAnaliza& ang0, TAnaliza const* ang1);
  //  long int WezPoprawkeNaSklPop(unsigned char *rozgr3, long int *oceny);
  //  void PorownajZeSklnr(krint *sklnr, krint *stratynr, krint *goradol, int ilesklnr);
  void UstawPolaczonyZ_sklad(krint *polaczony_z) const;
  void ZnajdzSkladowe(krint *skl_tab, int nrpoczskl, unsigned char *rozgr2) const;
  int OcenRuch(unsigned char *rozgr3, krint *polaczony_z, unsigned int indeks, 
	       int nasze, int &poziom_bezp) const;
  TRobaki& operator=(const TRobaki& arg);
};


void CzyscZakazaneWProstokacie(unsigned char *zakazane, krint *dod_pola,
			       TDwaUC marg3_min, TDwaUC marg3_max);

void UstawZakazane12(unsigned char *zakazane,
		     unsigned char* rozg, krint *skl_tab,
		     int ktory_gracz,
		     TDwaUC marg3_min, TDwaUC marg3_max);

#endif
