/*  Programik do gry w kropki.
 *
 *  Copyright (C) 2003,2004,2005 Bartek Dyda <kropki@yahoo.co.uk>.
 * 
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "sstop3.h"

#ifdef SA_STOPERY

// super-stopery
//   ssStart(i)   -- wlacza stoper nr i (od 0 do 31)
//   ssStop(i)    -- wylacza stoper nr i (od 0 do 31)
//   ssPodaj(i)   -- zwraca liczbe setek tysiecy cykli na stoperze
//   ssZeruj(i)   -- zeruje stoper
static long long int ss_stopery[32];
static long int ss_wlaczony[32];

void ssStart(int i)
// startuje stoper
{
 if (!ss_wlaczony[i])
  {
  asm("pushl %%eax;" "pushl %%edx;" "rdtsc;"
  "subl 0(%%esi),%%eax;"
  "sbbl 4(%%esi),%%edx;"
  "movl %%eax,0(%%esi);"
  "movl %%edx,4(%%esi);"
  "popl %%edx;" "popl %%eax;"
  :
  :"S" (&ss_stopery[i])
  : "memory", "%cc"         // zmienia pamiec, flagi
  );
  ss_wlaczony[i]=1;
  }
}

void ssStop(int i)
// zatrzymuje stoper
{
 if (ss_wlaczony[i])
  {
  asm("pushl %%eax;" "pushl %%edx;" "rdtsc;"
  "subl 0(%%esi),%%eax;"
  "sbbl 4(%%esi),%%edx;"
  "movl %%eax,0(%%esi);"
  "movl %%edx,4(%%esi);"
  "popl %%edx;" "popl %%eax;"
  :
  :"S" (&ss_stopery[i])
  : "memory", "%cc"         // zmienia pamiec, flagi
  );
  ss_wlaczony[i]=0;
  }
}

long int ssPodaj(int i)
// podaje odczyt w setkach tysiecy cykli
{
 long int wynik=0;
 ssStop(i);
// if (!ss_wlaczony[i])
   {
 asm("pushl %%eax;" "pushl %%edx;" "pushl %%ebx;"
 "movl 0(%%esi),%%eax;"
 "movl 4(%%esi),%%edx;"
 "movl $100000,%%ebx;"
 "divl %%ebx;"
 "movl %%eax,0(%%edi);"
 "popl %%ebx;" "popl %%edx;" "popl %%eax;"
 :
 :"S" (&ss_stopery[i]),
  "D" (&wynik)
 : "memory", "%cc"         // zmienia pamiec, flagi
 );
  }
 return wynik;
}

inline void ssZeruj(int i)
{ ss_stopery[i]=0; ss_wlaczony[i]=0; }

inline void ssZeruj()
{ for (int i=0; i<sizeof(ss_stopery)/sizeof(ss_stopery[0]); i++)
   { ss_stopery[i]=0; ss_wlaczony[i]=0; }
}

#endif


