#include <string.h>
#include <ctype.h>
#include <pthread.h>
#include "basic.h"
#include "sstop3.h"
#include "pla_skl.h"

int zasady_gry = 2;

TRuchyZam ruchy_zam_NULL;    // zerowe ruchy zamykajace, do przekazywania jako domyslny par.

void TRuchyZam::Przydziel()
{ 
  ile=0;
  int nowa_wlk_pam = 1+(wlkx-2)*(wlky-2)/2;
  if (nowa_wlk_pam<=wlk_pam) return;   // pamieci wystarczy, nic nie rob
  Zwolnij();
  if (zasady_gry==2) {
    tab = new TRuchZam[wlk_pam = nowa_wlk_pam];
    ile=0;
  }
}

void TRuchyZam::DodajRuch(krint r, TZdobycze z[], TZobrist k)
{
  if (tab!=NULL) {
    tab[ile].ruch = r;
    tab[ile].zd[0]= z[0];
    tab[ile].zd[1]= z[1];
    tab[ile].id   = k;
    // test
    /*
    char s[50];
    sprintf(s,"(%d,%d): zd=%d, ss=%d, pot=%d", 
	    int(upl_x[r & ~0x6000]), int(upl_y[r & ~0x6000]), z[0].zd, z[0].ss, z[0].pot_zd);
    ekran.WyswietlNapis(s);
    */
    //
    ile++;
  }
}


unsigned long int bseed1=0;
unsigned long int bseed2=0;

pthread_mutex_t random_mutex = PTHREAD_MUTEX_INITIALIZER;

unsigned short int random(unsigned short int n)
{
  pthread_mutex_lock(&random_mutex);
  bseed1 = ((bseed1 << 12 ) + 150889) % 714025;
  bseed2 = ((bseed2 * 1597) + 51749 ) % 244944;
  unsigned short int wynik = (bseed1 + bseed2) % n;
  pthread_mutex_unlock(&random_mutex);
  return wynik;
}

void brandomize()
{
 struct timeval czas;
 gettimeofday(&czas, NULL);
 bseed1 = czas.tv_sec % 714025;    // liczby 714025 i 244944
 bseed2 = czas.tv_sec % 244944;    // sa wzglednie pierwsze!
}


char* SGFDopiszPole(char *gdzie, krint pole)
// dopisuje dwa znaki oznaczajace [pole] do lancucha gdzie
{
  assert(upl_x[pole]>=2 && upl_x[pole]<wlkx+2 && upl_y[pole]>=2 && upl_y[pole]<wlky+2);
  const char *sgf_pola="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
  sprintf(&gdzie[strlen(gdzie)], "%c%c", sgf_pola[upl_x[pole]-2], sgf_pola[upl_y[pole]-2]);
  return gdzie;
}

int SGFDajPole(char *wsp)
// zwraca [ind] pola lub -1, gdy wsp. niepoprawne
{
  int x,y;
  if (wsp[0]>='a' && wsp[0]<='z')
    x = wsp[0] - 'a';
  else if (wsp[0]>='A' && wsp[0]<='Z')
    x = wsp[0] - 'A' + 26;
  else return -1;
  if (wsp[1]>='a' && wsp[1]<='z')
    y = wsp[1] - 'a';
  else if (wsp[1]>='A' && wsp[1]<='Z')
    y = wsp[1] - 'A' + 26;
  else return -1;
  if (x>=wlkx || y>=wlky) return -1;
  return WezIndeksTab(x+2, y+2);
}

unsigned int tablica_kierunkow[9]={7,0,1, 6,8,2, 5,4,3};  // 8=bez sensu
int kierunki_dx[8] = {0,1,1,1, 0,-1,-1,-1};
int kierunki_dy[8] = {-1,-1,0,1, 1,1,0,-1};
void Polacz(unsigned char*tab, int x1, int y1, int x2, int y2)
// laczy kreska dwie (sasiednie) kropki (x1,y1) i (x2,y2)
{
 unsigned int kier=tablica_kierunkow[ (x2-x1) + (y2-y1)*3 +4];
 unsigned char maska=(1<<kier);
 tab[x1*(wlky+4)+y1] |= maska;
 kier^=4;  maska=(1<<kier);
 tab[x2*(wlky+4)+y2] |= maska;
}
int CzyPolaczone(unsigned char*tab, int x1, int y1, int x2, int y2)
// sprawdza czy dwie (sasiednie) kropki (x1,y1) i (x2,y2) sa polaczone
{
 unsigned int kier=tablica_kierunkow[ (x2-x1) + (y2-y1)*3 +4];
 unsigned char maska=(1<<kier);
 return (tab[x1*(wlky+4)+y1] & maska) != 0;
}

int UstawOtoczenie(unsigned char otoczenie[9])
// uklad pol w tablicy otoczenie:
//   0 1 2
//   3 4 5
//   6 7 8.
{
 unsigned char czyja=otoczenie[4];
 // ponumeruj nasze kropki z sasiedztwa
 for (int i=0; i<4; i++)
   if (otoczenie[i]==czyja)
     otoczenie[i]=i+1;
   else
     otoczenie[i]=0;
 for (int i=5; i<9; i++)
   if (otoczenie[i]==czyja)
     otoczenie[i]=i;
   else
     otoczenie[i]=0;
 // teraz znajdz skladowe spojnosci
 int ost=0;
 if (otoczenie[1])
   {
   //if (otoczenie[0]) otoczenie[0]=1;  // -nie trzeba, bo to i tak =0 lub 1
   otoczenie[1]=1;
   if (otoczenie[2]) otoczenie[2]=1;
   if (otoczenie[3]) otoczenie[3]=1;
   if (otoczenie[5]) otoczenie[5]=1;
   ost=1;
   }
 if (otoczenie[3])
   {
   // [0] i [1] nie trzeba zmieniac
   otoczenie[3]=1;
   if (otoczenie[6]) otoczenie[6]=1;
   if (otoczenie[7]) otoczenie[7]=1;
   ost=1;
   }
 if (otoczenie[5])
   {
   if (!otoczenie[1] && (otoczenie[7]!=1)) ost++;
   // [1] nie trzeba zmieniac
   if (otoczenie[2]) otoczenie[2]=ost;
   otoczenie[5]=ost;
   if (otoczenie[7]) otoczenie[7]=ost;
   if (otoczenie[8]) otoczenie[8]=ost;
   }
 if (otoczenie[7]==7)
   {
   ost++;
   // [3] i [5] nie trzeba zmieniac - one sa w tym przypadku =0
   if (otoczenie[6]) otoczenie[6]=ost;
   otoczenie[7]=ost;
   if (otoczenie[8]) otoczenie[8]=ost;
   }
 else
   if (otoczenie[7])
     {
     if (otoczenie[6]) otoczenie[6]=otoczenie[7];
     if (otoczenie[8]) otoczenie[8]=otoczenie[7];
     }
 // ustaw ew. narozniki
 if (otoczenie[0] && !otoczenie[1] && !otoczenie[3])
   otoczenie[0]=++ost;
 if (otoczenie[2]==3)
   otoczenie[2]=++ost;
 if (otoczenie[6]==6)
   otoczenie[6]=++ost;
 if (otoczenie[8]==8)
   otoczenie[8]=++ost;
 return ost;
}

void ZnajdzSkladowa(krint *skl, unsigned char* pl,
                    unsigned int numskl,
                    unsigned int ind)
// [ind] - punkt, ktorego skladowa spojnosci chcemy znalezc
{
 unsigned char czyja = pl[ind];
 skl[ind] =numskl; // punkt p nalezy do swojej skladowej spojnosci
 // wsadz na stos [ind]
 krint *stos = skladowe.PrzydzielSkladowa();
 stos[0] = ind;
 int na_stosie = 1;
 do
   {
   ind = stos[--na_stosie];
   // przejdz punkty obok
   // idz w gore
   { unsigned int nind = ind +W_G;
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   nind+= W_DD;   // idz w dol
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     } }
   // idz w lewo gore
   { unsigned int nind = ind + W_LG;
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   nind+=W_D;  // idz w lewo
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   nind+=W_D;  // idz w lewo dol
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   }
   // idz w prawo gore
   { unsigned int nind = ind+W_PG;
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   nind+=W_D;  // idz w prawo
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   nind+=W_D;  // idz w prawo dol
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   }
	}
 while (na_stosie);
 skladowe.ZwolnijSkladowa(stos);
}

void WezRozgr23(unsigned char *rozgrywka, unsigned char *rozgr2, unsigned char *rozgr3,
                unsigned char *plansz_p)
{
 KopiujTablice(rozgr2, rozgrywka);
 KopiujTablice(rozgr3, rozgrywka);
 for (int i=up.lg; i<=up.pd; i++) {
   if (plansz_p[i] & 0x43)  // pole jest wewnatrz stopu/lancucha
     rozgr2[i]=0;           // wiec usun z niego ew. kropke w rozgr2
   if (plansz_p[i] & 0x5)   // pole jest wewnatrz stopu lub stalego stopu gr1
     rozgr3[i]=1;           // wiec wstaw kropke ,,1'' w rozgr3
   else if (plansz_p[i] & 0xa)
     rozgr3[i]=2;           // ...lub kropke ,,2'', jesli to jest u gracza 2
 }
}


void WezRozgr4(unsigned char *rozgrywka, unsigned char *rozgr4,
	       unsigned char *plansz_p)
{
 KopiujTablice(rozgr4, rozgrywka);
 if (zasady_gry==0) {
   for (int i=up.lg; i<=up.pd; i++) {
     if (plansz_p[i] & 0x5)   // pole jest wewnatrz stopu lub stalego stopu gr1
       rozgr4[i]=1;           // wiec wstaw kropke ,,1'' w rozgr4
     else if (plansz_p[i] & 0xa)
       rozgr4[i]=2;           // ...lub kropke ,,2'', jesli to jest u gracza 2
   }
 }
 else { // zasady_gry>0
   for (int i=up.lg; i<=up.pd; i++) {
     if (plansz_p[i] & 0x1)   // pole jest wewnatrz stopu
       rozgr4[i]=1;           // wiec wstaw kropke ,,1'' w rozgr4
     else if (plansz_p[i] & 0x2)
       rozgr4[i]=2;           // ...lub kropke ,,2'', jesli to jest u gracza 2
   }
 }
}

void WezOtoczenie(unsigned char ot[9], int x, int y,
		  unsigned char* plansz_p, unsigned char* rozgrywka,
                  int ktory_gracz)
{
 // zawsze sprawdzaj, czy pole nie lezy wewnatrz jakiegos stopu (... & 3)
 ot[0]=(WezUC(plansz_p,x-1,y-1) & 3) ? 0 : WezUC(rozgrywka,x-1,y-1);
 ot[1]=(WezUC(plansz_p,x  ,y-1) & 3) ? 0 : WezUC(rozgrywka,x  ,y-1);
 ot[2]=(WezUC(plansz_p,x+1,y-1) & 3) ? 0 : WezUC(rozgrywka,x+1,y-1);
 ot[3]=(WezUC(plansz_p,x-1,y  ) & 3) ? 0 : WezUC(rozgrywka,x-1,y  );
 ot[4]=ktory_gracz;
 ot[5]=(WezUC(plansz_p,x+1,y  ) & 3) ? 0 : WezUC(rozgrywka,x+1,y  );
 ot[6]=(WezUC(plansz_p,x-1,y+1) & 3) ? 0 : WezUC(rozgrywka,x-1,y+1);
 ot[7]=(WezUC(plansz_p,x  ,y+1) & 3) ? 0 : WezUC(rozgrywka,x  ,y+1);
 ot[8]=(WezUC(plansz_p,x+1,y+1) & 3) ? 0 : WezUC(rozgrywka,x+1,y+1);
}

void WezOtoczenieUlatw(unsigned char ot[9], int x, int y,
                       unsigned char* rozgr2,
		       int ktory_gracz)
{
 ot[0]=WezUC(rozgr2,x-1,y-1);
 ot[1]=WezUC(rozgr2,x  ,y-1);
 ot[2]=WezUC(rozgr2,x+1,y-1);
 ot[3]=WezUC(rozgr2,x-1,y  );
 ot[4]=ktory_gracz;
 ot[5]=WezUC(rozgr2,x+1,y  );
 ot[6]=WezUC(rozgr2,x-1,y+1);
 ot[7]=WezUC(rozgr2,x  ,y+1);
 ot[8]=WezUC(rozgr2,x+1,y+1);
}

int PustePole(unsigned char *rozgrywka, unsigned char *plansz_p, unsigned char *rozgr3,
	      unsigned int ind)
{
  return zasady_gry==0 ? (rozgr3[ind]==0) : (rozgrywka[ind]==0 && (plansz_p[ind] & 3)==0);
}

int PrzejdzWnetrze(const unsigned char *rozgrywka, const unsigned char *plansz_p,
                   unsigned char *plan, unsigned int ind, unsigned int &lewo,
                   int kto)
// zwraca 1, jesli jest (staly) stop (dla gracza kto)
// kropki wewnetrzne zostaja zaznaczone ,,1'',
//  (prawdopodobne) brzegowe -- 10,20,30 lub 40
// do ,,lewo'' wstawia indeks punktu brzegowego polozonego najbardziej na lewo
// (i na gorze, tj. o najmniejszym indeksie)
{
 CzyscTablice(plan);
 krint* stos =skladowe.PrzydzielSkladowa();
 stos[0]=ind;
 plan[ind]=1;   // zaznacz jako wnetrze
 int na_stosie=1;
 lewo=ind;
 do{
   ind = stos[--na_stosie];
   // idz na boki
   for (int k=0; k<4; k++)
     {
     unsigned int nind = ind + up.dind[k];
     if (rozgrywka[nind]==kto && (plansz_p[nind] & 3)==0)
       {
       plan[nind]+=10;  // kropka brzegowa
       if (nind<lewo) lewo=nind;
       }
     else if (plan[nind]==0)
       {  // pole wewnatrz ew. stopu
       if (upl_marg[nind]<=2)
         {  // jestesmy na brzegu planszy, czyli stopu jednak nie ma
         skladowe.ZwolnijSkladowa(stos);
         return 0;
         }
       stos[na_stosie++]=nind;
       plan[nind]=1;  // zaznacz jako wewnetrzne
       }
     }
   }
 while (na_stosie);
 skladowe.ZwolnijSkladowa(stos);
 return 1;
}

int ZnajdzBrzegStopu(krint *dad, unsigned char *plan, unsigned int lewo)
// przechodzi graf w glab, zaczyna przechodzic punkty od najmniej do
// do najbardziej na lewo polozonego punktu
// Idziemy z punktu ,,lewo'', ktory jest punktem brzegowym najbardziej
//   wysunietym na lewo (o najmniejszym indeksie)
// We: plan[...] >= 10 -- pole [...] moze byc na brzegu (przejdz)
// Zwraca dlugosc sciezki (np. dla najprostszego panstwa zwraca 4).
{
 CzyscTablice(dad);
 // inicjacja, przydzial pamieci
 unsigned char *kierunki = plansze.PrzydzielPlansze();
 krint         *q = skladowe.PrzydzielSkladowa();
 int na_stosie=0;
 int kierunki_dind[8];
 for (int i=0; i<8; i++)
   kierunki_dind[i]= kierunki_dx[i]*W_P + kierunki_dy[i]*W_D;
 kierunki[na_stosie] = 0x74;  // 7=kier_ost, 4=kier;  kiedys bylo 5 * 0x11
 dad[ q[na_stosie++] = lewo+wlky+3 ] = lewo;
 //
 do {
 Nastepny_punkt:
   krint  pn = q[na_stosie-1];
   int kier     = (kierunki[na_stosie-1] & 0xf);
   int kier_ost = (kierunki[na_stosie-1] >> 4);
   if (--kier==-1) kier=7;
   while (kier!=kier_ost) {
     krint pn2 = pn + kierunki_dind[kier];
     if (plan[pn2]>=10 && dad[pn2]==0) {
       dad[pn2] = pn;
       if (pn2==lewo) {
	 plansze.ZwolnijPlansze(kierunki);
	 skladowe.ZwolnijSkladowa(q);
	 return na_stosie+1;
       }
       // zapamietaj aktualny kierunek
       kierunki[na_stosie-1] &= 0xf0;
       kierunki[na_stosie-1] |= kier;
       // wsadz na stos punkt pn2
       q[na_stosie] = pn2;
       int kk=(kier^4);    // wez przeciwny kierunek do ,,kier''
       kierunki[na_stosie++] = (kk<<4) + kk;
       goto Nastepny_punkt;
     }
     if (--kier==-1) kier=7;
   }
   // przeszlismy cala galaz, zdejmij punkt ze stosu
   na_stosie--;
 }
 while (na_stosie);
 plansze.ZwolnijPlansze(kierunki);
 skladowe.ZwolnijSkladowa(q);
 return 0;
}

void PolaWLancuchu(unsigned char *rozgrywka, unsigned char *plansz_p,
                   int ktory_gracz, unsigned int *pola, int ile)
// pola[i] -- lista *naszych* kropek,
// ustawia bit lancucha (0x40) w plansz_p, jesli podane
//   pola sa wewnatrz lancuchow
{
 int maska_naszego_st = (ktory_gracz==1) ? 1:2;
 if (zasady_gry==0) maska_naszego_st = 0xf;
 // powyzej: & 0xf, bo [nind] moze byc tylko wewnatrz
 //    naszego stopu (bo [pola[i]] jest nasza kropka)
 for (int i=0; i<ile; i++)
   {
   int jest=1;
   for (int k=0; k<4; k++)
     {
     unsigned int nind = pola[i] + up.dind[k];
     if (rozgrywka[nind]!=ktory_gracz && (plansz_p[nind] & maska_naszego_st)==0
  /*        && upl_marg[nind]>=2 */)
       { jest=0; break; }
     }
   if (jest) plansz_p[pola[i]] |= 0x40;
   }
}

inline void UsunSkladowaZOt(unsigned char ot[9], unsigned char usun,
                            unsigned char zastap_przez)
{ for (int i=0; i<9; i++)  if (ot[i]==usun && i!=4)  ot[i]=zastap_przez; }

void OminPoleISasiadow(unsigned char ot[9], int nr)
{ // omin puste pola, ktore sa na pewno w tej samej skladowej co [nr]
 int do_spr[4] = {nr};
 ot[nr]=5;   // zaznacz
 int ile_do_spr=1;
 int sasiedzi1[4] = { 0, 0, 2, 6};
 int boczne1  [4] = { 3, 1, 1, 3};
 int sasiedzi2[4] = { 2, 6, 8, 8};
 int boczne2  [4] = { 5, 7, 7, 5};
 do
   {
   int p = do_spr[--ile_do_spr];
   // sprawdz sasiadow pola [p]
   if (ot[sasiedzi1[p>>1]]==0 && ot[boczne1[p>>1]]==0)
     { ot[boczne1[p>>1]]=5;  // zaznacz
     do_spr[ile_do_spr++]=p;
     }
   if (ot[sasiedzi2[p>>1]]==0 && ot[boczne2[p>>1]]==0)
     { ot[boczne2[p>>1]]=5;  // zaznacz
     do_spr[ile_do_spr++]=p;
     }
   }
 while (ile_do_spr);
}


// -----------------------------------------------------------------------------------------
void UsunBrzuszek(unsigned char* rozgrywka,
		  unsigned char* rozgr2, unsigned char* rozgr3,
		  unsigned char* plansz_p, unsigned int ind, int kto,
		  TZdobycze wynik[2], krint* stos)
// usuwa brzuszek gracza 3-kto o polu wewn. [ind]
// zaklada, ze pole [ind] NIE jest juz wewn. zadnego brzuszka gracza 3-kto
// modyfikuje zdobycze bezwzglednie ([0]=gracz1, [1]=gracz2)
{
  int maska_prz     = (kto==1) ? 0x9 : 0x6;
  int maska_brz_prz = (kto==1) ? 0x8 : 0x4;
  int maska_nasz    = (kto==1) ? 0x4 : 0x8;
  int maska_nasz_sstop = (kto==1) ? 0x5 : 0xa;
  int maska_nasz_sstop_lub_prz_st = (kto==1) ? 0x7 : 0xb;
  int maska_prz_and = (kto==1) ? (~0x28):(~0x14);
  unsigned char *odw = plansze.PrzydzielPlansze();
  CzyscTablice(odw);
  stos[0]=ind;  odw[ind]=1;
  int na_stosie=1;
  do {
    ind = stos[--na_stosie];
    // uaktualnij pole [ind]
    if (rozgrywka[ind]==0) {
      if (plansz_p[ind] & maska_nasz) {
	wynik[kto-1].ss++;  // sporne terytorium staje sie nasze
	if (rozgr2) rozgr2[ind]=0;
	if (rozgr3) rozgr3[ind]=kto;
      }
      else if (plansz_p[ind] & maska_brz_prz) {
	wynik[2-kto].ss--;  // przeciwnik traci terytorium
	if (rozgr2) rozgr2[ind]=0; //==rozgrywka[ind];
	if (rozgr3) rozgr3[ind]=0; //==rozgrywka[ind];
      }
    }
    else {
      if (rozgrywka[ind]==kto)
	wynik[2-kto].pot_zd--;  // przeciwnik traci ,,potencjalnie zdobyta kropke''
      if (rozgr2) {
	if (rozgrywka[ind]==0 || (plansz_p[ind] & 0x43))  // 4f=bity lancucha i stopu
	  rozgr2[ind]=0;    // (lancucha przy zal. rozgrywka[ind]!=0)
	else 
	  rozgr2[ind]=rozgrywka[ind];
      }
      if (rozgr3) {
	if ((plansz_p[ind] & maska_nasz_sstop_lub_prz_st)==0)
	  rozgr3[ind]=rozgrywka[ind];
	else if (plansz_p[ind] & maska_nasz_sstop)
	  rozgr3[ind]=kto;
	else
	  rozgr3[ind]=3-kto;
      }
    }
    // usun brzuszek
    plansz_p[ind] &= maska_prz_and;
    if (rozgrywka[ind]==0) plansz_p[ind] &= ~0x40;  // usun punktowane
    // odwiedz sasiadow
    for (int k=0; k<4; k++) {
      unsigned int nind = ind + up.dind[k];
      if ((plansz_p[nind] & maska_prz) && !odw[nind]) {
	stos[na_stosie++] = nind;
	odw[nind]=1;
      }
    }
  }
  while (na_stosie);
  plansze.ZwolnijPlansze(odw);
}


void UaktualnijBrzuszekP(unsigned char* rozgrywka,
			 unsigned char* rozgr2, unsigned char* rozgr3,
			 unsigned char* plansz_p, unsigned int ind, int kto)
// uaktualnia brzuszek przec. ustawiajac bit 0x10/0x20 (=mozna zamknac brzuszek)
{
  int maska_prz     = (kto==1) ? 0x8 : 0x4;
  int maska_or      = maska_prz*4;
  int maska_test    = maska_or | maska_prz;
  krint *stos=skladowe.PrzydzielSkladowa();
  stos[0]=ind;
  int na_stosie=1;
  plansz_p[ind] |= maska_or;
  do {
    ind = stos[--na_stosie];
    // odwiedz sasiadow
    for (int k=0; k<4; k++) {
      unsigned int nind = ind + up.dind[k];
      if ((plansz_p[nind] & maska_test)==maska_prz) {
	plansz_p[nind] |= maska_or;
	stos[na_stosie++] = nind;
      }
    }
  }
  while (na_stosie);
  skladowe.ZwolnijSkladowa(stos);
}

void ZamknijStopBrzeg(unsigned char* rozgrywka,
		     unsigned char* rozgr2, unsigned char* rozgr3,
		     unsigned char* plansz_p,
		     int kto,
		     TZdobycze wynik[2], TZobrist& zobr,
		     krint *dad, krint lewo, krint *wnetrze, int ile_wewnatrz)
// stop jest zadany przez dad (brzeg)+lewo (najbardziej na lewo wysuniete pole brzegu),
//   oraz wnetrze--ile_wewnatrz
// To jest funkcja ,,wewnetrzna'', wywolywana przez UaktObszarWokolPola()
//   oraz ZrobStopSGF()
{
  int maska_naszego_st_stopu = kto==1 ? 4:8;
  int maska_st_stopu_przec= kto==1 ? 8:4;
  int przec=3-kto;
  // w przypadku zasad gry >=1, usun rozerwane stopem brzuszki
  int caly_wewn=0;    // czy nasz stop jest caly wewn. brzuszka przec
  switch (zasady_gry) {
  case 1: {  // tylko jedna, swiezo postawiona kropka moze byc w brzuszku przeciwnika
    krint *bufor = skladowe.PrzydzielSkladowa();
    unsigned int pole=lewo;
    do {
      if (plansz_p[pole] & maska_st_stopu_przec) {
	UsunBrzuszek(rozgrywka, rozgr2, rozgr3,
		     plansz_p, pole, kto, wynik, bufor);
	break;
      }
      pole=dad[pole];
    }
    while (pole!=lewo);
    skladowe.ZwolnijSkladowa(bufor);
    break;
  }
  case 2: {
    // sprawdz, czy caly stop jest wewnatrz brzuszka przeciwnika
    unsigned int pole=lewo;
    caly_wewn=1;
    do {
      if ((plansz_p[pole] & maska_st_stopu_przec)==0) {
	caly_wewn=0;  break;	 }
      pole=dad[pole];
    }
    while (pole!=lewo);
    if (!caly_wewn) {
      // to oznacza, ze zadna kropka z brzegu nie jest teraz wewn. brzuszka przec.
      krint *bufor = skladowe.PrzydzielSkladowa();
      unsigned int pole=lewo;
      do {
	if (plansz_p[pole] & maska_st_stopu_przec)
	  UsunBrzuszek(rozgrywka, rozgr2, rozgr3,
		       plansz_p, pole, kto, wynik, bufor);
	pole=dad[pole];
      }
      while (pole!=lewo);
      skladowe.ZwolnijSkladowa(bufor);
    }
    break;
  }
  }
  // zamknij stop!
  /*
  // tak nie mozna:
  // trzeba jeszcze raz liczyc, bo niektore rzeczy mogly sie
  // zmienic po usunieciu brzuszkow przeciwnika, zob. np. plik pz3 (83.42)
  wynik[kto-1].zd += zd[0].zd+zd[0].pot_zd;
  wynik[kto-1].ss -= zd[0].ss;
  wynik[kto-1].pss-= zd[0].pss;
  wynik[kto-1].pot_zd -= zd[0].pot_zd;
  wynik[przec-1].ss -= zd[1].ss;
  wynik[przec-1].pss-= zd[1].pss;
  wynik[przec-1].pot_zd -= zd[1].pot_zd;  // jesli to >0, to przeciwnik schrzanil
  */
  // ustaw wnetrze na 0x1/0x2 (=kto) | ...
  int maskaz = zobrist_maska_stop[kto];
  int maska_wnetrza = caly_wewn ? (kto | (maska_st_stopu_przec*5)) : kto;
  for (int i=0; i<ile_wewnatrz; i++) {
    unsigned int nind=wnetrze[i];
    if (rozgrywka[nind]==0) {  // puste pole
      if ((plansz_p[nind] & 0xf)==0)
	; //  ile_w++;  // wolne pole
      else if ((plansz_p[nind] & 0xf)==maska_naszego_st_stopu) {
	wynik[kto-1].ss--;      if (plansz_p[nind] & 0x40) wynik[kto-1].pss--;
      }
      else if ((plansz_p[nind] & 0xf)==maska_st_stopu_przec) {
	wynik[przec-1].ss--;      if (plansz_p[nind] & 0x40) wynik[przec-1].pss--;
      }
    }
    else if (rozgrywka[nind]==kto) {
      if (plansz_p[nind] & maska_st_stopu_przec)
	wynik[przec-1].pot_zd--;
    }
    else {     // kropka przeciwnika
      if (plansz_p[nind] & maska_naszego_st_stopu)
	{ wynik[kto-1].pot_zd--; wynik[kto-1].zd++; }
      else if ((plansz_p[nind] & kto)==0)
	wynik[kto-1].zd++;               
    }
    
    plansz_p[nind] = maska_wnetrza;  // pole wewn. stopu (ktory_gracz)
    if (rozgr2!=NULL) rozgr2[nind] = 0;
    if (rozgr3!=NULL) rozgr3[nind] = kto;
    zobr ^= (nind | maskaz);
  }
}
		     

int UaktObszarWokolPola(unsigned char* rozgrywka, unsigned char* stopy,
			char* sgf_ruch,
			unsigned char* rozgr2, unsigned char* rozgr3,
			unsigned char* plansz_p,
			unsigned char* plan,
			unsigned int ind, int kto,
			TZdobycze wynik[2], TZobrist& zobr,
			TRuchyZam &ruchy_zam = ruchy_zam_NULL,			
			int zamknij=0, int lancuchy=0)
// Zwraca !=0, gdy jest (staly, potencjalny, zwykly) stop pola [ind] dla gracza (kto)
//  i wtedy zaznacza w plan pola wewn. na 59
// (bit &1 oznacza zwykly stop, &2 oznacza zmiane punktacji)
// W przeciwnym razie zaznacza niektore pola (zewnetrzne) na 1.
// we:
//  zamknij==1 oznacza, ze nalezy zamknac potencjalny stop (dotyczy zasad gry==2)
//  zamknij==0 -- nie zamykaj stopu, jesli nie trzeba (przy zasadach gry=0,1 trzeba),
//                lub gdy opoznianie zamkniecia nic nie daje (zasady==2)
//  zamknij==-1 -- nigdy nie zamykaj, tylko zaznacz odp. maski brzuszkow
//                (potrzebne do odczytywania plikow SGF i recznego rysowania stopow)
//  stopy, sgf_ruch, rozgr2, rozgr3 moga byc == NULL
// modyfikuje zdobycze bezwzglednie ([0]=gracz1, [1]=gracz2)
{
 STOPER_START_UOWP;
 if (zasady_gry<=1 && zamknij==0) zamknij=1;
 int jest_stop = 0;  // czy zamykamy normalny stop
 // przydziel pamiec
 // unsigned char* plan =plansze.PrzydzielPlansze();
 unsigned int lewo;
 if (PrzejdzWnetrze(rozgrywka, plansz_p, plan, ind, lewo, kto)) {
   krint* dad  =skladowe.PrzydzielSkladowa();
   krint* wnetrze =skladowe.PrzydzielSkladowa();
   ZnajdzBrzegStopu(dad, plan, lewo);
   // przejdz brzeg stopu
   {
     unsigned int pole=lewo;
     do {
       plan[pole]=60;   // 60=brzeg stopu
       pole=dad[pole];
     }
     while (pole!=lewo);
   }
   // przejdz jeszcze raz wnetrze stopu
   int ile_wewnatrz=1;
   plan[ind]=59;  // 59=wnetrze stopu
   wnetrze[0]=ind;
   TZdobycze zd[2];
   zd[0].Zeruj();   zd[1].Zeruj();
   int ile_w=0;
   int maska_naszego_st_stopu = kto==1 ? 4:8;
   int maska_st_stopu_przec= kto==1 ? 8:4;
   int przec=3-kto;
   for (int i_wewn=0; i_wewn<ile_wewnatrz; i_wewn++) {// uwaga: ile_wewnatrz zwieksza sie w petli
     unsigned int nind = wnetrze[i_wewn];
     // dodaj do zdobyczy
     if (rozgrywka[nind]==0) {  // puste pole
       if ((plansz_p[nind] & 0xf)==0)
	 ile_w++;  // wolne pole
       else if ((plansz_p[nind] & 0xf)==maska_naszego_st_stopu) {
	 zd[0].ss++;      if (plansz_p[nind] & 0x40) zd[0].pss++;
       }
       else if ((plansz_p[nind] & 0xf)==maska_st_stopu_przec) {
	 zd[1].ss++;      if (plansz_p[nind] & 0x40) zd[1].pss++;
       }
     }
     else if (rozgrywka[nind]==kto) {
       if (plansz_p[nind] & 0xc)  // w zasadzie maska_st_stopu_przec
	 zd[1].pot_zd++;
     }
     else {     // kropka przeciwnika
       if (plansz_p[nind] & 0xc)  // w zasadzie maska_naszego_st_stopu
	 zd[0].pot_zd++;
       else if ((plansz_p[nind] & kto)==0)  // jeszcze nie wewn. naszego stopu
	 zd[0].zd++;
     }
     // odwiedz sasiadow
     for (int k=0; k<4; k++) {
       unsigned int nnind = nind + up.dind[k];
       if (plan[nnind]<59) {
	 plan[nnind] = 59;  // zaznacz jako wewnetrzne
	 wnetrze[ile_wewnatrz++] = nnind;
       }
     }
   }
   if (ile_w==0 && zd[0].ss==0 && zd[1].ss==0 && zamknij==0) zamknij=1;  // nie ma sensu opozniac zamkniecia
   if (zd[0].zd + zd[0].pot_zd > 0  && zamknij==1) {
     jest_stop = 1;
     ZamknijStopBrzeg(rozgrywka, rozgr2, rozgr3, plansz_p,
		      kto, wynik, zobr,
		      dad, lewo, wnetrze, ile_wewnatrz);
     // zaznacz brzeg
     if (stopy!=NULL || sgf_ruch!=NULL) {
       unsigned int pole=lewo;
       int maska = zasady_gry ? 0x3:0xf;  // dla zasad gry==0 staly stop jest tak bezp. jak stop
       // powyzej 0xf (0x3), bo [nind] moze byc tylko wewnatrz
       //   naszego stopu (bo [pole] jest nasza kropka)
       if (sgf_ruch!=NULL) strcat(sgf_ruch, ".");
       do {
	 if (stopy!=NULL) Polacz(stopy, upl_x[pole], upl_y[pole], upl_x[dad[pole]], upl_y[dad[pole]]);
	 if (sgf_ruch!=NULL)
	   SGFDopiszPole(sgf_ruch, pole);
	 int jest=1;
	 for (int k=0; k<4; k++) {
	   unsigned int nind = pole + up.dind[k];
	   if (rozgrywka[nind]!=kto && (plansz_p[nind] & maska)==0
                /*&& upl_marg[nind]>=2 */)
              { jest=0; break; }
	 }
	 if (jest) plansz_p[pole] |= 0x40;
	 pole=dad[pole];
       }
       while (pole!=lewo);
       if (sgf_ruch!=NULL)
	 SGFDopiszPole(sgf_ruch, pole);
     }
   }
   else {  // staly stop lub potencjalny stop -- brzuszek z kropkami przeciwnika w srodku
     wynik[kto-1].ss += ile_w;
     int ile_zaznaczyc = (ile_w+zd[0].ss>=5) ? 3 : (ile_w+zd[0].ss>=2 ? 2 : ile_w+zd[0].ss);
     wynik[kto-1].pss += ile_zaznaczyc - zd[0].pss;
     wynik[kto-1].pot_zd += zd[0].zd;
     wynik[przec-1].ss -= zd[1].ss;   // tereny sporne
     int maska_wyl_potst = ~0;
     if (zd[0].zd + zd[0].pot_zd==0)     // to jest brzuszek, trzeba wylaczyc ew. bit pot.st.
       maska_wyl_potst = kto==1 ? (~0x10) : (~0x20);
     // (nie zmieniamy wynik[przec-1].pss, bo to sie nie zmienia dla zasad_gry < 2)
     // ustaw wnetrze w odp. tablicach
     int maska_nowa = maska_naszego_st_stopu;
     if (zd[0].zd) maska_nowa |= (maska_naszego_st_stopu << 2);  // maska = 0x14 lub 0x28
     TZobrist zobr_rz;  zobr_rz.Zeruj();   // rz = ruch zamykajacy
     for (int i=0; i<ile_wewnatrz; i++) {
       if ((plansz_p[wnetrze[i]] & 3)==0) {
         if (rozgrywka[wnetrze[i]]==0) {
           plansz_p[wnetrze[i]] |= maska_nowa;
           plansz_p[wnetrze[i]] &= maska_wyl_potst;
           if (ile_zaznaczyc)
             { plansz_p[wnetrze[i]] |= 0x40;  ile_zaznaczyc--; }
           else plansz_p[wnetrze[i]] &= ~0x40;
	 }
	 else if (rozgrywka[wnetrze[i]]==przec)
           plansz_p[wnetrze[i]] |= maska_nowa;
       }
       else if (plansz_p[wnetrze[i]] & (3-kto)) {  // wewnatrz panstwa przec
	 plansz_p[wnetrze[i]] |= maska_nowa;
       }
       //if (rozgr2!=NULL) rozgr2[wnetrze[i]] = 0;  // 83.42: nie zerujemy wnetrza brzuszka!
       if (rozgr3!=NULL) rozgr3[wnetrze[i]] = kto;
       zobr_rz ^= (wnetrze[i] | zobrist_maska_stop[kto]);
     }
     if (zd[0].zd+zd[0].pot_zd)
       ruchy_zam.DodajRuch(ind | zobrist_maska_stop[kto], zd,
			   zobr_rz);   // UWAGA: zd nie jest bezwzgledne, to moze byc zle!
     // sprawdz, czy brzeg jest w lancuchu
     if (stopy!=NULL || lancuchy) {
       unsigned int pole=lewo;
       int maska = zasady_gry ? 0x3:0xf;  // dla zasad gry==0 staly stop jest tak bezp. jak stop
       do {
	 int jest=1;
	 for (int k=0; k<4; k++) {
	   unsigned int nind = pole + up.dind[k];
	   if (rozgrywka[nind]!=kto && (plansz_p[nind] & maska)==0)
	     { jest=0; break; }
	 }
	 if (jest) plansz_p[pole] |= 0x40;
	 pole=dad[pole];
       }
       while (pole!=lewo);
     }
   }
   skladowe.ZwolnijSkladowa(dad);  skladowe.ZwolnijSkladowa(wnetrze);
   //   plansze.ZwolnijPlansze(plan);
   STOPER_STOP_UOWP;
   return (jest_stop | 2);
 }
 // plansze.ZwolnijPlansze(plan);
 STOPER_STOP_UOWP;
 return 0;
}


int ZrobStopSGF(unsigned char* rozgrywka, unsigned char* stopy,
		char *sgf_ruch,
		unsigned char* rozgr2, unsigned char* rozgr3,
		unsigned char* plansz_p,
		TZdobycze wynik[2], TZobrist& zobr)
// NOWA FUNKCJA -- slabo testowana!

// we: sgf_ruch -- lamana zamknieta
// Zamyka podany stop i zwraca 1, jesli jest poprawny.
// Zwraca 0, gdy jakis blad (nieprawidlowa lamana, nie ma stopu)
{
  unsigned char *plan = plansze.PrzydzielPlansze();
  krint* dad  =skladowe.PrzydzielSkladowa();
  CzyscTablice(plan);  CzyscTablice(dad);
  int kto = -1, przec=-1, poprz=-1, pole_pocz=-1;
  int blad=0;
  int miny= max_bok_planszy + 6, maxy =-1;
  int polemin = up.pd+1, polemax = -1;
  while (isalpha(sgf_ruch[0])) {
    int pole = SGFDajPole(sgf_ruch);
    if (pole==-1) {
      blad = 1;
      break;
    }
    sgf_ruch+=2;
    dad[pole] = poprz;
    if (pole==pole_pocz) {
      break;   // wrocilismy do punktu wyjscia
    }
    else 
      if (pole_pocz==-1) pole_pocz=pole;
    if (kto==-1) {
      kto = rozgrywka[pole];
      if (kto!=1 && kto!=2) { blad=1; break; }
      przec = 3-kto;
    }
    if (rozgrywka[pole]!=kto || kto==0       // zly kolor pola
	|| plan[pole]                      // samoprzeciecie lamanej
	|| (plansz_p[pole] & przec)) {     // wewn. stopu przeciwnika
      blad=1;
      break;
    }
    if (poprz!=-1) {
      int dx = int(upl_x[poprz]) - int(upl_x[pole]);
      int dy = int(upl_y[poprz]) - int(upl_y[pole]);
      if (dx>1 || dx<-1 || dy>1 || dy<-1) {
	blad=1;
	break;
      }
    }
    poprz = pole;
    // jest ok
    plan[pole] = 60;   // brzeg stopu
    if (pole<polemin) polemin = pole;         // bez else, bo moze byc (bledna) lamana
    if (pole>polemax) polemax = pole;         // zlozona z 1 pola -- nie chcemy sie pozniej wysypac...
    if (upl_y[pole] > maxy) maxy = upl_y[pole];
    if (upl_y[pole] < miny) miny = upl_y[pole];
  }
  if (blad) {
    plansze.ZwolnijPlansze(plan);
    skladowe.ZwolnijSkladowa(dad);
    return 0;
  }
  // brzeg stopu zaznaczony na 60, wlascicielem jest gracz ,,kto''
  // zaznacz zewnetrze stopu na 2
  int minx = upl_x[polemin], maxx = upl_x[polemax];
  // rozwazamy prostokat zawierajacy stop z marginesem 1
  krint *stos = skladowe.PrzydzielSkladowa();
  krint* wnetrze =skladowe.PrzydzielSkladowa();
  int na_stosie=0;
  int ile_wewnatrz=0;
  // zaznacz brzegi prostokata ,,2'' i dodaj sasiadow na stos
  for (int i=minx; i<=maxx; i++) {
    WezUC(plan, i, miny-1) = 2;
    WezUC(plan, i, maxy+1) = 2;
    if (WezUC(plan, i, miny)==0)
      plan[  stos[na_stosie++] = WezIndeksTab(i,miny)  ] =2;
    if (WezUC(plan, i, maxy)==0)
      plan[  stos[na_stosie++] = WezIndeksTab(i,maxy)  ] =2;
  }
  for (int j=miny; j<=maxy; j++) {
    WezUC(plan, minx-1, j) = 2;
    WezUC(plan, maxx+1, j) = 2;
    if (WezUC(plan, minx, j)==0)
      plan[  stos[na_stosie++] = WezIndeksTab(minx, j)  ] =2;
    if (WezUC(plan, maxx, j)==0)
      plan[  stos[na_stosie++] = WezIndeksTab(maxx, j)  ] =2;
  }
  // przejdz reszte zewnetrza (jesli jest)
  while (na_stosie) {
    int pole = stos[--na_stosie];
    // odwiedz sasiadow
    for (int k=0; k<4; k++) {
      unsigned int nind = pole + up.dind[k];
      if (plan[nind]==0 ) {
	 plan[nind] = 2;  // zaznacz jako zewnetrzne
	 stos[na_stosie++]=nind;
       }
    }
  }
  // znajdz wnetrze
  for (int i=minx; i<=maxx; i++)
    for (int j=miny; j<=maxy; j++) {
      int ind = WezIndeksTab(i, j);
      if (plan[ind]==0)
	wnetrze[ile_wewnatrz++] = ind;
    }
  skladowe.ZwolnijSkladowa(stos);
  plansze.ZwolnijPlansze(plan);
  // policz zdobycze
  TZdobycze zd[2];
  zd[0].Zeruj();   zd[1].Zeruj();
  int ile_w=0;
  int maska_naszego_st_stopu = kto==1 ? 4:8;
  int maska_st_stopu_przec= kto==1 ? 8:4;
  for (int i=0; i<ile_wewnatrz; i++) {
    int nind = wnetrze[i];
    // dodaj do zdobyczy
    if (rozgrywka[nind]==0) {  // puste pole
      if ((plansz_p[nind] & 0xf)==0)
	ile_w++;  // wolne pole
      else if ((plansz_p[nind] & 0xf)==maska_naszego_st_stopu) {
	zd[0].ss++;      if (plansz_p[nind] & 0x40) zd[0].pss++;
      }
      else if ((plansz_p[nind] & 0xf)==maska_st_stopu_przec) {
	zd[1].ss++;      if (plansz_p[nind] & 0x40) zd[1].pss++;
      }
    }
    else if (rozgrywka[nind]==kto) {
      if (plansz_p[nind] & 0xc)  // w zasadzie maska_st_stopu_przec
	zd[1].pot_zd++;
    }
    else {     // kropka przeciwnika
      if (plansz_p[nind] & 0xc)  // w zasadzie maska_naszego_st_stopu
	zd[0].pot_zd++;
      else if ((plansz_p[nind] & kto)==0)  // jeszcze nie wewn. naszego stopu
	zd[0].zd++;
    }
  }
  //
  if (zd[0].zd + zd[0].pot_zd == 0) {
    skladowe.ZwolnijSkladowa(wnetrze);
    skladowe.ZwolnijSkladowa(dad);
    return 0;   // blad! nie ma co zamknac!
  }
  // zamykamy!
  ZamknijStopBrzeg(rozgrywka, rozgr2, rozgr3, plansz_p,
		   kto, wynik, zobr,
		   dad, polemin, wnetrze, ile_wewnatrz);
  // zaznacz brzeg
  if (stopy!=NULL) {
    unsigned int pole=polemin;
    int maska = zasady_gry ? 0x3:0xf;  // dla zasad gry==0 staly stop jest tak bezp. jak stop
    // powyzej 0xf (0x3), bo [nind] moze byc tylko wewnatrz
    //   naszego stopu (bo [pole] jest nasza kropka)
    do {
      if (stopy!=NULL) Polacz(stopy, upl_x[pole], upl_y[pole], upl_x[dad[pole]], upl_y[dad[pole]]);
      int jest=1;
      for (int k=0; k<4; k++) {
	unsigned int nind = pole + up.dind[k];
	if (rozgrywka[nind]!=kto && (plansz_p[nind] & maska)==0
	    /*&& upl_marg[nind]>=2 */)
	  { jest=0; break; }
      }
      if (jest) plansz_p[pole] |= 0x40;
      pole=dad[pole];
    }
    while (pole!=polemin);
  }
  skladowe.ZwolnijSkladowa(wnetrze);
  skladowe.ZwolnijSkladowa(dad);
  return 1;
}

int ZrobLatwyStop(unsigned char* rozgrywka, unsigned char* stopy,
		  krint *nowe_ruchy,
		  char *sgf_ruch, int zostaw_stopy,
		  unsigned char* rozgr2, unsigned char* rozgr3,
		  unsigned char* plansz_p, unsigned int ind, int kto,
		  TZdobycze wynik[2], TZobrist& zobr)
// ind -- indeks pola w srodku, kto -- kto zamyka
// zwraca int z ustawionym bitem 0 (&1), gdy jest stop;
//   bitem 1 (&2), gdy jest zmiana punktacji (czyli &2 zawsze)
// (inaczej: 2 = staly stop, 3 = stop)
// modyfikuje zdobycze bezwzglednie ([0]=gracz1, [1]=gracz2)
{
 if (rozgr2!=NULL) rozgr2[ind]=0;
 if (rozgr3!=NULL) rozgr3[ind]=kto;
 int maska_nasza = (kto==1) ? 4:8;
 int maska_prz = maska_nasza ^ 0xc;
 if (rozgrywka[ind]==0) {
   if ((plansz_p[ind] & maska_nasza)==0)
     if ((plansz_p[ind] & maska_prz)==0)
       { wynik[kto-1].ss++;  wynik[kto-1].pss++; }
     else   // terytorium przeciwnika zrobilo sie sporne
       wynik[2-kto].ss--; //nie modyfikuj pss przeciwnika, przy tych zasadach gry i tak nie trzeba
   plansz_p[ind] &= (kto==1) ? (~0x10) : (~0x20);
   plansz_p[ind] |= (kto==1) ? 0x44:0x48;
   return 2;
   }
 else if (zostaw_stopy>=0) {
   int caly_wewn=0;  // czy caly wewn. brzuszka przec
   // najpierw ew. usun brzuszki przeciwnika
   switch (zasady_gry) {
   case 1:   // tylko jedna, swiezo postawiona kropka moze byc w brzuszku przeciwnika
     for (int k=0; k<4; k++)
       if (plansz_p[ind+up.dind[k]] & maska_prz) {
	 krint *bufor = skladowe.PrzydzielSkladowa();
	 UsunBrzuszek(rozgrywka, rozgr2, rozgr3,
		      plansz_p, ind+up.dind[k], kto, wynik, bufor);
	 skladowe.ZwolnijSkladowa(bufor);
	 break;
       }
       break;
   case 2: {
     // sprawdz, czy caly stop jest wewnatrz brzuszka przeciwnika
     caly_wewn=1;
     for (int k=0; k<4; k++)
       if ((plansz_p[ind+up.dind[k]] & maska_prz)==0) {
	 caly_wewn=0;  break;	 }
     if (!caly_wewn) {
       // to oznacza, ze zadna kropka z brzegu nie jest teraz wewn. brzuszka przec.
       krint *bufor = skladowe.PrzydzielSkladowa();
       for (int k=0; k<4; k++)
	 if ((plansz_p[ind+up.dind[k]] & maska_prz)!=0)
	   UsunBrzuszek(rozgrywka, rozgr2, rozgr3,
			plansz_p, ind+up.dind[k], kto, wynik, bufor);
       skladowe.ZwolnijSkladowa(bufor);
     }
     break;
   }
   }
   // a teraz utworz panstwo
   if (plansz_p[ind] & maska_nasza)
     wynik[kto-1].pot_zd--;
   wynik[kto-1].zd++;
   plansz_p[ind] = caly_wewn ? (kto==1 ? 0x29 : 0x16) : kto;
   //  plansz_p[ind] &= (kto==1) ? (~0x54) : (~0x68);  // niepotrzebne, jesli powyzej = a nie |=
   zobr ^= (ind | zobrist_maska_stop[kto]);
   if (stopy!=NULL) {
     int x=upl_x[ind], y=upl_y[ind];
     Polacz(stopy, x-1, y, x, y+1);
     Polacz(stopy, x+1, y, x, y+1);
     Polacz(stopy, x-1, y, x, y-1);
     Polacz(stopy, x+1, y, x, y-1);
     }
   if (sgf_ruch!=NULL) {
     strcat(sgf_ruch, ".");
     SGFDopiszPole(sgf_ruch, ind+W_L);
     SGFDopiszPole(sgf_ruch, ind+W_D);
     SGFDopiszPole(sgf_ruch, ind+W_P);
     SGFDopiszPole(sgf_ruch, ind+W_G);
     SGFDopiszPole(sgf_ruch, ind+W_L);
   }
   if (nowe_ruchy!=NULL)
     *nowe_ruchy++ = ind | 0x4000;
   return 3;
 }
 else {  // jest stop, ale nie nalezy go zamykac! (zostaw_stopy==-1)
   if ((plansz_p[ind] & 0x30)==0) {
     // kropka jeszcze nie byla w stopie
     plansz_p[ind] |= (kto==1) ? 0x14:0x28;
     wynik[kto-1].pot_zd++;
     return 2;
   }
 }
}

void PostawKropke(unsigned char* rozgrywka,
		  unsigned char* rozgr2, unsigned char* rozgr3,
		  unsigned char* plansz_p, unsigned int ind, int kto,
		  TZdobycze wynik[2], TZobrist& zobr,
		  char *sgf_ruch)
// ustawia wyniki bezwzglednie, tzn. [0]->gracz 1, [1]->gracz2
{
  rozgrywka[ind]=kto;
  zobr ^= (ind | zobrist_maska[kto]);
  if (sgf_ruch)
    SGFDopiszPole(sgf_ruch, ind);
  int maska_nasza = (kto==1) ? 4:8;
  int maska_prz = maska_nasza ^ 0xc;
  if (plansz_p[ind] & maska_nasza)
    if (plansz_p[ind] & maska_prz) {  // wstawilismy do terenu spornego
      plansz_p[ind] = maska_prz*5;   // moze nas zamknac prz, wiec ustaw 0x14/0x28; jest = nie |=
      wynik[2-kto].pot_zd++;
    }
    else {  // wstawilismy do swojego brzuszka
      plansz_p[ind] &= ~(maska_nasza*5);
      //      if (rozgr2) rozgr2[ind]=kto;
      wynik[kto-1].ss--;   // nie zmieniamy pss
    }
  else if (plansz_p[ind] & maska_prz) {  // wstawilismy do brzuszka przec.
    plansz_p[ind] = maska_prz*5;  // =, nie |=
    wynik[2-kto].pot_zd++;
    wynik[2-kto].ss--;
  }
  else {  // nie wewnatrz stopu
    //    if (rozgr2) rozgr2[ind]=kto;
    if (rozgr3) rozgr3[ind]=kto;
  }
  if (rozgr2) rozgr2[ind]=kto;  // 83.42: nie zerujemy wnetrza brzuszka!, dodane w 84.08
  // lancuchy: (na razie wylaczone)
  plansz_p[ind] &= ~0x40;  // wyczysc ew. punktowane
  /*
  int jest=1;
  int maska = zasady_gry ? kto : (kto*5);
  for (int k=0; k<4; k++)
    if (rozgrywka[ind+up.dind[k]]!=kto &&
	(plansz_p[ind+up.dind[k]] & maska)==0) {
      jest=0; break; }
  if (jest) plansz_p[ind] |= 0x40;
  //  else plansz_p[ind] &= ~0x40;
    
  */

  
}


/*
int TestRozgr23(const unsigned char* rozgrywka, const unsigned char* plansz_p, 
		const unsigned char* rozgr2, const unsigned char* rozgr3)
{
  if (rozgr2==NULL || rozgr3==NULL) return 1;
  for (int i=0; i<wlkx4wlky4; i++)
    if (upl_marg[i]<=1) {
      if (rozgrywka[i])	{ 
	printf("rozgrywka[%d]=%d",i, int(rozgrywka[i]));
	return 0;
      }
      if (rozgr2[i])	{ 
	printf("rozgr2[%d]=%d",i, int(rozgr2[i]));
	return 0;
      }
      if (rozgr3[i])	{ 
	printf("rozgr3[%d]=%d",i, int(rozgr3[i]));
	return 0;
      }
    }
    else {  // wewnatrz planszy
      if (rozgrywka[i]>2) {
	printf("rozgrywka[%d]=%d",i, int(rozgrywka[i]));
	return 0;
      }
      if (plansz_p[i] & 1) {  // wewnatrz stopu gracza 1
	if (plansz_p[i] & 0x3e) {
	  printf("plansz_p[%d]=%d",i, int(plansz_p[i]));
	  return 0;
	}
	if (rozgr2[i]!=0) {
	  printf("rozgr2[%d]=%d",i, int(rozgr2[i]));
	  return 0;
	}
	if (rozgr3[i]!=1) {
	  printf("rozgr3[%d]=%d",i, int(rozgr3[i]));
	  return 0;
	}
      }
      if (plansz_p[i] & 2) {  // wewnatrz stopu gracza 2
	if (plansz_p[i] & 0x3d) {
	  printf("plansz_p[%d]=%d",i, int(plansz_p[i]));
	  return 0;
	}
	if (rozgr2[i]!=0) {
	  printf("rozgr2[%d]=%d",i, int(rozgr2[i]));
	  return 0;
	}
	if (rozgr3[i]!=2) {
	  printf("rozgr3[%d]=%d",i, int(rozgr3[i]));
	  return 0;
	}
      }
      if ((plansz_p[i] & 0x43)==0 && rozgr2[i]!=rozgrywka[i]) {
	  printf("rozgr2[%d]=%d",i, int(rozgr2[i]));
	  return 0;
	}
      if (plansz_p[i] & 4) {  // wewnatrz stalego stopu gracza 1
	if ((plansz_p[i] & 8)==0)  {  // ale nie wewn. stalego stopu gracza 2
	  if (plansz_p[i] & 0x23) {
	    printf("plansz_p[%d]=%d",i, int(plansz_p[i]));
	    return 0;
	  }
	  if (rozgr3[i]!=1) {
	    printf("rozgr3[%d]=%d",i, int(rozgr3[i]));
	    return 0;
	  }
	}
      }
      if (plansz_p[i] & 8) {  // wewnatrz stalego stopu gracza 2
	if ((plansz_p[i] & 4)==0)  {  // ale nie wewn. stalego stopu gracza 1
	  if (plansz_p[i] & 0x13) {
	    printf("plansz_p[%d]=%d",i, int(plansz_p[i]));
	    return 0;
	  }
	  if (rozgr3[i]!=2) {
	    printf("rozgr3[%d]=%d",i, int(rozgr3[i]));
	    return 0;
	  }
	}
      }
    }
  return 1;
  } */


// -----------------------------------------------------------------------------------------
/* bity w plansz_p:
 Ogolnie:
  1,2 : wnetrze panstwa,
  4,8 : wnetrze brzuszka
  0x10, 0x20: kropka/wolne pole: moze zostac zamkniete przez gr 1,2
  0x40: punktowane (gdy wolne pole) / bit lancucha (gdy kropka) -- chyba, komentarz z wersji 83.41
  0x80: niezdefiniowane

 Dokladniej bity 0x1f:
 wewnatrz panstwa gracza 1:
   &1 zawsze ustawione,
   dodatkowo mozliwe bity 0x28 (wewnatrz brzuszka gracza 2 + moze byc przez niego zamkniete),
   bit 0x40 (lancucha) oraz bity 0x14 wyzerowane
   (czyli mozliwe maski to 1 lub 0x29)
 wewnatrz panstwa gracza 2:
   &2 zawsze ustawione,
   dodatkowo mozliwe bity 0x14 (wewnatrz brzuszka gracza 1 + moze byc przez niego zamkniete),
   bit 0x40 (lancucha) oraz bity 0x28 wyzerowane
   (czyli mozliwe maski to 2 lub 0x16)
 kropka gracza 1:
   0x28: wewn. brzuszka gracza 2,  (tutaj bity 0x14 zawsze wyzerowane)
   0   : nie
 kropka gracza 2:
   0x14: wewn. brzuszka gracza 1,  (tutaj bity 0x28 zawsze wyzerowane)
   0   : nie
 wolne pole:
   4,8 : wewnatrz brzuszka gracza 1,2
  + dodatkowo:
   0x10,0x20: moze zostac zamkniete przez gracza 1,2
 (moze byc wiec 0, 4, 0x14, 8, 0x28, 0x1c, 0x2c, 0x3c)

*/

int ZrobPanstwo(unsigned char* rozgrywka, unsigned char* stopy, 
		krint *nowe_ruchy, int &ile_domyslnych,
		char *sgf_ruch,
		int zostaw_stopy,
		unsigned char* rozgr2, unsigned char* rozgr3,
		unsigned char* plansz_p, int x, int y, int ktory_gracz,
		TZdobycze zdakt[2], TZobrist &zobr,
		     int &ile_zdobytych, int &powierzchnia, int &powierzchnia2,
		     int &punktacja_ss,
		TRuchyZam &ruchy_zam,
		int lancuchy)
// (x,y)  - wlasnie postawiona kropka, przez gracza (ktory_gracz)
// USTAWIA ile_zdobytych, powierzchnia, powierzchnia2, punktacja_ss.
// Moze byc stopy==NULL (lub rozgr2, rozgr3)
// Jesli lancuchy!=0, to ustawia bit lancucha (0x40) w plansz_p,
//  o ile powstal jakis (staly) stop;
// jesli stopy!=NULL, to ustawia bit lancucha zawsze (i zmienna lancuchy
// jest ignorowana).
// Gdy:
//  zostaw_stopy == 1  -- zamknij wszystkie potencjalne nowe stopy (przydatne w MonteCarlo)
//  zostaw_stopy == 0  -- standardowe zachowanie,
//  zostaw_stopy == -1  -- nie zamyka ZADNYCH stopow (ktore trzeba zamknac, bo zasady
//       gry tego wymagaja, ani takich, ktore warto zamknac, bo nic nie wnosza),
//       potrzebne do wczytywania SGF i recznych stopow
// Moze byc nowe_ruchy==NULL.
//
// Zwraca int z ustawionym bitem 0 (&1), gdy jest stop;
//   bitem 1 (&2), gdy jest zmiana punktacji.
//
// Mozliwe optymalizacje:
// 1. ,,latwe'' stopy: stopy na 2 pola?;
// 2.  na ogol nie trzeba przechodzic wnetrza stopu jeszcze raz -- jesli
//   na brzegu sa wszystkie kropki, ktore zostaly zaznaczone przez
//   PrzejdzWnetrze() jako prawdopodobne brzegowe, to ta funkcja znajduje
//   tez cale wnetrze -- wiec mozna by zliczac i porownywac liczbe brzegowych
// Do uzupelnienia:
//     Gdy lancuchy==1 i stopy==NULL, to mozna by ustawiac lancuchy
//     tylko wtedy, gdy jest jakis (staly) stop -- bo wtedy funkcje znajdujace
//     najlepszy ruch wiedza, ze plansz_p sie zmienilo i odtwarzaja je.
//  Wazne: 
//   1. Uaktualnianie stalych stopow w sytuacji, gdy zostaly rozerwane
//   nowym panstwem (mozliwe przy zasadach gry >= 1)!!
{
 STOPER_START_ZPDA;
 // TestRozgr23(rozgrywka, plansz_p, rozgr2, rozgr3);
 int stan=0;
 ile_domyslnych=0;    // ile domyslnych stopow
 ile_zdobytych = powierzchnia = powierzchnia2 = punktacja_ss = 0;
 // sprawdz wlasnie postawiona kropke - czy tworzy (staly) stop
 //
 unsigned char ot[9];
 WezOtoczenie(ot, x,y, plansz_p, rozgrywka, ktory_gracz);
 int ile_skl=UstawOtoczenie(ot);
 unsigned int indeks = WezIndeksTab(x,y);
 //
 int kropka_w_naszym_brz = ((plansz_p[indeks] & (ktory_gracz==1 ? 4:8)) != 0);
 if (kropka_w_naszym_brz)
   stan|=4;   // prosta zmiana punktacji
 int pierwsza_kr_w_brz_przec;
 {
   int maska = ktory_gracz==1 ? 0x28:0x14;
   int maskaw= ktory_gracz==1 ? 8:4;
   pierwsza_kr_w_brz_przec = ((plansz_p[indeks] & maska)==maskaw);
 }
 zdakt[0].Zeruj(); zdakt[1].Zeruj();
 PostawKropke(rozgrywka, rozgr2, rozgr3, plansz_p, indeks, ktory_gracz, zdakt, zobr, sgf_ruch);
 if (ile_skl<2)
   {
   if (ile_skl==1 && stopy!=NULL)
     { // sprawdz, czy kropki obok nie beda wewnatrz lancucha
     int ile=0;
     unsigned int brzegi[4];
     if (ot[1]) brzegi[ile++]=indeks-1;
     if (ot[7]) brzegi[ile++]=indeks+1;
     if (ot[3]) brzegi[ile++]=indeks-wlky-4;
     if (ot[5]) brzegi[ile++]=indeks+W_P;
     PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile);
     }
   goto Ustaw_punkty;
   }
 {
 unsigned int brzegi[12];
 int ile_brz = 0;
 // sprawdz, czy mamy moze najprostsze panstwo
 // czy stop u gory?
 if (ot[0] && ot[2] && ot[0]!=ot[2]
     && !(plansz_p[indeks-2] &3) && rozgrywka[indeks-2]==ktory_gracz) {
   int nstan = 
     ZrobLatwyStop(rozgrywka, stopy, nowe_ruchy, sgf_ruch, zostaw_stopy, rozgr2, rozgr3,
		   plansz_p, indeks-1, ktory_gracz, zdakt, zobr);
   stan|=nstan;
   if (nstan & 1) { if (nowe_ruchy) nowe_ruchy++;  ile_domyslnych++; }
   brzegi[ile_brz++] = indeks-wlky-5;
   brzegi[ile_brz++] = indeks-2;
   brzegi[ile_brz++] = indeks+wlky+3;
   if (--ile_skl + kropka_w_naszym_brz<2)
     {
     if (lancuchy)
       PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile_brz);
     goto Ustaw_punkty;
     }
   ot[1]=ot[0];
   if (!kropka_w_naszym_brz) UsunSkladowaZOt(ot, ot[2], ot[0]);
   }
 else if (ot[1])
   brzegi[ile_brz++] = indeks-1;
 // czy stop u dolu?
 if (ot[6] && ot[8] && ot[6]!=ot[8]
     && !(plansz_p[indeks+2] &3) && rozgrywka[indeks+2]==ktory_gracz) {
   int nstan =
     ZrobLatwyStop(rozgrywka, stopy, nowe_ruchy, sgf_ruch, zostaw_stopy, rozgr2, rozgr3,
		   plansz_p, indeks+1, ktory_gracz, zdakt, zobr);
   stan|=nstan;
   if (nstan & 1) { if (nowe_ruchy) nowe_ruchy++;  ile_domyslnych++; }
   brzegi[ile_brz++] = indeks-wlky-3;
   brzegi[ile_brz++] = indeks+2;
   brzegi[ile_brz++] = indeks+wlky+5;
   if (--ile_skl + kropka_w_naszym_brz<2)
     {
     if (lancuchy)
       PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile_brz);
     goto Ustaw_punkty;
     }
   ot[7]=ot[6];
   if (!kropka_w_naszym_brz) UsunSkladowaZOt(ot, ot[8], ot[6]);
   }
 else if (ot[7])
   brzegi[ile_brz++] = indeks+1;
 // czy stop z lewej?
 if (ot[0] && ot[6] && ot[0]!=ot[6] &&
    !(plansz_p[indeks-2*wlky-8] &3) && rozgrywka[indeks-2*wlky-8]==ktory_gracz) {
   int nstan = ZrobLatwyStop(rozgrywka, stopy, nowe_ruchy, sgf_ruch, zostaw_stopy, rozgr2, rozgr3,
			     plansz_p, indeks-wlky-4, ktory_gracz, zdakt, zobr);
   stan|=nstan;
   if (nstan & 1) { if (nowe_ruchy) nowe_ruchy++;  ile_domyslnych++; }
   brzegi[ile_brz++] = indeks-2*wlky-8;
   brzegi[ile_brz++] = indeks-wlky-5;
   brzegi[ile_brz++] = indeks-wlky-3;
   if (--ile_skl + kropka_w_naszym_brz<2)
     {
     if (lancuchy)
       PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile_brz);
     goto Ustaw_punkty;
     }
   ot[3]=ot[0];
   if (!kropka_w_naszym_brz) UsunSkladowaZOt(ot, ot[6], ot[0]);
   }
 else if (ot[3])
   brzegi[ile_brz++] = indeks-wlky-4;
 // czy stop z prawej?
 if (ot[2] && ot[8] && ot[2]!=ot[8] &&
    !(plansz_p[indeks+2*wlky+8] &3) && rozgrywka[indeks+2*wlky+8]==ktory_gracz) {
   int nstan =
     ZrobLatwyStop(rozgrywka, stopy, nowe_ruchy, sgf_ruch, zostaw_stopy, rozgr2, rozgr3,
		   plansz_p, indeks+W_P, ktory_gracz, zdakt, zobr);
   stan|=nstan;
   if (nstan & 1) { if (nowe_ruchy) nowe_ruchy++;  ile_domyslnych++;} 
   brzegi[ile_brz++] = indeks+wlky+3;
   brzegi[ile_brz++] = indeks+wlky+5;
   brzegi[ile_brz++] = indeks+2*wlky+8;
   if (--ile_skl + kropka_w_naszym_brz<2)
     {
     if (lancuchy)
       PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile_brz);
     goto Ustaw_punkty;
     }
   ot[5]=ot[2];
   if (!kropka_w_naszym_brz) UsunSkladowaZOt(ot, ot[8], ot[2]);
   }
 else if (ot[5])
   brzegi[ile_brz++] = indeks+W_P;
 if ((powierzchnia+ile_zdobytych && lancuchy) || stopy!=NULL)
   PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile_brz);
 }
 {
 // przydziel pamiec
 unsigned char* plan =plansze.PrzydzielPlansze();
 krint* dad  =skladowe.PrzydzielSkladowa();
 krint* stos =skladowe.PrzydzielSkladowa();
 krint* wnetrze =skladowe.PrzydzielSkladowa();
 int dind[4] = {-1, -wlky-4, W_P, 1};  // kolejnosc jest wazna!
 int nr=1;
 do {
   int maska_naszego_stopu = ktory_gracz | 0x80;  // 0x80 = potencjalny stop
   int maska_naszego_st_stopu = ktory_gracz==1 ? 4:8; //ktory_gracz==1 ? 0x14:0x28;
   int maska_st_stopu_przec= ktory_gracz==1 ? 8:4;
   // szukaj wolnego pola
   while (nr<8 && ot[nr]!=0) nr+=2;
   if (nr>=8) break;  // wolnych pol juz nie ma
   unsigned int lewo, ind = indeks + dind[nr>>1];
   // przejdz skladowa tego wolnego pola
   int js = UaktObszarWokolPola(rozgrywka, stopy, sgf_ruch, rozgr2, rozgr3, plansz_p, plan,
				ind, ktory_gracz, zdakt, zobr, ruchy_zam, zostaw_stopy, lancuchy);
   if (js) {
     if (js & 1) {
       if (nowe_ruchy)
	 *nowe_ruchy++ = ind | 0x4000;
       ile_domyslnych++;
     }
     stan |= js;
     if (--ile_skl + kropka_w_naszym_brz<2) break;
     // zaznacz pola, ktore sa wewnatrz akt. (stalego) stopu
     for (int k=0; k<4; k++)
       {
       unsigned int nind = indeks + dind[k];
       if (plan[nind]==59)  // pole wewnetrzne
         ot[2*k+1]=5;  // zaznacz jako zajete
       }
     }
   else
     { // omin puste pola, ktore sa na pewno w tej samej skladowej co [nr]
     OminPoleISasiadow(ot, nr);
     // zaznacz znalezione zewnetrzne pola
     for (int k=0; k<4; k++)
       {
       unsigned int nind = indeks + dind[k];
       if (plan[nind]==1 && ot[2*k+1]==0)  // pole zewnetrzne
         OminPoleISasiadow(ot, 2*k+1);
       }
     }
   }
 while (nr<8);
 plansze.ZwolnijPlansze(plan);    skladowe.ZwolnijSkladowa(dad);
 skladowe.ZwolnijSkladowa(stos);  skladowe.ZwolnijSkladowa(wnetrze);
 }
 Ustaw_punkty:;

 /*
 { 
   // test
   char s[50];
   sprintf(s,"(%d,%d): zd=%d, ss=%d, pot=%d",x,y,zdakt[0].zd,zdakt[0].ss, zdakt[0].pot_zd);
   ekran.WyswietlNapis(s);
   sprintf(s," [1]: zd=%d, ss=%d, pot=%d",zdakt[1].zd,zdakt[1].ss, zdakt[1].pot_zd);
   ekran.WyswietlNapis(s);
 }
 */

 // uaktualnij brzuszek przeciwnika, jesli postawiona kropka jest w nim pierwsza nasza...
 if (pierwsza_kr_w_brz_przec && (plansz_p[indeks] & 0x30)) {
   // i nadal jest wewn. brzuszka przec.
   UaktualnijBrzuszekP(rozgrywka, rozgr2, rozgr3,
		       plansz_p, indeks, ktory_gracz);
   stan |= 2;  // zmiana punktacji
 }
 {
   int k=ktory_gracz-1;
   ile_zdobytych = zdakt[k].zd+zdakt[k].pot_zd;
   powierzchnia  = zdakt[k].ss;
   powierzchnia2 = zdakt[1-k].ss;
   punktacja_ss  = zdakt[k].pss - zdakt[1-k].pss;
 }
 // TestRozgr23(rozgrywka, plansz_p, rozgr2, rozgr3);
 STOPER_STOP_ZPDA;
 return stan;
}

int ZrobPanstwo(unsigned char* rozgrywka, unsigned char* stopy,
		unsigned char* rozgr2, unsigned char* rozgr3,
		unsigned char* plansz_p, int x, int y, int ktory_gracz,
		TZdobycze zdakt[2], TZobrist &zobr,
		     int &ile_zdobytych, int &powierzchnia, int &powierzchnia2,
		     int &punktacja_ss,
		TRuchyZam &ruchy_zam,
		int lancuchy)
{
  int iledom;
  return ZrobPanstwo(rozgrywka, stopy, NULL, iledom, NULL, 0,
		     rozgr2, rozgr3, plansz_p,  x,  y, ktory_gracz,
		     zdakt, zobr, ile_zdobytych, powierzchnia, powierzchnia2,
		     punktacja_ss, ruchy_zam,lancuchy);
}

/*
int UstawPunktySS(unsigned char* plansz_p, unsigned char* plan,
                  unsigned int ind)
// [ind] -- pole *wewnatrz* stalego stopu, plan[ind]==0
// Ustawia bit 0x40 (pola punktowane) w stalym stopie zawierajacym [ind],
// zwraca liczbe, ktora trzeba dodac do punktacji_ss.
// Pola wewnatrz tego stopu zostaja zaznaczone na 1 w tablicy plan.
{
 krint* stos =skladowe.PrzydzielSkladowa();
 stos[0]=ind;
 plan[ind]=1;   // zaznacz jako wnetrze
 int na_stosie=1;
 int bylo_ss=0, pow=0, wnetrze[3];
 int maska = plansz_p[ind] & 0xf;
 do{
   ind = stos[--na_stosie];
   if (plansz_p[ind] & 0x40)
     { bylo_ss++; plansz_p[ind] &= ~0x40; }
   if (pow<3) wnetrze[pow]=ind;
   pow++;
   // idz na boki
   for (int k=0; k<4; k++)
     {
     unsigned int nind = ind + up.dind[k];
     if (plan[nind]==0 && (plansz_p[nind] & maska))
       {
       stos[na_stosie++]=nind;
       plan[nind]=1;  // zaznacz jako wewnetrzne
       }
     }
   }
 while (na_stosie);
 skladowe.ZwolnijSkladowa(stos);
 int jest_ss=0;
 if (pow>=1) { plansz_p[wnetrze[0]] |= 0x40;   jest_ss++; }
 if (pow>=2) { plansz_p[wnetrze[1]] |= 0x40;   jest_ss++; }
 if (pow>=5) { plansz_p[wnetrze[2]] |= 0x40;   jest_ss++; }
 return jest_ss - bylo_ss;
}
*/

/*
int TestPunktySS(unsigned char* plansz_p_arg)
// sprawdza, czy bity 0x40 sa dobrze ustawione, zwraca liczbe bledow
// (0 = wszystko dobrze)
// Bit 0x40 ustawiony poza stalym stopem jest liczony jako 10000
//  (dla ulatwienia identyfikacji rodzaju bledu --
// -- uwaga: to juz nie jest blad w 83.40+)
{
 unsigned char* plan =plansze.PrzydzielPlansze();
 unsigned char* plansz_p =plansze.PrzydzielPlansze();
 CzyscTablice(plan);  KopiujTablice(plansz_p, plansz_p_arg);
 int blad=0;
 for (int i=0; i<wlkx4wlky4; i++)
   if (plansz_p[i] & 0xc)
     {
     if (plan[i]==0 && UstawPunktySS(plansz_p, plan, i)!=0)
       blad++;
     }
   else if (plansz_p[i] & 0x40) blad+=10000;
 plansze.ZwolnijPlansze(plan);
 plansze.ZwolnijPlansze(plansz_p);
}
*/


int ZrobRuch(unsigned char* rozgrywka, unsigned char* stopy,
	     krint *nowe_ruchy, int &ile_domyslnych,
	     char *sgf_ruch, int zostaw_stopy,
	     unsigned char* plansz_p, unsigned int ruch, int ktory_gracz,
	     unsigned int ind_st, TZdobycze wynik[2], TZobrist &zobr,
	     int &ile_zdobytych, int &powierzchnia, int &powierzchnia2,
	     int &ile_zdobytych2,
	     TRuchyZam &ruchy_zam,
	     unsigned char* rozgr2, unsigned char* rozgr3)
// Jesli (ruch & 0x4000)==0, to
//   [ruch & ~0x4000]  - wlasnie postawiona kropka, przez gracza (ktory_gracz)
//   [ind_st]          - poprzednio postawiona kropka (przez przeciwnika)
//  Sprawdza, czy [ind_st] jest wewnatrz stalego stopu gracza
//   (ktory_gracz).  (Moze byc ind_st==0).
// w przeciwnym razie
//   [ruch & ~0x4000]  - ktory_gracz zamyka stop zawierajacy to pole
// Moze byc ruch==0, wtedy tylko zamyka ew. staly stop drugiego gracza [ind_st].
// Gdy:
//  zostaw_stopy == 1  -- zamknij wszystkie potencjalne *nasze* nowe stopy
//                        (dodane ostatnio postawiona kropka, gdy (ruch & 0x4000) ==0)
//                        (przydatne w MonteCarlo)
//  zostaw_stopy == 0  -- standardowe zachowanie,
//  zostaw_stopy == -1  -- nie zamyka ZADNYCH stopow (ktore trzeba zamknac, bo zasady
//       gry tego wymagaja, ani takich, ktore warto zamknac, bo nic nie wnosza),
//       potrzebne do wczytywania SGF i recznych stopow
// Gdy:
//  nowe_ruchy!=NULL, to zapisuje tam domyslnie wykonane ruchy zamykajace
// Wynik nie jest zerowany, tylko uaktualniany.
// Zwraca int z ustawionym bitem 0 (&1), gdy jest stop;
//   bitem 1 (&2), gdy jest nowy brzuszek;
//   bitem 2 (&4), gdy jest tylko zmiana punktacji (np. wstawienie kropki do wlasnego brzuszka)
{
  // TestRozgr23(rozgrywka, plansz_p, rozgr2, rozgr3);
  // zobr.Zeruj();  -- nie mozna!!
 int stan=0;
 ile_zdobytych=0;  powierzchnia=0; powierzchnia2=0;  ile_zdobytych2=0;
 ile_domyslnych=0;
 unsigned int ind= ruch & (~0x4000);
 int x = upl_x[ind], y=upl_y[ind];
 int zostaw_stopy_popk = (zostaw_stopy <= 0) ? zostaw_stopy : 0;
 if ((ruch & 0x4000)==0) {
   // zwykle == 3-kto, ale moze byc=kto, gdy 2 ruchy pod rzad
   int ktory_st = ind_st ? rozgrywka[ind_st] : 0; // gdy ind_st==0, wstaw cokolwiek!=ktory_gracz
   if (ruch) {
     // jesli ktory_st==ktory_gracz, to KLOPOTY: trzeba najpierw sprawdzic poprz kropke,
     // a potem panstwo...
     if (ktory_st==ktory_gracz) {   // na pewno ind_st!=0
       if ((plansz_p[ind_st] & (2 << (3-ktory_st)))!=0) {
	 unsigned char *plan=plansze.PrzydzielPlansze();

	 int nstan =
	   UaktObszarWokolPola(rozgrywka, stopy, sgf_ruch, rozgr2,rozgr3, plansz_p, plan, ind_st,
				   3-ktory_st, wynik, zobr, ruchy_zam, zostaw_stopy_popk);
	 stan|=nstan;
	 if (nstan & 1) { // byl stop
	   if (nowe_ruchy)
	     *nowe_ruchy++ = ind | 0x4000;  // zapisz domyslny ruch zamykajacy
	   ile_domyslnych++;
	 }
	 plansze.ZwolnijPlansze(plan);
	 ile_zdobytych2 += wynik[2-ktory_gracz].pot_zd + wynik[2-ktory_gracz].zd;
	 ile_zdobytych  += wynik[ktory_gracz-1].pot_zd + wynik[ktory_gracz-1].zd;
	 powierzchnia2  += wynik[2-ktory_gracz].ss;    // tutaj ktory_gracz, bo ile_zd...
	 powierzchnia   += wynik[ktory_gracz-1].ss;    // sa liczone wzgledem (ktory_gracz)
       }
       ind_st=0;   // nie sprawdzaj potem
     }
     // spr., czy wstawilismy do st.st. przec
     int maska_prz = ktory_gracz==1 ? 8:4;
     if ((plansz_p[ind] & maska_prz) && zasady_gry==0) {
       PostawKropke(rozgrywka,rozgr2,rozgr3,plansz_p,ind,ktory_gracz,wynik,zobr, sgf_ruch);
       powierzchnia2--;   // postawilismy kropke do stalego stopu przeciwnika (to jest w wynik)
       stan |= 2;
     }
     else {
       int punktacja_ss;
       TZdobycze zdakt[2];
       int ile_dom;
       stan|=ZrobPanstwo(rozgrywka, stopy, nowe_ruchy, ile_dom, sgf_ruch, zostaw_stopy,
			 rozgr2, rozgr3, plansz_p, x,y, ktory_gracz, zdakt, zobr,
			 ile_zdobytych,powierzchnia,powierzchnia2, punktacja_ss, ruchy_zam, 1);
       if (nowe_ruchy) nowe_ruchy+=ile_dom;
       ile_domyslnych+=ile_dom;
       wynik[0]+=zdakt[0];     wynik[1]+=zdakt[1];
     }
   }
   // teraz sprawdz, czy poprzednio postawiona kropka jest w stalym stopie
   if (ind_st) {     // tutaj ktory_st==3-ktory_gracz, wiec
     if ((plansz_p[ind_st] & (2 << ktory_gracz))!=0) { // mozna (2<<ktory_gracz) zamiast <<3-kto_st
       unsigned char *plan=plansze.PrzydzielPlansze();
       int nstan =
	 UaktObszarWokolPola(rozgrywka, stopy, sgf_ruch, rozgr2,rozgr3, plansz_p, plan, ind_st,
			     ktory_gracz, wynik, zobr, ruchy_zam, zostaw_stopy_popk);
       stan|=nstan;
       if (nstan & 1) { // byl stop
	 if (nowe_ruchy)
	   *nowe_ruchy++ = ind_st | 0x4000;  // zapisz domyslny ruch zamykajacy
	 ile_domyslnych++;
       }
       plansze.ZwolnijPlansze(plan);
       ile_zdobytych2 += wynik[2-ktory_gracz].pot_zd + wynik[2-ktory_gracz].zd;
       ile_zdobytych  += wynik[ktory_gracz-1].pot_zd + wynik[ktory_gracz-1].zd;
       powierzchnia2  += wynik[2-ktory_gracz].ss;
       powierzchnia   += wynik[ktory_gracz-1].ss;
     }
   }
 }
 else {  // tylko zamknij stop!
   unsigned char *plan=plansze.PrzydzielPlansze();
   stan|=UaktObszarWokolPola(rozgrywka, stopy, sgf_ruch, rozgr2,rozgr3, plansz_p, plan, ind, ktory_gracz,
			     wynik, zobr, ruchy_zam_NULL, 1);
   plansze.ZwolnijPlansze(plan);
   ile_zdobytych2 += wynik[2-ktory_gracz].zd;
   ile_zdobytych  += wynik[ktory_gracz-1].pot_zd + wynik[ktory_gracz-1].zd;   // zle, bo wynik nie jest zerowany w ZrobRuch
   powierzchnia2  += wynik[2-ktory_gracz].ss;
   powierzchnia   += wynik[ktory_gracz-1].ss;
 }
 // TestRozgr23(rozgrywka, plansz_p, rozgr2, rozgr3);
 return stan;
}

int CzyMozliwyStop(krint *skl, unsigned char *rozgr2, int i, int j, int ktory_gracz)
// czy gracz (ktory_gracz) stawiajac kropke w miejscu (i,j) bedzie mial
// stop lub staly stop
{
 STOPER_START_CZYM;
 unsigned char ot[9];
 /*
 unsigned int ind = WezIndeksTab(i,j-1);
 unsigned int indl = ind-wlky-4, indp=ind+W_P;
 ot[0] = rozgr2[indl  ];   ot[1] = rozgr2[ind  ];   ot[2] = rozgr2[indp  ];
 ot[3] = rozgr2[indl+1];   ot[4] = ktory_gracz;     ot[5] = rozgr2[indp+1];
 ot[6] = rozgr2[indl+2];   ot[7] = rozgr2[ind+2];   ot[8] = rozgr2[indp+2];
 */
 WezOtoczenieUlatw(ot, i, j, rozgr2, ktory_gracz);
 int is=UstawOtoczenie(ot);
 if (is<=1) { STOPER_STOP_CZYM; return 0; }
 krint jakie_sa[5] = {0,0,0,0,0};
 int ind_ot = 0;
 for (int dy=-1; dy<=1; dy++)
  for (int dx=-1; dx<=1; dx++)
   {
   if (ind_ot!=4 && ot[ind_ot])
     jakie_sa[ot[ind_ot]] = WezUI(skl, i+dx, j+dy);
   ind_ot++;
   }
 STOPER_STOP_CZYM;
 // zobacz, czy laczymy taka sama skladowa
 if (jakie_sa[1]==jakie_sa[2])
   return 1;
 if (is==2) return 0;    // dwie rozne skladowe
 if (jakie_sa[1]==jakie_sa[3] || jakie_sa[2]==jakie_sa[3])
   return 1;
 if (is==3) return 0;    // trzy rozne skladowe
 if (jakie_sa[1]==jakie_sa[4] || jakie_sa[2]==jakie_sa[4] || jakie_sa[3]==jakie_sa[4])
   return 1;
 return 0;    // cztery rozne skladowe
}

void IleWolnegoMiejsca(unsigned char* rozgrywka, unsigned char* plansz_p,
                       int &ile_wolnego, int &ile_wolnego_poza_sts)
{
 ile_wolnego=0;
 ile_wolnego_poza_sts=0;
 for (int i=up.lg; i<=up.pd; i++)
   if (rozgrywka[i]==0 &&        // nie ma tu jeszcze kropki
       (plansz_p[i] & 3)==0 &&   // nie wewnatrz stopu
       upl_marg[i]>=2) {         // wewnatrz planszy
     ile_wolnego++;
     if ((plansz_p[i] & 12)==0)  // nie wewnatrz stalego stopu
       ile_wolnego_poza_sts++;
   }
}


void ZnajdzSkladowe(krint *skl_tab, unsigned char *rozg, int ktory_gracz)
// znajduje skladowe dla obu graczy; w rozg powinno byc rozgr2, ew. rozgr3,
//  ale z rozgr3 jest mniej efektywnie
{
 STOPER_START_ZSKL;
 CzyscTablice(skl_tab);
 unsigned int num_skl_n=1;
 unsigned int num_skl_p=30001;
 unsigned int indeks_ij = up.lg;
 for (int i=0; i<wlkx; i++) {
  for (int j=0; j<wlky; j++)
    {
    unsigned char kr=rozg[indeks_ij];
    if (kr!=0)
      {
      if (skl_tab[indeks_ij]==0)
      if (kr==ktory_gracz)
        ZnajdzSkladowa(skl_tab, rozg, num_skl_n++, indeks_ij);
      else
        ZnajdzSkladowa(skl_tab, rozg, num_skl_p++, indeks_ij);
      }
    indeks_ij++;
    }
  indeks_ij+=4;
 }
 STOPER_STOP_ZSKL;
}

int DodajKropkeDoSkl(krint *wynik, krint *we, unsigned char *rozgr2,
     unsigned int indeks, int czyja, krint numskl)
// dodaje pojedyncza kropke [indeks] (czyja) do skladowych z we
//  i zapisuje w wynik
// jesli kropka tworzy oddzielna skladowa, to otrzyma ona numer numskl
// Zwraca liczbe skladowych, ktore sasiadowaly z kropka [indeks].
{
 krint jakies[6] = {0,0,0,0,0,0};   // 6 wystarczy!
 int iles=0;
 // zapamietaj wystepujace numery skladowych, zerowego w kolejnosci numeru
 //  nie zapamietuj wiecej niz raz
 unsigned int ind=indeks-wlky-4-1;    // lewo gora
 if (rozgr2[ind]==czyja)  { jakies[0]=we[ind];  iles=1; }
 ind++;   // lewo
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind++;   // lewo dol
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind=indeks-1;  // gora
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind+=2;   // dol
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind=indeks+wlky+4-1;    // prawo gora
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind++;   // prawo
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind++;   // prawo dol
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 if (iles<=1)
   {  // dodaj kropke
   KopiujTablice(wynik, we);
   wynik[indeks] = (iles==0) ? numskl : jakies[0];
   return iles;
   }
 // sa przynajmniej 2 skladowe; usun jakies[1] z nastepnych pol
 for (int i=iles-1; i>=2; i--)
   if (jakies[i]==jakies[1])
     jakies[i] = jakies[--iles];   // usun (powtarzajacy sie) numer jakies[i]
 if (iles==2)
   { // sa dwie skladowe, sklej je do jakies[0]
   for (int i=up.lg; i<=up.pd; i++)
     wynik[i] = (we[i]==jakies[1]) ? jakies[0] : we[i];
   wynik[indeks]=jakies[0];
   return 2;
   }
 // sa przynajmniej 2 skladowe; usun jakies[2] z nastepnych pol
 for (int i=iles-1; i>=3; i--)
   if (jakies[i]==jakies[2])
     jakies[i] = jakies[--iles];   // usun (powtarzajacy sie) numer jakies[i]
 if (iles==2)
   { // sa dwie skladowe, sklej je do jakies[0]
   for (int i=up.lg; i<=up.pd; i++)
     wynik[i] = (we[i]==jakies[1]) ? jakies[0] : we[i];
   wynik[indeks]=jakies[0];
   return 2;
   }
 if (iles==3)
   { // sa trzy skladowe, sklej je do jakies[0]
   for (int i=up.lg; i<=up.pd; i++)
     wynik[i] = (we[i]==jakies[1] || we[i]==jakies[2]) ? jakies[0] : we[i];
   wynik[indeks]=jakies[0];
   return 3;
   }
 // sa cztery skladowe, sklej je do jakies[0]
 for (int i=up.lg; i<=up.pd; i++)
   wynik[i] = (we[i]==jakies[1] || we[i]==jakies[2] || we[i]==jakies[3]) ?
                jakies[0] : we[i];
 wynik[indeks]=jakies[0];
 return 4;
}


int ZnajdzDomyslneRuchy(unsigned char* rozgrywka, unsigned char* plansz_p,
			int ktory_gracz,
			krint *nruchy, int st_x, int st_y)
// we: nruchy[0] -- ruch do wykonania
// wy:
//   zwraca n = liczbe ruchow (co najmniej jeden),
//   a w nruchy[1],...,nruchy[n-1] -- domyslne ruchy zamykajace
{
  unsigned char *pp = plansze.PrzydzielPlansze();
  unsigned char *r = plansze.PrzydzielPlansze();
  KopiujTablice(r, rozgrywka);
  KopiujTablice(pp, plansz_p);
  int ile_domysl, ile_zd,pow,pow2,ile_zd2;
  TZdobycze zdobycze[2];   TZobrist htab_zobr;

  ZrobRuch(r, NULL, &nruchy[1], ile_domysl,
	   NULL, 0, pp, nruchy[0], ktory_gracz, WezIndeksTab(st_x, st_y),
	   zdobycze, htab_zobr,
	   ile_zd,pow,pow2,ile_zd2, ruchy_zam_NULL, NULL, NULL);
  plansze.ZwolnijPlansze(pp);  plansze.ZwolnijPlansze(r);
  return ile_domysl + 1;
}



int GraKoncowa(unsigned char* rozgrywka, unsigned char* plansz_p,
                int ktory_gracz, 
		krint *nruchy, int &x, int &y, int st_x, int st_y)
// znajduje najlepszy ruch dla gracza (ktory_gracz)
// zwraca polozenie w (x,y)
// (st_x,st_y) - polozenie ostatnio postawionej kropki przeciwnika
//     (=0 - teraz pierwsza kropka)
// zwraca (0,0), gdy nie ma w ogole stalych stopow
// 
// zwraca liczbe ruchow (ruch + stopy), a kolejne ruchy w nruchy
//
// Mozliwe ulepszenie: powinien zwracac uwage na to, jakie stopy
//   powstana po wstawieniu kropki do wlasnego stopu.
//   np. podzial stopu 1x5 na dwa stopy 1x2 jest bardziej korzystny
//       niz podzial na jeden 1x1 i jeden 1x3.
{
 int liczba_nruchow=0;
 krint* stos    =skladowe.PrzydzielSkladowa();
 krint* wnetrze =skladowe.PrzydzielSkladowa();
 unsigned char* plan =plansze.PrzydzielPlansze();
 CzyscTablice(plan);
 int dind[4] = {-1,-wlky-4,W_P,1};
 int ot_dind[9] = { -wlky-5,-1,wlky+3, -wlky-4,0,W_P, -wlky-3,1,wlky+5 };
 int stary_ind = WezIndeksTab(st_x,st_y);
 int ocena_najl=0, ile_najl=0;
 unsigned int najlepsze[16] = {0}; // {0} wazne, gdy nie ma stalych stopow
 for (int i=3; i<wlkx+1; i++)  // i=3..wlkx, bo stale stopy moga byc tylko wewnatrz
   {
   unsigned int ind = WezIndeksTab(i,3);
   for (int y=3; y<wlky+1; y++)
    {
      if (rozgrywka[ind]==0 && (plansz_p[ind] & 0xc) && (plansz_p[ind] & 3)==0)   // 83.47
     {  // wewnatrz stalego stopu!
     int czyj_stop = (plansz_p[ind] & 0xc) >> 2;
     // zabezpieczenie dla zasad_gry==2:
     if (czyj_stop==3) {
       czyj_stop =  plansz_p[ind] & 0x3;       // 83.47
       if (czyj_stop==3)
	 czyj_stop=1;  // cokolwiek
     }
     if (plan[ind]==0)  // jeszcze w nim nie bylismy?
       {  // znajdz wielkosc tego stalego stopu
       int na_stosie=1;  stos[0]=ind;  plan[ind]=10;
       int pow=0, ta_skl=0;
       do {
         unsigned int nind = stos[--na_stosie];
         wnetrze[pow++]=nind;
         if (nind==stary_ind) ta_skl=1;
         // idz na boki
         for (int k=0; k<4; k++)
           {
           unsigned int nnind = nind + dind[k];
           if (plan[nnind]==0 && rozgrywka[nnind]!=czyj_stop)
             plan[stos[na_stosie++] = nnind] = 10;
           }
         }
       while (na_stosie);
       if (pow<10) for (int j=0; j<pow; j++) plan[wnetrze[j]] = pow;
       if (ta_skl && czyj_stop==ktory_gracz)
         for (int j=0; j<pow; j++) plan[wnetrze[j]] |= 0x20;  // bonus +32
           // za postawienie kropki do tej samego naszego stopu, do ktorego
           // wstawil nam przed chwila przeciwnik
       }
     // znajdz liczbe skladowych
     unsigned char ot[9];
     for (int j=0; j<9; j++)
       ot[j] = rozgrywka[ind + ot_dind[j]];
     ot[4] = czyj_stop;
     int ocena = (UstawOtoczenie(ot) << 6) + plan[ind] +
                 (czyj_stop==ktory_gracz ? 0:16);
     // zapamietaj ruch
     if (ocena>ocena_najl)
       { ocena_najl=ocena;  najlepsze[0]=ind;  ile_najl=1; }
     else if (ocena==ocena_najl && ile_najl<16) najlepsze[ile_najl++]=ind;
     }
    ind++;
    }
   }
 skladowe.ZwolnijSkladowa(stos);   skladowe.ZwolnijSkladowa(wnetrze);
 plansze.ZwolnijPlansze(plan);
 // wybierz najlepszy ruch
 int ktory = (ile_najl<=1) ? 0 : random(ile_najl);
 x = upl_x[najlepsze[ktory]];
 y = upl_y[najlepsze[ktory]];
 nruchy[0] = najlepsze[ktory];
 liczba_nruchow= (nruchy[0]!=0);
 if (liczba_nruchow) {
   unsigned char* pp =plansze.PrzydzielPlansze();
   unsigned char* r2 =plansze.PrzydzielPlansze();
   KopiujTablice(r2, rozgrywka);
   KopiujTablice(pp, plansz_p);
   int ile_domysl, ile_zd,pow,pow2,ile_zd2;
   TZdobycze zd[2];
   TZobrist zobr;
   ZrobRuch(r2, NULL, &nruchy[1], ile_domysl,
	    NULL, 0, pp, nruchy[0], ktory_gracz, WezIndeksTab(st_x, st_y),
	    zd, zobr, ile_zd,pow,pow2,ile_zd2, ruchy_zam_NULL, NULL, NULL);
   liczba_nruchow += ile_domysl;
   plansze.ZwolnijPlansze(pp);   plansze.ZwolnijPlansze(r2);
 }
 return liczba_nruchow;
}
