/*  Programik do gry w kropki.
 *
 *  Copyright (C) 2003,2004,2005 Bartek Dyda <kropki@yahoo.co.uk>.
 * 
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifdef SA_STOPERY
#define STOPER_ZERUJ_WSZYSTKIE  ssZeruj()

#define STOPER_START_OS12  ssStart(0) 
#define STOPER_STOP_OS12  ssStop(0)

#define STOPER_START_US12  ssStart(1)
#define STOPER_STOP_US12  ssStop(1)

#define STOPER_START_ZPDA  ssStart(2)
#define STOPER_STOP_ZPDA  ssStop(2)

#define STOPER_START_ZM12  ssStart(3)
#define STOPER_STOP_ZM12  ssStop(3)

#define STOPER_START_AW  ssStart(4)
#define STOPER_STOP_AW  ssStop(4)

#define STOPER_START_ZSKL  ssStart(5)
#define STOPER_STOP_ZSKL  ssStop(5)

#define STOPER_START_UZAK  ssStart(6)
#define STOPER_STOP_UZAK  ssStop(6)

#define STOPER_START_DSAS  ssStart(7)
#define STOPER_STOP_DSAS  ssStop(7)

#define STOPER_START_KARY  ssStart(8)
#define STOPER_STOP_KARY ssStop(8)

#define STOPER_START_CIET  ssStart(9)
#define STOPER_STOP_CIET ssStop(9)

#define STOPER_START_ROBD  ssStart(10)
#define STOPER_STOP_ROBD ssStop(10)

#define STOPER_START_ROBM  ssStart(11)
#define STOPER_STOP_ROBM ssStop(11)

#define STOPER_START_CZYM  ssStart(12)
#define STOPER_STOP_CZYM ssStop(12)

#define STOPER_START_BEZP  ssStart(13)
#define STOPER_STOP_BEZP ssStop(13)

#define STOPER_START_SORT  ssStart(14)
#define STOPER_STOP_SORT ssStop(14)

#define STOPER_START_ZAPO  ssStart(15)
#define STOPER_STOP_ZAPO ssStop(15)

#define STOPER_START_BEZS  ssStart(16)
#define STOPER_STOP_BEZS ssStop(16)

#define STOPER_START_ZWEZ  ssStart(17)
#define STOPER_STOP_ZWEZ ssStop(17)

#define STOPER_START_ZWST  ssStart(18)
#define STOPER_STOP_ZWST ssStop(18)

#define STOPER_START_SSTO ssStart(19)
#define STOPER_STOP_SSTO ssStop(19)

#define STOPER_START_TABL ssStart(20)
#define STOPER_STOP_TABL ssStop(20)

#define STOPER_START_GROZ ssStart(21)
#define STOPER_STOP_GROZ ssStop(21)

#define STOPER_START_POPR ssStart(22)
#define STOPER_STOP_POPR ssStop(22)

#define STOPER_START_ZAMS ssStart(23)
#define STOPER_STOP_ZAMS ssStop(23)

#define STOPER_START_UCTF ssStart(24)
#define STOPER_STOP_UCTF ssStop(24)

#define STOPER_START_ROBS  ssStart(25)
#define STOPER_STOP_ROBS ssStop(25)

#define STOPER_START_UOWP  ssStart(26)
#define STOPER_STOP_UOWP ssStop(26)

// super-stopery
//   ssStart(i)   -- wlacza stoper nr i (od 0 do 31)
//   ssStop(i)    -- wylacza stoper nr i (od 0 do 31)
//   ssPodaj(i)   -- zwraca liczbe setek tysiecy cykli na stoperze
//   ssZeruj(i)   -- zeruje stoper
static long long int ss_stopery[32];
static long int ss_wlaczony[32];

void ssStart(int i)
// startuje stoper
{
 if (!ss_wlaczony[i])
  {
  asm("pushl %%eax;" "pushl %%edx;" "rdtsc;"
  "subl 0(%%esi),%%eax;"
  "sbbl 4(%%esi),%%edx;"
  "movl %%eax,0(%%esi);"
  "movl %%edx,4(%%esi);"
  "popl %%edx;" "popl %%eax;"
  :
  :"S" (&ss_stopery[i])
  : "memory", "%cc"         // zmienia pamiec, flagi
  );
  ss_wlaczony[i]=1;
  }
}

void ssStop(int i)
// zatrzymuje stoper
{
 if (ss_wlaczony[i])
  {
  asm("pushl %%eax;" "pushl %%edx;" "rdtsc;"
  "subl 0(%%esi),%%eax;"
  "sbbl 4(%%esi),%%edx;"
  "movl %%eax,0(%%esi);"
  "movl %%edx,4(%%esi);"
  "popl %%edx;" "popl %%eax;"
  :
  :"S" (&ss_stopery[i])
  : "memory", "%cc"         // zmienia pamiec, flagi
  );
  ss_wlaczony[i]=0;
  }
}

long int ssPodaj(int i)
// podaje odczyt w setkach tysiecy cykli
{
 long int wynik=0;
 ssStop(i);
// if (!ss_wlaczony[i])
   {
 asm("pushl %%eax;" "pushl %%edx;" "pushl %%ebx;"
 "movl 0(%%esi),%%eax;"
 "movl 4(%%esi),%%edx;"
 "movl $100000,%%ebx;"
 "divl %%ebx;"
 "movl %%eax,0(%%edi);"
 "popl %%ebx;" "popl %%edx;" "popl %%eax;"
 :
 :"S" (&ss_stopery[i]),
  "D" (&wynik)
 : "memory", "%cc"         // zmienia pamiec, flagi
 );
  }
 return wynik;
}

inline void ssZeruj(int i)
{ ss_stopery[i]=0; ss_wlaczony[i]=0; }

inline void ssZeruj()
{ for (int i=0; i<sizeof(ss_stopery)/sizeof(ss_stopery[0]); i++)
   { ss_stopery[i]=0; ss_wlaczony[i]=0; }
}

#else

#define STOPER_ZERUJ_WSZYSTKIE  ;

#define STOPER_START_OS12  ;
#define STOPER_STOP_OS12   ;

#define STOPER_START_US12  ;
#define STOPER_STOP_US12   ;

#define STOPER_START_ZPDA  ;
#define STOPER_STOP_ZPDA   ;

#define STOPER_START_ZM12  ;
#define STOPER_STOP_ZM12   ;

#define STOPER_START_AW  ;
#define STOPER_STOP_AW  ;

#define STOPER_START_ZSKL  ;
#define STOPER_STOP_ZSKL  ;

#define STOPER_START_UZAK  ;
#define STOPER_STOP_UZAK   ;

#define STOPER_START_DSAS  ;
#define STOPER_STOP_DSAS   ;

#define STOPER_START_KARY ;
#define STOPER_STOP_KARY  ;

#define STOPER_START_CIET ;
#define STOPER_STOP_CIET  ;

#define STOPER_START_ROBD ;
#define STOPER_STOP_ROBD  ;

#define STOPER_START_ROBM ;
#define STOPER_STOP_ROBM  ;

#define STOPER_START_CZYM ;
#define STOPER_STOP_CZYM  ;

#define STOPER_START_BEZP ;
#define STOPER_STOP_BEZP  ;

#define STOPER_START_SORT ;
#define STOPER_STOP_SORT  ;

#define STOPER_START_ZAPO ;
#define STOPER_STOP_ZAPO  ;

#define STOPER_START_BEZS ;
#define STOPER_STOP_BEZS  ;

#define STOPER_START_ZWEZ ;
#define STOPER_STOP_ZWEZ  ;

#define STOPER_START_ZWST ;
#define STOPER_STOP_ZWST  ;

#define STOPER_START_SSTO ;
#define STOPER_STOP_SSTO  ;

#define STOPER_START_TABL ;
#define STOPER_STOP_TABL  ;

#define STOPER_START_GROZ ;
#define STOPER_STOP_GROZ  ;

#define STOPER_START_POPR ;
#define STOPER_STOP_POPR  ;

#define STOPER_START_ZAMS ;
#define STOPER_STOP_ZAMS  ;

#define STOPER_START_UCTF ;
#define STOPER_STOP_UCTF  ;

#define STOPER_START_ROBS ;
#define STOPER_STOP_ROBS  ;

#define STOPER_START_UOWP ;
#define STOPER_STOP_UOWP  ;
#endif

