/*   Programik do gry w kropki -- wyswietlanie.
 *
 *  Copyright (C) 1999,2001,2002,2003,2004,2005,2006,2007,2008,2009 Bartek Dyda <kropki@yahoo.co.uk>.
 *  Copyright (C) 2009 Alexander Mishchenko.
 *
 *  Some ideas by Rafal Pikula (1999,2001,2002,2003,2004,2005,2006,2007)
 * 
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <algorithm>
#include "ekro.h"
#include <limits.h>
#include <time.h>
#include <ctype.h>  // isdigit()

typedef int    TFlagi;     // flagi: lewy przycisk myszy, ...

#ifndef TEKSTOWY
int SZER_FONTU=6, WYS_FONTU=8;
#endif

#define ZD_NIC  0
// zdarzenia wewnetrzne TMenuGracz
#define ZD_OK   1
#define ZD_ANULUJ   2
#define ZD_KTO   800
#define ZD_NOWEIMIE 802
#define ZD_POZIOMGRY 804
#define ZD_MOSTKI 830
#define ZD_AGRESJA 832
#define ZD_PRZEJMUJESIE 870
#define ZD_PRZEJMUJESIE_PRZEC 872
#define ZD_BRZUSZKI 878
#define ZD_WAGAKROPKI 900
#define ZD_OPCJE11 920
#define ZD_OPCJE12 930
#define ZD_OCENASKL 940
#define ZD_KIEDYCZAS 950
#define ZD_LIMITCZAS 960
#define ZD_ANTYWEZE_O 970
#define ZD_ANTYWEZE_S 972
#define ZD_ANTYWEZE_R 974
#define ZD_BEZPIECZNE 976
#define ZD_SEX_1 978
#define ZD_SEX_2 992
#define ZD_ROZSZ_OST 999
#define ZD_FPOLE     1030
#define ZD_WAGABO_PRZEC  1035
#define ZD_WAGABO_NASZE  1036
#define ZD_DYLATACJA     1037
#define ZD_EROZJA        1070
#define ZD_PUNKTZAPOLE   1100
#define ZD_WAGA_LATWAFO  1102
#define ZD_LISTARUCHOW_N 1104
#define ZD_LISTARUCHOW_P 1114
#define ZD_LISTARUCHOW_U 1124
#define ZD_LISTARUCHOW_L 1134
#define ZD_GLEBOKOSC 1200

#define ZD_ITERACJI  1300
#define ZD_MC_FUNKCJA  1301

#define ZD_TEST1  2200
#define ZD_TEST2  2202
#define ZD_TEST3  2204

// zdarzenia wewnetrzne glownego menu
#define ZD_OPROGRAMIE 30
#define ZD_OPCJEW     31
#define ZD_TEKST_RYSUJ 32
#define ZD_RYSOW_ZERUJ 33
#define ZD_RYSOWANIE  34  // 0,...,+2

// zdarzenia wewnetrzne opcji wyswietlania
#define ZD_WLK_KROPKI 40
#define ZD_POKAZ_AN 47
#define ZD_ILE_R_W_WATKU 50
#define ZD_ODSW_AKT_WATKU 60
#define ZD_ODSW_LACZNY_CZAS 70
#define ZD_KROTKIE_IMIE 80
#define ZD_CIENIOWANIE  84
#define ZD_KOLORY       90
// zdarzenia wewnetrzne TPlikiMenu (ZD_PLIK_NR do ...+ILE_PLIKOW_MENU)
#define ZD_PLIK_NR      50
#define ZD_PLIK_NR_STAT 65
#define ZD_NAZWAOSTPLIKU 80
#define ZD_INFOOSTPLIK 81
// zdarzenia wewnetrzne TStatTurnieju/TFiltr
#define ZD_FILTR_ROZPX  2
#define ZD_FILTR_ROZPY  4
#define ZD_FILTR_WYGRX  6
#define ZD_FILTR_WYGRY  8
#define ZD_FILTR_REMIS  10
#define ZD_FILTR_NRPOZ  12
#define ZD_FILTR_INFO   14
#define ZD_FILTR_OK     15
#define ZD_FILTR_ANULUJ  16
#define ZD_FILTR_RUCH0   17
#define ZD_FILTR_RUCHX   19
#define ZD_FILTR_RUCHY   21
#define ZD_FILTR_SYMET   23
#define ZD_FILTR_GRACZ_X 100
#define ZD_FILTR_GRACZ_Y 300

// zdarzenia wewnetrzne TWezKalendarz
#define ZD_DRUZYNA  40
#define ZD_WNETRZE  41

// zdarzenia wewnetrzne TTurniejMenu
#define ZDT_OK           1
#define ZDT_ANULUJ       2
#define ZDT_PRZENUMERUJ  3
#define ZDT_LICZBA_GR    4
#define ZDT_GRACZ_NR     10
#define ZDT_ZMIEN_GR     50
#define ZDT_WLKX         150
#define ZDT_WLKY         350
#define ZDT_ZASADY       500
// BAZAGR musi byc wieksza od wszystkich innych zdarzen ZDT_
//  oraz od wszystkich zdarzen wewnetrznych TMenuGracz
#define ZDT_BAZAGR       10000



//TKolor color_button_fon=0xefefef, color_button_up_border=0xffffff, color_button_down_border=0x999999,
//  color_button_border=0x222222,color_button_text=0,color_button_border_inactive=0x888888,color_editor_fon=0xe8e8e8;
//TKolor color_button_text_inactive = 0x888888, color_button_fon_inactive=0x444444;

// funkcje pomocnicze
int TypLiczby(int liczba)
// zwraca typ liczby (=1 - pojedyncza, =2 - mnoga1, =3 - mnoga2)
{
 if (liczba<0) liczba=-liczba;
 if (liczba==1) return 1;
 int reszta= liczba % 100;
 if (reszta>=12 && reszta<=14) return 3;
 reszta= liczba % 10;
 if (reszta>=2 && reszta<=4) return 2;
 return 3;
}

struct {
  int WERSJA_KROPEK, WERSJA_KROPEK_LOW;
  int HTABZ_ile, HTABZ_wlk, HTABZ_klucz;
} wersja;

void TEkran::UstawWersje(int w, int wlow, int hz1,int hz2,int hz3)
{
  wersja.WERSJA_KROPEK=w;    wersja.WERSJA_KROPEK_LOW=wlow; 
  wersja.HTABZ_ile=hz1;      wersja.HTABZ_wlk=hz2;   wersja.HTABZ_klucz=hz3;
}

int TEkran::CzyKrotkieImie()
{ return krotkie_imie; }


char* TEkran::RuchTekst(char *s, int x, int y)
{
  sprintf(s, "%c%d", (x<26) ? (x+'a') : (x-26+'A'), int(gra.DWlkY()-y));
  return s;
}

#ifndef TEKSTOWY

#define KOLOR_ZOLTY        0
#define KOLOR_TLA          1
#define KOLOR_MENU         2
#define KOLOR_1            3
#define KOLOR_2            4
#define KOLOR_POMOCY       5
#define KOLOR_TLA_POMOCY   6
#define KOLOR_TLA_PLANSZY  7
#define KOLOR_KRATEK       8
#define KOLOR_WYL_MENU     9
#define KOLOR_TLA_GR       10
#define KOLOR_MENU_GR      11

// KOLOR_WYL_MENU_GR aktualnie nieuzywany...
#define KOLOR_WYL_MENU_GR  12

#define KOLOR_OBWODKI      13
#define KOLOR_CIEN1        14
#define KOLOR_CIEN2        15
#define KOLOR_RAMKI        16
#define KOLOR_WSPOLRZ      17

#define KOLOR_BUTTON_UP_BORDER    18
#define KOLOR_BUTTON_DOWN_BORDER  19
#define KOLOR_BUTTON_BORDER       20
#define KOLOR_BUTTON_TEXT         21
#define KOLOR_BUTTON_FON          22
#define KOLOR_BUTTON_BORDER_INACTIVE    23
#define KOLOR_EDITOR_FON          24
#define KOLOR_BUTTON_FON_INACTIVE 25
#define KOLOR_BUTTON_TEXT_INACTIVE 26
#define KOLOR_OSTATNI             26


TKolor TEkran::kolory_suwaka[];
TKolor TEkran::kolory_ciemnego_suwaka[];
TKolor TEkran::kolory_przycisku[];
TKolor TEkran::kolory_przycisku_kilka_opcji[];
TKolor TEkran::kolory_przycisku_dwie_opcje[];
TKolor TEkran::kolory_edytora[];
TKolor TEkran::kolory_wybor_przycisku[];

//Button
void MyBox(int x1, int y1, int x2, int y2, TKolor *k)
{
  GrFilledBox(x1, y1, x2, y2, k[4]); //color_button_fon
  GrBox(x1, y1, x2, y2, k[2]);  //color_button_border
  GrLine(x1+1, y1+1, x2-1, y1+1, k[0]); //color_button_up_border
  GrVLine(x1+1, y1+1, y2-1, k[0]); //color_button_up_border);
  GrLine(x1+2, y2-1, x2-1, y2-1,k[1]); //color_button_down_border);
  GrVLine(x2-1, y2-1, y1+2,k[1]); //color_button_down_border);
}

void Wypisz(int x, int y, const char *tekst, TKolor kolor, 
	    TKolor kolortla, int align)
{
  if (tekst[0]=='$')
    if (tekst[1]=='$')  // pomin pierwszy znak $, a reszte wypisz
      outtextxy(x, y, &tekst[1], kolor, kolortla, align);
    else
      outtextxy(x, y, slowa[&tekst[1]], kolor, kolortla, align);
  else
    outtextxy(x, y, tekst, kolor, kolortla, align);
}

void WypiszBold(int x, int y, const char *tekst, TKolor kolor, 
		TKolor kolortla, int align)
// wypisuje pogrubiony tekst (lepiej byloby uzywac innego fontu...)
{
  Wypisz(x, y, tekst, kolor, kolortla, align);
  if (ekran.CzyCzcionkaBold())
    Wypisz(x+1, y, tekst, kolor, kolortla, align);
}


#define POMOC_POZIOM 1
#define POMOC_BRZUSZ 2
#define POMOC_AGRESJ 3
#define POMOC_ZDOBNA 4
#define POMOC_ZDOBPR 5
#define POMOC_WAGAKR 6
#define POMOC_ROZMOS 7
#define POMOC_OPCJ12 8
#define POMOC_SKLADO 9
#define POMOC_AWEZEO 10
#define POMOC_AWEZES 11
#define POMOC_AWEZER 12
#define POMOC_GLEBOK 13
#define POMOC_SEX_1  14
#define POMOC_SEX_2  15
#define POMOC_QUIETS 16
#define POMOC_KIEDYC 17
#define POMOC_WLKPLA 18
#define POMOC_OPROGR 19
#define POMOC_BLOKAD 20
#define POMOC_TRYB   21
#define POMOC_PAUZA  22
#define POMOC_INFOAN 23
#define POMOC_PRZENU 24
#define POMOC_TURNST 25
#define POMOC_SBEZP  26
#define POMOC_KIMIE  27
#define POMOC_FPOLE  28
#define POMOC_WAGABO 29
#define POMOC_DYLAT  30
#define POMOC_EROZJA 31
#define POMOC_PKTPOL 32
#define POMOC_WAGALF 33
#define POMOC_DPLIK  34
#define POMOC_LISTARUCHOW_N 35
#define POMOC_LISTARUCHOW_P 36
#define POMOC_LISTARUCHOW_U 37
#define POMOC_LISTARUCHOW_L 38
#define POMOC_STOP 39
#define POMOC_ZASADY 40
#define POMOC_RYS    41
#define POMOC_RYS_ZER 42
#define POMOC_MC_ITERACJI 43
#define POMOC_MC_FUNKCJA  44
#define POMOC_LIMIT_CZASU 45

//
#define POMOC_STGRX  100
#define POMOC_STGRY  101
#define POMOC_STROZX 102
#define POMOC_STROZY 103
#define POMOC_STWYGX 104
#define POMOC_STREMI 105
#define POMOC_STWYGY 106
#define POMOC_STNPOZ 107
#define POMOC_STWSPX 108
#define POMOC_STWSPY 109
#define POMOC_STUSYM 110
//
#define POMOC_OPCIEN  200
#define POMOC_OPKOLOR 201
#define POMOC_OPWLKK  202
//
#define POMOC_TEST1 1000
#define POMOC_TEST2 1001
#define POMOC_TEST3 1002

void PokazPomoc(int x, int y, int nrs, int nrpods)
{
  if (nrs<0) return;
  FILE *f=fopen(nazwa_pliku_pomocy,"rt");
  if (f==NULL) return;
  const int max_wierszy_tekstu=22;
  char tekst[max_wierszy_tekstu][50];
  int wiersz=0, dlugw=0;
  int teraz_liczba=0, kopiuj_tekst=0;
  char aktl[2][15];
  int ktoral=0, dlugl=0;
  while (!feof(f)) {
    char z;
    fread(&z,1,1,f);
    if (z=='$')
      if (teraz_liczba) {
	aktl[ktoral][dlugl]=0;
	if (atoi(aktl[0])==nrs && (ktoral==0 || atoi(aktl[1])==nrpods))
	  kopiuj_tekst |= (wiersz<max_wierszy_tekstu);
	teraz_liczba=0;  ktoral = dlugl = 0;
      }
      else {
	if (kopiuj_tekst) {
	  tekst[wiersz][dlugw]=0;
	  wiersz++;  dlugw=0;  kopiuj_tekst=0;
	}
	teraz_liczba=1;
      }
    else // z!='$'
      if (teraz_liczba) 
	if (isdigit(z)) {
	  if (dlugl+1 < sizeof(aktl[0]))
	    aktl[ktoral][dlugl++] = z;
	}
	else {
	  if (z=='i') {
	    aktl[ktoral][dlugl]=0;
	    if (atoi(aktl[0])==nrs && (ktoral==0 || atoi(aktl[1])==nrpods))
	      kopiuj_tekst |= (wiersz<max_wierszy_tekstu);
	    ktoral=0; dlugl=0;
	  }
	  else if (z=='.' && ktoral==0) {
	    ktoral=1;  aktl[0][dlugl]=0;  dlugl=0;
	  }
	}
      else // !teraz_liczba
	if (kopiuj_tekst)
	  if (z=='\n') {
	    tekst[wiersz][dlugw]=0;
	    if (dlugw || wiersz) { // ignoruj poczatkowe puste wiersze
	      dlugw=0;   wiersz++;
	      if (wiersz==max_wierszy_tekstu) kopiuj_tekst=0;
	    }
	  }
	  else if (dlugw+1<sizeof(tekst[0]))
	    if (z=='\\') { // czy inny znak ?
	      char buf[3];
	      fread(buf,1,1,f);
	      if (buf[0]!='\\') {  // inny znak!
		fread(&buf[1],1,2,f);  // wczytaj kolejne 2 cyfry osemkowe znaku
		int kod = int(buf[0]-'0')*64 + int(buf[1]-'0')*8 + buf[2]-'0';
		if (kod>=0 && kod<0x100)
		  tekst[wiersz][dlugw++]=kod;
	      }
	      else tekst[wiersz][dlugw++]=z; // po prostu backslash
	    }
	    else
	      tekst[wiersz][dlugw++]=z;      // zwykly znak
  }
  fclose(f);
  if (wiersz==0 && dlugw==0) return;
  if (wiersz<max_wierszy_tekstu) tekst[wiersz][dlugw]=0;
  if (dlugw) wiersz++;
  while (wiersz>0 && tekst[wiersz-1][0]==0) wiersz--;
  // pokaz
  int odstep = WYS_FONTU/2-1;
  int wys = wiersz * (WYS_FONTU+odstep) + odstep +2;
  int szer = 302;
  // znajdz miejsce do wyswietlenia
  int xst = std::min(x, (ekran.DajRozdzX()-1-szer));
  int yst = y+2*WYS_FONTU;
  if (yst+wys >= ekran.DajRozdzY())
    yst = y - 2*WYS_FONTU - wys;
  GrZapamietajObszar(xst,yst,szer+1,wys+1);
  // narysuj pomoc
  GrFilledBox(xst+1,yst+1,xst+szer,yst+wys,ekran.DajKolorZielonyTla());
  GrBox(xst,yst,xst+szer,yst+wys,ekran.DajKolorZielony());
  for (int i=0; i<wiersz; i++)
    Wypisz(xst+3,yst+odstep+i*(odstep+WYS_FONTU), tekst[i], 
	      ekran.DajKolorZielony(), ekran.DajKolorZielonyTla(), KR_ALIGN_LEFTTOP);
  GrFlush();
  // czekaj
  GrMouseEvent gme;
  for (;;) {
    GrMouseGetEvent((GR_M_KEYPRESS | GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_MIDDLE_DOWN),
		    &gme);
    if ((gme.flags & (GR_M_KEYPRESS | GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_MIDDLE_DOWN)))
      break;
  }
  GrOdtworzObszar();
  GrFlush();
}

class TElMenu
  {
  public:
  short int *wspolrz;
  TElMenu   *nast;
  TKolor    *kolor;   // [0]=kolortla, [1],[2],... -- nastepne kolory
  short int str_pomocy;
  // DajZdarzenie() sprawdza, czy element lub jakis jego nastepnik
  // w liscie wskazywanej przez *nast daje zdarzenie inne niz ZD_NIC
  // i zwraca to zdarzenie.
  // Podobnie dzialaja InicjujZdarzeniem() i Rysuj() -- przechodza przez
  // cala liste i inicjuja/rysuja.
  int     DajZdarzenie(TKlawisz k, TFlagi f, int x, int y);
  int     DajWartosc(int zd);
  void    InicjujZdarzeniem(int zd);
  void    RysujJesliZdarzenie(int zd);
  void    Rysuj();
  void    Przesun(int dx, int dy);
  void    Zniszcz();
  virtual void PrzesunTylkoTen(int dx, int dy)
   { wspolrz[0]+=dx; wspolrz[1]+=dy; wspolrz[2]+=dx; wspolrz[3]+=dy; };
  //
  virtual ~TElMenu() { ; };
  TElMenu() { nast=NULL; };
  protected:
  virtual int DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y)
    { return ZD_NIC; };
  virtual int DajWartosc_el(int zd) { return ZD_NIC; };
  virtual void InicjujZdarzeniem_el(int zd) {};
  virtual void RysujJesliZdarzenie_el(int zd) {};
  virtual void Rysuj_el()=0;
  virtual void PrzesunDrzewo(int dx, int dy)
    { PrzesunTylkoTen(dx,dy); };
  // funkcja WSrodku() sprawdza, czy podane wsp. mieszcza sie w prostokacie.
  // Nie zawsze ma to sens -- np. klasa TNapis wyprowadzona z TElMenu
  // nie definiuje prostokata!
  virtual void ZniszczPoddrzewa() {};
  virtual int WSrodku(int x, int y)
    { return (x>wspolrz[0] && x<wspolrz[2]) && (y>wspolrz[1] && y<wspolrz[3]);};
  };

int TElMenu::DajZdarzenie(TKlawisz k, TFlagi f, int x, int y)
{
 TElMenu *wsk=this;
 do
   {
   int zd = wsk->DajZdarzenie_el(k,f,x,y);
   if (zd!=ZD_NIC) return zd;
   wsk = wsk->nast;
   }
 while (wsk!=NULL);
 return ZD_NIC;
}

int  TElMenu::DajWartosc(int zd)
{
 TElMenu *wsk=this;
 do
   {
   int zdarz = wsk->DajWartosc_el(zd);
   if (zdarz!=ZD_NIC) return zdarz;
   wsk = wsk->nast;
   }
 while (wsk!=NULL);
 return ZD_NIC;
}

void TElMenu::InicjujZdarzeniem(int zd)
{
 TElMenu *wsk=this;
 do
   {
   wsk->InicjujZdarzeniem_el(zd);
   wsk = wsk->nast;
   }
 while (wsk!=NULL);
}

void TElMenu::RysujJesliZdarzenie(int zd)
{
 TElMenu *wsk=this;
 do
   {
   wsk->RysujJesliZdarzenie_el(zd);
   wsk = wsk->nast;
   }
 while (wsk!=NULL);
}

void TElMenu::Rysuj()
{
 TElMenu *wsk=this;
 do
   {
   wsk->Rysuj_el();
   wsk = wsk->nast;
   }
 while (wsk!=NULL);
}

void TElMenu::Przesun(int dx, int dy)
{
 TElMenu *wsk=this;
 do
   {
   wsk->PrzesunDrzewo(dx,dy);
   wsk = wsk->nast;
   }
 while (wsk!=NULL);
}

void TElMenu::Zniszcz()
{
 TElMenu *wsk=nast;
 while (wsk!=NULL)
   {
   TElMenu *nt = wsk->nast;
   wsk->ZniszczPoddrzewa();
   delete wsk;
   wsk = nt;
   }
 delete this;
}

// proste klasy potomne
class TNapis : public TElMenu
  {
  const char *napis;
  int justowanie;
  protected:
  void Rysuj_el()
    { WypiszBold(wspolrz[0], wspolrz[1], napis, kolor[1], kolor[0], justowanie); };
  public:
  TNapis(short int *wsp, TKolor *k, const char *s, int j=KR_ALIGN_CENTER)
    { wspolrz=wsp;  napis=s;  kolor=k;
      justowanie = j; };
  void PrzesunTylkoTen(int dx, int dy)
    { wspolrz[0]+=dx; wspolrz[1]+=dy; }
  };

class TNapisA : public TNapis
  {  // napis aktywny -- mozna go narysowac zdarzeniem
  // dodatkowe 4 wspolrzedne definiuja czyszczacy prostokacik
  int zdarzenie;
  protected:
  void RysujJesliZdarzenie_el(int zd) { if (zd==zdarzenie) Rysuj_el(); };
  void Rysuj_el();
  void PrzesunTylkoTen(int dx, int dy)
    { wspolrz[0]+=dx; wspolrz[1]+=dy; wspolrz[2]+=dx;
      wspolrz[3]+=dy; wspolrz[4]+=dx; wspolrz[5]+=dy; };
  public:
  TNapisA(short int *wsp, TKolor *k, const char *s, int zd, int j=KR_ALIGN_CENTER)
   : TNapis(wsp,k,s,j)  { zdarzenie=zd; };
  };

void TNapisA::Rysuj_el()
{
 GrFilledBox(wspolrz[2], wspolrz[3], wspolrz[4], wspolrz[5], kolor[0]);
 TNapis::Rysuj_el();
}

// kolory:
//      [0] nieuzywane
//      [1] = ramka (kolor jak w suwaku, itp.)
//      [2] = color_button_up_border
// dzieki temu mozna uzywac np. TEkran::kolory_suwaka
class TRamka : public TElMenu
  {
  public:
  void Rysuj_el()
    { 
     GrBox(wspolrz[0], wspolrz[1], wspolrz[2], wspolrz[3], kolor[1]); 
     GrLine(wspolrz[0]+1, wspolrz[1]+1, wspolrz[2]-1, wspolrz[1]+1, kolor[2]); // color_button_up_border
     GrLine(wspolrz[0]+1, wspolrz[1]+1, wspolrz[0]+1, wspolrz[3]-1, kolor[2]); // color_button_up_border
     GrLine(wspolrz[2]+1, wspolrz[1]+1, wspolrz[2]+1, wspolrz[3]+1, kolor[2]); // color_button_up_border
     GrLine(wspolrz[0]+1, wspolrz[3]+1, wspolrz[2]-1, wspolrz[3]+1, kolor[2]); // color_button_up_border
    };
  TRamka(short int *wsp, TKolor *k) { wspolrz = wsp;  kolor=k; };
  };

//
class TRamkaGruba : public TElMenu {
  int grubosc;
  public:
  void Rysuj_el() {
    for (int i=0; i<grubosc; i++)
      GrBox(wspolrz[0]-i, wspolrz[1]-i, wspolrz[2]+i, wspolrz[3]+i, kolor[1]); 
  };
  TRamkaGruba(short int *wsp, TKolor *k, int grub) { wspolrz = wsp;  kolor=k; grubosc=grub; };
  };

//
class TProstokat : public TElMenu
  {
  public:
  void Rysuj_el()
    { GrFilledBox(wspolrz[0], wspolrz[1], wspolrz[2], wspolrz[3], kolor[0]); };
  TProstokat(short int *wsp, TKolor *k) { wspolrz = wsp;  kolor=k; };
  };

// SUWAK
//  wspolrzedne:
//    [0] = x pocz minusa
//    [1] = x pocz suwaka
//    [2] = x pocz plusa
//    [3] = x dlug znaku
//    [4] = x napisu
//    [5] = y znaku
//    [6] = y suwaka
//    [7] = y napisu
//    [8] = y dlug znaku
//    [9] = grub kreski
//    [10] = dlug kreski
//  kolory:
//    [0] = tlo
//    [1] = suwak
//      [2] = color_button_up_border
//      [3] = color_button_down_border
//      [4] = color_button_border
//      [5] = color_button_text=0,
//      [6] = color_button_fon
//  napisy moga byc == NULL
class TSuwak : public TElMenu
  {
  public:
  int zdarzenie;
  int wart_p, ile_wart;
  int akt_wart;
  const char *napis_minus, *napis_plus;
  TSuwak(short int *wsp, TKolor *k, int zd, int wp, int iw, const char *nm, const char *np,
	 short int str_pom=-1);
  protected:
  int pocz_wsk, xkon_suwaka, dx;
  int DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y);
  int DajWartosc_el(int zd);
  void InicjujZdarzeniem_el(int zd);
  void RysujJesliZdarzenie_el(int zd);
  void Rysuj_el();
  void RysujWskazowke(TKolor kol);
  void RysujMinusPlus();
  int WSrodku(int x, int y);
  void UstawZmienne();
  void PrzesunTylkoTen(int dx, int dy)
    {
    wspolrz[0]+=dx; wspolrz[1]+=dx; wspolrz[2]+=dx; wspolrz[4]+=dx;
    wspolrz[5]+=dy; wspolrz[6]+=dy; wspolrz[7]+=dy;
    };
  };

TSuwak::TSuwak(short int *wsp, TKolor *k, int zd, int wp, int iw, const char *nm, const char *np,
	       short int str_pom)
{
 wspolrz=wsp;  zdarzenie=zd;  wart_p=wp;  ile_wart=iw;
 napis_minus=nm;   napis_plus=np;
 kolor=k;
 akt_wart=wart_p;
 str_pomocy = str_pom;
}

void TSuwak::UstawZmienne()
{
 xkon_suwaka = wspolrz[2]-(wspolrz[1]-(wspolrz[0]+wspolrz[3]));
 dx = (xkon_suwaka - wspolrz[1] - wspolrz[9]+3) / (ile_wart+2);
 int efekt_d_suw = dx*(ile_wart-1) + wspolrz[9];
 pocz_wsk = wspolrz[1] + (xkon_suwaka - wspolrz[1] +1 - efekt_d_suw)/2;
}

int TSuwak::WSrodku(int x, int y)
{
 return (x>wspolrz[0] && x<wspolrz[2]+wspolrz[3] &&
         y>wspolrz[5] && y<wspolrz[5]+wspolrz[8]);
}

int TSuwak::DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y)
{
 if (!WSrodku(x,y)) return ZD_NIC;
 if (f & GR_M_RIGHT_DOWN) {
   PokazPomoc(x,y,str_pomocy,0);
   return ZD_NIC;
 }
 if (!(f & GR_M_LEFT_DOWN)) return ZD_NIC;
 if (x<wspolrz[0]+wspolrz[3])
   if (akt_wart>wart_p)
     {
     RysujWskazowke(kolor[0]);   // wyczysc stara wskazowke
     RysujMinusPlus();           // odtworz znaczki (mogly zostac zniszczone przez liczbe)
     akt_wart--;
     RysujWskazowke(kolor[1]);   // narysuj nowa wskazowke
     return zdarzenie+(akt_wart-wart_p);
     }
   else return ZD_NIC;
 if (x>wspolrz[2])
   if (akt_wart<wart_p+ile_wart-1)
     {
     RysujWskazowke(kolor[0]);   // wyczysc stara wskazowke
     RysujMinusPlus();           // odtworz znaczki (mogly zostac zniszczone przez liczbe)
     akt_wart++;
     RysujWskazowke(kolor[1]);   // narysuj nowa wskazowke
     return zdarzenie+(akt_wart-wart_p);
     }
   else return ZD_NIC;
 UstawZmienne();
 if (x>=wspolrz[1] && x<=xkon_suwaka)
   {
   int nr=x-pocz_wsk-(wspolrz[9]-1)/2;
   if (nr>0 && dx>1)
     {
     int reszta = nr%dx;
     nr/=dx;  if (reszta>dx/2) nr++;
     }
   else if (nr<0) nr=0;
   if (nr>=ile_wart) nr=ile_wart-1;
   if (nr!=akt_wart-wart_p)
     {
     RysujWskazowke(kolor[0]);   // wyczysc stara wskazowke
     RysujMinusPlus();           // odtworz znaczki (mogly zostac zniszczone przez liczbe)
     akt_wart=wart_p+nr;
     RysujWskazowke(kolor[1]);   // narysuj nowa wskazowke
     return zdarzenie+nr;
     }
   }
 return ZD_NIC;
}

int TSuwak::DajWartosc_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+ile_wart)
   return zdarzenie+akt_wart-wart_p;
 else return ZD_NIC;
}

void TSuwak::InicjujZdarzeniem_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+ile_wart)
   akt_wart = wart_p+zd-zdarzenie;
}

void TSuwak::RysujJesliZdarzenie_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+ile_wart) Rysuj_el();
}

void TSuwak::RysujWskazowke(TKolor kol)
{
 UstawZmienne();
 // GrFilledBox(pocz_wsk+dx*(akt_wart-wart_p),  wspolrz[6]-wspolrz[10],
 //             pocz_wsk+dx*(akt_wart-wart_p)+wspolrz[9]-1, wspolrz[6]-1, kol);
 GrPlot(pocz_wsk+dx*(akt_wart-wart_p)+1, wspolrz[6]-wspolrz[10]-1,kol);
 GrPlot(pocz_wsk+dx*(akt_wart-wart_p)+2, wspolrz[6]-wspolrz[10]-1,kol);
 GrLine(pocz_wsk+dx*(akt_wart-wart_p),  wspolrz[6]-wspolrz[10],
             pocz_wsk+dx*(akt_wart-wart_p)+wspolrz[9]+1, wspolrz[6]-wspolrz[10], kol);
 GrLine(pocz_wsk+dx*(akt_wart-wart_p),  wspolrz[6]-wspolrz[10]+6,
             pocz_wsk+dx*(akt_wart-wart_p)+wspolrz[9]+1, wspolrz[6]-wspolrz[10]+6, kol);
 char s[10];
 sprintf(s,"%d",akt_wart);
 Wypisz(pocz_wsk+dx*(akt_wart-wart_p)+(wspolrz[9] )/2,
           wspolrz[6]-wspolrz[10]-1, s, kol, kolor[0], KR_ALIGN_CENTERBOTTOM);
}

void TSuwak::RysujMinusPlus()
{
 // minus i plus
  // GrBox(wspolrz[0],wspolrz[5],wspolrz[0]+wspolrz[3],wspolrz[5]+wspolrz[8],kolor[1]);
  // GrBox(wspolrz[2],wspolrz[5],wspolrz[2]+wspolrz[3],wspolrz[5]+wspolrz[8],kolor[1]);
  MyBox(wspolrz[0],wspolrz[5],wspolrz[0]+wspolrz[3],wspolrz[5]+wspolrz[8], &kolor[2]);
  MyBox(wspolrz[2],wspolrz[5],wspolrz[2]+wspolrz[3],wspolrz[5]+wspolrz[8], &kolor[2]);
  // minus i plus -- znaczki
  int pol_dl = (wspolrz[3]<wspolrz[8]) ? wspolrz[3]/6 : wspolrz[8]/6;
  GrHLine(wspolrz[0]+wspolrz[3]/2-pol_dl, wspolrz[0]+wspolrz[3]/2+pol_dl,
	  wspolrz[5]+wspolrz[8]/2, kolor[5]);  // color_button_text
  GrHLine(wspolrz[2]+wspolrz[3]/2-pol_dl, wspolrz[2]+wspolrz[3]/2+pol_dl,
	  wspolrz[5]+wspolrz[8]/2, kolor[5]);  // color_button_text
  GrVLine(wspolrz[2]+wspolrz[3]/2, wspolrz[5]+wspolrz[8]/2-pol_dl,
	  wspolrz[5]+wspolrz[8]/2+pol_dl, kolor[5]);  // color_button_text
}

void TSuwak::Rysuj_el()
{
 RysujMinusPlus();
 UstawZmienne();
 // napisy
 if (napis_minus!=NULL)
  Wypisz(wspolrz[4], wspolrz[7], napis_minus,kolor[1],kolor[0],KR_ALIGN_LEFTTOP);
 if (napis_plus!=NULL)
  Wypisz(wspolrz[2]+wspolrz[3]+(wspolrz[0]-wspolrz[4]), wspolrz[7],
            napis_plus,kolor[1],kolor[0],KR_ALIGN_RIGHTTOP);
 // suwak
 GrHLine(wspolrz[1]+1, xkon_suwaka-1, wspolrz[6]-2, kolor[4]); // color_button_border
 GrHLine(wspolrz[1]+1, xkon_suwaka-1, wspolrz[6]-1, kolor[3]); //color_button_down_border
 GrHLine(wspolrz[1]+1, xkon_suwaka-1, wspolrz[6], kolor[2]);  // color_button_up_border
 GrHLine(wspolrz[1]+1, xkon_suwaka-1, wspolrz[6]+1, kolor[2]); //color_button_up_border
 GrHLine(wspolrz[1]+1, xkon_suwaka-1, wspolrz[6]+2, kolor[4]); //color_button_border
// GrHLine(wspolrz[1], xkon_suwaka, wspolrz[6], kolor[1]);
 RysujWskazowke(kolor[1]);

}

// kolory: jak w suwaku
class TPrzycisk : public TElMenu
  {
  int zdarzenie;
  TKlawisz klaw1,klaw2;
  const char *napis;
  protected:
  void Rysuj_el()
    {
    GrBox(wspolrz[0], wspolrz[1], wspolrz[2], wspolrz[3], kolor[1]);
    GrFilledBox(wspolrz[0]+1, wspolrz[1]+1, wspolrz[2]-1, wspolrz[3]-1, kolor[0]);  // (czemu tego kiedys nie bylo?)
    //    GrBox(wspolrz[0]+1, wspolrz[1]+1, wspolrz[2]-1, wspolrz[3]-1, kolor[1]);  // pogrubione
    MyBox(wspolrz[0],wspolrz[1],wspolrz[2],wspolrz[3], &kolor[2]);
 
    Wypisz((wspolrz[0]+wspolrz[2])/2, (wspolrz[1]+wspolrz[3])/2,
              napis, kolor[5], kolor[6], KR_ALIGN_CENTER);
    };
  int DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y)
    { 
      if (WSrodku(x,y) && (f & GR_M_RIGHT_DOWN)) {
	PokazPomoc(x,y,str_pomocy,0);
	return ZD_NIC;
      }
      return (k==klaw1 || k==klaw2 || 
	      ((f & GR_M_LEFT_DOWN) && WSrodku(x,y))) ? zdarzenie : ZD_NIC; };
  void RysujJesliZdarzenie_el(int zd) { if (zd==zdarzenie) Rysuj_el(); };
  public:
  TPrzycisk(short int *wsp, TKolor *k, const char *s, int zd,
            TKlawisz k1, TKlawisz k2, short int str_pom = -1)
    { wspolrz=wsp;  kolor=k;
    napis=s;
    zdarzenie=zd;  klaw1=k1;  klaw2=k2;  str_pomocy = str_pom; };
  };

//
// TPrzyciskDwieOpcje
//  kolory:
//    [0] = tlo
//    [1],[2] = kolory przyciskow

//  kolory: nowe
//    [0] = color_button_fon
//    [1] = color_button_border
//    [2] = color_button_text=0,
//    [3] = color_button_fon_inactive
//    [4] = color_button_border_inactive
//    [5] = color_button_tex_inactive
class TPrzyciskDwieOpcje : public TElMenu
  {
  protected:
  const char *napis;
  int ktora_opcja, zdarzenie;
  void Rysuj_el();
  int DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y);
  int DajWartosc_el(int zd);
  void InicjujZdarzeniem_el(int zd);
  void RysujJesliZdarzenie_el(int zd);
  public:
  TPrzyciskDwieOpcje(short int *wsp, TKolor *k, const char *s, int zd, short int str_pom = -1);
  };

void TPrzyciskDwieOpcje::Rysuj_el()
{
  int shift = (ktora_opcja ? 3 : 0);
  GrFilledBox(wspolrz[0]+2, wspolrz[1]+2, wspolrz[2]-1, wspolrz[3]-1, kolor[shift]); // color_button_fon or _inactive
  GrLine(wspolrz[0]+2, wspolrz[1], wspolrz[2]-2, wspolrz[1], kolor[1+shift]);  //color_button_border or _inactive
  GrLine(wspolrz[0]+2, wspolrz[1]+1, wspolrz[2]-2, wspolrz[1]+1, kolor[shift]);
  GrLine(wspolrz[0], wspolrz[1]+2, wspolrz[0], wspolrz[3]-2, kolor[1+shift]);  //color_button_border or _inactive
  GrLine(wspolrz[0]+1, wspolrz[1]+2, wspolrz[0]+1, wspolrz[3]-2, kolor[shift]);
  GrLine(wspolrz[0]+2, wspolrz[3], wspolrz[2]-2, wspolrz[3], kolor[1+shift]);  //color_button_border or _inactive
  GrLine(wspolrz[0]+2, wspolrz[3]-1, wspolrz[2]-2, wspolrz[3]-1, kolor[shift]);
  GrLine(wspolrz[2], wspolrz[1]+2, wspolrz[2], wspolrz[3]-2, kolor[1+shift]);  //color_button_border or _inactive
  GrLine(wspolrz[2]-1, wspolrz[1]+2, wspolrz[2]-1, wspolrz[3]-2, kolor[shift]);
  GrPlot(wspolrz[0]+1, wspolrz[1]+1,kolor[1+shift]);
  GrPlot(wspolrz[2]-1, wspolrz[1]+1, kolor[1+shift]);
  GrPlot(wspolrz[0]+1, wspolrz[3]-1,kolor[1+shift]);
  GrPlot(wspolrz[2]-1, wspolrz[3]-1, kolor[1+shift]);
  Wypisz((wspolrz[0]+wspolrz[2])/2, (wspolrz[1]+wspolrz[3])/2,
	 napis, kolor[2+shift], kolor[shift], KR_ALIGN_CENTER);//you must set colors for active-notactive
  /*
  GrFilledBox(wspolrz[0]+1, wspolrz[1]+1, wspolrz[2], wspolrz[3], kolor[shift]); // color_button_fon or _inactive
  GrLine(wspolrz[0]+1, wspolrz[1], wspolrz[2]-1, wspolrz[1], kolor[1+shift]);  //color_button_border or _inactive
  GrLine(wspolrz[0], wspolrz[1]+1, wspolrz[0], wspolrz[3]-1, kolor[1+shift]);  //color_button_border or _inactive
  GrLine(wspolrz[0]+1, wspolrz[3], wspolrz[2]-1, wspolrz[3], kolor[1+shift]);  //color_button_border or _inactive
  GrLine(wspolrz[2], wspolrz[1]+1, wspolrz[2], wspolrz[3]-1, kolor[1+shift]);  //color_button_border or _inactive
  Wypisz((wspolrz[0]+wspolrz[2])/2, (wspolrz[1]+wspolrz[3])/2,
	 napis, kolor[2+shift], kolor[shift], KR_ALIGN_CENTER);//you must set colors for active-notactive
  */
 /*
 GrBox(wspolrz[0], wspolrz[1], wspolrz[2], wspolrz[3], kolor[1+ktora_opcja]);
 GrFilledBox(wspolrz[0]+1, wspolrz[1]+1, wspolrz[2]-1, wspolrz[3]-1, kolor[0]);
 // pogrubione...
 GrBox(wspolrz[0]+1, wspolrz[1]+1, wspolrz[2]-1, wspolrz[3]-1, kolor[1+ktora_opcja]);
 Wypisz((wspolrz[0]+wspolrz[2])/2, (wspolrz[1]+wspolrz[3])/2,
	   napis, kolor[1+ktora_opcja], kolor[0], KR_ALIGN_CENTER);
 */
}

int TPrzyciskDwieOpcje::DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y)
{
 if (WSrodku(x,y))
  if (f & GR_M_LEFT_DOWN)
   {
   ktora_opcja ^=1;
   Rysuj_el();
   return zdarzenie+ktora_opcja;
   }
  else if (f & GR_M_RIGHT_DOWN)
   PokazPomoc(x,y,str_pomocy,ktora_opcja);
 return ZD_NIC;
}

int TPrzyciskDwieOpcje::DajWartosc_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+2)
  return zdarzenie+ktora_opcja;
 return ZD_NIC;
}

void TPrzyciskDwieOpcje::InicjujZdarzeniem_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+2)
  ktora_opcja = zd-zdarzenie;
}

void TPrzyciskDwieOpcje::RysujJesliZdarzenie_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+2) Rysuj_el();
}


TPrzyciskDwieOpcje::TPrzyciskDwieOpcje(short int *wsp, TKolor *k, const char *s, int zd, 
				       short int str_pom)
{ wspolrz=wsp; kolor=k;
  napis=s;
  zdarzenie=zd;
  ktora_opcja=0;  str_pomocy = str_pom;
}


// TPrzyciskKilkaOpcji
//  kolory: stare
//    [0] = tlo
//    [1],[2],...,[ile_opcji] = kolory przyciskow

//  kolory: nowe
//    [0] = color_button_fon
//    [1] = color_button_border
//    [2] = color_button_text=0,
//    [3] = color_button_fon_inactive
//    [4] = color_button_border_inactive
//    [5] = color_button_tex_inactive
//        ([6] uzywane przez TPrzyciskKilkaOpcjiOpoznDeakt)
// WAZNE: Jesli lancuch konczy sie 2 zerami, to bedzie wyswietlony
// w jednym wierszu, a jesli jednym zerem, to w dwoch wierszach.
class TPrzyciskKilkaOpcji : public TElMenu
  {
  protected:
  char **napisy;
  int ile_opcji, ktora_opcja, zdarzenie;
  void Rysuj_el();
  int DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y);
  int DajWartosc_el(int zd);
  void InicjujZdarzeniem_el(int zd);
  void RysujJesliZdarzenie_el(int zd);
  public:
  TPrzyciskKilkaOpcji(short int *wsp, TKolor *k, const char **ss, int iop, int zd, short int str_pom=-1);
  ~TPrzyciskKilkaOpcji();
  };

void TPrzyciskKilkaOpcji::Rysuj_el()
{
// GrBox(wspolrz[0], wspolrz[1], wspolrz[2], wspolrz[3], kolor[1+ktora_opcja]);
// GrFilledBox(wspolrz[0]+1, wspolrz[1]+1, wspolrz[2]-1, wspolrz[3]-1, kolor[0]);
// GrBox(wspolrz[0]+1, wspolrz[1]+1, wspolrz[2]-1, wspolrz[3]-1, kolor[1+ktora_opcja]);  // pogrubione
  int shift = (ile_opcji==2 && ktora_opcja==0) ? 3 : 0;
  GrFilledBox(wspolrz[0]+1, wspolrz[1]+1, wspolrz[2], wspolrz[3], kolor[shift]); //color_button_fon
  TKolor kb = kolor[shift+1];    // color_button_border

  GrFilledBox(wspolrz[0]+2, wspolrz[1]+2, wspolrz[2]-1, wspolrz[3]-1, kolor[shift]); // color_button_fon or _inactive
  GrLine(wspolrz[0]+2, wspolrz[1], wspolrz[2]-2, wspolrz[1], kolor[1+shift]);  //color_button_border or _inactive
  GrLine(wspolrz[0]+2, wspolrz[1]+1, wspolrz[2]-2, wspolrz[1]+1, kolor[shift]);
  GrLine(wspolrz[0], wspolrz[1]+2, wspolrz[0], wspolrz[3]-2, kolor[1+shift]);  //color_button_border or _inactive
  GrLine(wspolrz[0]+1, wspolrz[1]+2, wspolrz[0]+1, wspolrz[3]-2, kolor[shift]);
  GrLine(wspolrz[0]+2, wspolrz[3], wspolrz[2]-2, wspolrz[3], kolor[1+shift]);  //color_button_border or _inactive
  GrLine(wspolrz[0]+2, wspolrz[3]-1, wspolrz[2]-2, wspolrz[3]-1, kolor[shift]);
  GrLine(wspolrz[2], wspolrz[1]+2, wspolrz[2], wspolrz[3]-2, kolor[1+shift]);  //color_button_border or _inactive
  GrLine(wspolrz[2]-1, wspolrz[1]+2, wspolrz[2]-1, wspolrz[3]-2, kolor[shift]);
  GrPlot(wspolrz[0]+1, wspolrz[1]+1,kolor[1+shift]);
  GrPlot(wspolrz[2]-1, wspolrz[1]+1, kolor[1+shift]);
  GrPlot(wspolrz[0]+1, wspolrz[3]-1,kolor[1+shift]);
  GrPlot(wspolrz[2]-1, wspolrz[3]-1, kolor[1+shift]);

  /*
  GrLine(wspolrz[0]+1, wspolrz[1], wspolrz[2]-1, wspolrz[1], kb);
  GrLine(wspolrz[0], wspolrz[1]+1, wspolrz[0], wspolrz[3]-1, kb);
  GrLine(wspolrz[0]+1, wspolrz[3], wspolrz[2], wspolrz[3], kb);
  GrLine(wspolrz[2], wspolrz[1]+1, wspolrz[2], wspolrz[3], kb);
  */
  if (ile_opcji>2) {
    //treangle in bottom right corner -- only when multiple (>2) options
    GrLine(wspolrz[2]-4, wspolrz[3], wspolrz[2], wspolrz[3]-4, kolor[1]);//color_button_border  or maybe better kb?  
    GrLine(wspolrz[2]-3, wspolrz[3], wspolrz[2], wspolrz[3]-3, kolor[1]);//color_button_border  
    GrLine(wspolrz[2]-2, wspolrz[3], wspolrz[2], wspolrz[3]-2, kolor[1]);//color_button_border  
    GrLine(wspolrz[2]-1, wspolrz[3], wspolrz[2], wspolrz[3]-1, kolor[1]);//color_button_border
  GrLine(wspolrz[0]+2, wspolrz[3], wspolrz[2]-2, wspolrz[3], kolor[1]);  //color_button_border or _inactive
  GrLine(wspolrz[2], wspolrz[1]+2, wspolrz[2], wspolrz[3]-2, kolor[1]);  //color_button_border or _inactive
  }
  char *s = napisy[ktora_opcja];
  if (s[strlen(s)+1]!=0) {
    // sa dwa napisy !
    int dy=(wspolrz[3]-wspolrz[1])/2;
    Wypisz((wspolrz[0]+wspolrz[2])/2, wspolrz[1]+dy/2,
	   s, kolor[shift+2], kolor[shift], KR_ALIGN_CENTER);
    Wypisz((wspolrz[0]+wspolrz[2])/2, wspolrz[1]+dy+dy/2,
	   &s[strlen(s)+1], kolor[shift+2], kolor[shift], KR_ALIGN_CENTER);
  }
  else
    Wypisz((wspolrz[0]+wspolrz[2])/2, (wspolrz[1]+wspolrz[3])/2,
	   s, kolor[shift+2], kolor[shift], KR_ALIGN_CENTER);
}

int TPrzyciskKilkaOpcji::DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y)
{
 if (WSrodku(x,y))
  if (f & GR_M_LEFT_DOWN)
   {
   if (++ktora_opcja == ile_opcji) ktora_opcja=0;
   Rysuj_el();
   return zdarzenie+ktora_opcja;
   }
  else if (f & GR_M_RIGHT_DOWN)
   PokazPomoc(x,y,str_pomocy,ktora_opcja);
 return ZD_NIC;
}

int TPrzyciskKilkaOpcji::DajWartosc_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+ile_opcji)
  return zdarzenie+ktora_opcja;
 return ZD_NIC;
}

void TPrzyciskKilkaOpcji::InicjujZdarzeniem_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+ile_opcji)
  ktora_opcja = zd-zdarzenie;
}

void TPrzyciskKilkaOpcji::RysujJesliZdarzenie_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+ile_opcji) Rysuj_el();
}


TPrzyciskKilkaOpcji::TPrzyciskKilkaOpcji(short int *wsp, TKolor *k, const char **ss, int iop, int zd,
					 short int str_pom)
{ wspolrz=wsp; kolor=k;
 napisy = new char*[iop];
 memcpy(napisy, ss, sizeof(char*)*iop);
 ile_opcji=iop;  zdarzenie=zd;
 ktora_opcja=0;  str_pomocy = str_pom;
}

TPrzyciskKilkaOpcji::~TPrzyciskKilkaOpcji()
{
 delete[] napisy;
}

// TPrzyciskKilkaOpcjiOpozn dziala jak TPrzyciskKilkaOpcji, ale
// nie zmienia sam swojej wartosci po kliknieciu mysza -- trzeba zrobic
// to wolajac InicjujZdarzeniem
class TPrzyciskKilkaOpcjiOpozn : public TPrzyciskKilkaOpcji
  {
  protected:
  int DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y);
  public:
  TPrzyciskKilkaOpcjiOpozn(short int *wsp, TKolor *k, const char **ss, int iop, int zd, short int str_pom=-1)
   : TPrzyciskKilkaOpcji(wsp, k, ss, iop, zd, str_pom) {};
  };

int TPrzyciskKilkaOpcjiOpozn::DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y)
{
 if (WSrodku(x,y))
  if (f & GR_M_LEFT_DOWN)
   {
   int ktora=ktora_opcja+1;
   return (ktora == ile_opcji) ? zdarzenie : zdarzenie+ktora;
   }
  else if (f & GR_M_RIGHT_DOWN)
   PokazPomoc(x,y,str_pomocy,ktora_opcja);
 return ZD_NIC;
}

// TPrzyciskKilkaOpcjiOpoznDeakt dziala jak TPrzyciskKilkaOpcjiOpozn, ale
// mozna go dezaktywowac: InicjujZdarzeniem(ZD);
//  aktywowac: InicjujZdarzeniem(ZD+1);
// ustawiac opcje: InicjujZdarzeniem(ZD+2);  ...az do (ZD+2+ile_opcji-1);
// kolory:
//    [6] = kolor tla (do czyszczenia przycisku)
class TPrzyciskKilkaOpcjiOpoznDeakt : public TPrzyciskKilkaOpcjiOpozn {
  protected:
  int aktywny;
  int DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y);
  void RysujJesliZdarzenie_el(int zd);
  void Rysuj_el();
  void InicjujZdarzeniem_el(int zd);
  public:
  TPrzyciskKilkaOpcjiOpoznDeakt(short int *wsp, TKolor *k, const char **ss, int iop, int zd, short int str_pom=-1)
    : TPrzyciskKilkaOpcjiOpozn(wsp, k, ss, iop, zd, str_pom) { aktywny=1; };
};

int TPrzyciskKilkaOpcjiOpoznDeakt::DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y)
{
 if (aktywny && WSrodku(x,y))
  if (f & GR_M_LEFT_DOWN)
   {
   int ktora=ktora_opcja+1;
   return (ktora == ile_opcji) ? zdarzenie+2 : zdarzenie+2+ktora;
   }
  else if (f & GR_M_RIGHT_DOWN)
   PokazPomoc(x,y,str_pomocy,ktora_opcja);
 return ZD_NIC;
}

void TPrzyciskKilkaOpcjiOpoznDeakt::InicjujZdarzeniem_el(int zd)
{
  if (zd>=zdarzenie && zd<zdarzenie+2)
    aktywny = zd-zdarzenie;
  else if (aktywny && zd>=zdarzenie+2 && zd<zdarzenie+ile_opcji+2)
    ktora_opcja = zd-zdarzenie-2;
}

void TPrzyciskKilkaOpcjiOpoznDeakt::RysujJesliZdarzenie_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+2+ile_opcji) Rysuj_el();
}

void TPrzyciskKilkaOpcjiOpoznDeakt::Rysuj_el()
{
  if (aktywny)
    TPrzyciskKilkaOpcjiOpozn::Rysuj_el();
  else 
    GrFilledBox(wspolrz[0], wspolrz[1], wspolrz[2]+1, wspolrz[3]+1, kolor[6]);
}

//  kolory:
//    [0] = color_editor_fon
//    [1] = color_button_text
//      [2] = color_button_up_border
//      [3] = color_button_down_border
//      [4] = color_button_border
class TEdytorLiniowy : public TElMenu
  {
  int zdarzenie;
  char *napis;
  int dlug, kursor, max_dlug;
  int tylko_cyfry, liczba_min, liczba_max;
  int poczatek;
  char s[260];
  protected:
  void Rysuj_el();
  void RysujTekst();
  int DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y);
  void RysujJesliZdarzenie_el(int zd);
  public:
  TEdytorLiniowy(short int *wsp, TKolor *k, char *s, int zd, int md, int tc=0, int lmi=0, int lma=0,
		 short int str_pom=-1)
    { wspolrz=wsp;  kolor=k;  tylko_cyfry=tc; liczba_min=lmi;  liczba_max=lma;
    napis=s;  zdarzenie=zd;  max_dlug=md;  str_pomocy = str_pom; 
    };
  };


void TEdytorLiniowy::Rysuj_el()
{
// New kolor set as white
 GrFilledBox(wspolrz[0]+1, wspolrz[1]+1, wspolrz[2]-1, wspolrz[3]-1, kolor[0]); //color_editor_fon
//kolory k[*] are as in MyBox but swaped
 GrBox(wspolrz[0], wspolrz[1], wspolrz[2], wspolrz[3], kolor[4]);  //color_button_border
 GrLine(wspolrz[0]+1, wspolrz[1]+1, wspolrz[2]-1, wspolrz[1]+1, kolor[3]); //color_button_down_border
 GrLine(wspolrz[0]+1, wspolrz[1]+1, wspolrz[0]+1, wspolrz[3]-1, kolor[3]); //color_button_down_border);
 GrLine(wspolrz[0]+2, wspolrz[3]-1, wspolrz[2]-1, wspolrz[3]-1, kolor[2]); //color_button_up_border);
 GrLine(wspolrz[2]-1, wspolrz[1]+2, wspolrz[2]-1, wspolrz[3]-1, kolor[2]); //color_button_up_border);
 int zmiesci_sie=(wspolrz[2]-wspolrz[0]-2) / SZER_FONTU - 1;
 if (strlen(napis)>zmiesci_sie) {
   strcpy(&s[1],&napis[strlen(napis)-zmiesci_sie+1]);
   s[0]='<';
 }
 else strcpy(s,napis);
// inputed text as color_button_text 
 outtextxy(wspolrz[0]+1+SZER_FONTU/2, (wspolrz[1]+wspolrz[3])/2,
	   s, kolor[1], kolor[0], KR_ALIGN_LEFT);
}

void TEdytorLiniowy::RysujTekst()
{
 GrFilledBox(wspolrz[0]+2, wspolrz[1]+2, wspolrz[2]-2, wspolrz[3]-2, kolor[0]);
 // ustaw odp. poczatek
 int zmiesci_sie=(wspolrz[2]-wspolrz[0]-2) / SZER_FONTU - 1;
 if (kursor<poczatek || (kursor<=poczatek+1 && poczatek)) {
   if (kursor<zmiesci_sie)
     poczatek=0;
   else poczatek=kursor-3;
 }
 else if (kursor-poczatek>zmiesci_sie) 
   poczatek=kursor-zmiesci_sie+3;
 char pom[260];
 strcpy(pom, &s[poczatek]);
 if (poczatek) pom[0]='<';
 if (strlen(pom)>zmiesci_sie || kursor-poczatek>zmiesci_sie) {
   pom[zmiesci_sie]='>';
   pom[zmiesci_sie+1]=0;
 }
 outtextxy(wspolrz[0]+1+SZER_FONTU/2, (wspolrz[1]+wspolrz[3])/2,
	   pom, kolor[1], kolor[0], KR_ALIGN_LEFT);
 // rysuj kursor
 GrHLine(wspolrz[0]+1+SZER_FONTU/2 + (kursor-poczatek)*SZER_FONTU+1,
         wspolrz[0]+1 +(kursor-poczatek+1)*SZER_FONTU,
         (wspolrz[1]+wspolrz[3])/2 + 4, kolor[1]);
}

int TEdytorLiniowy::DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y)
{
 if (WSrodku(x,y))
  if (f & GR_M_LEFT_DOWN)
   { // wlacz edytor liniowy
   strcpy(s,napis);
   dlug = kursor = strlen(s);
   poczatek=0;
   RysujTekst();
   GrFlush();
   for (;;)
    {
    GrMouseEvent gme;
    GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_KEYPRESS), &gme);
    if (gme.flags & GR_M_LEFT_DOWN)      // symulacja
      gme.key = GrKey_Return;            // enter
    switch (Konwersja(gme.key))
      {
      case GrKey_Alt_Backspace:
        if (kursor>0)
          { // skasuj literki od [0] do [kursor-1]
          for (int i=kursor; i<=dlug; i++)
            s[i-kursor]=s[i];
          dlug-=kursor; kursor=0;
          RysujTekst();
          }
        break;
      case GrKey_BackSpace:
        if (kursor>0) kursor--;  // bez break'a !
        else break;
      case GrKey_Delete:
        if (kursor<dlug)
          { // skasuj literke s[kursor]
          for (int i=kursor; i<dlug; i++) s[i]=s[i+1];
          dlug--;
          RysujTekst();
	  GrFlush();
          }
        break;
      case GrKey_Left:
        if (kursor>0) { kursor--; RysujTekst(); GrFlush(); }
        break;
      case GrKey_Right:
        if (kursor<dlug) { kursor++; RysujTekst(); GrFlush(); }
        break;
      case GrKey_Home:
        if (kursor>0) { kursor=0; RysujTekst(); GrFlush(); }
        break;
      case GrKey_End:
        if (kursor<dlug) { kursor=dlug; RysujTekst(); GrFlush(); }
        break;
      case GrKey_Return:
	if (tylko_cyfry) {
	  int liczba=atoi(s);
	  if (liczba>=liczba_min && liczba<=liczba_max)
	    strcpy(napis,s);
	}
	else 
	  strcpy(napis,s);
	Rysuj_el(); GrFlush();
        return zdarzenie;
      case GrKey_Escape:
        Rysuj_el(); GrFlush();
        return ZD_NIC;
      default:
        if ((gme.key>=32 && gme.key<=126 && dlug<max_dlug) &&
	    (!tylko_cyfry || (gme.key>='0' && gme.key<='9')))
          {  // wstaw nowa literke w miejsce s[kursor]
          for (int i=dlug+1; i>kursor; i--) s[i]=s[i-1];
          s[kursor]=Konwersja(gme.key);
          kursor++;  dlug++;
          RysujTekst(); GrFlush();
          }
        break;
      }
    }
   }
 else if (f & GR_M_RIGHT_DOWN)
   PokazPomoc(x,y,str_pomocy,0);
 return ZD_NIC;
}

void TEdytorLiniowy::RysujJesliZdarzenie_el(int zd)
{ if (zd==zdarzenie) Rysuj_el(); }

// WyborPrzycisku
//  wspolrzedne
//    [4*i], [4*i+1], [4*i+2], [4*i+3] = wsp. xlg,ylg,xpd,ypd i-tego przycisku
//  kolory:
//    [0] = tlo
//    [1] = aktywny przycisk
//    [2] = nieaktywny przycisk

//  kolory: nowe (jak TPrzyciskDwieOpcje)
//    [0] = color_button_fon
//    [1] = color_button_border
//    [2] = color_button_text=0,
//    [3] = color_button_fon_inactive
//    [4] = color_button_border_inactive
//    [5] = color_button_tex_inactive

class TWyborPrzycisku : public TElMenu
  {
  protected:
  char **napisy;
  int ile_przyc, ktory_wl, zdarzenie;
  TElMenu **w_dol;
  void Rysuj_el();
  int DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y);
  int DajWartosc_el(int zd);
  void InicjujZdarzeniem_el(int zd);
  void RysujJesliZdarzenie_el(int zd);
  void PrzesunTylkoTen(int dx, int dy);
  void PrzesunDrzewo(int dx, int dy);
  void RysujPrzyc(int i, TKolor kol);
  public:
  TWyborPrzycisku(short int *wsp, TKolor *k, const char **ss, int ip, int zd, short int str_pom=-1);
  ~TWyborPrzycisku();
  void DodajDziecko(int nr, TElMenu *adres);
  virtual void ZniszczPoddrzewa();
  };

void TWyborPrzycisku::RysujPrzyc(int i, TKolor kol)
{
  /*
  GrBox(wspolrz[4*i], wspolrz[4*i+1], wspolrz[4*i+2], wspolrz[4*i+3], kol);
  GrBox(wspolrz[4*i]+1, wspolrz[4*i+1]+1, wspolrz[4*i+2]-1, wspolrz[4*i+3]-1, kol);  // pogrubione
  Wypisz((wspolrz[4*i]+wspolrz[4*i+2])/2, (wspolrz[4*i+1]+wspolrz[4*i+3])/2,
	 napisy[i], kol, kolor[0], KR_ALIGN_CENTER);
  */

  GrFilledBox(wspolrz[4*i], wspolrz[4*i+1], wspolrz[4*i+2], wspolrz[4*i+3],
	      (i==ktory_wl) ? kolor[0] : kolor[3]);   // color_button_fon : color_button_fon_inactive
  GrBox(wspolrz[4*i], wspolrz[4*i+1], wspolrz[4*i+2], wspolrz[4*i+3],
   	      (i==ktory_wl) ? kolor[1] : kolor[4]);  // color_button_border : color_button_border_inactive
  //  GrBox(wspolrz[4*i]+1, wspolrz[4*i+1]+1, wspolrz[4*i+2]-1, wspolrz[4*i+3]-1, kol);  // pogrubione
  Wypisz((wspolrz[4*i]+wspolrz[4*i+2])/2, (wspolrz[4*i+1]+wspolrz[4*i+3])/2,
	 napisy[i], 
	 (i==ktory_wl) ? kolor[2] : kolor[5],   // color_button_text : color_button_text_inactive
	 (i==ktory_wl) ? kolor[0] : kolor[3],   //color_button_fon : color_button_fon_inactive
	 KR_ALIGN_CENTER);
}

void TWyborPrzycisku::Rysuj_el()
{
 // rysuj najpierw nieaktywne przyciski
 for (int i=0; i<ile_przyc; i++)
  if (i!=ktory_wl)
    RysujPrzyc(i, kolor[2]);
 // i aktywny przycisk
 RysujPrzyc(ktory_wl, kolor[1]);
 // drzewo aktywnego przycisku
 if (w_dol[ktory_wl]!=NULL)
   w_dol[ktory_wl]->Rysuj();
}

int TWyborPrzycisku::DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y)
{
 for (int i=0; i<ile_przyc; i++)
   if (x>wspolrz[4*i] && x<wspolrz[4*i+2] &&
       y>wspolrz[4*i+1] && y<wspolrz[4*i+3]) {
    if (f & GR_M_LEFT_DOWN)
     if (i!=ktory_wl) {
      int ktory_byl_wl = ktory_wl;
      ktory_wl=i;
      RysujPrzyc(ktory_byl_wl,kolor[2]);  // zgas przycisk
      RysujPrzyc(ktory_wl,kolor[1]);  // zapal przycisk
      // rysuj drzewo aktywnego przycisku
      if (w_dol[ktory_wl]!=NULL)
        w_dol[ktory_wl]->Rysuj();
      return zdarzenie+ktory_wl;
      }
     else return ZD_NIC;  // ponowny wybor tego, co juz jest wybrane
    else if (f & GR_M_RIGHT_DOWN)
      PokazPomoc(x,y,str_pomocy,i);
    return ZD_NIC;
   }
 // badaj aktywne poddrzewo
 return (w_dol[ktory_wl]!=NULL) ? w_dol[ktory_wl]->DajZdarzenie(k,f,x,y) : ZD_NIC;
}

int TWyborPrzycisku::DajWartosc_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+ile_przyc)
  return zdarzenie+ktory_wl;
 else
  return (w_dol[ktory_wl]!=NULL) ? w_dol[ktory_wl]->DajWartosc(zd) : ZD_NIC;
}

void TWyborPrzycisku::PrzesunTylkoTen(int dx, int dy)
{
 for (int i=0; i<ile_przyc; i++)
   {
   wspolrz[4*i  ]+=dx;  wspolrz[4*i+1]+=dy;
   wspolrz[4*i+2]+=dx;  wspolrz[4*i+3]+=dy;
   }
}

void TWyborPrzycisku::PrzesunDrzewo(int dx, int dy)
{
 for (int i=0; i<ile_przyc; i++)
   {
   wspolrz[4*i  ]+=dx;  wspolrz[4*i+1]+=dy;
   wspolrz[4*i+2]+=dx;  wspolrz[4*i+3]+=dy;
   if (w_dol[i]!=NULL)
     w_dol[i]->Przesun(dx,dy);
   }
}

void TWyborPrzycisku::InicjujZdarzeniem_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+ile_przyc)
   ktory_wl=zd-zdarzenie;
 for (int i=0; i<ile_przyc; i++)
   if (w_dol[i]!=NULL)
     w_dol[i]->InicjujZdarzeniem(zd);
}

void TWyborPrzycisku::RysujJesliZdarzenie_el(int zd)
{
 if (zd>=zdarzenie && zd<zdarzenie+ile_przyc)
   Rysuj_el();
 else if (w_dol[ktory_wl]!=NULL)
   w_dol[ktory_wl]->RysujJesliZdarzenie(zd);
}

TWyborPrzycisku::TWyborPrzycisku(short int *wsp, TKolor *k, const char **ss, int ip, int zd, 
				 short int str_pom)
{ wspolrz=wsp; kolor=k;
 napisy = new char*[ip];
 memcpy(napisy, ss, sizeof(char*)*ip);
 ile_przyc=ip;  zdarzenie=zd;
 ktory_wl=0;    str_pomocy = str_pom;
 w_dol = new TElMenu*[ip];
 for (int i=0; i<ip; i++) w_dol[i]=NULL;
}

TWyborPrzycisku::~TWyborPrzycisku()
{
 delete[] napisy;   delete[] w_dol;
}

void TWyborPrzycisku::ZniszczPoddrzewa()
{
 for (int i=0; i<ile_przyc; i++)
   if (w_dol[i]!=NULL)
     w_dol[i]->Zniszcz();
}

void TWyborPrzycisku::DodajDziecko(int nr, TElMenu *adres)
{
 w_dol[nr]=adres;
}

// TWyborPrzyciskuOpozn dziala jak TWyborPrzycisku, ale
// nie zmienia sam swojej wartosci po kliknieciu mysza -- trzeba zrobic
// to wolajac InicjujZdarzeniem
class TWyborPrzyciskuOpozn : public TWyborPrzycisku
  {
  protected:
  int DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y);
  public:
  TWyborPrzyciskuOpozn(short int *wsp, TKolor *k, const char **ss, int ip, int zd, short int str_pom=-1)
   : TWyborPrzycisku(wsp, k, ss, ip, zd, str_pom) {};
  };

int TWyborPrzyciskuOpozn::DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y)
{
 for (int i=0; i<ile_przyc; i++)
   if (x>wspolrz[4*i] && x<wspolrz[4*i+2] &&
       y>wspolrz[4*i+1] && y<wspolrz[4*i+3]) {
    if (f & GR_M_LEFT_DOWN)
      if (i!=ktory_wl)
	return zdarzenie+i;
      else return ZD_NIC;  // ponowny wybor tego, co juz jest wybrane
    else if (f & GR_M_RIGHT_DOWN)
      PokazPomoc(x,y,str_pomocy,i);
    return ZD_NIC;
   }
 // badaj aktywne poddrzewo
 return (w_dol[ktory_wl]!=NULL) ? w_dol[ktory_wl]->DajZdarzenie(k,f,x,y) : ZD_NIC;
}

// klasa do pobierania inf. o graczu
//  rozmiar ,,lista'' i ,,nie_przesuwaj'' jest istotny w konstruktorze
//  kolory:
//    [0] = tlo
//    [1] = aktywny przycisk
//    [2] = nieaktywny przycisk
//    [3] = tlo napisu gracza
//    [4] = kolor napisu gracza
// Po zmianie fontu nalezy wywolac UstawWlk().

class TMenuGracz : public TElMenu
  {
  int zdarzenie;            // zdarzenie bazowe
  TElMenu *m;
  // parametry konstruktora
  TGraczO   *g;
  const char *naglowek;     // napis w naglowku (np. Podaj gracza 1)
  unsigned short int stan;  // bit 0: czy jest wybor czlowiek/komp, bit 1: czy jest ok/anuluj
     // bit 2: czy zwracac zdarzenie, gdy cos sie zmienia (np. poziom_gry)
    // bit 3 (&8): czy wyswietlac opcje zaawansowane?
  // zmienne pomocnicze, stale
    char wagan[12], wagap[12], limitcz[12], waganBo[12], wagapBo[12], wagalfo[12], iteracji[12], mc_funkcja[12];
  TElMenu *lista[92];
  char nie_przesuwaj[92];   // jesli ==1, to nie nalezy przesuwac elementu
  int  ile_el;              // liczba elementow na liscie -- to moglaby byc stala, ale tak latwiej modyfikowac
  short int *wsp;
  const static char *nu[];   // napisy ustalone
  void UstawGracza();        // wstawia dane z ,,g'' do ,,m''
  void UaktualnijPolozenie();   // uaktualnia polozenie wg danych z wspolrz[]
  public:
  TMenuGracz(short int*, TKolor*, TGraczO*, const char*, unsigned short int, int zd=0);
  ~TMenuGracz();
//  int Wez(int x, int y, TGraczO &gr, int nr);
  void PrzesunTylkoTen(int dx, int dy);
  void UstawWlk();           // aktualizuje wielkosc po zmianie fontu
  int DajWlkX();         // zwraca swoja wielkosc
  int DajWlkY();         // w pikselach
  protected:
  int DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y);
  void InicjujZdarzeniem_el(int zd);
  void RysujJesliZdarzenie_el(int zd);
  void Rysuj_el();
  int WSrodku(int x, int y);
  };

const char* TMenuGracz::nu[] = {"$OK", "$Anuluj",
                          "$gr.czl","$gr.komp","$gr.Pgry",
                          "0","1","2","3","4","5","6","7","8","9","12","MC",
                          "$gr.imie",
                          "$gr.mostki\000",
                          "$gr.mostki\000",
                          "$gr.gleb",
                          "$gr.agr", "$gr.mala", "$gr.duza",
                          "$gr.waga",
                          "$gr.malo", "$gr.bardzo",
			  "$gr.niska_ocena\000",
			  "$gr.niska_ocena\000",
			  "$gr.naszych", "$gr.przec",
			  "$gr.Wkwb",
			   "$gr.Skl", "$gr.Zdob", "$gr.Pole", "$gr.Opcje", "$gr.Czas",
				"$gr.uwaga1",
				"$gr.uwaga2",
				" > 30 * (12+agresja),",
				"$gr.uwaga4",
				" > 30 * (12-agresja).",
				"$gr.uwaga6",
				"$gr.uwaga7",
				"$gr.wyl", "$gr.stnd", "$gr.x",
				"$gr.BMt", "$gr.BMT",
				"-3","-2","-1",
				"0","1","2","3","4","5","6","7","8","9","10","11","12","13",
				"14","15","16", "32",  "18",  // 18 nieuzywana
				"$gr.Scn",  // sprawdzaj czas namyslu
				"$gr.Nigdy","$gr.PoG","$gr.PoR", "$gr.Cz",
				"$gr.Limit",
				"$gr.AW",
				"$gr.antyw.ocena\000", "$gr.antyw.ocena\000",
				"$gr.antyw.sasiedzi\000", "$gr.antyw.sasiedzi\000",
				"Testowe (AR)\000","Testowe (AR)\000",
				"$gr.Rozsz1", "$gr.Rozsz2", "$gr.RozszQ",
				"$gr.SzBezp",
				"$gr.Bouzy", "$gr.LatwaFO",
				"$gr.WagiBouzy", "$gr.nasze", "$gr.prz-a", "$gr.Dylat", "$gr.Eroz", "$gr.PktZaPole",
				"$gr.WagaLFO",
				"$gr.ListaR", "$gr.LRnasze", "$gr.LRprzec", "$gr.LRupr", "$gr.LRlisc"
                          };

TMenuGracz::TMenuGracz(short int *nowewsp, TKolor *nowek, TGraczO *noweg,
                    const char *nowynapis, unsigned short int nowystan, int zd)
// zd = zdarzenie bazowe, dodawane do wszystkich zdarzen
{
 naglowek=nowynapis;  wspolrz=nowewsp;  kolor=nowek;  g=noweg;
 zdarzenie=zd;
 stan=nowystan;
 memset(nie_przesuwaj, 0, sizeof(nie_przesuwaj));  ile_el=0;
 wsp=new short int[570+10];  // 10 na zapas
 m=lista[ile_el++]=new TProstokat(&wsp[0], &kolor[0]);
 TElMenu *wsk=m;
 // tworz dalsze elementy
 wsk->nast =lista[ile_el++]= new TRamka(&wsp[4], TEkran::kolory_suwaka);
 wsk=wsk->nast;
 wsk->nast = lista[ile_el++]=new TRamka(&wsp[8], TEkran::kolory_suwaka);
 wsk=wsk->nast;
 if (stan & 2)
  {
  wsk->nast = lista[ile_el++]=new TPrzycisk(&wsp[12], TEkran::kolory_przycisku,
					    nu[0], zd+ZD_OK, GrKey_Return,GrKey_Return);
  wsk=wsk->nast;
  wsk->nast = lista[ile_el++]=new TPrzycisk(&wsp[16], TEkran::kolory_przycisku,
					    nu[1], zd+ZD_ANULUJ, GrKey_Escape,GrKey_Escape);
  wsk=wsk->nast;
  }
 wsk->nast = lista[ile_el++]=new TNapis(&wsp[20], &kolor[3],naglowek);
 wsk=wsk->nast;
 if (stan & 1) {
  wsk->nast = lista[ile_el++]=new TWyborPrzycisku(&wsp[22], TEkran::kolory_wybor_przycisku, &nu[2], 2, zd+ZD_KTO);
  wsk=wsk->nast;
  // utworz galaz dla czlowieka
  TElMenu *ktos = lista[ile_el++]=new TProstokat(&wsp[30], &kolor[0]);
  ((TWyborPrzycisku*) wsk)->DodajDziecko(0, ktos);
  nie_przesuwaj[ile_el]=1;
  ktos->nast =lista[ile_el++]=new TNapis(&wsp[34], &kolor[0], nu[17]);     // napis ,,Imie''
  ktos=ktos->nast;
  ktos->nast =lista[ile_el++]=new TEdytorLiniowy(&wsp[158], TEkran::kolory_edytora,
                                    g->imie, zd+ZD_NOWEIMIE, sizeof(g->imie)-1);
  // utworz galaz dla kompa
  nie_przesuwaj[ile_el]=1;
  ktos = lista[ile_el++]=new TProstokat(&wsp[30], &kolor[0]);
  ((TWyborPrzycisku*) wsk)->DodajDziecko(1, ktos);
  wsk=ktos;
  }
 // poczatek/c.d. kompa
 if (stan & 8) {
   wsk->nast = lista[ile_el++]=new TNapis(&wsp[34], &kolor[0], nu[4]);
   wsk=wsk->nast;
   TElMenu *ktos = wsk->nast =
     lista[ile_el++]=new TWyborPrzycisku(&wsp[36], TEkran::kolory_wybor_przycisku,
					 &nu[5], 12, zd+ZD_POZIOMGRY, POMOC_POZIOM);
   TElMenu *brz =lista[ile_el++]=new TPrzyciskKilkaOpcji(&wsp[162], TEkran::kolory_przycisku_kilka_opcji,
							 &nu[27], 2, zd+ZD_BRZUSZKI, POMOC_BRZUSZ);
   // dodaj czysczenie do poziomow 0-9
   wsk=lista[ile_el++]=new TProstokat(&wsp[150], &kolor[0]);
   wsk->nast=brz;
   for (int i=0; i<10; i++) ((TWyborPrzycisku*) ktos)->DodajDziecko(i, wsk);
   // dodajemy galaz do poziomu 11
   /*
     wsk=lista[ile_el++]=new TProstokat(&wsp[154], &kolor[0]);
     ((TWyborPrzycisku*) ktos)->DodajDziecko(10, wsk);
     wsk->nast=lista[ile_el++]=new TWyborPrzycisku(&wsp[166], TEkran::kolory_wybor_przycisku,
                                                   &nu[32], 2, zd+ZD_OPCJE11);
     TElMenu *opcje11 = wsk->nast;
     // 1 opcja ,,11'': skladowe
     wsk = lista[ile_el++] = new TProstokat(&wsp[178], &kolor[0]);
     ((TWyborPrzycisku*) opcje11)->DodajDziecko(0, wsk);
     wsk->nast=lista[ile_el++]=new TPrzyciskKilkaOpcji(&wsp[84], TEkran::kolory_przycisku_kilka_opcji,
                                                       &nu[18], 2, zd+ZD_MOSTKI,
     POMOC_ROZMOS);
     wsk=wsk->nast;
     TElMenu *agresja = wsk->nast =
     lista[ile_el++]=new TSuwak(&wsp[94], TEkran::kolory_suwaka, zd+ZD_AGRESJA, -9, 19, nu[22], nu[23], POMOC_AGRESJ);
     wsk=wsk->nast;
     wsk->nast =lista[ile_el++]= 
     new TNapis(&wsp[90], &kolor[0], nu[21]);   // agresja
     // 2 opcja ,,11'': zdobycze 
     nie_przesuwaj[ile_el]=1;
     wsk = lista[ile_el++] = new TProstokat(&wsp[178], &kolor[0]);
     ((TWyborPrzycisku*) opcje11)->DodajDziecko(1, wsk);
   */
   
   // zdobycze
   TElMenu *zdobycze = wsk = lista[ile_el++]=
     new TNapis(&wsp[92], &kolor[0], nu[24],KR_ALIGN_LEFT);   // ,,waga zdobyczy''
   wsk->nast=lista[ile_el++]=
     new TEdytorLiniowy(&wsp[106], TEkran::kolory_edytora, wagan, zd+ZD_PRZEJMUJESIE, 7, 1, 1, 20000,POMOC_ZDOBNA);
   wsk=wsk->nast;
   wsk->nast=lista[ile_el++]= 
     new TNapis(&wsp[88], &kolor[0], nu[29],KR_ALIGN_LEFT);   // ,,nasze zdobycze''
   wsk=wsk->nast;
   wsk->nast=lista[ile_el++]= 
     new TNapis(&wsp[114], &kolor[0], nu[30],KR_ALIGN_RIGHT);   // i przeciwnika
   wsk=wsk->nast;
   wsk->nast=lista[ile_el++]=
     new TEdytorLiniowy(&wsp[110], TEkran::kolory_edytora, wagap, zd+ZD_PRZEJMUJESIE_PRZEC, 7, 1, 1, 20000, POMOC_ZDOBPR);
   for (int i=0; i<7; i++) {
     wsk=wsk->nast;
     wsk->nast=lista[ile_el++]= 
       new TNapis(&wsp[324+2*i], &kolor[0], nu[37+i],KR_ALIGN_LEFT);   // objasnienia
   }
   wsk=wsk->nast;
   wsk->nast=lista[ile_el++]= 
     new TNapis(&wsp[182], &kolor[0], nu[31],KR_ALIGN_LEFT);   // waga kropki
   wsk=wsk->nast;
   wsk->nast=lista[ile_el++]= 
     new TWyborPrzycisku(&wsp[184], TEkran::kolory_wybor_przycisku,&nu[7], 7, zd+ZD_WAGAKROPKI,POMOC_WAGAKR);
   wsk=wsk->nast;
   wsk->nast=brz;
   
   
   // dodajemy galaz do poziomu 12
   // nie_przesuwaj[ile_el]=1;
   wsk=lista[ile_el++]=new TProstokat(&wsp[154], &kolor[0]);
   ((TWyborPrzycisku*) ktos)->DodajDziecko(10, wsk);
   wsk->nast=lista[ile_el++]=new TWyborPrzycisku(&wsp[212], TEkran::kolory_wybor_przycisku, &nu[32], 5, zd+ZD_OPCJE12,
						 POMOC_OPCJ12);
   TElMenu *opcje12 = wsk->nast;
   // 1 opcja ,,12'': skladowe
   //nie_przesuwaj[ile_el]=1;
   wsk = lista[ile_el++] = new TProstokat(&wsp[178], &kolor[0]);
   ((TWyborPrzycisku*) opcje12)->DodajDziecko(0, wsk); 
   wsk->nast=lista[ile_el++]=
     new TWyborPrzycisku(&wsp[232], TEkran::kolory_wybor_przycisku, &nu[44], 5, zd+ZD_OCENASKL, POMOC_SKLADO);
   // UWAGA: ostatnia funkcja, BM przed T, jest wylaczona!  -- juz wlaczona, ale o innym znaczeniu
   //   new TWyborPrzycisku(&wsp[232], TEkran::kolory_wybor_przycisku, &nu[44], 5, zd+ZD_OCENASKL, POMOC_SKLADO);
   TElMenu *agresja = 
     lista[ile_el++]=new TSuwak(&wsp[94], TEkran::kolory_suwaka, zd+ZD_AGRESJA, -9, 19, nu[22], nu[23], POMOC_AGRESJ);
   agresja->nast =lista[ile_el++]= 
     new TNapis(&wsp[90], &kolor[0], nu[21]);   // agresja
   
   {
     TElMenu *pom =  lista[ile_el++]= new TProstokat(&wsp[118], &kolor[0]);
     ((TWyborPrzycisku*) wsk->nast)->DodajDziecko(0, pom);
     for (int i=1; i<=4; i++)
       ((TWyborPrzycisku*) wsk->nast)->DodajDziecko(i, agresja);
   }
   // 2 opcja ,,12'': zdobycze
   nie_przesuwaj[ile_el]=1;
   wsk = lista[ile_el++] = new TProstokat(&wsp[178], &kolor[0]);
   ((TWyborPrzycisku*) opcje12)->DodajDziecko(1, wsk); 
   wsk->nast = zdobycze;
   // 3 opcja ,,12'': bouzy
   nie_przesuwaj[ile_el]=1;
   wsk = lista[ile_el++] = new TProstokat(&wsp[178], &kolor[0]);
   ((TWyborPrzycisku*) opcje12)->DodajDziecko(2, wsk); 
   {
     TElMenu *pom = lista[ile_el++] =
       wsk->nast = new TWyborPrzycisku(&wsp[428], TEkran::kolory_wybor_przycisku, &nu[88], 2, zd+ZD_FPOLE, POMOC_FPOLE);
     // Bouzy:
     wsk = lista[ile_el++] = new TProstokat(&wsp[436], &kolor[0]);
     ((TWyborPrzycisku*) pom)->DodajDziecko(0, wsk);
     wsk->nast = lista[ile_el++] = new TNapis(&wsp[440], &kolor[0], nu[90],KR_ALIGN_LEFT);   // wagi
     wsk=wsk->nast;
     wsk->nast = lista[ile_el++] =
       new TEdytorLiniowy(&wsp[442], TEkran::kolory_edytora, waganBo, zd+ZD_WAGABO_NASZE, 7, 1, 0, 20000, POMOC_WAGABO); 
     wsk=wsk->nast;
     wsk->nast = lista[ile_el++] =
       new TEdytorLiniowy(&wsp[446], TEkran::kolory_edytora, wagapBo, zd+ZD_WAGABO_PRZEC, 7, 1, 0, 20000, POMOC_WAGABO); 
     wsk=wsk->nast;
     wsk->nast = lista[ile_el++] = new TNapis(&wsp[450], &kolor[0], nu[91],KR_ALIGN_LEFT);   // nasze
     wsk=wsk->nast;
     wsk->nast = lista[ile_el++] = new TNapis(&wsp[452], &kolor[0], nu[92],KR_ALIGN_RIGHT);   // przec
     wsk=wsk->nast;
     wsk->nast = lista[ile_el++] = new TNapis(&wsp[454], &kolor[0], nu[93]);   // dylatacja
     wsk=wsk->nast;
     wsk->nast = lista[ile_el++] = new TSuwak(&wsp[456], TEkran::kolory_suwaka,
					      zd+ZD_DYLATACJA, 0, 11, NULL, NULL, POMOC_DYLAT);
     wsk=wsk->nast;
     wsk->nast = lista[ile_el++] = new TNapis(&wsp[468], &kolor[0], nu[94]);   // erozja
     wsk=wsk->nast;
     wsk->nast = lista[ile_el++] = new TSuwak(&wsp[470], TEkran::kolory_suwaka,
					      zd+ZD_EROZJA, 0, 22, NULL, NULL, POMOC_EROZJA);
     wsk=wsk->nast;
     wsk->nast = lista[ile_el++] =
       new TPrzyciskDwieOpcje(&wsp[482], TEkran::kolory_przycisku_dwie_opcje, nu[95],zd+ZD_PUNKTZAPOLE, POMOC_PKTPOL);
     // latwa funkcja:
     nie_przesuwaj[ile_el]=1;
     wsk = lista[ile_el++] = new TProstokat(&wsp[436], &kolor[0]);
     ((TWyborPrzycisku*) pom)->DodajDziecko(1, wsk);
     wsk->nast = lista[ile_el++] = new TNapis(&wsp[486], &kolor[0], nu[96],KR_ALIGN_LEFT);   // waga latwej funkcji
     wsk=wsk->nast;
     wsk->nast = lista[ile_el++] =
       new TEdytorLiniowy(&wsp[488], TEkran::kolory_edytora, wagalfo, zd+ZD_WAGA_LATWAFO, 7, 1, 0, 40000, POMOC_WAGALF); 
   }
   // 4 opcja ,,12'': opcje
   nie_przesuwaj[ile_el]=1;
   wsk = lista[ile_el++] = new TProstokat(&wsp[178], &kolor[0]);
   ((TWyborPrzycisku*) opcje12)->DodajDziecko(3, wsk); 
   // dodaj glebokosc
   wsk->nast=lista[ile_el++]=
     new TNapis(&wsp[116], &kolor[0], nu[20],KR_ALIGN_LEFT);   // ,,glebokosc analizy''
   wsk=wsk->nast;
   int ile_gleb_an = ((MAX_GLEB_ANALIZY-14) > 15) ? 
     15 + (MAX_GLEB_ANALIZY-13 >=20) : MAX_GLEB_ANALIZY-14;
   wsk->nast = lista[ile_el++]=new TWyborPrzycisku(&wsp[252], TEkran::kolory_wybor_przycisku,&nu[54], 
						   ile_gleb_an, zd+ZD_GLEBOKOSC,
						   POMOC_GLEBOK);
   wsk=wsk->nast;
   TElMenu *gleb_menu = wsk;
   // antyweze
   wsk->nast = lista[ile_el++]=
     new TNapis(&wsp[338], &kolor[0], nu[77],KR_ALIGN_LEFT);   // ,,antyweze''
   wsk=wsk->nast;
   wsk->nast =lista[ile_el++]=
     new TPrzyciskKilkaOpcji(&wsp[340], TEkran::kolory_przycisku_kilka_opcji, &nu[78], 2, zd+ZD_ANTYWEZE_O,POMOC_AWEZEO);
   wsk=wsk->nast;
   wsk->nast =lista[ile_el++]=
     new TPrzyciskKilkaOpcji(&wsp[344], TEkran::kolory_przycisku_kilka_opcji, &nu[80], 2, zd+ZD_ANTYWEZE_S,POMOC_AWEZES);
   /*  TYMCZASOWO wylaczone!
       wsk=wsk->nast;
       wsk->nast =lista[ile_el++]=
       new TPrzyciskKilkaOpcji(&wsp[348], TEkran::kolory_przycisku_kilka_opcji, &nu[82], 2, zd+ZD_ANTYWEZE_R,POMOC_AWEZER);
   */
   // testowe zamiast antyweza R:
   wsk=wsk->nast;
   wsk->nast =lista[ile_el++]=
     new TPrzyciskDwieOpcje(&wsp[412], TEkran::kolory_przycisku_dwie_opcje, nu[53],zd+ZD_TEST1, POMOC_TEST1);
   wsk=wsk->nast;
   wsk->nast =lista[ile_el++]=
     new TPrzyciskDwieOpcje(&wsp[416], TEkran::kolory_przycisku_dwie_opcje, nu[54],zd+ZD_TEST2, POMOC_TEST2);
   wsk=wsk->nast;
   wsk->nast =lista[ile_el++]=
     new TPrzyciskDwieOpcje(&wsp[420], TEkran::kolory_przycisku_dwie_opcje, nu[56],zd+ZD_TEST3, POMOC_TEST3);
   // szybkie wykrywanie bezp.
   wsk=wsk->nast;
   wsk->nast =lista[ile_el++]=
     new TPrzyciskDwieOpcje(&wsp[424], TEkran::kolory_przycisku_dwie_opcje, nu[87],zd+ZD_BEZPIECZNE, POMOC_SBEZP);
   // rozszerzenia
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=new TPrzyciskDwieOpcje(&wsp[174], TEkran::kolory_przycisku_dwie_opcje,
						      nu[86],zd+ZD_ROZSZ_OST,
						      POMOC_QUIETS);
   // teraz rozszerzenia pojedyncze/podwojne, ktore sa podczepiane do gleb_menu
   wsk = lista[ile_el++]=
     new TNapis(&wsp[352], &kolor[0], nu[84],KR_ALIGN_LEFT);   // ,,rozszerzenia pojedyncze''
   for (int i=2; i<ile_gleb_an; i++)
     ((TWyborPrzycisku*) gleb_menu)->DodajDziecko(i, wsk); 
   wsk->nast = lista[ile_el++]=new TWyborPrzycisku(&wsp[354], TEkran::kolory_wybor_przycisku,&nu[52], 9, zd+ZD_SEX_1,
						   POMOC_SEX_1);
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=
     new TNapis(&wsp[390], &kolor[0], nu[85],KR_ALIGN_LEFT);   // ,,rozszerzenia podwojne''
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=new TWyborPrzycisku(&wsp[392], TEkran::kolory_wybor_przycisku,&nu[52], 5, zd+ZD_SEX_2,
						   POMOC_SEX_2);
   // czyszczenie rozszerzen pojedynczych/podwojnych
   wsk = lista[ile_el++]= new TProstokat(&wsp[320], &kolor[0]); 
   ((TWyborPrzycisku*) gleb_menu)->DodajDziecko(0, wsk); 
   ((TWyborPrzycisku*) gleb_menu)->DodajDziecko(1, wsk); 
   // 5. opcja ,,12'': limit czasu
   nie_przesuwaj[ile_el]=1;
   wsk = lista[ile_el++] = new TProstokat(&wsp[178], &kolor[0]);
   ((TWyborPrzycisku*) opcje12)->DodajDziecko(4, wsk); 
   wsk->nast = lista[ile_el++]=
     new TNapis(&wsp[122], &kolor[0], nu[71],KR_ALIGN_LEFT);
   wsk=wsk->nast;
   TElMenu *kczas = wsk->nast = lista[ile_el++]=
     new TWyborPrzycisku(&wsp[124], TEkran::kolory_wybor_przycisku,&nu[72], 4, zd+ZD_KIEDYCZAS,POMOC_KIEDYC);
   wsk=wsk->nast;
   // dodaj listy ruchow
   wsk->nast = lista[ile_el++]=
     new TNapis(&wsp[492], &kolor[0], nu[97],KR_ALIGN_LEFT);   // ,,listy ruchow''
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=
     new TNapis(&wsp[494], &kolor[0], nu[98],KR_ALIGN_LEFT);   // ,,nasze''
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=
     new TNapis(&wsp[496], &kolor[0], nu[99],KR_ALIGN_LEFT);   // ,,przec''
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=
     new TNapis(&wsp[498], &kolor[0], nu[100],KR_ALIGN_LEFT);   // ,,przedost''
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=
     new TNapis(&wsp[500], &kolor[0], nu[101],KR_ALIGN_RIGHT);   // ,,lisc''
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=
     new TWyborPrzycisku(&wsp[502], TEkran::kolory_wybor_przycisku,&nu[49], 5, zd+ZD_LISTARUCHOW_N,POMOC_LISTARUCHOW_N);
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=
     new TWyborPrzycisku(&wsp[522], TEkran::kolory_wybor_przycisku,&nu[52], 5, zd+ZD_LISTARUCHOW_P,POMOC_LISTARUCHOW_P);
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=
     new TWyborPrzycisku(&wsp[542], TEkran::kolory_wybor_przycisku,&nu[52], 2, zd+ZD_LISTARUCHOW_U,POMOC_LISTARUCHOW_U);
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=
     new TWyborPrzycisku(&wsp[550], TEkran::kolory_wybor_przycisku,&nu[52], 2, zd+ZD_LISTARUCHOW_L,POMOC_LISTARUCHOW_L);
   // wartosc limitu czasu
   wsk = lista[ile_el++]=
     new TNapis(&wsp[140], &kolor[0], nu[76],KR_ALIGN_LEFT);
   for (int i=1; i<=3; i++)
     ((TWyborPrzycisku*) kczas)->DodajDziecko(i, wsk); 
   wsk->nast = lista[ile_el++]=
     new TEdytorLiniowy(&wsp[142], TEkran::kolory_edytora, limitcz, zd+ZD_LIMITCZAS, 8, 1, 1, 100000, POMOC_LIMIT_CZASU);
   // prostokat czyszczacy dla ,,nigdy''
   wsk=lista[ile_el++]= new TProstokat(&wsp[146], &kolor[0]);
   ((TWyborPrzycisku*) kczas)->DodajDziecko(0, wsk); 
   
   // poziom 13
   // dodajemy galaz do poziomu 13
   wsk=lista[ile_el++]=new TProstokat(&wsp[558], &kolor[0]);
   ((TWyborPrzycisku*) ktos)->DodajDziecko(11, wsk);
   wsk->nast = lista[ile_el++]=
     new TEdytorLiniowy(&wsp[562], TEkran::kolory_edytora, iteracji, zd+ZD_ITERACJI, 10, 1, 1, 100000000, POMOC_MC_ITERACJI);
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=
     new TEdytorLiniowy(&wsp[566], TEkran::kolory_edytora, mc_funkcja, zd+ZD_MC_FUNKCJA, 8, 1, 1, 100000, POMOC_MC_FUNKCJA);
   
   assert(ile_el<=sizeof(nie_przesuwaj)/sizeof(nie_przesuwaj[0]));
 }
 else {
   // tylko uproszczone opcje!
   wsk->nast = lista[ile_el++]=new TNapis(&wsp[34], &kolor[0], nu[21]);
   wsk=wsk->nast;
   wsk->nast =
     lista[ile_el++]=new TSuwak(&wsp[94], TEkran::kolory_suwaka,
				zd+ZD_AGRESJA, -9, 19, nu[22], nu[23], POMOC_AGRESJ);
   wsk=wsk->nast;
   // wartosc limitu czasu
   wsk->nast = lista[ile_el++]=
     new TNapis(&wsp[140], &kolor[0], nu[76]); //,KR_ALIGN_LEFT);
   wsk=wsk->nast;
   wsk->nast = lista[ile_el++]=
     new TEdytorLiniowy(&wsp[142], TEkran::kolory_edytora, limitcz, zd+ZD_LIMITCZAS, 8, 1, 1, 100000, POMOC_LIMIT_CZASU);
 }

 //  printf("ile_el = %d\n",ile_el);
 UstawWlk();
 UaktualnijPolozenie();
 UstawGracza();
}

void TMenuGracz::UstawWlk()
// uwaga: wszystkie zmienne ozn. liczbe pikseli, czyli dlugosc-1
{
 int wys_przyc=2*WYS_FONTU+1, odstep_przyc=WYS_FONTU/2-1;
 int marg=(2*wys_przyc)/3;
 int odstep_duzy = 2*WYS_FONTU;
 int odstep_duzy_poz = 3*WYS_FONTU;
 int szer_pgry = 3*SZER_FONTU;   // szerokosc wnetrza prostokacika poziomu gry
 int szer_wn_menu = (12*szer_pgry + 14 + SZER_FONTU);   // 14 kreseczek tworzacych ramki
 {
 int ile_za_malo = 204 - szer_wn_menu + (2*szer_pgry+4);  // ile za malo na suwak -- chcemy >=204
 if (ile_za_malo>0)
   {
   szer_pgry += ile_za_malo/12;
   szer_wn_menu += ile_za_malo;
   }
 }
 int szer_pudelka = 2+ 2*odstep_duzy_poz + szer_wn_menu;
 // prostokat czyszczacy
 wsp[0]=0;  wsp[1]=0;
 wsp[2]=2*marg + szer_pudelka - 1;
 int y=marg;
 // ramka zewnetrzna
 wsp[4]=marg;  wsp[5]=marg;
 wsp[6]=marg + szer_pudelka - 1;
 // napis w naglowku
 wsp[20]=marg + (szer_pudelka - 1)/2;
 wsp[21]=marg + odstep_przyc + (wys_przyc+1)/2;
 // ramka wewnetrzna
 y+=wys_przyc+2*odstep_przyc+1;
 wsp[8]=marg;  wsp[9]= y;
 wsp[10]=marg + szer_pudelka - 1;
 y+=odstep_duzy+1;
 int przyc_komp_k = wsp[6]-odstep_duzy_poz-1;
 int przyc_komp_p = przyc_komp_k - (szer_wn_menu - odstep_duzy_poz -1)/2;
 if (stan & 1)  // jest czlowiek/komputer
   {
   // czlowiek
   wsp[22]= marg+odstep_duzy_poz+1;
   wsp[23]= y;
   wsp[24]= wsp[22] + (szer_wn_menu - odstep_duzy_poz -1)/2;
   wsp[25]= y+wys_przyc-1;
   // komputer
   wsp[28]= przyc_komp_k;
   wsp[26]= przyc_komp_p;
   wsp[27]= y;
   wsp[29]= y+wys_przyc-1;
   // czyszczenie fragmentu pod czlowiek/komputer
   wsp[30]= wsp[4]+2;
   wsp[31]= wsp[29]+1;
   wsp[32]= wsp[6]-2;
   y+=wys_przyc+odstep_duzy;
   }
 // napis imie/poziom gry
 wsp[34] = (wsp[4]+wsp[6])/2;
 wsp[35] = y+WYS_FONTU/2;
 y+=WYS_FONTU+odstep_przyc+1;
 // imie
 wsp[158]= marg+odstep_duzy_poz+1;
 wsp[159]= y;
 wsp[160]= wsp[6]-odstep_duzy_poz-1;
 wsp[161]= y+wys_przyc-1;
 // poziom gry
 wsp[36] = wsp[158];              wsp[37] = wsp[159];
 wsp[38] = wsp[158]+szer_pgry+1;  wsp[39] = wsp[161];
 for (int i=0; i<9; i++)
   {
   wsp[40+4*i] = wsp[38+4*i];
   wsp[41+4*i] = wsp[37];
   wsp[42+4*i] = wsp[38+4*i]+szer_pgry+1;
   wsp[43+4*i] = wsp[39];
   }
 // ostatnie 2 poziomy
 wsp[82] = wsp[160];
 wsp[78] = wsp[80] = wsp[160]-szer_pgry-1;
 wsp[76] = wsp[80]-szer_pgry-1;
 wsp[77] = wsp[81] = wsp[37];
 wsp[79] = wsp[83] = wsp[39];
 y+=wys_przyc+odstep_duzy;
 // czyszczenie fragmentu pod poziomem gry
 wsp[150]=wsp[4]+2;
 wsp[151]=y;
 wsp[152]=wsp[6]-2;
 // opcje 11/12
 wsp[166]=wsp[158];
 wsp[172]=wsp[160];
 {
   int dlug=(wsp[172]-wsp[166])/2;
   wsp[168]=wsp[170] = wsp[166]+dlug;
 }
 wsp[213]=wsp[217]=wsp[221]=wsp[225]=wsp[229]= wsp[167]=wsp[171]= y;
 wsp[215]=wsp[219]=wsp[223]=wsp[227]=wsp[231]= wsp[169]=wsp[173]= y+=wys_przyc-1;
 y+=odstep_przyc+1;
 // cd. opcji 12
 wsp[212]=wsp[158];
 wsp[230]=wsp[160];
 {
   int dlug=(wsp[230]-wsp[212])/4;
   wsp[214]=wsp[216] = wsp[212]+dlug;
   wsp[218]=wsp[220] = wsp[216]+dlug;
   dlug = (wsp[230]-wsp[218])/3;
   wsp[222]=wsp[224] = wsp[220]+dlug;
   wsp[226]=wsp[228] = wsp[224]+dlug;
 }
 // czyszczenie opcji 11/12
 wsp[154]=wsp[4]+2;
 wsp[155]=wsp[213];
 wsp[156]=wsp[6]-2;
 wsp[157]=wsp[215];
 // prostokat czyszczacy pod opcjami 11/12
 wsp[178]=wsp[4]+2;
 wsp[179]=y+1;
 wsp[180]=wsp[6]-2;
 y+=WYS_FONTU+odstep_przyc+1;
 // brzuszki
 wsp[162]=wsp[158];
 wsp[164]=wsp[160];
 wsp[163]=y;
 wsp[165]=y += wys_przyc-1;
 y+=odstep_przyc;
 int y_po_brz = y;
 // przycisk rozpoznawania mostkow
 wsp[84] = wsp[162];
 wsp[85] = wsp[163];
 wsp[86] = wsp[164];
 wsp[87] = wsp[165];
 // wlaczona/wylaczona ocena skladowych
 for (int i=0; i<3; i++)
   {
   wsp[232+4*i] = wsp[162] + (i*(wsp[164]-wsp[162])) / 3;
   wsp[233+4*i] = wsp[163];
   wsp[234+4*i] = wsp[162] + ((i+1)*(wsp[164]-wsp[162])) / 3;
   wsp[235+4*i] = wsp[165];
   }
 for (int i=0; i<8; i++) wsp[244+i] = wsp[236+i];
 for (int i=1; i<8; i+=2) wsp[244+i] += (wsp[165]-wsp[163]);
 // czyszczenie pod wylacznikiem oceny skl.
 wsp[118]=wsp[4]+2;
 wsp[119]=wsp[251]+1;
 wsp[120]=wsp[6]-2;
 // napis ,,agresja''
 y=wsp[251];
 wsp[90] =(wsp[162]+wsp[164])/2;
 wsp[91] = y+=WYS_FONTU;
 // suwak agresji  (inicjowany wspolrzednymi poziomow gry)
 y+=3*WYS_FONTU/2+odstep_przyc+1  +2;  // dodatkowe +2, zeby troszke odsunac suwak
 wsp[94] = wsp[40];
 wsp[95] = wsp[42]; //+1;
 wsp[96] = wsp[76];
 wsp[97] = szer_pgry+1;
 wsp[98] = wsp[36]+SZER_FONTU/2;
 wsp[99] = y;
 wsp[100]= y+wys_przyc/2;
 wsp[101]= y+wys_przyc-1 + odstep_przyc;
 wsp[102]= wys_przyc-1;
 wsp[103]= 2;
 wsp[104]= odstep_przyc;
 y += wys_przyc+odstep_duzy+WYS_FONTU+odstep_przyc+1;


 // Pole (Bouzy itp.)
 y = wsp[163];
 // wybor: Bouzy/Latwa f. oc.
 wsp[428]=wsp[162];
 wsp[430]=wsp[162] + (wsp[164]-wsp[162])/2;
 wsp[432]=wsp[430];
 wsp[434]=wsp[164];
 wsp[429]=wsp[433]=y;
 wsp[431]=wsp[435]=y+=wys_przyc-1;
 // prostokat czyszczacy:
 wsp[436]=wsp[4]+2;
 wsp[437]=y+1;
 wsp[438]=wsp[6]-2;
 y+=odstep_przyc+WYS_FONTU/2;
 // napis ,,wagi''
 wsp[440] = wsp[36];
 wsp[441] = y+WYS_FONTU/2;
 y+=WYS_FONTU+odstep_przyc+1;
 // wpisywanie naszej wagi
 wsp[442] = wsp[158];
 wsp[444] = wsp[48];
 wsp[443] = y;
 wsp[445]=  y+=wys_przyc-1;
 y += odstep_przyc+1; 
 // napis ,,nasze''
 wsp[450] = wsp[48]+2;
 wsp[451] =(wsp[443]+wsp[445])/2;
// drugie wpisywanie wagi (przeciwnika)
 wsp[448] = wsp[160];
 wsp[446] = wsp[448]-(wsp[444]-wsp[442]);
 wsp[447] = wsp[443];
 wsp[449] = wsp[445];
 // napis ,,przeciwnika''
 wsp[452] = wsp[446]-2;
 wsp[453] = wsp[451];
 y += WYS_FONTU/2 - (WYS_FONTU*5)/4;
 // napis ,,dylatacja''
 wsp[454] =(wsp[162]+wsp[164])/2;
 wsp[455] = y+=WYS_FONTU-2;
 // suwak dylatacji
 y+=WYS_FONTU/2+odstep_przyc+1  +2;  // dodatkowe +2, zeby troszke odsunac suwak
 for (int i=0; i<11; i++)
   wsp[456+i] = wsp[470+i] = wsp[94+i];   // inicjuj suwaki suwakiem agresji
 wsp[461]=y;
 wsp[462]=y+wys_przyc/2;
 wsp[463]=y+wys_przyc-1 + odstep_przyc;
 y += wys_przyc+1;
 // napis ,,erozja''
 wsp[468] =(wsp[162]+wsp[164])/2;
 wsp[469] = y+=WYS_FONTU-4;
 // suwak erozji
 y+=WYS_FONTU/2+odstep_przyc+1  +2;  // dodatkowe +2, zeby troszke odsunac suwak
 wsp[475]=y;
 wsp[476]=y+wys_przyc/2;
 wsp[477]=y+wys_przyc-1 + odstep_przyc;
 y += wys_przyc+odstep_przyc+1;
 // przycisk ,,punkt za pole''
 wsp[482]=wsp[162];
 wsp[484]=wsp[164];
 wsp[483]=y;
 wsp[485]=y+=wys_przyc-1;
 // y+=odstep_przyc;
 wsp[439]=y+1;  // prostokat czyszczacy
 // Druga opcja: Latwa funkcja oceniajaca
 wsp[486]= wsp[440];
 wsp[487]= wsp[441];
 // wpisywanie wagi LFO
 wsp[488] = wsp[442];
 wsp[490] = wsp[444];
 wsp[489] = wsp[443];
 wsp[491]=  y = wsp[445];
 
 // glebokosc analizy
 y = wsp[163];  // y_po_brz + odstep_przyc;
 // napis glebokosci analizy
 wsp[116] = wsp[162];
 wsp[117] = y+WYS_FONTU/2;
 y+=WYS_FONTU + odstep_przyc;
 int ile_gleb_an = ((MAX_GLEB_ANALIZY-14) > 15) ? 
   15 + (MAX_GLEB_ANALIZY-13 >=20) : MAX_GLEB_ANALIZY-14;
 int ile_podzialow_an = ile_gleb_an + (ile_gleb_an==16);
 for (int i=0; i<ile_gleb_an; i++)
   {
   int popr = (i==ile_gleb_an-1 && ile_gleb_an!=ile_podzialow_an);
   wsp[252+4*i] = wsp[162] + ((i+popr)*(wsp[164]-wsp[162])) / ile_podzialow_an;
   wsp[253+4*i] = y;
   wsp[254+4*i] = wsp[162] + ((i+popr+1)*(wsp[164]-wsp[162])) / ile_podzialow_an;
   wsp[255+4*i] = y+wys_przyc-1;
   }
 y+=wys_przyc-1+2*odstep_przyc;
 // napis ,,antyweze''
 wsp[338]=wsp[162];
 wsp[339]=y+WYS_FONTU/2;
 y+=WYS_FONTU+odstep_przyc;
 for (int i=0; i<3; i++)
   {
   wsp[340+4*i] = wsp[162] + (i*(wsp[164]-wsp[162])) / 3;
   wsp[341+4*i] = y;
   wsp[342+4*i] = wsp[162] + (((i+1)*(wsp[164]-wsp[162])) / 3) - (i!=2);
   wsp[343+4*i] = y+wys_przyc-1;
   }
 for (int i=0; i<4; i++) {
   // testowe:
   wsp[413+4*i] = y;
   wsp[415+4*i] = y+wys_przyc-1;
   wsp[412+4*i] = wsp[80]-(3-i)*(wsp[82]-wsp[78])+1;
   wsp[414+4*i] = wsp[412+4*i]-1 + wsp[82]-wsp[80];
   }
 y+=wys_przyc-1;
 // czyszczenie rozszerzen
 wsp[320]=wsp[178];
 wsp[321]=y+1;
 wsp[322]=wsp[180];
 //
 y+=2*odstep_przyc;
 // napis ,,rozszerzenia pojedyncze''
 wsp[352]=wsp[162];
 wsp[353]=y+WYS_FONTU/2;
 y+=WYS_FONTU+odstep_przyc;
 for (int i=0; i<9; i++)
   {
   wsp[354+4*i] = wsp[36+4*i];
   wsp[355+4*i] = y;
   wsp[356+4*i] = wsp[38+4*i];
   wsp[357+4*i] = y+wys_przyc-1;
   }
 y+=wys_przyc-1+2*odstep_przyc;
 // napis ,,rozszerzenia podwojne''
 wsp[390]=wsp[162];
 wsp[391]=y+WYS_FONTU/2;
 y+=WYS_FONTU+odstep_przyc;
 for (int i=0; i<5; i++)
   {
   wsp[392+4*i] = wsp[36+4*i];
   wsp[393+4*i] = y;
   wsp[394+4*i] = wsp[38+4*i];
   wsp[395+4*i] = y+wys_przyc-1;
   }
 y+=wys_przyc-1+2*odstep_przyc;
 wsp[323]=y-1;  // dolna krawedz czyszczenia rozszerzen pojed/podw
 // przycisk ,,rozszerzenia na ost. glebokosci''
 wsp[174]=wsp[158];
 wsp[175]=y;
 wsp[176]=wsp[160];
 wsp[177]=y+=wys_przyc-1;
 y+=odstep_przyc;
 int yopcje = y;
 // teraz czas
 // napis ,,sprawdzaj czas namyslu''
 y = wsp[163];
 wsp[122]=wsp[162];
 wsp[123]=y+WYS_FONTU/2;
 y+=WYS_FONTU+odstep_przyc;
 for (int i=0; i<4; i++)
   {
   wsp[124+4*i] = wsp[162] + (i*(wsp[164]-wsp[162])) / 4;
   wsp[125+4*i] = y;
   wsp[126+4*i] = wsp[162] + ((i+1)*(wsp[164]-wsp[162])) / 4;
   wsp[127+4*i] = y+wys_przyc-1;
   }
 y+=wys_przyc-1+odstep_przyc;
 // napis ,,limit czasu''
 wsp[140]=wsp[162];
 wsp[141]=y+WYS_FONTU/2;
 y+=WYS_FONTU+odstep_przyc;
 // wpisywanie limitu czasu
 wsp[142]=wsp[162];
 wsp[143]=y;
 wsp[144]=wsp[48];
 wsp[145]=y+=wys_przyc-1;
 // czyszczenie dla ,,nigdy''
 wsp[146]=wsp[4]+2;
 wsp[147]=wsp[127]+1;
 wsp[148]=wsp[6]-2;
 wsp[149]=y+1;
 y+=2*odstep_przyc;
 // napis ,,lista ruchow''
 wsp[492]=wsp[162];
 wsp[493]=y+WYS_FONTU/2;
 y+=WYS_FONTU+odstep_przyc;
 // napisy ,,nasze'',...
 wsp[494]=wsp[162];
 wsp[501]=wsp[499]=wsp[497]=wsp[495]=y+wys_przyc+WYS_FONTU/2;
 wsp[496]=wsp[276];
 // ustawianie
 for (int i=0; i<5; i++) {
   wsp[502+4*i] = wsp[252+4*i];
   wsp[503+4*i] = y;
   wsp[504+4*i] = wsp[254+4*i];
   wsp[505+4*i] = y+wys_przyc-1;
   wsp[522+4*i] = wsp[276+4*i];
   wsp[523+4*i] = y;
   wsp[524+4*i] = wsp[278+4*i];
   wsp[525+4*i] = y+wys_przyc-1;
 }
 {
 wsp[554]=wsp[252+(ile_gleb_an-1)*4  ];  // lisc[1]
 wsp[556]=wsp[252+(ile_gleb_an-1)*4+2];
 int d=wsp[556]-wsp[554]+1;
 wsp[550]=wsp[554]-d;        // lisc[0]
 wsp[552]=wsp[556]-d;
 wsp[546]=wsp[550]-2*d;   // przedost[1]
 wsp[548]=wsp[552]-2*d;
 wsp[542]=wsp[546]-d;     // przedost[0]
 wsp[544]=wsp[548]-d;
 for (int i=0; i<4; i++) {
   wsp[543+4*i]=y;
   wsp[545+4*i]=y+wys_przyc-1;
 }
 // napisy ,,przedost'' i ,,lisc'' -- wsp. x
 wsp[498]=wsp[542];
 wsp[500]=wsp[160];
 }
 // zdobycze -- napis ,,waga kropki''
 int yzd = wsp[165] + 2*odstep_przyc;
 wsp[182]=wsp[36];
 wsp[183]=yzd+WYS_FONTU/2;
 yzd+=WYS_FONTU+odstep_przyc;
 // wagi kropki
 wsp[184]=wsp[36];
 wsp[185]=yzd;
 wsp[187]=yzd+=wys_przyc-1;
 wsp[186]=wsp[38];
 for (int i=0; i<6; i++) {
   wsp[184+4+4*i] = wsp[186+4*i];
   wsp[185+4+4*i] = wsp[185];
   wsp[187+4+4*i] = wsp[187];
   wsp[186+4+4*i] = wsp[184+4+4*i] + (wsp[38]-wsp[36]);
 }
 yzd+=2*odstep_przyc;
 // 
 // napis ,,waga zdobyczy''
 wsp[92] = wsp[36];
 wsp[93] = yzd+WYS_FONTU/2;
 yzd+=WYS_FONTU+odstep_przyc+1;
 // wpisywanie naszej wagi zdobyczy
 wsp[106] = wsp[158];
 wsp[108] = wsp[48];
 wsp[107] = yzd;
 wsp[109]= yzd+=wys_przyc-1;
 yzd += odstep_przyc+1; 
 // napis ,,nasze''
 wsp[88] = wsp[48]+2;
 wsp[89]=(wsp[107]+wsp[109])/2;
// drugie wpisywanie przejmuje sie
 wsp[112] = wsp[160];
 wsp[110] = wsp[112]-(wsp[108]-wsp[106]);
 wsp[111] = wsp[107];
 wsp[113] = wsp[109];
 // napis ,,przeciwnika''
 wsp[114] = wsp[110]-2;
 wsp[115] = wsp[89];
 yzd += WYS_FONTU/2 - (WYS_FONTU*5)/4;
 // napisy objasniajace
 for (int i=0; i<7; i++) {
   wsp[324+2*i] = wsp[36];
   wsp[325+2*i] = yzd+=(WYS_FONTU*5)/4;
 }
 yzd+=WYS_FONTU/2+odstep_przyc+1;
 if (y<yzd) y = yzd;
 if (y<yopcje) y = yopcje;
 wsp[33]=y-1;  // czyszczenie pod czlowiek/komp
 wsp[121]=wsp[181]=wsp[153]=y-1; // czyszczenie pod poziomem gry
 wsp[11]=y;    // ramka wewnetrzna
 // opcje poziomu 13
 for (int i=0; i<4; i++)
   wsp[558+i] = wsp[150+i];   // prostokat czyszczacy
 for (int i=0; i<4; i++)
   wsp[562+i] = wsp[212+i];   // liczba iteracji - skopiuj z opcji 12
 wsp[564] = wsp[230];   // x2 skopiuj z ostatniej opcji 12
 for (int i=0; i<4; i++)
   wsp[566+i] = wsp[162+i];   // funkcja MC -- skopiuj z niskiej oceny duzych brzuszkow
 // napis OK/Anuluj
 if (stan & 2)
   {
   wsp[12] = wsp[158];
   wsp[13] = y+ odstep_przyc+1;
   wsp[14] = wsp[158] + (szer_wn_menu - odstep_duzy_poz -1)/2;
   wsp[15] = y+ odstep_przyc+wys_przyc;
   wsp[16] = wsp[160] - (wsp[14]-wsp[12]);
   wsp[18] = wsp[160];
   wsp[17] = wsp[13];
   wsp[19] = wsp[15];
   y+= wys_przyc+2*odstep_przyc+1;
   }
 wsp[7]=y;       // dol ramki zewnetrznej
 wsp[3]=y+marg;  // dol prostokatu czysczacego
 if (!(stan & 8)) {
   // poprawki dla uproszczonej wersji graczy
   int ile = (wsp[91] - wsp[35]);
   wsp[99]  -= ile;
   wsp[100] -= ile;
   wsp[101] -= ile;
   // wycentruj napis limitu czasu i okienko do wpisywania
   wsp[140] = wsp[34];
   wsp[142] = wsp[236];
   wsp[144] = wsp[238];
   ile = (wsp[141] - wsp[241]);
   wsp[141] -= ile;
   wsp[143] -= (ile - odstep_przyc);
   wsp[145] -= (ile - odstep_przyc);

 }
}

int TMenuGracz::DajWlkX()
{ return wsp[2]-wsp[0]+1; }
int TMenuGracz::DajWlkY()
{ return wsp[3]-wsp[1]+1; }

TMenuGracz::~TMenuGracz()
{
 for (int i=0; i<ile_el; i++) delete lista[i];
 delete[] wsp;
}

void TMenuGracz::UaktualnijPolozenie()
// uaktualnia polozenie wg danych z wspolrz[]
{
 if (wsp[0]!=wspolrz[0] || wsp[1]!=wspolrz[1])
   PrzesunTylkoTen(0,0);
}

void TMenuGracz::PrzesunTylkoTen(int dx, int dy)
{
 int oilex=dx+wspolrz[0]-wsp[0], oiley=dy+wspolrz[1]-wsp[1];
 for (int i=0; i<ile_el; i++)
  if (!nie_przesuwaj[i])
   lista[i]->PrzesunTylkoTen(oilex, oiley);
}

int TMenuGracz::DajZdarzenie_el(TKlawisz k, TFlagi f, int x, int y)
{
 int zd=m->DajZdarzenie(k,f,x,y);
 if (zd==ZD_NIC)
   {
     // tymczasowe: if (k=='6') g->umiejetnosci ^= 0x10;
   return ZD_NIC;
   }
 zd-=zdarzenie;
 switch (zd) 
   {
     //   case ZD_NIC:     return ZD_NIC;
   case ZD_OK:      return zdarzenie+ZD_OK;
   case ZD_ANULUJ:  return zdarzenie+ZD_ANULUJ;
   case ZD_KTO:     g->komputer=0; break;
   case ZD_KTO+1:   g->komputer=1; break;
   case ZD_MOSTKI:   g->umiejetnosci |= 4; break;
   case ZD_MOSTKI+1: g->umiejetnosci &= ~4; break;
   case ZD_BRZUSZKI  : g->umiejetnosci |= 0x10; break;
   case ZD_BRZUSZKI+1: g->umiejetnosci &= ~0x10; break;
   case ZD_ROZSZ_OST  : g->umiejetnosci |= 0x100; break;
   case ZD_ROZSZ_OST+1: g->umiejetnosci &= ~0x100; break;
   case ZD_PRZEJMUJESIE:
     g->wagi_n.zd = atoi(wagan);
     break;
   case ZD_PRZEJMUJESIE_PRZEC:
     g->wagi_p.zd = atoi(wagap);
     break;
   case ZD_KIEDYCZAS:
   case ZD_KIEDYCZAS+1:
   case ZD_KIEDYCZAS+2:
   case ZD_KIEDYCZAS+3:
     g->czas_kiedy = zd-ZD_KIEDYCZAS;
     break;
   case ZD_LIMITCZAS:
     g->czas_sek = atoi(limitcz);
     g->czas_ssek = 0;
     if (!(stan & 8)) {
       // ustaw odpowiednia glebokosc...
       if (g->czas_sek<3)
	 g->dokl_analizy=6;
       else if (g->czas_sek<10)
	 g->dokl_analizy=8;
       else if (g->czas_sek<100)
	 g->dokl_analizy=10;
       else if (g->czas_sek<1000)
	 g->dokl_analizy=12;
       else if (g->czas_sek<10000)
	 g->dokl_analizy=16;
       else
	 g->dokl_analizy=20;
     }
     break;
   case ZD_ANTYWEZE_O  : g->umiejetnosci |= 0x20; break;
   case ZD_ANTYWEZE_O+1: g->umiejetnosci &= ~0x20; break;
   case ZD_ANTYWEZE_S  : g->umiejetnosci |= 0x40; break;
   case ZD_ANTYWEZE_S+1: g->umiejetnosci &= ~0x40; break;
   case ZD_ANTYWEZE_R  : g->umiejetnosci |= 0x80; break;
   case ZD_ANTYWEZE_R+1: g->umiejetnosci &= ~0x80; break;
   case ZD_BEZPIECZNE  : g->umiejetnosci |= 0x200; break;
   case ZD_BEZPIECZNE+1: g->umiejetnosci &= ~0x200; break;
   case ZD_TEST1    : g->testowe |= 1; break;
   case ZD_TEST1+1  : g->testowe &= ~1; break;
   case ZD_TEST2    : g->testowe |= 2; break;
   case ZD_TEST2+1  : g->testowe &= ~2; break;
   case ZD_TEST3    : g->testowe |= 4; break;
   case ZD_TEST3+1  : g->testowe &= ~4; break;
   case ZD_WAGABO_PRZEC:
     g->wagi_p.Bo = atoi(wagapBo);
     break;
   case ZD_WAGABO_NASZE:
     g->wagi_n.Bo = atoi(waganBo);
     break;
   case ZD_ITERACJI:
     g->iteracji = atoi(iteracji);
     break;
   case ZD_MC_FUNKCJA:
     g->funkcja_mc = atoi(mc_funkcja);
     break;
   case ZD_PUNKTZAPOLE  : g->opcje_Bouzy |= 1;  break;
   case ZD_PUNKTZAPOLE+1: g->opcje_Bouzy &=~1;  break;
   case ZD_WAGA_LATWAFO:
     g->waga_latwe_pole = atoi(wagalfo);
     break;
   default:
     if (zd>=ZD_POZIOMGRY && zd<ZD_POZIOMGRY+12)
       {
       g->poziom_gry=zd-ZD_POZIOMGRY;
       if (g->poziom_gry>=10)
	 g->poziom_gry += 2;
       }
     else if (zd>=ZD_AGRESJA && zd<ZD_AGRESJA+19) {
       int agresja=zd-ZD_AGRESJA-9;
       //       g->wagi_n.zd /= g->wagi_p.sk; // na odwrot: wagi_n.zd dzielimy przez wagi_p.sk!!
       //       g->wagi_p.zd /= g->wagi_n.sk;
       g->wagi_n.sk = 12-agresja;
       g->wagi_p.sk = 12+agresja;
       //       g->wagi_n.zd *= g->wagi_p.sk;
       //       g->wagi_p.zd *= g->wagi_n.sk;
     }
     else if (zd>=ZD_GLEBOKOSC && zd<ZD_GLEBOKOSC+(MAX_GLEB_ANALIZY-14)) {
       g->dokl_analizy=zd-ZD_GLEBOKOSC+2;
       if (g->dokl_analizy==17)  g->dokl_analizy=MAX_GLEB_ANALIZY-13;  // dodatkowa opcja
     }
     else if (zd>=ZD_WAGAKROPKI && zd<ZD_WAGAKROPKI+7)
       g->waga_kropki = zd - ZD_WAGAKROPKI + 2;
     else if (zd>=ZD_OCENASKL && zd<ZD_OCENASKL+5)
       g->funkcja_sk = (zd-ZD_OCENASKL) + ((zd-ZD_OCENASKL) != 0);
     else if (zd>=ZD_SEX_1 && zd<ZD_SEX_1+9)
       g->sex_limit = zd-ZD_SEX_1;
     else if (zd>=ZD_SEX_2 && zd<ZD_SEX_2+5)
       g->sex_limit_podw = zd-ZD_SEX_2;
     else if (zd>=ZD_DYLATACJA && zd<ZD_DYLATACJA+11)
       g->Bouzy_dil = zd-ZD_DYLATACJA;
     else if (zd>=ZD_EROZJA && zd<ZD_EROZJA+22)
       g->Bouzy_er = zd-ZD_EROZJA;
     else if (zd>=ZD_LISTARUCHOW_N && zd<ZD_LISTARUCHOW_N+5)
       g->listy_ruchow[0]=zd-ZD_LISTARUCHOW_N-3;  // zaczyna sie od -3
     else if (zd>=ZD_LISTARUCHOW_P && zd<ZD_LISTARUCHOW_P+5)
       g->listy_ruchow[1]=zd-ZD_LISTARUCHOW_P; 
     else if (zd>=ZD_LISTARUCHOW_U && zd<ZD_LISTARUCHOW_U+2)
       g->listy_ruchow[2]=zd-ZD_LISTARUCHOW_U; 
     else if (zd>=ZD_LISTARUCHOW_L && zd<ZD_LISTARUCHOW_L+2)
       g->listy_ruchow[3]=zd-ZD_LISTARUCHOW_L; 
     break;
   }
 return (stan & 4) ? zdarzenie : ZD_NIC;
}

void TMenuGracz::InicjujZdarzeniem_el(int zd)
{
 if (zd==zdarzenie)
   UstawGracza();
 else
   for (int i=0; i<ile_el; i++) lista[i]->InicjujZdarzeniem(zd);
}

void TMenuGracz::RysujJesliZdarzenie_el(int zd)
{
 if (zd==zdarzenie) Rysuj_el();
 else m->RysujJesliZdarzenie(zd);
}

inline void TMenuGracz::Rysuj_el()
{ m->Rysuj(); }

int TMenuGracz::WSrodku(int x, int y)
{  return (x>wspolrz[0] && x<wspolrz[0]+DajWlkX()-1) &&
          (y>wspolrz[1] && y<wspolrz[1]+DajWlkY()-1);    };

void TMenuGracz::UstawGracza()
// wstawia dane z ,,g'' do ,,m''
{
 m->InicjujZdarzeniem(zdarzenie+ZD_KTO + g->komputer);
 m->InicjujZdarzeniem(zdarzenie+ZD_POZIOMGRY + g->poziom_gry - 2*(g->poziom_gry>=10));
 m->InicjujZdarzeniem(zdarzenie+ZD_POZIOMGRY + g->poziom_gry - 2*(g->poziom_gry>=10));
 if (g->dokl_analizy<=16)
   m->InicjujZdarzeniem(zdarzenie+ZD_GLEBOKOSC + g->dokl_analizy-2);
 else
   m->InicjujZdarzeniem(zdarzenie+ZD_GLEBOKOSC + 15);
 m->InicjujZdarzeniem(zdarzenie+ZD_AGRESJA + g->wagi_p.sk-3);
 // m->InicjujZdarzeniem(zdarzenie+ZD_PRZEJMUJESIE + 
 //		      (g->wagi_p.sk ? ((g->wagi_n.zd/g->wagi_p.sk)-30) : 0));
 m->InicjujZdarzeniem(zdarzenie+ZD_MOSTKI + ((g->umiejetnosci & 4)==0));
 m->InicjujZdarzeniem(zdarzenie+ZD_OCENASKL + g->funkcja_sk - (g->funkcja_sk!=0));
 m->InicjujZdarzeniem(zdarzenie+ZD_BRZUSZKI + ((g->umiejetnosci & 0x10)==0));
 m->InicjujZdarzeniem(zdarzenie+ZD_DYLATACJA + g->Bouzy_dil);
 m->InicjujZdarzeniem(zdarzenie+ZD_EROZJA + g->Bouzy_er);
 m->InicjujZdarzeniem(zdarzenie+ZD_PUNKTZAPOLE + ((g->opcje_Bouzy & 1)==0));
 m->InicjujZdarzeniem(zdarzenie+ZD_ANTYWEZE_O + ((g->umiejetnosci & 0x20)==0));
 m->InicjujZdarzeniem(zdarzenie+ZD_ANTYWEZE_S + ((g->umiejetnosci & 0x40)==0));
 m->InicjujZdarzeniem(zdarzenie+ZD_ANTYWEZE_R + ((g->umiejetnosci & 0x80)==0));
 m->InicjujZdarzeniem(zdarzenie+ZD_BEZPIECZNE + ((g->umiejetnosci & 0x200)==0));
 m->InicjujZdarzeniem(zdarzenie+ZD_TEST1 + ((g->testowe & 1)==0));
 m->InicjujZdarzeniem(zdarzenie+ZD_TEST2 + ((g->testowe & 2)==0));
 m->InicjujZdarzeniem(zdarzenie+ZD_TEST3 + ((g->testowe & 4)==0));
 m->InicjujZdarzeniem(zdarzenie+ZD_ROZSZ_OST + ((g->umiejetnosci & 0x100)==0));
 m->InicjujZdarzeniem(zdarzenie+ZD_SEX_1 + g->sex_limit);
 m->InicjujZdarzeniem(zdarzenie+ZD_SEX_2 + g->sex_limit_podw);
 m->InicjujZdarzeniem(zdarzenie+ZD_WAGAKROPKI + g->waga_kropki-2);
 m->InicjujZdarzeniem(zdarzenie+ZD_KIEDYCZAS + g->czas_kiedy);
 m->InicjujZdarzeniem(zdarzenie+ZD_LISTARUCHOW_N + g->listy_ruchow[0]+3);
 m->InicjujZdarzeniem(zdarzenie+ZD_LISTARUCHOW_P + g->listy_ruchow[1]);
 m->InicjujZdarzeniem(zdarzenie+ZD_LISTARUCHOW_U + g->listy_ruchow[2]);
 m->InicjujZdarzeniem(zdarzenie+ZD_LISTARUCHOW_L + g->listy_ruchow[3]);

 sprintf(wagan, "%d", int(g->wagi_n.zd));
 sprintf(wagap, "%d", int(g->wagi_p.zd));
 sprintf(waganBo, "%d", int(g->wagi_n.Bo));
 sprintf(wagapBo, "%d", int(g->wagi_p.Bo));
 sprintf(wagalfo, "%d", int(g->waga_latwe_pole));
 sprintf(limitcz, "%d", int(g->czas_sek));
 sprintf(iteracji, "%d", int(g->iteracji));
 sprintf(mc_funkcja, "%d", int(g->funkcja_mc));
}

/*
#define K_TLA 0
#define K_KRATEK 1
#define K_TLATEKSTU 2
#define K_TEKSTU 3
#define K_GRACZA0 4
#define K_GRACZA1 5
#define K_CIENGRACZA0 6
#define K_CIENGRACZA1 7
#define K_OBWODKA     8
 */

class TRysujPlansze
{
  private:
  // parametry wyswietlania
  short int parw[9];   // [0-1] wsp lg, [2-3] pd rogu;
             // [4-5] lg rog prostokata na wlkx x wlky i liczbe kropek;
             // [6-7] pd rog tego prostokata; [8] min. margines
  TKolor kolory[10];    // tla, kratek, tla tekstu, tekstu,
                        // [4] gr1, gr2, [6] cien gr1, cien gr2, [8] obwodki
                        // [9] tekstu wspolrzednych
  int  wlk_kropki, cieniowanie;
  // parametry pomocnicze ustawiane automatycznie
  short int pocz_x, pocz_y, wlk_kratki;
  void UstawParamKratki();
  // parametry obwodki wokol ostatnio postawionej kropki; pokazywanie tablicy
//  unsigned char obwodki[max_bok_planszy][max_bok_planszy];
  int ost_kr_x, ost_kr_y, pokazuj_ost;  // pokazuj_ost ==-1 -- wskaznik schowany na czas pokazywania tablicy
  // parametry do opcji
  struct TOpcje {
    short int wsp[10];
    TKolor kol[11];
    static const char *napisy[10];
  } opcje;
  // rysunki, komentarze na planszy
  struct TKomentarz {
    short int rodzaj;
    char tekst[4];
  } komentarze[max_bok_planszy][max_bok_planszy];
  // metody ,,techniczne'' (rysuja pikselki)
  void NarysujKropke(int x, int y, TKolor kolor);
  void NarysujObwodke(int x, int y, TKolor kolor, int maska=0xff);
  // metody do rysowania (zaczynaja sie od ,,R'')
  void RObwodka(int x, int y, TKolor kolor);
  void RObwodka(int x, int y);
  void RSkasujObwodke(int x, int y);
  void RKropka(int x, int y, int czyja);
  void RKrzyzyk(int i, int j, TKolor kolor);
  void RKomentarz(int i, int j, TKomentarz kom);
  void RKreska(int x1, int y1, int x2, int y2, int czyja);
  void RKwadracik(char odtw[max_bok_planszy][max_bok_planszy], int x, int y, TKolor kolor);
  void RTrojkacik(char odtw[max_bok_planszy][max_bok_planszy], int x, int y, int nr, TKolor kolor);
  void RCieniowanie(int odswiez_kropki=1, int kasuj_cieniowanie=0);
  void RTekst(int);
  void RPlansza();
  void RWszystko();
  public:
  // glowna funkcja do rysowania
  void Rysuj(int);
  // do pokazywania tablicy
  void RysujObwodke(int, int);
  void RysujObwodke(int, int, TKolor kolor);
  void CzyscObwodke(int, int);
  void CzyscObwodki();
  // do komentarzy
  void ZerujKomentarze();
  void RysujKomentarze();
  // do pokazywania propozycji ruchu (analiza)
  void Obwodka(int i, int j, int co);
  // metody do ustawiania parametrow
  void UstawCieniowanie(int);
  void UstawWlkKropki(int);
  void UstawObwodkaOstKropka(int);
  void UstawKolory(TKolor*);
  void UstawKolory(int, TKolor);
  void UstawParW(short int*);
  void UstawParW(int, short int);
  void UstawOpcje(TElMenu*);
  // metody do pobierania parametrow
  int DajCieniowanie();
  int DajWlkKropki();
  int DajObwodkaOstKropka();
  int DajZdarzenie(TKlawisz k, TFlagi f, int x, int y, int &nx, int &ny);
  int DowiazOpcje(TElMenu *&wsk, int x1, int x2, int y, 
		  int wys_przyc, int odstep_przyc, int marg, TKolor*);
  // zerowanie tablic
  TRysujPlansze();
};

const char * TRysujPlansze::TOpcje::napisy[10] = {
  "$opcje.kropka0\0",
  "$opcje.kropka1\0", "$opcje.kropka2\0", "$opcje.kropka3\0",
  "$opcje.kropka4\0", "$opcje.kropka5\0", "$opcje.kropka6\0",
  "$opcje.WlkKr",
  "$opcje.cieniowanie\0", "$opcje.cieniowanie\0" };

void TRysujPlansze::UstawParamKratki()
{ // ustawia xkratki, ykratki, wlkkratki na podstawie parw i wlkx/y
 int szer_krtk = (parw[2]-parw[0]-2*parw[8]) / (gra.DWlkX()-1);
 int wys_krtk = (parw[3]-parw[1]-2*parw[8]) / (gra.DWlkY()-1);
 wlk_kratki = (szer_krtk < wys_krtk) ? szer_krtk : wys_krtk;
 int szer_efekt = wlk_kratki*(gra.DWlkX()-1)+1;
 pocz_x = parw[0]+(parw[2]-parw[0]-szer_efekt+1)/2;
 int wys_efekt = wlk_kratki*(gra.DWlkY()-1)+1;
 pocz_y = parw[1]+(parw[3]-parw[1]-wys_efekt+1)/2;
}

void TRysujPlansze::NarysujKropke(int x, int y, TKolor kolor)
// rysuje kropke w miejscu w wspolrzednych ekranowych (x,y)
{
 switch (wlk_kropki)
   {
   case 1:
     GrPlot(x,y,kolor);
     break;
   case 3:
     GrHLine(x-1, x+1, y-1, kolor);     GrHLine(x-1, x+1, y  , kolor);
     GrHLine(x-1, x+1, y+1, kolor);
     break;
   case 5:
     GrHLine(x-1, x+1, y-2, kolor);     GrHLine(x-2, x+2, y-1, kolor);
     GrHLine(x-2, x+2, y  , kolor);     GrHLine(x-2, x+2, y+1, kolor);
     GrHLine(x-1, x+1, y+2, kolor);
     break;
   case 7:
     GrHLine(x-1, x+1, y-3, kolor);     GrHLine(x-2, x+2, y-2, kolor);
     GrHLine(x-3, x+3, y-1, kolor);     GrHLine(x-3, x+3, y  , kolor);
     GrHLine(x-3, x+3, y+1, kolor);     GrHLine(x-2, x+2, y+2, kolor);
     GrHLine(x-1, x+1, y+3, kolor);
     break;
   case 9:
     GrHLine(x-2, x+2, y-4, kolor);     GrHLine(x-3, x+3, y-3, kolor);
     GrHLine(x-4, x+4, y-2, kolor);     GrHLine(x-4, x+4, y-1, kolor);
     GrHLine(x-4, x+4, y  , kolor);     GrHLine(x-4, x+4, y+1, kolor);
     GrHLine(x-4, x+4, y+2, kolor);     GrHLine(x-3, x+3, y+3, kolor);
     GrHLine(x-2, x+2, y+4, kolor);
     break;
   case 11: {
     GrHLine(x-2, x+2, y-5, kolor);     GrHLine(x-3, x+3, y-4, kolor);
     GrHLine(x-4, x+4, y-3, kolor);
     for (int i=-2; i<=2; i++) GrHLine(x-5, x+5, y+i, kolor);
     GrHLine(x-4, x+4, y+3, kolor);
     GrHLine(x-3, x+3, y+4, kolor);     GrHLine(x-2, x+2, y+5, kolor);
   }
     break;
   case 13: {
     GrHLine(x-2, x+2, y-6, kolor);     GrHLine(x-4, x+4, y-5, kolor);
     GrHLine(x-5, x+5, y-4, kolor);     GrHLine(x-5, x+5, y-3, kolor);
     for (int i=-2; i<=2; i++) GrHLine(x-6, x+6, y+i, kolor);
     GrHLine(x-5, x+5, y+3, kolor);     GrHLine(x-5, x+5, y+4, kolor);
     GrHLine(x-4, x+4, y+5, kolor);     GrHLine(x-2, x+2, y+6, kolor);
   }
     break;

   }
}

// kierunki:
//
//    \ NW | NE /
//     \   |   /
//  WN  \  |  /   EN
//  ----------------
//  WS  /  |  \   ES
//     /   |   \
//    / SW | SE \
//
#define OBW_NE  1
#define OBW_NW  2
#define OBW_EN  4
#define OBW_ES  8
#define OBW_SE  16
#define OBW_SW  32
#define OBW_WN  64
#define OBW_WS  128
#define OBW_N  (OBW_NE | OBW_NW)
#define OBW_W  (OBW_WN | OBW_WS)
#define OBW_S  (OBW_SE | OBW_SW)
#define OBW_E  (OBW_ES | OBW_EN)
#define OBW_rNE (OBW_NE | OBW_EN)
#define OBW_rNW (OBW_NW | OBW_WN)
#define OBW_rSE (OBW_SE | OBW_ES)
#define OBW_rSW (OBW_SW | OBW_WS)


void TRysujPlansze::NarysujObwodke(int x, int y, TKolor kolor, int maska)
// rysuje obwodke w miejscu w wspolrzednych ekranowych (x,y)
//  (maska & OBW_?): czy rysowac w kierunku ? (?=N,E,S,W)
{
 switch (wlk_kropki)
   {
   case 1:
     if ((maska & OBW_N)==OBW_N)  GrPlot(x  ,y-1,kolor);
     if ((maska & OBW_E)==OBW_E)  GrPlot(x+1,y  ,kolor);
     if ((maska & OBW_S)==OBW_S)  GrPlot(x  ,y+1,kolor);
     if ((maska & OBW_W)==OBW_W)  GrPlot(x-1,y  ,kolor);
     if ((maska & OBW_rNE)==OBW_rNE)  GrPlot(x+1,y-1,kolor);
     if ((maska & OBW_rNW)==OBW_rNW)  GrPlot(x-1,y-1,kolor);
     if ((maska & OBW_rSE)==OBW_rSE)  GrPlot(x+1,y+1,kolor);
     if ((maska & OBW_rSW)==OBW_rSW)  GrPlot(x-1,y+1,kolor);
     break;
   case 3:
     if (maska!=0xff) {
       if ((maska & OBW_N)==OBW_N)  GrPlot(x  ,y-2,kolor);
       if ((maska & OBW_E)==OBW_E)  GrPlot(x+2,y  ,kolor);
       if ((maska & OBW_S)==OBW_S)  GrPlot(x  ,y+2,kolor);
       if ((maska & OBW_W)==OBW_W)  GrPlot(x-2,y  ,kolor);
       if (maska & OBW_NW)  GrPlot(x-1,y-2,kolor);
       if (maska & OBW_NE)  GrPlot(x+1,y-2,kolor);
       if (maska & OBW_SW)  GrPlot(x-1,y+2,kolor);
       if (maska & OBW_SE)  GrPlot(x+1,y+2,kolor);
       if (maska & OBW_EN)  GrPlot(x+2,y-1,kolor);
       if (maska & OBW_ES)  GrPlot(x+2,y+1,kolor);
       if (maska & OBW_WN)  GrPlot(x-2,y-1,kolor);
       if (maska & OBW_WS)  GrPlot(x-2,y+1,kolor);
     }
     else {
     for (int i=-1; i<=1; i++)  {
       GrPlot(x+i, y-2, kolor);       
       GrPlot(x+2, y+i, kolor);
       GrPlot(x+i, y+2, kolor);
       GrPlot(x-2, y+i, kolor);       
       }
     }
     break;
   case 5:
     if (maska!=0xff) {
       if ((maska & OBW_N)==OBW_N)  GrPlot(x  ,y-3,kolor);
       if ((maska & OBW_E)==OBW_E)  GrPlot(x+3,y  ,kolor);
       if ((maska & OBW_S)==OBW_S)  GrPlot(x  ,y+3,kolor);
       if ((maska & OBW_W)==OBW_W)  GrPlot(x-3,y  ,kolor);
       if ((maska & OBW_rNE)==OBW_rNE)  GrPlot(x+2,y-2,kolor);
       if ((maska & OBW_rNW)==OBW_rNW)  GrPlot(x-2,y-2,kolor);
       if ((maska & OBW_rSE)==OBW_rSE)  GrPlot(x+2,y+2,kolor);
       if ((maska & OBW_rSW)==OBW_rSW)  GrPlot(x-2,y+2,kolor);
       if (maska & OBW_NW)  GrPlot(x-1,y-3,kolor);
       if (maska & OBW_NE)  GrPlot(x+1,y-3,kolor);
       if (maska & OBW_SW)  GrPlot(x-1,y+3,kolor);
       if (maska & OBW_SE)  GrPlot(x+1,y+3,kolor);
       if (maska & OBW_EN)  GrPlot(x+3,y-1,kolor);
       if (maska & OBW_ES)  GrPlot(x+3,y+1,kolor);
       if (maska & OBW_WN)  GrPlot(x-3,y-1,kolor);
       if (maska & OBW_WS)  GrPlot(x-3,y+1,kolor);
     }
     else {
       for (int i=-1; i<=1; i++) {
	 GrPlot(x+i, y-3, kolor);
	 GrPlot(x+3, y+i, kolor);
	 GrPlot(x+i, y+3, kolor);
	 GrPlot(x-3, y+i, kolor);
       }
     GrPlot(x-2, y-2, kolor);
     GrPlot(x-2, y+2, kolor);
     GrPlot(x+2, y-2, kolor);       
     GrPlot(x+2, y+2, kolor);
     }
     break;
   case 7:
     if (maska!=0xff) {
       if ((maska & OBW_N)==OBW_N)  GrPlot(x  ,y-4,kolor);
       if ((maska & OBW_E)==OBW_E)  GrPlot(x+4,y  ,kolor);
       if ((maska & OBW_S)==OBW_S)  GrPlot(x  ,y+4,kolor);
       if ((maska & OBW_W)==OBW_W)  GrPlot(x-4,y  ,kolor);
       if ((maska & OBW_rNE)==OBW_rNE)  GrPlot(x+3,y-3,kolor);
       if ((maska & OBW_rNW)==OBW_rNW)  GrPlot(x-3,y-3,kolor);
       if ((maska & OBW_rSE)==OBW_rSE)  GrPlot(x+3,y+3,kolor);
       if ((maska & OBW_rSW)==OBW_rSW)  GrPlot(x-3,y+3,kolor);
       if (maska & OBW_NW) { GrPlot(x-1,y-4,kolor); GrPlot(x-2,y-3,kolor); GrPlot(x-2,y-4,kolor); }
       if (maska & OBW_NE) { GrPlot(x+1,y-4,kolor); GrPlot(x+2,y-3,kolor); GrPlot(x+2,y-4,kolor); }
       if (maska & OBW_SW) { GrPlot(x-1,y+4,kolor); GrPlot(x-2,y+3,kolor); GrPlot(x-2,y+4,kolor); }
       if (maska & OBW_SE) { GrPlot(x+1,y+4,kolor); GrPlot(x+2,y+3,kolor); GrPlot(x+2,y+4,kolor); }
       if (maska & OBW_EN) { GrPlot(x+4,y-1,kolor); GrPlot(x+3,y-2,kolor); GrPlot(x+4,y-2,kolor); }
       if (maska & OBW_ES) { GrPlot(x+4,y+1,kolor); GrPlot(x+3,y+2,kolor); GrPlot(x+4,y+2,kolor); }
       if (maska & OBW_WN) { GrPlot(x-4,y-1,kolor); GrPlot(x-3,y-2,kolor); GrPlot(x-4,y-2,kolor); }
       if (maska & OBW_WS) { GrPlot(x-4,y+1,kolor); GrPlot(x-3,y+2,kolor); GrPlot(x-4,y+2,kolor); }
     }
     else {
       GrHLine(x-2,x+2,y-4, kolor);  GrHLine(x-2,x+2, y+4, kolor);
       GrVLine(x-4,y-2,y+2, kolor);  GrVLine(x+4,y-2,y+2, kolor);
       GrPlot(x-2, y-3, kolor);     GrPlot(x+2, y-3, kolor);
       GrPlot(x+3, y-2, kolor);     GrPlot(x+3, y+2, kolor);
       GrPlot(x-2, y+3, kolor);     GrPlot(x+2, y+3, kolor);
       GrPlot(x-3, y-2, kolor);     GrPlot(x-3, y+2, kolor);
       GrPlot(x-3, y-3, kolor);     GrPlot(x-3, y+3, kolor);
       GrPlot(x+3, y-3, kolor);     GrPlot(x+3, y+3, kolor);
     }
     break;
   case 9:
     if (maska!=0xff) {
       if ((maska & OBW_N)==OBW_N)  GrPlot(x  ,y-5,kolor);
       if ((maska & OBW_E)==OBW_E)  GrPlot(x+5,y  ,kolor);
       if ((maska & OBW_S)==OBW_S)  GrPlot(x  ,y+5,kolor);
       if ((maska & OBW_W)==OBW_W)  GrPlot(x-5,y  ,kolor);
       if (maska & OBW_NW) { GrPlot(x-1,y-5,kolor); GrPlot(x-2,y-5,kolor); GrPlot(x-3,y-4,kolor); }
       if (maska & OBW_NE) { GrPlot(x+1,y-5,kolor); GrPlot(x+2,y-5,kolor); GrPlot(x+3,y-4,kolor); }
       if (maska & OBW_SW) { GrPlot(x-1,y+5,kolor); GrPlot(x-2,y+5,kolor); GrPlot(x-3,y+4,kolor); }
       if (maska & OBW_SE) { GrPlot(x+1,y+5,kolor); GrPlot(x+2,y+5,kolor); GrPlot(x+3,y+4,kolor); }
       if (maska & OBW_EN) { GrPlot(x+5,y-1,kolor); GrPlot(x+5,y-2,kolor); GrPlot(x+4,y-3,kolor); }
       if (maska & OBW_ES) { GrPlot(x+5,y+1,kolor); GrPlot(x+5,y+2,kolor); GrPlot(x+4,y+3,kolor); }
       if (maska & OBW_WN) { GrPlot(x-5,y-1,kolor); GrPlot(x-5,y-2,kolor); GrPlot(x-4,y-3,kolor); }
       if (maska & OBW_WS) { GrPlot(x-5,y+1,kolor); GrPlot(x-5,y+2,kolor); GrPlot(x-4,y+3,kolor); }
     }
     else {
       GrHLine(x-2, x+2, y-5, kolor); 
       GrHLine(x-2, x+2, y+5, kolor);
       GrVLine(x+5, y-2, y+2, kolor);
       GrVLine(x-5, y-2, y+2, kolor);       
       GrPlot(x-3, y-4, kolor);  GrPlot(x+3, y-4, kolor);
       GrPlot(x+4, y-3, kolor);  GrPlot(x+4, y+3, kolor); 
       GrPlot(x-3, y+4, kolor);  GrPlot(x+3, y+4, kolor);
       GrPlot(x-4, y-3, kolor);  GrPlot(x-4, y+3, kolor);       
     }
     break;
   case 11:
     if (maska!=0xff) {
       if ((maska & OBW_N)==OBW_N)  GrPlot(x  ,y-6,kolor);
       if ((maska & OBW_E)==OBW_E)  GrPlot(x+6,y  ,kolor);
       if ((maska & OBW_S)==OBW_S)  GrPlot(x  ,y+6,kolor);
       if ((maska & OBW_W)==OBW_W)  GrPlot(x-6,y  ,kolor);
       if (maska & OBW_NW) { GrPlot(x-1,y-6,kolor); GrPlot(x-2,y-6,kolor); GrPlot(x-3,y-5,kolor); }
       if (maska & OBW_NE) { GrPlot(x+1,y-6,kolor); GrPlot(x+2,y-6,kolor); GrPlot(x+3,y-5,kolor); }
       if (maska & OBW_SW) { GrPlot(x-1,y+6,kolor); GrPlot(x-2,y+6,kolor); GrPlot(x-3,y+5,kolor); }
       if (maska & OBW_SE) { GrPlot(x+1,y+6,kolor); GrPlot(x+2,y+6,kolor); GrPlot(x+3,y+5,kolor); }
       if (maska & OBW_EN) { GrPlot(x+6,y-1,kolor); GrPlot(x+6,y-2,kolor); GrPlot(x+5,y-3,kolor); }
       if (maska & OBW_ES) { GrPlot(x+6,y+1,kolor); GrPlot(x+6,y+2,kolor); GrPlot(x+5,y+3,kolor); }
       if (maska & OBW_WN) { GrPlot(x-6,y-1,kolor); GrPlot(x-6,y-2,kolor); GrPlot(x-5,y-3,kolor); }
       if (maska & OBW_WS) { GrPlot(x-6,y+1,kolor); GrPlot(x-6,y+2,kolor); GrPlot(x-5,y+3,kolor); }
       if ((maska & OBW_rNE)==OBW_rNE)  GrPlot(x+4,y-4,kolor);
       if ((maska & OBW_rNW)==OBW_rNW)  GrPlot(x-4,y-4,kolor);
       if ((maska & OBW_rSE)==OBW_rSE)  GrPlot(x+4,y+4,kolor);
       if ((maska & OBW_rSW)==OBW_rSW)  GrPlot(x-4,y+4,kolor);
     }
     else {
       GrHLine(x-2, x+2, y-6, kolor); 
       GrHLine(x-2, x+2, y+6, kolor);
       GrVLine(x+6, y-2, y+2, kolor);
       GrVLine(x-6, y-2, y+2, kolor);       
       GrPlot(x-3, y-5, kolor);  GrPlot(x+3, y-5, kolor);
       GrPlot(x+5, y-3, kolor);  GrPlot(x+5, y+3, kolor); 
       GrPlot(x-3, y+5, kolor);  GrPlot(x+3, y+5, kolor);
       GrPlot(x-5, y-3, kolor);  GrPlot(x-5, y+3, kolor);     
       GrPlot(x+4,y-4,kolor);    GrPlot(x+4,y+4,kolor);
       GrPlot(x-4,y-4,kolor);    GrPlot(x-4,y+4,kolor);

       GrPlot(x-4,y-5,kolor);    GrPlot(x-5,y-4,kolor);
       GrPlot(x+4,y-5,kolor);    GrPlot(x+5,y-4,kolor);
       GrPlot(x-4,y+5,kolor);    GrPlot(x-5,y+4,kolor);
       GrPlot(x+4,y+5,kolor);    GrPlot(x+5,y+4,kolor);
     }
     break;
   case 13:
     if (maska!=0xff) {
       if ((maska & OBW_N)==OBW_N)  GrPlot(x  ,y-7,kolor);
       if ((maska & OBW_E)==OBW_E)  GrPlot(x+7,y  ,kolor);
       if ((maska & OBW_S)==OBW_S)  GrPlot(x  ,y+7,kolor);
       if ((maska & OBW_W)==OBW_W)  GrPlot(x-7,y  ,kolor);
       if (maska & OBW_NW)
	 { GrPlot(x-1,y-7,kolor); GrPlot(x-2,y-7,kolor); 
	   GrPlot(x-3,y-6,kolor); GrPlot(x-4,y-6,kolor); }
       if (maska & OBW_NE)
	 { GrPlot(x+1,y-7,kolor); GrPlot(x+2,y-7,kolor);
	   GrPlot(x+3,y-6,kolor); GrPlot(x+4,y-6,kolor); }
       if (maska & OBW_SW)
	 { GrPlot(x-1,y+7,kolor); GrPlot(x-2,y+7,kolor);
	   GrPlot(x-3,y+6,kolor); GrPlot(x-4,y+6,kolor); }
       if (maska & OBW_SE)
	 { GrPlot(x+1,y+7,kolor); GrPlot(x+2,y+7,kolor);
	   GrPlot(x+3,y+6,kolor); GrPlot(x+4,y+6,kolor); }
       if (maska & OBW_EN)
	 { GrPlot(x+7,y-1,kolor); GrPlot(x+7,y-2,kolor);
	   GrPlot(x+6,y-3,kolor); GrPlot(x+6,y-4,kolor); }
       if (maska & OBW_ES)
	 { GrPlot(x+7,y+1,kolor); GrPlot(x+7,y+2,kolor);
	   GrPlot(x+6,y+3,kolor); GrPlot(x+6,y+4,kolor); }
       if (maska & OBW_WN)
	 { GrPlot(x-7,y-1,kolor); GrPlot(x-7,y-2,kolor);
	   GrPlot(x-6,y-3,kolor); GrPlot(x-6,y-4,kolor); }
       if (maska & OBW_WS)
	 { GrPlot(x-7,y+1,kolor); GrPlot(x-7,y+2,kolor);
	   GrPlot(x-6,y+3,kolor); GrPlot(x-6,y+4,kolor); }
       if ((maska & OBW_rNE)==OBW_rNE)  GrPlot(x+5,y-5,kolor);
       if ((maska & OBW_rNW)==OBW_rNW)  GrPlot(x-5,y-5,kolor);
       if ((maska & OBW_rSE)==OBW_rSE)  GrPlot(x+5,y+5,kolor);
       if ((maska & OBW_rSW)==OBW_rSW)  GrPlot(x-5,y+5,kolor);
     }
     else {
       GrHLine(x-2, x+2, y-7, kolor); 
       GrHLine(x-2, x+2, y+7, kolor);
       GrVLine(x+7, y-2, y+2, kolor);
       GrVLine(x-7, y-2, y+2, kolor);       
       GrPlot(x-3, y-6, kolor);  GrPlot(x+3, y-6, kolor);
       GrPlot(x+6, y-3, kolor);  GrPlot(x+6, y+3, kolor); 
       GrPlot(x-3, y+6, kolor);  GrPlot(x+3, y+6, kolor);
       GrPlot(x-6, y-3, kolor);  GrPlot(x-6, y+3, kolor);     
       GrPlot(x-4, y-6, kolor);  GrPlot(x+4, y-6, kolor);
       GrPlot(x+6, y-4, kolor);  GrPlot(x+6, y+4, kolor); 
       GrPlot(x-4, y+6, kolor);  GrPlot(x+4, y+6, kolor);
       GrPlot(x-6, y-4, kolor);  GrPlot(x-6, y+4, kolor);     
       GrPlot(x+5,y-5,kolor);    GrPlot(x+5,y+5,kolor);
       GrPlot(x-5,y-5,kolor);    GrPlot(x-5,y+5,kolor);
     }
     break;

   }
}

inline void TRysujPlansze::RObwodka(int x, int y, TKolor kolor)
// x,y -- wspolrzedne obwodki
{ NarysujObwodke(pocz_x + x*wlk_kratki, pocz_y + y*wlk_kratki, kolor); }

inline void TRysujPlansze::RObwodka(int x, int y)
// x,y -- wspolrzedne obwodki
{ NarysujObwodke(pocz_x + x*wlk_kratki, pocz_y + y*wlk_kratki, kolory[8]); }

void TRysujPlansze::RSkasujObwodke(int x, int y)
{
 if (cieniowanie)
   if (gra.DPlanszP(x,y) & 3)
     NarysujObwodke(pocz_x + x*wlk_kratki, pocz_y + y*wlk_kratki, 
		    kolory[5+(gra.DPlanszP(x,y) & 3)]);
   else {
     int maskac = 0;
     if (y>0 && (gra.DPlanszP(x,y-1) & 3)) {
       maskac |= OBW_N;
       if (x>0 && (gra.DPlanszP(x-1,y-1) & 3)) maskac |= OBW_WN;
       if (x+1<gra.DWlkX() && (gra.DPlanszP(x+1,y-1) & 3)) maskac |= OBW_EN;
     }
     if (x+1<gra.DWlkX() && (gra.DPlanszP(x+1,y) & 3)) {
       maskac |= OBW_E;
       if (y>0 && (gra.DPlanszP(x+1,y-1) & 3)) maskac |= OBW_NE;
       if (y+1<gra.DWlkY() && (gra.DPlanszP(x+1,y+1) & 3)) maskac |= OBW_SE;
     }
     if (y+1<gra.DWlkY() && (gra.DPlanszP(x,y+1) & 3)) {
       maskac |= OBW_S;
       if (x>0 && (gra.DPlanszP(x-1,y+1) & 3)) maskac |= OBW_WS;
       if (x+1<gra.DWlkX() && (gra.DPlanszP(x+1,y+1) & 3)) maskac |= OBW_ES;
     }
     if (x>0 && (gra.DPlanszP(x-1,y) & 3)) {
       maskac |= OBW_W;
       if (y>0 && (gra.DPlanszP(x-1,y-1) & 3)) maskac |= OBW_NW;
       if (y+1<gra.DWlkY() && (gra.DPlanszP(x-1,y+1) & 3)) maskac |= OBW_SW;
     }
     if (maskac) {
       // obok pola (x,y) jest stop, ale na polu (x,y) nie ma -- musi byc tu wiec kropka
       int kto = gra.DKropka(x,y);
       NarysujObwodke(pocz_x + x*wlk_kratki, pocz_y + y*wlk_kratki, 
		      kolory[5+kto], maskac);
       NarysujObwodke(pocz_x + x*wlk_kratki, pocz_y + y*wlk_kratki, 
		      kolory[0],  (maskac ^ 0xff) );
     }
     else
       NarysujObwodke(pocz_x + x*wlk_kratki, pocz_y + y*wlk_kratki, kolory[0]);
   }
 else
   NarysujObwodke(pocz_x + x*wlk_kratki, pocz_y + y*wlk_kratki, kolory[0]);
 int w_bok = wlk_kropki/2 +1, na_ukos;
 TKolor kolor = kolory[3+gra.DKropka(x,y)];  // gdy (x,y) jest puste, to to bez znaczenia
 switch (wlk_kropki)
   {
   case 1: na_ukos=1; break;
   case 5: na_ukos=2; break;
   case 7: na_ukos=3; break;
   case 11: na_ukos=4; break;
   case 13: na_ukos=5; break;
   default:na_ukos=0; break;  // nie ma w obwodce kropki na ukos
   }
 for (int dx=-1; dx<=1; dx++)
 for (int dy=-1; dy<=1; dy++)
  if ((dx || dy) && (x+dx>=0 && x+dx<gra.DWlkX() && y+dy>=0 && y+dy<gra.DWlkY()))
   {
   if (dx==0 || dy==0)
     GrPlot(pocz_x + x*wlk_kratki+dx*w_bok, pocz_y + y*wlk_kratki+dy*w_bok,
            gra.DKreska(x,y, x+dx,y+dy) ? kolor : kolory[1]);
   else  // na ukos
   if (na_ukos && gra.DKreska(x,y, x+dx,y+dy))
     GrPlot(pocz_x + x*wlk_kratki+dx*na_ukos, pocz_y + y*wlk_kratki+dy*na_ukos,
            kolor);
   }
}

inline void TRysujPlansze::RKropka(int x, int y, int czyja)
// x,y -- wspolrzedne kropki, czyja==1 lub 2; albo 0, wtedy nie rysuje nic
{ 
  if (czyja)
    NarysujKropke(pocz_x + x*wlk_kratki, pocz_y + y*wlk_kratki, kolory[3+czyja]);
}

inline void TRysujPlansze::RKreska(int x1, int y1, int x2, int y2, int czyja)
{
 GrLine(pocz_x + x1*wlk_kratki, pocz_y + y1*wlk_kratki,
        pocz_x + x2*wlk_kratki, pocz_y + y2*wlk_kratki, kolory[3+czyja]);
}

void TRysujPlansze::RKrzyzyk(int i, int j, TKolor kolor)
// x,y -- wspolrzedne pola
{ 
  int x= pocz_x + i*wlk_kratki, y= pocz_y + j*wlk_kratki;
  GrLine(x-wlk_kratki/3, y-wlk_kratki/3, x+wlk_kratki/3, y+wlk_kratki/3, kolor);
  GrLine(x-wlk_kratki/3, y+wlk_kratki/3, x+wlk_kratki/3, y-wlk_kratki/3, kolor);
}

void TRysujPlansze::RKwadracik(char odtw[max_bok_planszy][max_bok_planszy],
			       int x, int y, TKolor kolor)
// rysuje kwadracik lub dwa trojkaciki (gdy jest kreska na przekatnej)
// kwadracik ma przeciwlegle wierzcholki (x,y) oraz (x+1,y+1)
{
  if (gra.DKreska(x,y, x+1,y+1)) {
    RTrojkacik(odtw, x,y, 1, kolor);
    RTrojkacik(odtw, x,y, 2, kolor);
  }
  else if (gra.DKreska(x+1,y, x,y+1)) {
    RTrojkacik(odtw, x,y, 0, kolor);
    RTrojkacik(odtw, x,y, 3, kolor);
  }
  else {
    // rysuj pelny kwadracik
    GrFilledBox(pocz_x +     x*wlk_kratki +1, pocz_y +     y*wlk_kratki +1,
		pocz_x + (x+1)*wlk_kratki   , pocz_y + (y+1)*wlk_kratki   , kolor);
    odtw[x][y]=1;  odtw[x][y+1]=1;  odtw[x+1][y]=1;  odtw[x+1][y+1]=1;
  }
}

void TRysujPlansze::RTrojkacik(char odtw[max_bok_planszy][max_bok_planszy],
			       int x, int y, int nr, TKolor kolor)
// (x,y), (x+1,y+1) -- przeciwlegle wierzcholki kwadraciku zawierajego rysowany trojkat
// nr == 0: kat prosty jest w rogu (x,y) kwadratu
//    == 1: kat prosty jest w rogu (x+1,y) kwadratu
//    == 2: kat prosty jest w rogu (x,y+1) kwadratu
//    == 3: kat prosty jest w rogu (x+1,y+1) kwadratu
{
  switch (nr) {
  case 0:
    GrFilledTrojkat(pocz_x + x*wlk_kratki +1,   pocz_y + y*wlk_kratki +1,
		    pocz_x + (x+1)*wlk_kratki-1,   pocz_y + y*wlk_kratki +1,
		    pocz_x + x*wlk_kratki +1,   pocz_y + (y+1)*wlk_kratki-1, kolor);
    odtw[x][y]=1;  odtw[x+1][y]=1;  odtw[x][y+1]=1;
    break;
  case 1:
    GrFilledTrojkat(pocz_x + x*wlk_kratki +1,   pocz_y + y*wlk_kratki +1,
		    pocz_x + (x+1)*wlk_kratki,   pocz_y + y*wlk_kratki +1,
		    pocz_x + (x+1)*wlk_kratki,   pocz_y + (y+1)*wlk_kratki-1, kolor);
		    
    odtw[x][y]=1;  odtw[x+1][y]=1;  odtw[x+1][y+1]=1;
    break;
  case 2:
    GrFilledTrojkat(pocz_x + x*wlk_kratki +1,   pocz_y + y*wlk_kratki +1,
		    pocz_x + x*wlk_kratki +1,   pocz_y + (y+1)*wlk_kratki,
		    pocz_x + (x+1)*wlk_kratki,   pocz_y + (y+1)*wlk_kratki, kolor);
    odtw[x][y]=1;  odtw[x][y+1]=1;  odtw[x+1][y+1]=1;
    break;
  case 3:
    GrFilledTrojkat(pocz_x + (x+1)*wlk_kratki,   pocz_y + y*wlk_kratki +1,
		    pocz_x + x*wlk_kratki +1,   pocz_y + (y+1)*wlk_kratki,
		    pocz_x + (x+1)*wlk_kratki,   pocz_y + (y+1)*wlk_kratki, kolor);
    odtw[x+1][y]=1;  odtw[x][y+1]=1;  odtw[x+1][y+1]=1;
    break;
  }
}

void TRysujPlansze::RCieniowanie(int odswiez_kropki, int kasuj_cieniowanie)
// wyswietla/kasuje cieniowanie
{ if (cieniowanie || kasuj_cieniowanie)
 {
 TKolor kol[2];
 kol[0] = kasuj_cieniowanie ? kolory[0] : kolory[6];   // [0]=kolor tla,
 kol[1] = kasuj_cieniowanie ? kolory[0] : kolory[7];   //     kasuje cieniowanie
 // cieniuj uzywajac kol[0] dla 1. gracza i kol[1] dla drugiego
 char odtw[max_bok_planszy][max_bok_planszy];
 memset(odtw, 0, sizeof(odtw));
 int di[4] = {0,1,0,1};   // wazna
 int dj[4] = {0,0,1,1};   // kolejnosc
 for (int i=0; i<gra.DWlkX()-1; i++)
   for (int j=0; j<gra.DWlkY()-1; j++) {
     // rozwazamy kwadrat o przeciwleglych wierzcholkach (i,j) oraz (i+1,j+1)
     int ile=0, czyj, nr;
     for (int k=0; k<4; k++)
       if (gra.DPlanszP(i+di[k], j+dj[k]) & 3) {
	 czyj = gra.DPlanszP(i+di[k], j+dj[k]) & 3;
	 nr = k;
	 ile++;
       }
     if (ile>=2) RKwadracik(odtw, i,j, kol[czyj-1]);
     else if (ile==1) RTrojkacik(odtw, i,j, nr, kol[czyj-1]);
   }
 if (odswiez_kropki)  // odtworz zamazane kropki:
   for (int i=0; i<gra.DWlkX(); i++)
     for (int j=0; j<gra.DWlkY(); j++)
       if (odtw[i][j]) RKropka(i, j, gra.DKropka(i,j));
 }
}

void TRysujPlansze::RTekst(int co)
{
 char s[30];
 if (co==WS_NOWAPLANSZA)
   {
   GrFilledBox(parw[4], parw[5], parw[6], parw[7], kolory[2]);
   sprintf(s,"%dx%d",int(gra.DWlkX()),int(gra.DWlkY()));
   Wypisz(parw[6]-SZER_FONTU/2, (parw[5]+parw[7])/2, s,
             kolory[3], kolory[2], KR_ALIGN_RIGHT);
   }
 else
   GrFilledBox(parw[4], parw[5], parw[4]+SZER_FONTU*6, parw[7], kolory[2]);
 sprintf(s,"%d",int(gra.DIleKropek()));
 Wypisz(parw[4]+SZER_FONTU/2, (parw[5]+parw[7])/2, s,
           kolory[3], kolory[2], KR_ALIGN_LEFT);
}

void TRysujPlansze::RPlansza()
{
 // tlo
 GrFilledBox(parw[0], parw[1], parw[2], parw[3], kolory[0]);
 // wyswietl linie pionowe i wspolrzedne A,B,...
 int margwsp = std::min(wlk_kratki/2, 7);  // 6=max wlk polowy kropki
 {
 int wx=pocz_x;
 int ky=pocz_y+wlk_kratki*(gra.DWlkY()-1);
 for (int i=0; i<gra.DWlkX(); i++) {
   GrVLine(wx,pocz_y, ky, kolory[1]);
   char tekst_wsp[2]; tekst_wsp[1]=0; tekst_wsp[0]=(i<26) ? ('a'+i) : ('A'+i-26);
   Wypisz(wx, pocz_y-margwsp, tekst_wsp, kolory[9],
	  kolory[0], KR_ALIGN_CENTERBOTTOM);
   Wypisz(wx, ky+margwsp, tekst_wsp, kolory[9],
	  kolory[0], KR_ALIGN_CENTERTOP);
   wx+=wlk_kratki;
   }
 }
 // wyswietl linie poziome i wspolrzedne 1,2,...
 {
 int wy=pocz_y;
 int kx=pocz_x+wlk_kratki*(gra.DWlkX()-1);
 for (int i=0; i<gra.DWlkY(); i++)
  {
  GrHLine(pocz_x, kx, wy, kolory[1]);
  char tekst_wsp[3]; 
  sprintf(tekst_wsp, "%d", int(gra.DWlkY()-i));
  Wypisz(pocz_x-margwsp, wy, tekst_wsp, kolory[9],
	 kolory[0], KR_ALIGN_RIGHT);
  Wypisz(kx+margwsp, wy, tekst_wsp, kolory[9],
	 kolory[0], KR_ALIGN_LEFT);
  wy+=wlk_kratki;
  }
 }
 // wyswietl cieniowanie
 RCieniowanie(0);
 // wyswietl kropki
 {
 for (int i=0; i<gra.DWlkX(); i++)
  for (int j=0; j<gra.DWlkY(); j++)
   {
   unsigned char r=gra.DKropka(i,j);
   RKropka(i,j,r);
   // wyswietl kreski stopow
   if (gra.DKreska(i,j))
     {
     // sprawdz polaczenia w prawo:
     for (int dy=-1; dy<=1; dy++)
       if (gra.DKreska(i,j,i+1,j+dy))
      RKreska(i,j,i+1,j+dy,r);
     // sprawdz polaczenie w dol:
     if (gra.DKreska(i,j,i,j+1))
       RKreska(i,j,i,j+1,r);
     }
   }
 }
 // wyswietl obwodke
 if (pokazuj_ost)
   {
   ost_kr_x = gra.DOstKropkaX();
   ost_kr_y = gra.DOstKropkaY();
   if (ost_kr_x>=0) RObwodka(ost_kr_x, ost_kr_y);
   }
 else { ost_kr_x=ost_kr_y=-1; }
 // i komentarze
 RysujKomentarze();
}

inline void TRysujPlansze::RWszystko()
{ RPlansza();  RTekst(WS_NOWAPLANSZA); }

inline void TRysujPlansze::UstawCieniowanie(int nc)
{ cieniowanie = nc; }
inline void TRysujPlansze::UstawWlkKropki(int nwlk)
{ if ((nwlk & 1) && nwlk>=1 && nwlk<=13) wlk_kropki = nwlk; }

void TRysujPlansze::UstawObwodkaOstKropka(int npok)
{
 if (npok==pokazuj_ost) return;  // nic sie nie zmienia
 if (npok)  // wlacz
   {
   pokazuj_ost=1;
   ost_kr_x = gra.DOstKropkaX();
   ost_kr_y = gra.DOstKropkaY();
   if (ost_kr_x>=0) RObwodka(ost_kr_x, ost_kr_y);
   }
 else
   {
   pokazuj_ost=0;
   if (ost_kr_x>=0) RSkasujObwodke(ost_kr_x, ost_kr_y);
   ost_kr_x = -1;   ost_kr_y = -1;
   }

}

void TRysujPlansze::UstawKolory(TKolor* nk)
{ for (int i=0; i<sizeof(kolory)/sizeof(kolory[0]); i++) kolory[i]=nk[i]; }

void TRysujPlansze::UstawParW(short int* nw)
{ for (int i=0; i<sizeof(parw)/sizeof(parw[0]); i++) kolory[i]=nw[i]; }

inline void TRysujPlansze::UstawKolory(int nr, TKolor nk)
{ kolory[nr]=nk; }

inline void TRysujPlansze::UstawParW(int nr, short int nw)
{ parw[nr]=nw; }

inline int TRysujPlansze::DajCieniowanie()
{ return cieniowanie; }

inline int TRysujPlansze::DajWlkKropki()
{ return wlk_kropki; }

inline int TRysujPlansze::DajObwodkaOstKropka()
{ return pokazuj_ost; }

void TRysujPlansze::RysujObwodke(int i, int j)
{ if (pokazuj_ost==1)
    {
    if (ost_kr_x>=0) RSkasujObwodke(ost_kr_x, ost_kr_y);
    pokazuj_ost=-1;
    }
 RObwodka(i,j);
}

void TRysujPlansze::RysujObwodke(int i, int j, TKolor kolor)
{ if (pokazuj_ost==1)
    {
    if (ost_kr_x>=0) RSkasujObwodke(ost_kr_x, ost_kr_y);
    pokazuj_ost=-1;
    }
 RObwodka(i,j, kolor);
}

void TRysujPlansze::CzyscObwodke(int i, int j)
{ if (pokazuj_ost==1)
    {
    if (ost_kr_x>=0) RSkasujObwodke(ost_kr_x, ost_kr_y);
    pokazuj_ost=-1;
    }
 RSkasujObwodke(i,j);
}

void TRysujPlansze::CzyscObwodki()
{
 for (int i=0; i<gra.DWlkX(); i++)
  for (int j=0; j<gra.DWlkY(); j++)
   RSkasujObwodke(i,j);
 if (pokazuj_ost==-1)
   {
   if (ost_kr_x>=0) RObwodka(ost_kr_x, ost_kr_y);
   pokazuj_ost=1;
   }
}

void TRysujPlansze::ZerujKomentarze()
{
  memset(komentarze, 0, sizeof(komentarze));
  RPlansza();   // czysci tlo przy okazji
}

void TRysujPlansze::RKomentarz(int i, int j, TKomentarz kom)
{
  switch (kom.rodzaj) {
  case 0: return;
  case 1: // tekst
    if (kom.tekst[0])
      outtextxy(pocz_x + i*wlk_kratki, pocz_y + j*wlk_kratki,
		kom.tekst, kolory[9], kolory[0], KR_ALIGN_CENTER);
    break;
  case 2:
    RKrzyzyk(i,j,kolory[9]);
    break;
  case 3:
    RObwodka(i,j,kolory[9]);
    break;
  }
}

void TRysujPlansze::RysujKomentarze()
{
  for (int i=0; i<gra.DWlkX(); i++)
  for (int j=0; j<gra.DWlkY(); j++)
    RKomentarz(i,j,komentarze[i][j]);
}

void TRysujPlansze::Obwodka(int i, int j, int co)
{
  if (co==0) {
    if (pokazuj_ost!=1 || i!=ost_kr_x || j!=ost_kr_y)
      RSkasujObwodke(i,j);
  }
  else RObwodka(i,j);
}

void TRysujPlansze::Rysuj(int co)
{
 switch (co)
   {
   case WS_NOWAPLANSZA:
     UstawParamKratki();
     // bez break'a
   case WS_CALAPLANSZA:
     RWszystko();
     break;
   case WS_STOP:
     // rysuj wszystkie kreski stopow
     {
     for (int i=0; i<gra.DWlkX(); i++)
      for (int j=0; j<gra.DWlkY(); j++)
       {
       if (gra.DKreska(i,j))
         {
         unsigned char r=gra.DKropka(i,j);
         // sprawdz polaczenia w prawo:
         for (int dy=-1; dy<=1; dy++)
           if (gra.DKreska(i,j,i+1,j+dy))
            RKreska(i,j,i+1,j+dy,r);
         // sprawdz polaczenie w dol:
         if (gra.DKreska(i,j,i,j+1))
           RKreska(i,j,i,j+1,r);
         }
       }
     }
     RCieniowanie();
     // bez break'a
   case WS_POWIERZCHNIA:
   case WS_KROPKA:
     {
     // ostatnia kropka
     int x=gra.DOstKropkaX(), y=gra.DOstKropkaY();
     RKropka(x,y, gra.DKropka(x,y));
     // obwodka
     if (pokazuj_ost)
       {
       if (ost_kr_x>=0) RSkasujObwodke(ost_kr_x, ost_kr_y);
       RObwodka(ost_kr_x = x, ost_kr_y = y);
       }
     }
     RTekst(WS_KROPKA);
     break;
   case WS_KTONARUCHU:
     break;
   }
}

int TRysujPlansze::DajZdarzenie(TKlawisz k, TFlagi f, int x, int y, int &nx, int &ny)
{
 int ile=wlk_kratki/3;
 x+=ile-pocz_x;   y+=ile-pocz_y;
 int gx=x/wlk_kratki, gy=y/wlk_kratki;
 if (gx>=gra.DWlkX() || gy>=gra.DWlkY() || x<0 || y<0)
   return ZD_NIC;
 // sprawdz, czy przycisnieto nie za daleko
 int px=x % wlk_kratki, py=y % wlk_kratki;
 ile+=ile;
 if (px>ile || py>ile)  // za daleko
   return ZD_NIC;
 nx=gx;  ny=gy;
 if (f & GR_M_LEFT_DOWN)
   return ZD_KROPKA;
 if (ekran.DajOpcjeZaawansowane() && (f & GR_M_RIGHT_DOWN)) {
   // rysuj cos
   int co=ekran.JakiKomentarz();
   if (komentarze[nx][ny].rodzaj==co) {
     komentarze[nx][ny].rodzaj=0;
     RPlansza();  // rysuj od nowa
   }
   else { // nowy komentarz
     if (komentarze[nx][ny].rodzaj) {  // byl juz jakis komentarz
       komentarze[nx][ny].rodzaj=co;
       if (co==1) // tekst
	 strcpy(komentarze[nx][ny].tekst, ekran.DajTekstKoment());
       RPlansza();  // wyczysc obecny koment
     }
     else {  // nie bylo jeszcze komentarza na tym polu
       komentarze[nx][ny].rodzaj=co;
       if (co==1) // tekst
	 strcpy(komentarze[nx][ny].tekst, ekran.DajTekstKoment());
       RKomentarz(nx, ny, komentarze[nx][ny]);
     }
   }
 }
 return ZD_NIC;
}

int TRysujPlansze::DowiazOpcje(TElMenu *&wsk, int x1, int x2, int y, 
			       int wys_przyc, int odstep_przyc, int marg,
			       TKolor *kolory)
{ 
  wsk->nast = new TNapis(opcje.wsp, opcje.kol, opcje.napisy[7], KR_ALIGN_LEFTTOP);
  wsk=wsk->nast;  
  wsk->nast = new TPrzyciskKilkaOpcji(&opcje.wsp[2], TEkran::kolory_przycisku_kilka_opcji, opcje.napisy, 7, ZD_WLK_KROPKI,
				      POMOC_OPWLKK);
  wsk=wsk->nast;
  wsk->InicjujZdarzeniem(ZD_WLK_KROPKI + DajWlkKropki()/2);
  wsk->nast = new TPrzyciskKilkaOpcji(&opcje.wsp[6], TEkran::kolory_przycisku_kilka_opcji, &opcje.napisy[8], 2,
				      ZD_CIENIOWANIE, POMOC_OPCIEN);
  wsk=wsk->nast;
  wsk->InicjujZdarzeniem(ZD_CIENIOWANIE + cieniowanie);
  opcje.kol[0]= kolory[0];
  for(int i=1; i<=7; i++) opcje.kol[i]=kolory[1];
  int max=0;
  for (int i=0; i<7; i++) { int d=strlen(opcje.napisy[i]);  if (d>max) max=d; } 
  opcje.wsp[0] = x1+marg;
  opcje.wsp[1] = y;
  opcje.wsp[2] = x1+marg;
  opcje.wsp[3] = y+=WYS_FONTU+odstep_przyc;
  opcje.wsp[4] = opcje.wsp[0] + (max+2)*SZER_FONTU+2;
  opcje.wsp[5] = y+=wys_przyc;
  // cieniowanie:
  opcje.kol[8] = kolory[0];
  opcje.kol[9] = kolory[1];
  opcje.kol[10] = kolory[2];
  for (int i=2; i<6; i++)
    opcje.wsp[i+4] = opcje.wsp[i];
  opcje.wsp[6] += marg + (opcje.wsp[4]-opcje.wsp[2]);
  opcje.wsp[8] += marg + (opcje.wsp[4]-opcje.wsp[2]);
  return y+odstep_przyc;
}

void TRysujPlansze::UstawOpcje(TElMenu *menu)
{
  int zd=menu->DajWartosc(ZD_WLK_KROPKI);
  const int wielkosci[] = {1,3,5,7,9,11,13};
  UstawWlkKropki(wielkosci[zd-ZD_WLK_KROPKI]);
  UstawCieniowanie((menu->DajWartosc(ZD_CIENIOWANIE) - ZD_CIENIOWANIE));
}

TRysujPlansze::TRysujPlansze()
{
// memset(obwodki, 0, sizeof(obwodki));
  memset(komentarze, 0, sizeof(komentarze));
  ost_kr_x=-1; ost_kr_y=-1; pokazuj_ost=1; wlk_kropki=5;
  cieniowanie=1;
}

//***************************

class TRysujGraczy  {
  char imiona[2][30];
  // parametry wyswietlania
  short int parw[4];  // [0-1] wsp lg, [2-3] pd rogu
  TKolor kolory[9];    // [0] tla, [1] tekstu ,,koniec gry'', ,,kropki'' i ,,powierzchnia''
                       // [2] gr1, [3] gr2
              // [4] tla menu, [5] akt przycisk, [6] nieakt przycisk
              // [7] tla gracza (ust. automatycznie na [4]),
              // [8] gracza (ustawiane automatycznie na [2] lub [3])
  int zaawansowane;  // czy pokazywac opcje zaawansowane
  int WSrodku(int nrgr, int x, int y);
  public:
  void RysujGraczy();
  void RysujWyniki(int co);
  void UstawKolory(int nr, TKolor nk);
  void UstawKolory(TKolor *nk);
  void UstawParW(int nr, short int nw);
  void UstawParW(short int *nw);
  void UstawZaawansowane(int nz);
  int  DajZdarzenie(TKlawisz k, TFlagi f, int x, int y);
  };

void TRysujGraczy::UstawKolory(int nr, TKolor nk)
{ kolory[nr]=nk; }

void TRysujGraczy::UstawParW(int nr, short int nw)
{ parw[nr]=nw; }

void TRysujGraczy::UstawKolory(TKolor* nk)
{ for (int i=0; i<sizeof(kolory)/sizeof(kolory[0]); i++) kolory[i]=nk[i]; }

void TRysujGraczy::UstawParW(short int* nw)
{ for (int i=0; i<sizeof(parw)/sizeof(parw[0]); i++) kolory[i]=nw[i]; }

void TRysujGraczy::UstawZaawansowane(int nz)
{ zaawansowane = nz; }

void TRysujGraczy::RysujGraczy()
{
 // najpierw ustaw imiona gracza 0
 TGraczO gr;
 gra.DGracza(0,gr);
 int dlug_im = ((parw[2]-parw[0])/SZER_FONTU - 1-24) /2;
 if (gr.komputer)
   { gr.UstawImie(); strcpy(imiona[0], gr.imie_k[0]); }
 else
   strcpy(imiona[0], gr.imie);
 if (strlen(imiona[0]) > dlug_im)
   imiona[0][dlug_im]=0;   // skroc imie
 // drugi gracz
 gra.DGracza(1,gr);
 if (gr.komputer)
   { gr.UstawImie(); strcpy(imiona[1], gr.imie_k[0]); }
 else
   strcpy(imiona[1], gr.imie);
 if (strlen(imiona[1]) > dlug_im)
   imiona[1][dlug_im]=0;   // skroc imie
 // rysuj imiona, kropki i powierzchnie
 GrFilledBox(parw[0], parw[1], parw[2], parw[3], kolory[0]);
 int y = parw[1] + (parw[3]-parw[1])/4;
 WypiszBold(parw[0] + SZER_FONTU/2, y, imiona[0], kolory[2], kolory[0], KR_ALIGN_LEFT);
 WypiszBold(parw[2] - SZER_FONTU/2, y, imiona[1], kolory[3], kolory[0], KR_ALIGN_RIGHT);
 WypiszBold((parw[0] + parw[2])/2, y, slowa["wynik.kr"], kolory[1], kolory[0], KR_ALIGN_CENTER);
 y = parw[3] - (parw[3]-parw[1])/4;
 WypiszBold((parw[0] + parw[2])/2, y, slowa["wynik.pow"], kolory[1], kolory[0], KR_ALIGN_CENTER);
 RysujWyniki(WS_STOP);  // rysuj wszystko
}

void TRysujGraczy::RysujWyniki(int co)
// zakladamy, ze imiona[] sa ustawione wlasciwie
{
 int xs = (parw[0] + parw[2])/2;
 int dx = SZER_FONTU*7;
 int  y = parw[3] - (parw[3]-parw[1])/4;
 if (co>WS_STOP) co=WS_STOP;
 else if (co==WS_KROPKA) co=WS_KTONARUCHU;
 // czysc odpowiedni obszar
 switch (co)
   {
   case WS_KTONARUCHU:  // czysc tylko ,,ruch'' albo ,,przegrana'', itp.
     // *10, bo trzeba wyczyscic 9 znakow (,,przegrana'') + 1 na margines
     // teraz jest *20, zapas dla dow. wersji jezykowej...
     GrFilledBox(parw[0], y-SZER_FONTU/2 -1, parw[0]+SZER_FONTU*20, parw[3], kolory[0]);
     GrFilledBox(parw[2]-SZER_FONTU*20, y-SZER_FONTU/2 -1, parw[2], parw[3], kolory[0]);
     break;
   case WS_STOP:  // czysc liczbe zdobytych kropek
   case WS_POWIERZCHNIA:    // zdobycze moga sie zmienic i wtedy, i to nawet przy z.gry==0
     // (gdy sie wstawi kropke do brzuszka przeciwnika)
     GrFilledBox(xs+dx-1, parw[1], xs+dx+9*SZER_FONTU +1, parw[3], kolory[0]);
     GrFilledBox(xs-dx-9*SZER_FONTU-1, parw[1], xs-dx+1, parw[3], kolory[0]);
     GrFilledBox(parw[0], y-SZER_FONTU/2 -1, xs-dx+1, parw[3], kolory[0]);
     GrFilledBox(xs+dx-1, y-SZER_FONTU/2 -1, parw[2], parw[3], kolory[0]);
     break;
   }
 switch (gra.DNaRuchu())
  {
  case 0:
   Wypisz(parw[0] + SZER_FONTU/2, y, slowa["ruch"], kolory[2], kolory[0], KR_ALIGN_LEFT);
   break;
  case 1:
   Wypisz(parw[2] - SZER_FONTU/2, y, slowa["ruch"], kolory[3], kolory[0], KR_ALIGN_RIGHT);
   break;
  case -1:
   if (gra.DIleZd(0) > gra.DIleZd(1))
     {
     Wypisz(parw[0] + SZER_FONTU/2, y, slowa["WYGRANA"], kolory[2], kolory[0], KR_ALIGN_LEFT);
     Wypisz(parw[2] - SZER_FONTU/2, y, slowa["przegrana"], kolory[3], kolory[0], KR_ALIGN_RIGHT);
     }
   else if (gra.DIleZd(0) < gra.DIleZd(1))
     {
     Wypisz(parw[0] + SZER_FONTU/2, y, slowa["przegrana"], kolory[2], kolory[0], KR_ALIGN_LEFT);
     Wypisz(parw[2] - SZER_FONTU/2, y, slowa["WYGRANA"], kolory[3], kolory[0], KR_ALIGN_RIGHT);
     }
   else
     {
     Wypisz(parw[0] + SZER_FONTU/2, y, slowa["remis"], kolory[2], kolory[0], KR_ALIGN_LEFT);
     Wypisz(parw[2] - SZER_FONTU/2, y, slowa["remis"], kolory[3], kolory[0], KR_ALIGN_RIGHT);
     }
   break;
   }
  // wyswietl zdobycze
  if (co>=WS_POWIERZCHNIA)
    { // wyswietl powierzchnie
    char s[30];
    sprintf(s,"%d", int(gra.DPowSS(0)));
    WypiszBold(xs-dx, y, s, kolory[2], kolory[0], KR_ALIGN_RIGHT);
    sprintf(s,"%d", int(gra.DPowSS(1)));
    WypiszBold(xs+dx, y, s, kolory[3], kolory[0], KR_ALIGN_LEFT);
    //    if (co==WS_STOP)
      {
      y = parw[1] + (parw[3]-parw[1])/4;
      if (gra.DZasadyGry()<2)
	sprintf(s,"%d", int(gra.DIleZd(0)));
      else
	sprintf(s,"%d (+%d)", int(gra.DIleZd(0)-gra.DIlePotZd(0)), int(gra.DIlePotZd(0)));
      WypiszBold(xs-dx, y, s, kolory[2], kolory[0], KR_ALIGN_RIGHT);
      if (gra.DZasadyGry()<2)
	sprintf(s,"%d", int(gra.DIleZd(1)));
      else
	sprintf(s,"%d (+%d)", int(gra.DIleZd(1)-gra.DIlePotZd(1)), int(gra.DIlePotZd(1)));
      WypiszBold(xs+dx, y, s, kolory[3], kolory[0], KR_ALIGN_LEFT);
      }
    }
}

int TRysujGraczy::WSrodku(int nrgr, int x, int y)
{
 int xs = (parw[0] + parw[2])/2;
 int dx = SZER_FONTU*12;
 if (nrgr)
   return (x>=xs+dx && x<=parw[2] && y>=parw[1] && y<=parw[3]);
 else
   return (x>=parw[0] && x<=xs-dx && y>=parw[1] && y<=parw[3]);
}

int TRysujGraczy::DajZdarzenie(TKlawisz k, TFlagi f, int x, int y)
{
 gra.DGracza(0,pargry.gr[0]);   gra.DGracza(1,pargry.gr[1]);
 for (int i=0; i<=1; i++)
 if (WSrodku(i,x,y))
  {  // gracz i-ty wcisniety
  short int wsp[2] = {0,0};
  kolory[7]=kolory[4];  kolory[8]=kolory[2+i];
  TMenuGracz *menugr = new TMenuGracz(wsp, &kolory[4], &pargry.gr[i],
                          i ? slowa["Podaj_g2"] : slowa["Podaj_g1"],
				      (zaawansowane ? 11 : 3));
  menugr->PrzesunTylkoTen(parw[2*i] + (i ? -menugr->DajWlkX() : 1), parw[3]+2);
  // glowna petla
  GrMouseEvent zdarz;
  menugr->Rysuj();
  GrFlush();
  for (;;)
    {
    int zd=ZD_NIC;
    GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
    if (zdarz.flags & GR_M_KEYPRESS)
      { zd=menugr->DajZdarzenie(zdarz.key, zdarz.flags, -1000,-1000);
      GrFlush(); }
    else if (zdarz.flags & (GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN))
      { zd=menugr->DajZdarzenie(GrKey_Nieistniejacy, 
                     zdarz.flags, zdarz.x,zdarz.y);
      GrFlush(); }
    switch (zd)
      {
      case ZD_ANULUJ:
      case ZD_OK:
        delete menugr;
        ekran.WyswietlWszystko();
        GrFlush();
	return zd==ZD_OK ? ZD_ZMIENGRACZY : ZD_NIC;
      }
    }
  }
 return ZD_NIC;
}

// ***************************
struct TZbior
  {
  int nalezy[MAX_GRACZY_W_TURN];
  TZbior() { Ustaw(); };
  int  IleElementow(int n);
  void Zeruj() { for (int i=0; i<MAX_GRACZY_W_TURN; i++) nalezy[i]=0; };
  void Ustaw() { for (int i=0; i<MAX_GRACZY_W_TURN; i++) nalezy[i]=1; };
  private:
  }
  zbior;

int TZbior::IleElementow(int n)
{ int ile=0;
  for (int i=0; i<n; i++) ile+=nalezy[i];
  return ile;
}

struct TFiltr {
  TZbior graczX, graczY;
  int wygrX,wygrY,remis;
  int rozpX,rozpY;
  int pole_pocz[8];
  int ile_pol_pocz;  // = 0: nie zwracaj uwagi na pole pocz
  char liczba[16];
  char wsp_x[10], wsp_y[10];
  int tylko_gra_srodkowa;   // to w zasadzie nie jest czesc filtru!
  int CzySpelniaPolePocz(int pole_start);
  int CzySpelnia(int g1, int g2, int zd1, int zd2, int pole_start);
  int CzySpelnia(int g1, int g2, int zd1, int zd2);
  void ZapiszInfo(FILE*,int);
  TFiltr() {
    // inicjuj
    liczba[0]='1';  liczba[1]=0;
    wsp_x[0]='3';  wsp_x[1]=0;    wsp_y[0]='3';  wsp_y[1]=0;
    graczX.Ustaw(); graczY.Ustaw();
    wygrX = wygrY = remis = rozpX = rozpY =1;
    ile_pol_pocz=0;
    tylko_gra_srodkowa = 0;
  };
};

struct TWykres {
  TElMenu *menu;
  TKolor kolory_menu[4*6], kolory[4];
  char *napisy_menu[MAX_GRACZY_W_TURN+1];
  char napis_menu[MAX_GRACZY_W_TURN*3 + 20];
  short int *wsp_menu;
  int max_gier;
  int y,wys, ywykr0, ywykr1;
  int x0,x1,szer_kreski;
  long int *wyniki[MAX_GRACZY_W_TURN];
  int gracze_pok[4];
  void Wyswietl();
};

class TStatTurnieju {
  int x0,y0,x1,y1;  // wsp. ekranowe
  int ygr1, ygr2, ywysgr;   // wsp. y linii rozpoczynajacej/konczacej okno graczy, wys gracza
  int ystatusu;      // dolna linia okienka statusu (gorna to ygr2)
  TKolor k[5];      // kolor tla, menu, nieakt menu, kolor tla, kolor zolty
  TKolor kgraczy[4]; // kolor nieakt menu, kolor 1, kolor 2, kolor menu
  int blad;         // ustawiane przez konstruktor
  int sezonp, sezonk;
  TTurniej turniej;
  // dane filtru:
  static TFiltr filtr;
  TElMenu *filtr_menu;
  short int wsp_menu[84+8*MAX_GRACZY_W_TURN];
  const static char *nu[];   // napisy ustalone
  char informacja[80];
  //
  struct TDane {
    int ile_zd[2];
    int ile_w, ile_r, ile_p;
    TStoper czas[5];
    void Zeruj() { 
      ile_zd[0]=ile_zd[1]=ile_w=ile_p=ile_r=0;
      for (int i=0; i<5; i++) czas[i].Zeruj();
    };
  };
  TDane razem;
  struct TLista {
    int nrg;
    TDane dane;
  } *lista;
  int ile_na_liscie;
  struct TDaneZebrane {
    int ile_zd[2], ile_meczow;
    TStoper czas[7];  // 3,4 = min,max dla gracza1, 5,6 = min,max dla gracza2
    void Zeruj() { 
      ile_zd[0]=ile_zd[1]=ile_meczow = 0;
      for (int i=0; i<5; i++) czas[i].Zeruj();
    };
  };
  TDaneZebrane *dane_zebrane;
  char *teksty;
  TWykres wykres;
  void ZrobWykres(int y, int wys);
  void ZerujDane();
  void PokazGracza(int);
  void PokazGraczy();
  void PokazStatus();
  void ZbierzDane();
  void ZliczajPunktyICzas();
  void ZrobMenuFiltr(int,int,int,int);
  int  SzukajRozgr();
  void WezFiltr();
  void UaktualnijMenuFiltr();
  void ZapiszInfo();
public:
  TStatTurnieju(char* nazwa);
  ~TStatTurnieju();
  int Pokaz(int nx0, int ny0, int nx1, int ny1, TKolor, TKolor, TKolor, TKolor, TKolor, TKolor);
};

TFiltr TStatTurnieju::filtr;
const char* TStatTurnieju::nu[] =
{ "$stat.gX", "$stat.gY", 
  "$stat.rX", "$stat.rY",
  "$stat.wX", "$stat.remis","$stat.wY",
  "$stat.nPoz",
  "$OK", "$stat.ruch",
  "$stat.dow", "$stat.zad",
  "$stat.wspx", "$stat.wspy", "$stat.sym",
  "$stat.uwaga",
  "A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z" 
};


int TStatTurnieju::Pokaz(int nx0, int ny0, int nx1, int ny1,
			 TKolor k0, TKolor k1, TKolor k2, TKolor kz, TKolor kg1, TKolor kg2)
// zwraca 1, gdy chcemy wczytac mecz (ustawia wtedy odp. pargry.x i pargry.y)
{
  x0=nx0;  y0=ny0;  x1=nx1;  y1=ny1;
  k[3]=k[0]=k0;  kgraczy[3]=k[1]=k1;  kgraczy[0]=k[2]=k2;  k[4]=kz;  
  kgraczy[1]=kg1;  kgraczy[2]=kg2;
  GrFilledBox(x0+1,y0+1, x1-1, y1-1, k[0]);
  GrBox(x0,y0,x1,y1, k[1]);
  int srodek = (x0+x1)/2;
  ygr1 = y0 + WYS_FONTU*2;
  PokazGraczy();
  sezonp=0;  sezonk=INT_MAX;
  ystatusu = ygr2+3*WYS_FONTU+WYS_FONTU/4;
  ZrobMenuFiltr(x0+1,ystatusu+1,x1-1,y1-1);
  int pokaz_teksty=1;
  ZbierzDane();
  strcpy(&teksty[1*256],slowa["stat.tab"]);
  for (;;) {
    if (pokaz_teksty) {
      char s[180];
      sprintf(s, "%s %s.",slowa["stat.dla"], turniej.nazwa_t);
      strcpy(&teksty[0*256],s);
      Wypisz(srodek, y0+WYS_FONTU, s, k[1], k[0], KR_ALIGN_CENTER);
      GrFilledBox(x0+1, ystatusu+1, x1-1, y1-1, k[0]);
      Wypisz(x0 + 1 + SZER_FONTU/2, ystatusu+WYS_FONTU, &teksty[1*256], k[1],k[0], KR_ALIGN_LEFT);
      Wypisz(x0 + 1 + SZER_FONTU/2, y1-WYS_FONTU/4,
	     slowa["stat.pomoc"], k[1],k[0], KR_ALIGN_LEFTBOTTOM);
      pokaz_teksty=0;
    }
    ZliczajPunktyICzas();
    PokazStatus();
    // pokaz liste
    int y = ystatusu+WYS_FONTU +WYS_FONTU/4;
    GrFilledBox(x0+1,ystatusu+WYS_FONTU+WYS_FONTU/2+1,x1-1,y1-1-3*WYS_FONTU/2,k[0]);
    for (int i=0; i<ile_na_liscie; i++) {
      char s[150],s2[10],s3[10],s4[10],s5[10],s6[10];
      sprintf(s, "%d. %s",i+1, turniej.gracze[lista[i].nrg].imie_k[0]);
      while (strlen(s)<20) strcat(s," ");
      TStoper sredni_czas = lista[i].dane.czas[0];
      sredni_czas /= (lista[i].dane.ile_w+lista[i].dane.ile_r+ lista[i].dane.ile_p);
      sprintf(&s[strlen(s)], "(%c)%6d %5d%s %6d%5d%6d%10d:%-10d %6s:%6s  %6s  %6s--%s",
	      'A'+lista[i].nrg, 
	      int(lista[i].dane.ile_w+lista[i].dane.ile_r+ lista[i].dane.ile_p),
     	      int(lista[i].dane.ile_w+lista[i].dane.ile_r/2),
	      ((lista[i].dane.ile_r & 1) ? ",5":"  "),
	      lista[i].dane.ile_w, lista[i].dane.ile_r,  lista[i].dane.ile_p,
	      lista[i].dane.ile_zd[0], lista[i].dane.ile_zd[1],
	      lista[i].dane.czas[0].IleTrwaloSkr(s2),
	      lista[i].dane.czas[1].IleTrwaloSkr(s3),
	      sredni_czas.IleTrwaloSkr(s4),
	      lista[i].dane.czas[3].IleTrwaloSkr(s5),
	      lista[i].dane.czas[4].IleTrwaloSkr(s6) );
      Wypisz(x0 + 1 + SZER_FONTU/2, y += (5*WYS_FONTU)/4, s, k[1],k[0], KR_ALIGN_LEFT);
      strcpy(&teksty[(i+2)*256],s);
    }
    // pokaz laczna statystyke
    {
      TStoper sredni_czas = razem.czas[2];
      sredni_czas /= ((razem.ile_w + razem.ile_r + razem.ile_p)/2);  // /2, bo kazdy mecz liczony 2x
      char s[120], s2[20], s3[20];
      sprintf(s, "   \243\261cznie:            %6d %5d  %7d %4d %5d%10d:%-10d %ss     %ss",
	      int((razem.ile_w+razem.ile_r+ razem.ile_p)/2),
     	      int(razem.ile_w+razem.ile_r/2),
	      razem.ile_w, razem.ile_r,  razem.ile_p,
	      razem.ile_zd[0]+razem.ile_zd[1],
	      razem.ile_zd[0]+razem.ile_zd[1],
	      razem.czas[2].IleTrwalo(s2),
	      sredni_czas.IleTrwalo(s3)
	      );
      Wypisz(x0 + 1 + SZER_FONTU/2, y += (6*WYS_FONTU)/4, s, k[1],k[0], KR_ALIGN_LEFT);
      strcpy(&teksty[(turniej.ile_graczy+2)*256],s);
    }
    GrFlush();
    // teraz czekaj na przycisk
    GrMouseEvent zdarz;
    int zmiana=0;
    do {
      GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
      if (zdarz.flags & GR_M_KEYPRESS)
	switch (Konwersja(zdarz.key)) {
	case GrKey_Escape: return 0;
	case GrKey_Minus:
	case GrKey_Dash:
	  for (int i=turniej.ile_graczy-1; i>=0; i--)
	    if (filtr.graczX.nalezy[i] || filtr.graczY.nalezy[i]) {
	      filtr.graczX.nalezy[i] = filtr.graczY.nalezy[i] = 0;
	      PokazGracza(i);
	      zmiana=1;
	    }
	  if (zmiana) UaktualnijMenuFiltr();
	  break;
	case GrKey_Plus:
	case GrKey_KPPlus:
	  for (int i=turniej.ile_graczy-1; i>=0; i--)
	    if (filtr.graczX.nalezy[i]==0 || filtr.graczY.nalezy[i]==0) {
	      filtr.graczX.nalezy[i] = filtr.graczY.nalezy[i] = 1;
	      PokazGracza(i);
	      zmiana=1;
	    }
	  if (zmiana) UaktualnijMenuFiltr();
	  break;
	case GrKey_Star:
	case GrKey_KPStar:
#if (GrKey_Star!='*')
	case '*':
#endif
	  for (int i=turniej.ile_graczy-1; i>=0; i--) {
	    filtr.graczX.nalezy[i] ^=1;
	    filtr.graczY.nalezy[i] ^= 1;
	  }
	  PokazGraczy();
	  zmiana=1;
	  UaktualnijMenuFiltr();
	  break;
	case GrKey_F2:
	  {
	    int zap=filtr.pole_pocz[0], zap2=filtr.ile_pol_pocz;
	    WezFiltr();
	    if (zap!=filtr.pole_pocz[0] || zap2!=filtr.ile_pol_pocz)
	      ZbierzDane();
	  }
	  PokazGraczy();
	  zmiana=1;
	  pokaz_teksty=1;
	  break;
	case GrKey_F3:
	  if (SzukajRozgr()) {
	    int ktory = atoi(filtr.liczba);
	    sprintf(filtr.liczba, "%d", ktory+1);   // zwieksz licznik o 1
	    return 1;
	  }
	  break;
	case GrKey_F5:
	  ZrobWykres(y0+1, y1-y0-2);
	  GrFilledBox(x0+1,y0+1, x1-1, y1-1, k[0]);
	  PokazGraczy();
	  pokaz_teksty=1;
	  zmiana=1;
	  break;
	case GrKey_F8:
	  ZapiszInfo();
	  break;
	case GrKey_F10:
	  filtr.tylko_gra_srodkowa ^= 1;
	  ZbierzDane();
	  zmiana=1;
	  break;
	default: {
	  for (int i=0; i<turniej.ile_graczy; i++)
	    if (zdarz.key == 'A'+i || zdarz.key == 'a'+i) {
	      filtr.graczX.nalezy[i] ^=1;
	      filtr.graczY.nalezy[i] ^= 1;
	      PokazGracza(i);
	      zmiana=1;
	      UaktualnijMenuFiltr();
	      break;
	    }
	  if (!zmiana)
	  for (int i=0; i<ile_na_liscie && i<9; i++)
	    if (zdarz.key == '1'+i) {
	      filtr.graczX.nalezy[lista[i].nrg] ^=1;
	      filtr.graczY.nalezy[lista[i].nrg] ^= 1;
	      PokazGracza(lista[i].nrg);
	      zmiana=1;
	      UaktualnijMenuFiltr();
	      break;
	    }
	  
	  break;
	}
	}
    } while (!zmiana);
  }
}

void TStatTurnieju::ZapiszInfo()
{	    
  FILE *f = fopen("turnieje.txt","a+t");
  fprintf(f,"----------------------------------------\n");
  fprintf(f,&teksty[0*256]);  // statystyka dla...
  fprintf(f,"; wersja Kropek %d.%d.\n",	int(wersja.WERSJA_KROPEK), int(wersja.WERSJA_KROPEK_LOW));
  turniej.ZapiszInfoOTurnieju(f);
  fprintf(f, "\nPlansza %dx%d.\n",turniej.plx, turniej.ply);
  fprintf(f, "Sezon pocz\261tkowy: %d, sezon ko\361cowy: %d.\n", sezonp, sezonk);
  fprintf(f,"\nGracze:\n\n");
  for (int ktory=0; ktory<turniej.ile_graczy; ktory++) {
    fprintf(f,"%c: %s\n",'A'+ktory, turniej.gracze[ktory].imie_k[0]);
    for (int i=1; i<4; i++)
      if (turniej.gracze[ktory].imie_k[i][0]) {
	fprintf(f, turniej.gracze[ktory].imie_k[i]);
	fprintf(f, "\n");
      }
    fprintf(f, "\n");    
  }
  // filtr:
  filtr.ZapiszInfo(f, turniej.ile_graczy);
  // lista:
  for (int i=1; i<=turniej.ile_graczy+2; i++)
    fprintf(f,"%s\n",&teksty[i*256]);
  fprintf(f,"\n");
  fclose(f);
}
	    

void TStatTurnieju::PokazStatus()
{
  GrHLine(x0+1,x1-1,ystatusu, k[1]);
  int dy = WYS_FONTU + WYS_FONTU/4;
  GrFilledBox(x0+1,ygr2+1,x1-1,ystatusu-1, k[0]);
  char s[120];
  sprintf(s, "%s %dx%d.",slowa["Plansza"], turniej.plx, turniej.ply);
  Wypisz(x0+SZER_FONTU/2+1, ygr2 + WYS_FONTU, s, k[1],k[0], KR_ALIGN_LEFT);
  sprintf(s, "%s %d, %s %d.",
	  slowa["stat.sezp"], sezonp, slowa["stat.sezk"], sezonk);
  Wypisz(x0+SZER_FONTU/2+1, ygr2 + dy + WYS_FONTU, s, k[1],k[0], KR_ALIGN_LEFT);
  int ilew = filtr.wygrX + filtr.wygrY + filtr.remis;
  if ((ilew>0 && ilew<3) || filtr.rozpX + filtr.rozpY == 1 || filtr.ile_pol_pocz)
    Wypisz(x1-SZER_FONTU/2-1, ygr2 + WYS_FONTU, slowa["stat.uwagaF"],
	      k[4],k[0], KR_ALIGN_RIGHT);
  if (filtr.tylko_gra_srodkowa)
    Wypisz(x1-SZER_FONTU/2-1, ygr2 + dy + WYS_FONTU, slowa["stat.uwagaGS"],
	      k[4],k[0], KR_ALIGN_RIGHT);
}

void TStatTurnieju::PokazGraczy()
{
  ywysgr = ((WYS_FONTU+WYS_FONTU/4)*3+  WYS_FONTU);
  for (int i=0; i<turniej.ile_graczy; i++)
    PokazGracza(i);
  ygr2 = ygr1 + WYS_FONTU/2 + ywysgr*(((turniej.ile_graczy-1)>>2)+1);
  GrHLine(x0+1,x1-1, ygr1, k[1]);
  GrHLine(x0+1,x1-1, ygr2, k[1]);
}

void TStatTurnieju::PokazGracza(int ktory)
{
  int xs = (((x1-x0) * (ktory & 3)) >> 2) + 1 + SZER_FONTU/2;
  int dy = WYS_FONTU/4;
  int ys = ygr1 + WYS_FONTU + ywysgr*(ktory>>2);
  TKolor kolor = kgraczy[filtr.graczX.nalezy[ktory] + 2*filtr.graczY.nalezy[ktory]];
  char s[40];
  sprintf(s,"%c: %s",'A'+ktory, turniej.gracze[ktory].imie_k[0]);
  Wypisz(xs,ys,s,kolor,k[0],KR_ALIGN_LEFT);
  for (int i=1; i<4; i++)
    Wypisz(xs,ys+=WYS_FONTU+dy,turniej.gracze[ktory].imie_k[i],
    kolor,k[0],KR_ALIGN_LEFT); 

}

void TStatTurnieju::ZbierzDane()
// moze byc sezonk == np. INT_MAX, wtedy ustawi sezonk na ostatni, czesciowo
// rozegrany sezon
{
  for (int i=0; i<turniej.ile_graczy*turniej.ile_graczy*3; i++)
    dane_zebrane[i].Zeruj();
  TMecz mecz;
  turniej.UstawMecz(sezonp, 0);
  int ostatni=sezonp;
  int pole_start;
  while ((pole_start=turniej.OdczytajInfoOMeczu(mecz, filtr.tylko_gra_srodkowa))  // ma byc =
	 && mecz.nr_sez<=sezonk) {
    int g1 = turniej.kalendarz.mecze[mecz.nr_mecz].g1;
    int g2 = turniej.kalendarz.mecze[mecz.nr_mecz].g2;
    if (filtr.CzySpelniaPolePocz(pole_start)) {
      int nr = (g1*turniej.ile_graczy + g2)*3 +
	(mecz.ile_zd[0] <= mecz.ile_zd[1]) + (mecz.ile_zd[0] < mecz.ile_zd[1]);  // 0=wygr,1=remis,2=przegr
      for (int i=0; i<3; i++)
	dane_zebrane[nr].czas[i]+=mecz.czas[i];
      if (dane_zebrane[nr].ile_meczow==0) {
	dane_zebrane[nr].czas[3] = dane_zebrane[nr].czas[4] = mecz.czas[0];
	dane_zebrane[nr].czas[5] = dane_zebrane[nr].czas[6] = mecz.czas[1];
      }
      else {
	if (dane_zebrane[nr].czas[3] > mecz.czas[0]) dane_zebrane[nr].czas[3] = mecz.czas[0];
	if (dane_zebrane[nr].czas[4] < mecz.czas[0]) dane_zebrane[nr].czas[4] = mecz.czas[0];
	if (dane_zebrane[nr].czas[5] > mecz.czas[1]) dane_zebrane[nr].czas[5] = mecz.czas[1];
	if (dane_zebrane[nr].czas[6] < mecz.czas[1]) dane_zebrane[nr].czas[6] = mecz.czas[1];
      }
      dane_zebrane[nr].ile_zd[0] += mecz.ile_zd[0];
      dane_zebrane[nr].ile_zd[1] += mecz.ile_zd[1];
      dane_zebrane[nr].ile_meczow++;
    }
    ostatni = mecz.nr_sez;
  }
  sezonk = ostatni;
}

void TStatTurnieju::ZliczajPunktyICzas()
{
  ZerujDane();
  int nrdz=0;
  for (int g1=0; g1<turniej.ile_graczy; g1++)
    for (int g2=0; g2<turniej.ile_graczy; g2++)
      for (int wynik=0; wynik<=2; wynik++) {
	if (dane_zebrane[nrdz].ile_meczow && filtr.CzySpelnia(g1,g2, 1, wynik)) {
	  lista[g1].dane.czas[0]   += dane_zebrane[nrdz].czas[0];
	  lista[g1].dane.czas[1]   += dane_zebrane[nrdz].czas[1];
	  lista[g1].dane.czas[2]   += dane_zebrane[nrdz].czas[2];
	  lista[g2].dane.czas[0]   += dane_zebrane[nrdz].czas[1];
	  lista[g2].dane.czas[1]   += dane_zebrane[nrdz].czas[0];
	  lista[g2].dane.czas[2]   += dane_zebrane[nrdz].czas[2];
	  if (lista[g1].dane.ile_w==0 && lista[g1].dane.ile_r==0 && lista[g1].dane.ile_p==0) {
	    lista[g1].dane.czas[3] = dane_zebrane[nrdz].czas[3];
	    lista[g1].dane.czas[4] = dane_zebrane[nrdz].czas[4];
	  }
	  else {
	    if (dane_zebrane[nrdz].czas[3] < lista[g1].dane.czas[3]) 
	      lista[g1].dane.czas[3] = dane_zebrane[nrdz].czas[3];
	    if (dane_zebrane[nrdz].czas[4] > lista[g1].dane.czas[4]) 
	      lista[g1].dane.czas[4] = dane_zebrane[nrdz].czas[4];
	  }
	  if (lista[g2].dane.ile_w==0 && lista[g2].dane.ile_r==0 && lista[g2].dane.ile_p==0) {
	    lista[g2].dane.czas[3] = dane_zebrane[nrdz].czas[5];
	    lista[g2].dane.czas[4] = dane_zebrane[nrdz].czas[6];
	  }
	  else {
	    if (dane_zebrane[nrdz].czas[5] < lista[g2].dane.czas[3]) 
	      lista[g2].dane.czas[3] = dane_zebrane[nrdz].czas[5];
	    if (dane_zebrane[nrdz].czas[6] > lista[g2].dane.czas[4]) 
	      lista[g2].dane.czas[4] = dane_zebrane[nrdz].czas[6];
	  }
	  lista[g1].dane.ile_zd[0] += dane_zebrane[nrdz].ile_zd[0];
	  lista[g1].dane.ile_zd[1] += dane_zebrane[nrdz].ile_zd[1];
	  lista[g2].dane.ile_zd[0] += dane_zebrane[nrdz].ile_zd[1];
	  lista[g2].dane.ile_zd[1] += dane_zebrane[nrdz].ile_zd[0];
	  switch (wynik) {
	  case 0:
	    lista[g1].dane.ile_w += dane_zebrane[nrdz].ile_meczow;
	    lista[g2].dane.ile_p += dane_zebrane[nrdz].ile_meczow;
	    razem.ile_w          += dane_zebrane[nrdz].ile_meczow;
	    razem.ile_p          += dane_zebrane[nrdz].ile_meczow;
	    break;
	  case 1:
	    lista[g1].dane.ile_r += dane_zebrane[nrdz].ile_meczow;
	    lista[g2].dane.ile_r += dane_zebrane[nrdz].ile_meczow;
	    razem.ile_r          += 2*dane_zebrane[nrdz].ile_meczow;
	    break;
	  case 2:
	    lista[g1].dane.ile_p += dane_zebrane[nrdz].ile_meczow;
	    lista[g2].dane.ile_w += dane_zebrane[nrdz].ile_meczow;
	    razem.ile_w          += dane_zebrane[nrdz].ile_meczow;
	    razem.ile_p          += dane_zebrane[nrdz].ile_meczow;
	    break;
	  }
	  razem.ile_zd[0] += dane_zebrane[nrdz].ile_zd[0];
	  razem.ile_zd[1] += dane_zebrane[nrdz].ile_zd[1];
	  razem.czas[2]   += dane_zebrane[nrdz].czas[2];
	}
	nrdz++;
      }
  // wywal niezaznaczonych graczy na koniec
  ile_na_liscie=0;
  for (int skad=0; skad<turniej.ile_graczy; skad++)
    if (filtr.graczX.nalezy[skad] || filtr.graczY.nalezy[skad])
      lista[ile_na_liscie++] = lista[skad];
  // teraz posortuj (ile_na_liscie) graczy (sort. babelkowe)
  if (ile_na_liscie>=2)
    for (int powt=0; powt<ile_na_liscie; powt++) 
      for (int g=1; g<ile_na_liscie; g++) {
	// zamien (g-1) i g, jesli trzeba
	int rozn = 2*lista[g-1].dane.ile_w + lista[g-1].dane.ile_r
	  - 2*lista[g].dane.ile_w - lista[g].dane.ile_r;
	int malep = lista[g-1].dane.ile_zd[0] - lista[g-1].dane.ile_zd[1]
	  - (lista[g].dane.ile_zd[0] - lista[g].dane.ile_zd[1]);
	if (rozn<0 || (rozn==0 && malep<0)) {
	  TLista pom = lista[g];
	  lista[g]   = lista[g-1];
	  lista[g-1] = pom;
	}
      }
}

void TStatTurnieju::ZerujDane()
{
  razem.Zeruj();
  for (int i=0; i<turniej.ile_graczy; i++)
    { lista[i].nrg=i;  lista[i].dane.Zeruj(); }
}

void TStatTurnieju::ZrobMenuFiltr(int fx0, int fy0, int fx1, int fy1)
{
  int wys_przyc=2*WYS_FONTU+1, odstep_przyc=WYS_FONTU/2-1;
  int marg=(2*wys_przyc)/3;
  int odstep_duzy = 2*WYS_FONTU;
  int odstep_duzy_poz = 3*WYS_FONTU;
  filtr_menu = new TProstokat(&wsp_menu[0], &k[0]);
  wsp_menu[0]=fx0;    wsp_menu[1]=fy0;
  wsp_menu[2]=fx1;    wsp_menu[3]=fy1;
  TElMenu *wsk=filtr_menu;
 // tworz dalsze elementy
  int y;
  wsk->nast = new TNapis(&wsp_menu[4], &k[0],nu[0],KR_ALIGN_LEFT);
  wsp_menu[4] = fx0+marg;
  wsp_menu[5] = y = fy0+marg;
  wsk=wsk->nast;
  wsk->nast = new TNapis(&wsp_menu[6], &k[0],nu[1],KR_ALIGN_RIGHT);
  wsp_menu[6] = fx1-marg;
  wsp_menu[7] = fy0+marg;
  wsk=wsk->nast;
  y+=WYS_FONTU;
  assert(turniej.ile_graczy <= 26);
  {
  int ile_odjac=0;
  for (int i=0; i<turniej.ile_graczy; i++) {
    if (i==10) { ile_odjac=10; y+=wys_przyc+1; }
    wsk->nast = 
      new TPrzyciskDwieOpcje(&wsp_menu[84+4*i], TEkran::kolory_przycisku_dwie_opcje, nu[16+i], ZD_FILTR_GRACZ_X+i*2,
			     POMOC_STGRX);
    wsp_menu[84  +4*i] = fx0 + marg + (i-ile_odjac)*3*SZER_FONTU;
    wsp_menu[84+1+4*i] = y;
    wsp_menu[84+2+4*i] = fx0 + marg + (i-ile_odjac+1)*3*SZER_FONTU-1;
    wsp_menu[84+3+4*i] = y + wys_przyc;
    wsk=wsk->nast;
    wsk->nast = 
      new TPrzyciskDwieOpcje(&wsp_menu[84+4*(MAX_GRACZY_W_TURN+i)], TEkran::kolory_przycisku_dwie_opcje, 
			     nu[16-1+turniej.ile_graczy-i], 
			     ZD_FILTR_GRACZ_Y+(turniej.ile_graczy-i-1)*2,
			     POMOC_STGRY);
    wsp_menu[84+  4*(MAX_GRACZY_W_TURN+i)] = fx1 - marg - (i-ile_odjac+1)*3*SZER_FONTU +1;
    wsp_menu[84+1+4*(MAX_GRACZY_W_TURN+i)] = y;
    wsp_menu[84+2+4*(MAX_GRACZY_W_TURN+i)] = fx1 - marg - (i-ile_odjac)*3*SZER_FONTU;
    wsp_menu[84+3+4*(MAX_GRACZY_W_TURN+i)] = y + wys_przyc;
    wsk=wsk->nast;
  }
  }
  y+=wys_przyc+odstep_duzy;
  wsk->nast = new TPrzyciskDwieOpcje(&wsp_menu[8], TEkran::kolory_przycisku_dwie_opcje,
				     nu[2], ZD_FILTR_ROZPX,POMOC_STROZX);
  wsk=wsk->nast;
  wsk->nast = new TPrzyciskDwieOpcje(&wsp_menu[12], TEkran::kolory_przycisku_dwie_opcje,
				     nu[3], ZD_FILTR_ROZPY,POMOC_STROZY);
  wsk=wsk->nast;
  int szer_przyc = (fx1-fx0-2*marg)/3;
  wsp_menu[8]  = fx0+marg;
  wsp_menu[10]  = wsp_menu[8]+szer_przyc;
  wsp_menu[14] = fx1-marg;
  wsp_menu[12]  = wsp_menu[14]-szer_przyc;
  wsp_menu[13] = wsp_menu[9] = y;
  wsp_menu[15] = wsp_menu[11] = y+=wys_przyc;
  y+=odstep_przyc;
  // teraz wygrana x,y, remis
  int zdarz[3] = {ZD_FILTR_WYGRX, ZD_FILTR_REMIS, ZD_FILTR_WYGRY};
  int pom3[3] = {POMOC_STWYGX, POMOC_STREMI, POMOC_STWYGY};
  for (int i=0; i<3; i++) {
    wsk->nast = new TPrzyciskDwieOpcje(&wsp_menu[16+4*i], TEkran::kolory_przycisku_dwie_opcje,
				       nu[4+i], zdarz[i], pom3[i]);
    wsk=wsk->nast;
    wsp_menu[17+4*i]=y;
    wsp_menu[19+4*i]=y+wys_przyc;
  }
  wsp_menu[16]=wsp_menu[8];
  wsp_menu[18]=wsp_menu[10];
  wsp_menu[20]=wsp_menu[10]+1;
  wsp_menu[22]=wsp_menu[12]-1;
  wsp_menu[24]=wsp_menu[12];
  wsp_menu[26]=wsp_menu[14];
  y+=wys_przyc+odstep_duzy;
  // pole poczatkowe
  wsk->nast = new TNapis(&wsp_menu[52], &k[0],nu[9], KR_ALIGN_LEFT);
  wsp_menu[52]=wsp_menu[8];
  wsp_menu[53]=y+=WYS_FONTU/2;
  y+=WYS_FONTU;
  wsk=wsk->nast;
  wsk->nast = new TWyborPrzycisku(&wsp_menu[54], TEkran::kolory_wybor_przycisku,&nu[10], 2, ZD_FILTR_RUCH0);
  wsp_menu[54]=wsp_menu[16];
  wsp_menu[56]=(wsp_menu[16]+wsp_menu[18])/2;
  wsp_menu[58]=wsp_menu[56]+1;
  wsp_menu[60]=wsp_menu[18];
  wsp_menu[55]=wsp_menu[59]=y;
  wsp_menu[57]=wsp_menu[61]=y+=wys_przyc;
  y+=odstep_przyc;
  wsk=wsk->nast;
  { // czesc do ustawiania pocz. ruchu
    // czysczenie
    TElMenu *czysc = new TProstokat(&wsp_menu[62], &k[0]);
    wsp_menu[62]=wsp_menu[60]+1;
    wsp_menu[63]=wsp_menu[53]-WYS_FONTU;
    wsp_menu[64]=fx1-1;
    // wsp_menu[65] pozniej
    ((TWyborPrzycisku*) wsk)->DodajDziecko(0, czysc);
    // utworz galaz dla ruchu poczatkowego
    TElMenu *galaz = new TNapis(&wsp_menu[66], &k[0],nu[12], KR_ALIGN_LEFT);  // wsp. x
    ((TWyborPrzycisku*) wsk)->DodajDziecko(1, galaz);
    galaz->nast = new TNapis(&wsp_menu[68], &k[0],nu[13], KR_ALIGN_LEFT);  // wsp. y
    galaz=galaz->nast;
    wsp_menu[66]=wsp_menu[20]+marg;
    wsp_menu[68]=wsp_menu[22]-szer_przyc/3-marg;
    wsp_menu[67]=wsp_menu[69]=wsp_menu[53];
    galaz->nast = new TEdytorLiniowy(&wsp_menu[70], TEkran::kolory_edytora, filtr.wsp_x, ZD_FILTR_RUCHX, 
				     sizeof(filtr.wsp_x)-1, 1, 0, max_bok_planszy-1, POMOC_STWSPX);
    galaz=galaz->nast;
    galaz->nast = new TEdytorLiniowy(&wsp_menu[74], TEkran::kolory_edytora, filtr.wsp_y, ZD_FILTR_RUCHY, 
				     sizeof(filtr.wsp_y)-1, 1, 0, max_bok_planszy-1, POMOC_STWSPY);
    galaz=galaz->nast;
    galaz->nast = new TPrzyciskDwieOpcje(&wsp_menu[78], TEkran::kolory_przycisku_dwie_opcje,
					 nu[14], ZD_FILTR_SYMET,POMOC_STUSYM);;
    galaz=galaz->nast;
    wsp_menu[70]=wsp_menu[66];
    wsp_menu[72]=wsp_menu[66]+szer_przyc/3;
    wsp_menu[74]=wsp_menu[68];
    wsp_menu[76]=wsp_menu[68]+szer_przyc/3;
    wsp_menu[78]=wsp_menu[24];
    wsp_menu[80]=wsp_menu[26];
    wsp_menu[71]=wsp_menu[75]=wsp_menu[79]= wsp_menu[55];
    wsp_menu[73]=wsp_menu[77]=wsp_menu[81]= wsp_menu[57];
    galaz->nast = new TNapis(&wsp_menu[82], &k[0],nu[15], KR_ALIGN_LEFT);  // pole LG ma wsp...
    wsp_menu[82]=wsp_menu[70];
    wsp_menu[83]=y+=WYS_FONTU/2;
    y+=WYS_FONTU+odstep_duzy;
    wsp_menu[65]=y-1;
  }
  // numer pozycji
  wsk->nast = new TNapis(&wsp_menu[32], &k[0],nu[7],KR_ALIGN_LEFT);
  wsk=wsk->nast;
  wsp_menu[32]=wsp_menu[8];
  wsp_menu[33]=y+=WYS_FONTU/2;
  y+=WYS_FONTU;
  wsk->nast = new TEdytorLiniowy(&wsp_menu[34], TEkran::kolory_edytora, filtr.liczba, ZD_FILTR_NRPOZ, 
				 sizeof(filtr.liczba)-1, 1, 1, 999999999, POMOC_STNPOZ);
  wsk=wsk->nast;
  wsp_menu[34]=wsp_menu[8];
  wsp_menu[35]=y;
  wsp_menu[36]=wsp_menu[8]+szer_przyc;
  wsp_menu[37]=y+=wys_przyc;
  y+=odstep_przyc;
  // 
  wsk->nast = new TNapisA(&wsp_menu[38], &k[3], informacja, ZD_FILTR_INFO, KR_ALIGN_LEFT);
  wsk=wsk->nast;
  informacja[0]=0;  // pusty ciag znakow
  wsp_menu[38]=wsp_menu[8];
  wsp_menu[39]=y+WYS_FONTU/2;
  wsp_menu[40]=fx0;
  wsp_menu[41]=wsp_menu[37]+1;
  wsp_menu[42]=fx1;
  wsp_menu[43]=wsp_menu[39]+WYS_FONTU-1;
  y+=2*WYS_FONTU;
  // i ostatnie przyciski
  wsk->nast = new TPrzycisk(&wsp_menu[44], TEkran::kolory_przycisku,nu[8],ZD_FILTR_OK, GrKey_Return, GrKey_Return);
  wsk=wsk->nast;
  //  wsk->nast = new TPrzycisk(&wsp_menu[48], TEkran::kolory_przycisku,nu[9],ZD_FILTR_ANULUJ, GrKey_Escape,GrKey_Escape);
  //  wsk=wsk->nast;
  for (int i=0; i<8; i+=2) wsp_menu[44+i]=wsp_menu[8+i];  // wsp. x-owe przepisz z ,,rozpoczyna...''
  wsp_menu[45] = wsp_menu[49] = y;
  wsp_menu[47] = wsp_menu[51] = y+=wys_przyc;
  UaktualnijMenuFiltr();
}

void TStatTurnieju::WezFiltr()
{
 // glowna petla
 GrMouseEvent zdarz;
 filtr_menu->Rysuj();
 GrFlush();
 for (;;)
   {
   int zd=ZD_NIC;
   GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
   if (zdarz.flags & GR_M_KEYPRESS)
     zd=filtr_menu->DajZdarzenie(zdarz.key, zdarz.flags, -1000,-1000);
   else if (zdarz.flags & (GR_M_LEFT_DOWN  | GR_M_RIGHT_DOWN))
     zd=filtr_menu->DajZdarzenie(GrKey_Nieistniejacy, zdarz.flags, zdarz.x,zdarz.y);
   if ((zdarz.flags & GR_M_KEYPRESS) || (zdarz.flags & (GR_M_LEFT_DOWN  | GR_M_RIGHT_DOWN))) {
     // wyczysc informacje
     informacja[0]=0;
     filtr_menu->InicjujZdarzeniem(ZD_FILTR_INFO);
     filtr_menu->RysujJesliZdarzenie(ZD_FILTR_INFO);
     GrFlush();
     }
   switch (zd)
     {
     case ZD_FILTR_ROZPX:
     case ZD_FILTR_ROZPX+1:
       filtr.rozpX = -zd+1+ZD_FILTR_ROZPX;
       break;
     case ZD_FILTR_ROZPY:
     case ZD_FILTR_ROZPY+1:
       filtr.rozpY = -zd+1+ZD_FILTR_ROZPY;
       break;
     case ZD_FILTR_WYGRX:
     case ZD_FILTR_WYGRX+1:
       filtr.wygrX = -zd+1+ZD_FILTR_WYGRX;
       break;
     case ZD_FILTR_WYGRY:
     case ZD_FILTR_WYGRY+1:
       filtr.wygrY = -zd+1+ZD_FILTR_WYGRY;
       break;
     case ZD_FILTR_REMIS:
     case ZD_FILTR_REMIS+1:
       filtr.remis = -zd+1+ZD_FILTR_REMIS;
       break;
     case ZD_FILTR_NRPOZ:
       break;
     case ZD_FILTR_RUCH0:
       filtr.ile_pol_pocz=0;
       break;
     case ZD_FILTR_RUCH0+1:
     case ZD_FILTR_RUCHX:
     case ZD_FILTR_RUCHY:
     case ZD_FILTR_SYMET:
     case ZD_FILTR_SYMET+1:
       filtr.ile_pol_pocz = 
	 gra.DPola(filtr.pole_pocz, atoi(filtr.wsp_x), atoi(filtr.wsp_y),
		   turniej.plx, turniej.ply,
		   filtr_menu->DajWartosc(ZD_FILTR_SYMET)==ZD_FILTR_SYMET);
       break;
     case ZD_FILTR_OK:
       return;
     default:
       if (zd>=ZD_FILTR_GRACZ_X && zd<ZD_FILTR_GRACZ_X + 2*turniej.ile_graczy) {
	 filtr.graczX.nalezy[ (zd-ZD_FILTR_GRACZ_X)>>1 ] = ((zd-ZD_FILTR_GRACZ_X) & 1)^1;
	 PokazGracza((zd-ZD_FILTR_GRACZ_X)>>1);
       }
       else
       if (zd>=ZD_FILTR_GRACZ_Y && zd<ZD_FILTR_GRACZ_Y + 2*turniej.ile_graczy) {
	 filtr.graczY.nalezy[ (zd-ZD_FILTR_GRACZ_Y)>>1 ] = ((zd-ZD_FILTR_GRACZ_Y) & 1)^1;
	 PokazGracza((zd-ZD_FILTR_GRACZ_Y)>>1);
       }
       break;
     }
   }
}

void TStatTurnieju::UaktualnijMenuFiltr()
{
  // inicjuj
  for (int i=0; i<turniej.ile_graczy; i++) {
    filtr_menu->InicjujZdarzeniem(ZD_FILTR_GRACZ_X + 2*i + 1-filtr.graczX.nalezy[i]);
    filtr_menu->InicjujZdarzeniem(ZD_FILTR_GRACZ_Y + 2*i + 1-filtr.graczY.nalezy[i]);
  }
  filtr_menu->InicjujZdarzeniem(ZD_FILTR_ROZPX + 1-filtr.rozpX);
  filtr_menu->InicjujZdarzeniem(ZD_FILTR_ROZPY + 1-filtr.rozpY);
  filtr_menu->InicjujZdarzeniem(ZD_FILTR_WYGRX + 1-filtr.wygrX); 
  filtr_menu->InicjujZdarzeniem(ZD_FILTR_WYGRY + 1-filtr.wygrY); 
  filtr_menu->InicjujZdarzeniem(ZD_FILTR_REMIS + 1-filtr.remis); 
  filtr_menu->InicjujZdarzeniem(ZD_FILTR_RUCH0 + (filtr.ile_pol_pocz!=0)); 
}

void TFiltr::ZapiszInfo(FILE *f, int ilegr)
{
  fprintf(f,"Filtr:\n");
  fprintf(f," X = ");
  for (int i=0; i<ilegr; i++)
    if (graczX.nalezy[i]) fprintf(f,"%c",'A'+i);
  fprintf(f,"\n Y = ");
  for (int i=0; i<ilegr; i++)
    if (graczY.nalezy[i]) fprintf(f,"%c",'A'+i);
  fprintf(f,"\n Rozpoczyna: ");
  if ((rozpX ^ rozpY)==0)
    fprintf(f,"ktokolwiek.\n");
  else fprintf(f,"%c.\n", 'X'+rozpY);
  fprintf(f," Wynik: ");
  if ((wygrX && wygrY && remis) || (!wygrX && !wygrY && !remis))
    fprintf(f,"dowolny");
  else {
    if (wygrX) fprintf(f,"X");
    if (remis) fprintf(f,"0");
    if (wygrY) fprintf(f,"Y");
  }
  fprintf(f,".\n Pole pocz\261tkowe: ");
  if (ile_pol_pocz==0)
    fprintf(f,"dowolne");
  else {
    fprintf(f,"(%s,%s)",wsp_x,wsp_y);
    if (ile_pol_pocz) fprintf(f," + symetrie");
  }
  fprintf(f,".\n\n");
}

int TFiltr::CzySpelniaPolePocz(int pole_start)
{
  if (ile_pol_pocz) {
    for (int i=0; i<ile_pol_pocz; i++)
      if (pole_pocz[i]==pole_start)
	return 1;
    return 0;
  }
  return 1;
}

int TFiltr::CzySpelnia(int g1, int g2, int zd1, int zd2, int pole_start)
{
  return (CzySpelniaPolePocz(pole_start) && CzySpelnia(g1, g2, zd1, zd2));
}

int TFiltr::CzySpelnia(int g1, int g2, int zd1, int zd2)
{
  int czy_spelnia_warunki=0;
  if (rozpX || rozpY==0)   // X moze rozpoczynac
    if (graczX.nalezy[g1] && graczY.nalezy[g2]) {
      int wynik =  (zd1 >= zd2) + (zd1==zd2);
      switch (wynik) {
      case 0:  // wygral Y
	czy_spelnia_warunki = (wygrY || (wygrX==0 && remis==0));
	break;
      case 1:  // wygral X
	czy_spelnia_warunki = (wygrX || (wygrY==0 && remis==0));
	break;
      case 2:  // remis
	czy_spelnia_warunki = (remis || (wygrX==0 && wygrY==0));
	break;
      }
    }
  if (!czy_spelnia_warunki)
    if (rozpY || rozpX==0)   // Y moze rozpoczynac
      if (graczY.nalezy[g1] && graczX.nalezy[g2]) {
	int wynik =  (zd2 >= zd1) + (zd1==zd2);
	switch (wynik) {
	case 0:  // wygral Y
	  czy_spelnia_warunki = (wygrY || (wygrX==0 && remis==0));
	  break;
	case 1:  // wygral X
	  czy_spelnia_warunki = (wygrX || (wygrY==0 && remis==0));
	  break;
	case 2:  // remis
	  czy_spelnia_warunki = (remis || (wygrX==0 && wygrY==0));
	  break;
	}
      }
  return czy_spelnia_warunki;
}

int TStatTurnieju::SzukajRozgr()
// szuka meczu spelniajacego kryteria ustawione w ,,filtr''
// jesli znajdzie, zwraca 1 i ustawia (pargry.x, pargry.y) na nr sezonu i meczu
{
  TMecz mecz;
  int ile_znal=0;
  int ktory = atoi(filtr.liczba);
  turniej.UstawMecz(sezonp, 0);
  int pole_start;
  while ((pole_start=turniej.OdczytajInfoOMeczu(mecz, filtr.tylko_gra_srodkowa))  // ma byc =
	 && mecz.nr_sez<=sezonk) {
    int g1 = turniej.kalendarz.mecze[mecz.nr_mecz].g1;
    int g2 = turniej.kalendarz.mecze[mecz.nr_mecz].g2;
    if (filtr.CzySpelnia(g1,g2, mecz.ile_zd[0], mecz.ile_zd[1], pole_start)) {
      pargry.x = mecz.nr_sez;  pargry.y = mecz.nr_mecz;
      if (++ile_znal >= ktory) return 1;
      }
  }
  return (ile_znal!=0);
}

void TWykres::Wyswietl()
{
  GrFilledBox(x0,ywykr0,x1,ywykr0+wys,ekran.DajKolorTla());
  menu->Rysuj();
  // znajdz min i max wynik
  int wynik_min=INT_MAX, wynik_max=-INT_MAX;
  int szer = x1-x0+1;
  for (int g=0; g<4; g++)
    if (gracze_pok[g]>=0)
      for (int i=0; i<szer; i++)
	if (wyniki[gracze_pok[g]][i]!=LONG_MAX) {
	  if (wyniki[gracze_pok[g]][i] > wynik_max) wynik_max = wyniki[gracze_pok[g]][i];
	  if (wyniki[gracze_pok[g]][i] < wynik_min) wynik_min = wyniki[gracze_pok[g]][i];
	}
  int rozpietosc = wynik_max-wynik_min;
  if (rozpietosc < 2) rozpietosc = 2;
  int wyswykr = ywykr1-ywykr0+1;
  int dzielnik=1, mnoznik=1;
  if (rozpietosc > wyswykr-2)
    dzielnik = rozpietosc / (wyswykr-2) +1;
  else
    mnoznik =  (wyswykr-2) / rozpietosc ;
  int yosi0;
  {
    long long int p = wyswykr;
    p *= wynik_max;
    p /= rozpietosc;
    yosi0 = ywykr0 + p;
  }
  // zaznacz linie poziome
  int skala = 1;
  {
    int mnoznik_skali=0;
    while (rozpietosc/skala > 8) {
      switch (mnoznik_skali) {
      case 2:  // bez break'a
      case 0:  skala *= 2; break;
      case 1:  skala /= 2; skala *= 5;  break;
      }
      if (++mnoznik_skali==3) mnoznik_skali=0;
    }
  }
  int poczy = (wynik_min / skala) * skala;
  while (poczy<wynik_max) {
    int y = yosi0 - (mnoznik*poczy)/dzielnik;
    GrLine(x0,y,x1,y,ekran.DajKolorNieaktMenu());
    poczy+=skala;
  }
  // rysuj wykresy
  for (int g=0; g<4; g++)
    if (gracze_pok[g]>=0) {
      int ypop = yosi0 - (mnoznik*wyniki[gracze_pok[g]][0])/dzielnik;
      for (int i=1; i<szer; i++)
	if (wyniki[gracze_pok[g]][i]!=LONG_MAX) {
	  int y = yosi0 - (mnoznik*wyniki[gracze_pok[g]][i])/dzielnik;
	  GrLine(x0+(i-1)*szer_kreski,ypop,x0+i*szer_kreski,y ,kolory[g]);
	  ypop=y;
	}
    }
  // wypisz info
  {
  char s[105];
  /*
  for (int g=0; g<4; g++)
    if (gracze_pok[g]>=0) {
      sprintf(s,"Gracz %c", 'A'+gracze_pok[g]);
      Wypisz(x0+SZER_FONTU+g*SZER_FONTU*10, ywykr1+WYS_FONTU, s, kolory[g]);
    }
  */
  sprintf(s, slowa["stat.wykres"], skala);  // napisz: podzialka pionowa co %d pkt.
  Wypisz(x1-SZER_FONTU, ywykr1+WYS_FONTU, s, ekran.DajKolorMenu(),
	    ekran.DajKolorTla(), KR_ALIGN_RIGHTTOP);
  }
}

void TStatTurnieju::ZrobWykres(int y, int wys)
{
  int ile_jest = (ile_na_liscie < 4) ? ile_na_liscie : 4;
  for (int i=0; i<4; i++) 
    wykres.gracze_pok[i]= (i<ile_jest) ? lista[i].nrg : -1;
  wykres.y=y;       wykres.wys=wys;
  wykres.ywykr0=y;  wykres.ywykr1 =  y+wys - 4*(3*WYS_FONTU/2) - 2;
  wykres.x0=1;      wykres.x1=ekran.DajRozdzX()-2;
  for (int i=0; i<MAX_GRACZY_W_TURN; i++) {
    wykres.wyniki[i] = new long int[wykres.x1-wykres.x0+1];
    wykres.wyniki[i][0]=0;
    for (int j=2; j<=wykres.x1-wykres.x0; j++)
      wykres.wyniki[i][j]=LONG_MAX;
  }
  // skala pozioma:
  int skala_poz;
  {
    int max_mecz=1;
    for (int i=0; i<ile_na_liscie; i++) {
      int ile = lista[i].dane.ile_w + lista[i].dane.ile_r + lista[i].dane.ile_p;
      if (ile>max_mecz) max_mecz=ile;
    }
    skala_poz = 1 + max_mecz / (wykres.x1-wykres.x0);
    wykres.szer_kreski = (wykres.x1-wykres.x0) / max_mecz;
    if (wykres.szer_kreski==0) wykres.szer_kreski=1;
  }
  int ilem[MAX_GRACZY_W_TURN], wspx[MAX_GRACZY_W_TURN];
  memset(ilem, 0, sizeof(ilem));
  for (int i=0; i<MAX_GRACZY_W_TURN; i++) wspx[i]=1;
  // zbierz dane
  TMecz mecz;
  turniej.UstawMecz(sezonp, 0);
  int pole_start;
  while ((pole_start=turniej.OdczytajInfoOMeczu(mecz, filtr.tylko_gra_srodkowa))  // ma byc =
	 && mecz.nr_sez<=sezonk) {
    int g1 = turniej.kalendarz.mecze[mecz.nr_mecz].g1;
    int g2 = turniej.kalendarz.mecze[mecz.nr_mecz].g2;
    if (filtr.CzySpelnia(g1,g2, mecz.ile_zd[0], mecz.ile_zd[1], pole_start)) {
      int wynik = (mecz.ile_zd[0]>mecz.ile_zd[1]) - (mecz.ile_zd[0]<mecz.ile_zd[1]);
      if (ilem[g1]==0) wykres.wyniki[g1][ wspx[g1] ]= wykres.wyniki[g1][ wspx[g1]-1 ];
      if (ilem[g2]==0) wykres.wyniki[g2][ wspx[g2] ]= wykres.wyniki[g2][ wspx[g2]-1 ];
      wykres.wyniki[g1][ wspx[g1] ] += wynik;
      wykres.wyniki[g2][ wspx[g2] ] -= wynik;
      if (++ilem[g1]==skala_poz) { ilem[g1]=0; wspx[g1]++; }
      if (++ilem[g2]==skala_poz) { ilem[g2]=0; wspx[g2]++; }
    }
  }
  // dorob menu
  TElMenu *wsk;
  wykres.wsp_menu = new short int[4*4*(ile_na_liscie+1)];
  wykres.kolory[0] = ekran.DajKolorMenu();
  wykres.kolory[1] = ekran.DajKolorGracza(0);
  wykres.kolory[2] = ekran.DajKolorGracza(1);
  wykres.kolory[3] = ekran.DajKolorZielony();
  wykres.napisy_menu[0] = wykres.napis_menu;
  strcpy(wykres.napisy_menu[0], slowa["stat.brak"]);
  for (int i=1; i<=ile_na_liscie; i++) {
    wykres.napisy_menu[i] = wykres.napisy_menu[i-1] + strlen(wykres.napisy_menu[i-1]) + 1;
    wykres.napisy_menu[i][0] = 'A'+lista[i-1].nrg;
    wykres.napisy_menu[i][1] = 0;
  }
  for (int g=0; g<4; g++) {
    if (g==0) 
      wsk = wykres.menu = 
	new TWyborPrzycisku(&wykres.wsp_menu[g*4*(ile_na_liscie+1)], 
			    &wykres.kolory_menu[g*6], 
			    (const char**) wykres.napisy_menu, ile_na_liscie+1, (g+1)*100);
    else {
      wsk->nast = new TWyborPrzycisku(&wykres.wsp_menu[g*4*(ile_na_liscie+1)], 
				      &wykres.kolory_menu[g*6], 
				      (const char**) wykres.napisy_menu, ile_na_liscie+1, (g+1)*100);
      wsk = wsk->nast;
    }
    for (int j=0; j<6; j++)
      wykres.kolory_menu[g*6+j] = TEkran::kolory_wybor_przycisku[j];
    wykres.kolory_menu[g*6+1]=wykres.kolory[g];
    short int *pm = &wykres.wsp_menu[g*4*(ile_na_liscie+1)];
    pm[0]= wykres.x0+SZER_FONTU;
    pm[1]= y+wys - (4-g)*(3*WYS_FONTU/2);
    pm[2]= wykres.x0+SZER_FONTU*8;
    pm[3]= y+wys - (3-g)*(3*WYS_FONTU/2) -1;
    for (int i=1; i<=ile_na_liscie; i++) {
      wykres.napisy_menu[i] = wykres.napisy_menu[i-1] + strlen(wykres.napisy_menu[i-1]) + 1;
      wykres.napisy_menu[i][0] = 'A'+lista[i-1].nrg;
      wykres.napisy_menu[i][1] = 0;
      pm[4*i]  = pm[4*(i-1)+2]+1;
      pm[4*i+1]= pm[4*(i-1)+1];
      pm[4*i+2]= pm[4*(i-1)+2] + SZER_FONTU*2;
      pm[4*i+3]= pm[4*(i-1)+3];
    }
  }
  // inicjuj
  for (int g=0; g<4; g++) {
    int m=-1;
    for (int j=0; j<ile_na_liscie; j++)
      if (lista[j].nrg==wykres.gracze_pok[g]) {
	m=j; break;
      }
    wykres.menu->InicjujZdarzeniem((g+1)*100 + m+1);
  }
  // pokaz
  wykres.Wyswietl();
  for (;;) {
    // czekaj
    GrMouseEvent zdarz;
    GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
    if ((zdarz.flags & (GR_M_KEYPRESS | GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN)) ==0)
      continue;  // nic nie zostalo przycisniete
    if (zdarz.flags & GR_M_KEYPRESS)
      {
	zdarz.x=zdarz.y=-1000;
	if (Konwersja(zdarz.key)==GrKey_Escape)
	  break;
      }
    else if (zdarz.flags & (GR_M_LEFT_DOWN  | GR_M_RIGHT_DOWN))
      zdarz.key=GrKey_Nieistniejacy;
    int zd=wykres.menu->DajZdarzenie(zdarz.key, zdarz.flags, zdarz.x, zdarz.y);
    if (zd>=100) {
      int nr = zd/100 -1;
      wykres.gracze_pok[nr] = (zd % 100) -1;
      if (wykres.gracze_pok[nr]>=0)
	wykres.gracze_pok[nr] = lista[ wykres.gracze_pok[nr] ].nrg;
      wykres.Wyswietl();
    }
  }
  // wyjdz
  for (int i=0; i<MAX_GRACZY_W_TURN; i++)
    delete[] wykres.wyniki[i];
  wykres.menu->Zniszcz();
  delete[] wykres.wsp_menu;
}

TStatTurnieju::TStatTurnieju(char* nazwa)
{
  strcpy(turniej.nazwa_t, nazwa);
  blad = turniej.OdczytajNagl()-1;
  if (blad) return;
  lista = new TLista[turniej.ile_graczy];
  filtr_menu = NULL;
  teksty = new char[(turniej.ile_graczy+3)*256];
  dane_zebrane = new TDaneZebrane[turniej.ile_graczy*turniej.ile_graczy*3];  // 3, bo wygr, remis, przegr
}

TStatTurnieju::~TStatTurnieju()
{
  if (!blad) {
    delete[] teksty;
    delete[] dane_zebrane;
    delete[] lista; 
    if (filtr_menu!=NULL) filtr_menu->Zniszcz();
  }
}


// ***************************
#define ILE_PLIKOW_MENU 11
class TPlikiMenu
  {
  TElMenu *menu;
  TElMenu *lista[7+3*ILE_PLIKOW_MENU];
  short int wsp[28+10*ILE_PLIKOW_MENU];
  // parametry wyswietlania
  TKolor kolory[2];   // [0] tla menu, [1] akt przycisk
  void UstawWlk();
  const static char *nu[2];   // napis ustalone
  char naglowek[30];
  char nazwa_ostatni[256];
  char pliki_info[ILE_PLIKOW_MENU+1][70];   // ostatni element idze na opis ost. pliku, a przedostatni na napis ,,Inny plik:''
  char operacja[ILE_PLIKOW_MENU][50];         // Odczytaj, Zapisz albo Nowy
  void OstatniPlik(const char *bledy[], const char *odm_kr[], int odczytaj);
  void OstatniPlikTurn(const char *bledy[], const char *odm_gr[]);
  public:
  void UstawKolory(int nr, TKolor nk);
  int  OdczytWezNazwe(char*, int, int, int odczytaj=1);
  int  ZapisWezNazwe(char*, int, int);
  int  WezTurniej(int, int);
  TPlikiMenu();
  ~TPlikiMenu();
  };

const char *TPlikiMenu::nu[2] = {"$Anuluj", "$turn.Stat"};

void TPlikiMenu::UstawKolory(int nr, TKolor nk)
{ kolory[nr]=nk; }

void TPlikiMenu::UstawWlk()
// uwaga: wszystkie zmienne ozn. liczbe pikseli, czyli dlugosc-1
{
 int wys_przyc=2*WYS_FONTU+1, odstep_przyc=WYS_FONTU/2-1;
 int marg=(2*wys_przyc)/3;
 int szer_pudelka = 2+ SZER_FONTU/2   // ramki + odstep do napisu (o pliku)
  +(45+1+10)*SZER_FONTU+  // 45: info o pliku, 1: odstep, 10: przycisk
    odstep_przyc;
 // prostokat czyszczacy
 wsp[0]=0;  wsp[1]=0;
 wsp[2]=2*marg + szer_pudelka - 1;
 int y=marg;
 // ramka zewnetrzna
 wsp[4]=marg;  wsp[5]=marg;
 wsp[6]=marg + szer_pudelka - 1;
 // napis w naglowku
 wsp[16]=marg + (szer_pudelka - 1)/2;
 wsp[17]=marg + odstep_przyc + (wys_przyc+1)/2;
 // ramka wewnetrzna
 y+=wys_przyc+2*odstep_przyc+1;
 wsp[8]=marg;  wsp[9]= y;
 wsp[10]=marg + szer_pudelka - 1;
 // napisy o plikach i przyciski
 for (int i=0; i<ILE_PLIKOW_MENU; i++)
   {
   y+=odstep_przyc+1;
   wsp[28+2*ILE_PLIKOW_MENU+4*i]= marg+szer_pudelka-1 - 12*SZER_FONTU - odstep_przyc-2;
   wsp[29+6*ILE_PLIKOW_MENU+4*i]= wsp[29+2*ILE_PLIKOW_MENU+4*i]= y;
   wsp[30+2*ILE_PLIKOW_MENU+4*i]= marg+szer_pudelka-1 - odstep_przyc-1;
   wsp[31+6*ILE_PLIKOW_MENU+4*i]= wsp[31+2*ILE_PLIKOW_MENU+4*i]= y+wys_przyc-1;
   wsp[30+6*ILE_PLIKOW_MENU+4*i]= wsp[28+2*ILE_PLIKOW_MENU+4*i]-odstep_przyc-1;
   wsp[28+6*ILE_PLIKOW_MENU+4*i]= wsp[30+6*ILE_PLIKOW_MENU+4*i]-12*SZER_FONTU-1;
   // tekst
   wsp[28+2*i]= marg+1+SZER_FONTU/2;
   wsp[29+2*i]= y+(wys_przyc-1)/2;
   y+=wys_przyc-1;
   }
 // teraz dodatkowa linia z edytorem liniowym
 y+=odstep_przyc+1;
 wsp[18] = marg+1+SZER_FONTU/2;   // napisA
 wsp[19] = y+(wys_przyc-1)/2;     // napisA
 wsp[20] = marg+1+SZER_FONTU*15;  // prostokat czysczacy napisA
 wsp[21] = y;
 wsp[22] = marg + szer_pudelka - 2;
 wsp[24] = wsp[20]+1;             // poczatek edytora liniowego
 wsp[25] = wsp[29+2*ILE_PLIKOW_MENU + 4*(ILE_PLIKOW_MENU-1)];
 wsp[26] = marg+szer_pudelka-1 - odstep_przyc-1;
 wsp[27] = wsp[31+2*ILE_PLIKOW_MENU + 4*(ILE_PLIKOW_MENU-1)];
 // obniz przyciski ostatniego pliku
 wsp[29+2*ILE_PLIKOW_MENU + 4*(ILE_PLIKOW_MENU-1)] += odstep_przyc+wys_przyc;
 wsp[31+2*ILE_PLIKOW_MENU + 4*(ILE_PLIKOW_MENU-1)] += odstep_przyc+wys_przyc;
 wsp[29+6*ILE_PLIKOW_MENU + 4*(ILE_PLIKOW_MENU-1)] += odstep_przyc+wys_przyc;
 wsp[31+6*ILE_PLIKOW_MENU + 4*(ILE_PLIKOW_MENU-1)] += odstep_przyc+wys_przyc;
 y+=wys_przyc-1;
 //
 y+=odstep_przyc+1;
 wsp[23]=y-1;    // dol prostokata czysczacego napisA
 wsp[11]=y;       // dol ramki wewnetrznej
 // przycisk Anuluj
 wsp[12]=marg + (szer_pudelka - 1)/2 - 5*SZER_FONTU;
 wsp[13]=y+ odstep_przyc+1;
 wsp[14]=marg + (szer_pudelka - 1)/2 + 5*SZER_FONTU+1;
 wsp[15]=y+ odstep_przyc+wys_przyc;
 y+= wys_przyc+2*odstep_przyc+1;
 wsp[7]=y;       // dol ramki zewnetrznej
 wsp[3]=y+marg;  // dol prostokatu czysczacego
}

void TPlikiMenu::OstatniPlik(const char *bledy[], const char *odm_kr[], int odczytaj)
{
 // ostatni przycisk
 strcpy(pliki_info[ILE_PLIKOW_MENU-1], slowa["plik.Inny"]);
 pliki_info[ILE_PLIKOW_MENU][0]=0;
 if (nazwa_ostatni[0]) {
   int wx,wy,ile,zgry;
   int jaki=gra.DInfoOPliku(nazwa_ostatni, wx, wy, ile, zgry);
   int dolacz_przycisk = !odczytaj && jaki!=-1;   // jaki==-1 oznacza zly ID pliku (prawdopodobnie zupelnie inny plik)
   if (jaki<=0 && jaki!=-1)   // -1: zly naglowek, czyli moze SGF?
     sprintf(pliki_info[ILE_PLIKOW_MENU],"   %s",slowa[bledy[-jaki]]);
   else if (jaki==4 || jaki==5 || jaki==12 || jaki==13) {
     sprintf(pliki_info[ILE_PLIKOW_MENU],"   %s",slowa[bledy[5]]);  // plik turniejowy
     dolacz_przycisk=0;
   }
   else if (jaki!=-1) {   // nie sgf
     sprintf(pliki_info[ILE_PLIKOW_MENU],"   %s %dx%d, %d %s%s", slowa["Plansza"],
	     wx, wy, ile, slowa[odm_kr[ TypLiczby(ile)-1 ]],
	     (jaki==1 || jaki==9)? slowa["plik.kong"]:"");
     dolacz_przycisk=1;
   }
   else {  // sgf?
     sprintf(pliki_info[ILE_PLIKOW_MENU],"   %s", slowa["plik.sgf"]);
     dolacz_przycisk=1;
   }
   if (dolacz_przycisk) {
     lista[5]->nast = lista[7+ILE_PLIKOW_MENU + ILE_PLIKOW_MENU-1];
     lista[7+ILE_PLIKOW_MENU + ILE_PLIKOW_MENU-1]->nast = lista[6];
   }
   else lista[5]->nast = lista[6];
 }
 else
   lista[5]->nast=lista[6];   // skasuj ew. przyciski ostatniego pliku
}

int TPlikiMenu::OdczytWezNazwe(char *par, int x, int y, int odczytaj)
// do podanego lancucha kopiuje nazwe pliku do wczytania/zapisania (*)
// i zwraca 1, lub zwraca 0, gdy anulowano
//  (*) jesli odczytaj==1 (domyslnie), to do wczytania,
//      a gdy odczytaj==0, to do zapisania
// Uwaga: (x,y) to wspolrzedne PRAWEGO gornego rogu!
{
 UstawWlk();
 x-=wsp[2];   // wez LEWY rog
 // przesun do (x,y)
 for (int i=0; i<sizeof(lista)/sizeof(lista[0]); i++) lista[i]->PrzesunTylkoTen(x,y);
 if (odczytaj)
   {
   strcpy(naglowek,slowa["OdczytajG"]);
   for (int i=0; i<ILE_PLIKOW_MENU; i++) strcpy(operacja[i],slowa["Odczytaj"]);
   }
 else
   {
   strcpy(naglowek,slowa["ZapiszG"]);
   for (int i=0; i<ILE_PLIKOW_MENU; i++) strcpy(operacja[i],slowa["Zapisz"]);
   }
 TElMenu *wsk=lista[7+ILE_PLIKOW_MENU-1]; //10];
 // wez info o plikach
 char nazwa[] = "kropkix.z";
 const char *bledy[] = {
   "plik.nieuz", "plik.blad", "plik.nwer", "plik.zlap", "plik.zlyg", "plik.turn"};
 const char *odm_kr[3] = {"kropka1", "kropka2", "kropka5"};
 for (int i=0; i<ILE_PLIKOW_MENU-1; i++) {
   nazwa[6]='0'+i;
   int wx,wy,ile,zgry;
   int jaki= gra.DInfoOPliku(nazwa, wx, wy, ile, zgry);
   int dolacz_przycisk = !odczytaj;
   if (jaki<=0)
     sprintf(pliki_info[i],"%d. %s",i,slowa[bledy[-jaki]]);
   else if (jaki==4 || jaki==5 || jaki==12 || jaki==13)
     sprintf(pliki_info[i],"%d. %s",i,slowa[bledy[5]]);  // plik turniejowy
   else {
     sprintf(pliki_info[i],"%d. %s %dx%d, %d %s%s", i, slowa["Plansza"],
	     wx, wy, ile, slowa[odm_kr[ TypLiczby(ile)-1 ]],
	     (jaki==1 || jaki==9)? slowa["plik.kong"]:"");
     dolacz_przycisk=1;
   }
   if (dolacz_przycisk) {
     wsk->nast = lista[7+ILE_PLIKOW_MENU+i];
     wsk=wsk->nast;
   }
 }
 wsk->nast=NULL;   // koniec listy (zwyklych) przyciskow
 OstatniPlik(bledy, odm_kr,  odczytaj);  // dodaj przyciski ostatniego pliku
 // glowna petla
 GrMouseEvent zdarz;
 menu->Rysuj();
 GrFlush();
 for (;;)
   {
   int zd=ZD_NIC;
   GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
   if (zdarz.flags & GR_M_KEYPRESS)
     { zd=menu->DajZdarzenie(zdarz.key, zdarz.flags, -1000,-1000);
     GrFlush(); }
   else if (zdarz.flags & (GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN))
     { zd=menu->DajZdarzenie(GrKey_Nieistniejacy, 
                    zdarz.flags, zdarz.x,zdarz.y);
     GrFlush(); }
   switch (zd)
     {
     case ZD_ANULUJ:
       ekran.WyswietlWszystko();   // mozna lepiej, jesli wiadomo, gdzie sie wyswietlamy
       GrFlush();
       return 0;
     case ZD_NIC:
       break;
     case ZD_INFOOSTPLIK:
       break;
     case ZD_NAZWAOSTPLIKU: {
       OstatniPlik(bledy, odm_kr,  odczytaj);  // dodaj przyciski ostatniego pliku
       menu->Rysuj();
       GrFlush();
     }
       break;
     default:
       if (zd-ZD_PLIK_NR < ILE_PLIKOW_MENU-1) {
	 nazwa[6]='0'+(zd-ZD_PLIK_NR);
	 strcpy(par, nazwa);
       }
       else strcpy(par, nazwa_ostatni);
       if (!odczytaj)
         ekran.WyswietlWszystko();   // mozna lepiej, jesli wiadomo, gdzie sie wyswietlamy
       GrFlush();
       return 1;
     }
   }
 return 0;
}

inline int TPlikiMenu::ZapisWezNazwe(char *par, int x, int y)
{
 return OdczytWezNazwe(par, x, y, 0);
}

void TPlikiMenu::OstatniPlikTurn(const char *bledy[], const char *odm_gr[])
{
 strcpy(pliki_info[ILE_PLIKOW_MENU-1], slowa["plik.Inny"]);
 pliki_info[ILE_PLIKOW_MENU][0]=0;
 if (nazwa_ostatni[0]) {
   int wx,wy,ile, zgry;
   int jaki=gra.DInfoOPliku(nazwa_ostatni, wx, wy, ile, zgry);
   TElMenu *wsk=lista[5];
   if (jaki<=0)
     {
     sprintf(pliki_info[ILE_PLIKOW_MENU],"   %s",slowa[bledy[-jaki]]);
     if (jaki==0)
       {
       wsk->nast = lista[7+ILE_PLIKOW_MENU+ ILE_PLIKOW_MENU-1];
       wsk=wsk->nast;
       strcpy(operacja[ILE_PLIKOW_MENU-1], slowa["turn.Nowy"]);
       }
     }
   else if (jaki!=12 && jaki!=13)
     sprintf(pliki_info[ILE_PLIKOW_MENU],"   %s",slowa[bledy[6]]);  // zly typ pliku
   else
     {
     sprintf(pliki_info[ILE_PLIKOW_MENU],"   %s %dx%d, %d %s", slowa["Plansza"],
                wx, wy, ile, slowa[odm_gr[ TypLiczby(ile)-1 ]]);
     // kolejnosc ponizej jest wazna! najpierw statystyka...
     wsk->nast = lista[7+2*ILE_PLIKOW_MENU+ ILE_PLIKOW_MENU-1];
     wsk=wsk->nast;
     wsk->nast = lista[7+ILE_PLIKOW_MENU+ ILE_PLIKOW_MENU-1];
     wsk=wsk->nast;
     strcpy(operacja[ILE_PLIKOW_MENU-1], slowa["Odczytaj"]);
     }
   wsk->nast=lista[6];
 }
 else
   lista[5]->nast=lista[6];   // skasuj ew. przyciski ostatniego pliku
}


int TPlikiMenu::WezTurniej(int x, int y)
// zwraca
//   1 (==odczytaj) lub 2 (==nowy) i ustawia odpowiednio nazwy plikow w pargry
//   lub 3 (==odczytaj mecz, wtedy tez ustawia pargry.x, pargry.y = nrsez, nrm)
//   0, gdy anulowano
// Uwaga: (x,y) to wspolrzedne PRAWEGO gornego rogu!
{
 UstawWlk();
 x-=wsp[2];   // wez LEWY rog
 // przesun do (x,y)
 for (int i=0; i<sizeof(lista)/sizeof(lista[0]); i++) lista[i]->PrzesunTylkoTen(x,y);
 strcpy(naglowek, slowa["turn.nagl"]);
 TElMenu *wsk=lista[7+ILE_PLIKOW_MENU-1];
 // wez info o plikach
 char nazwa[] = "turniejx.t";
 const char *bledy[] = {
   "plik.nieuz", "plik.blad", "plik.nwer", "plik.zlap", "plik.zlyg", "plik.zlal",
   "plik.zlyt"};
 const char *odm_gr[3] = {"gracz1","gracz2","gracz5"};
 for (int i=0; i<ILE_PLIKOW_MENU-1; i++)
   {
   nazwa[7]='0'+i;
   int wx,wy,ile,zgry;
   int jaki=gra.DInfoOPliku(nazwa, wx, wy, ile, zgry);
   if (jaki<=0)
     {
     sprintf(pliki_info[i],"%d. %s",i,slowa[bledy[-jaki]]);
     if (jaki==0)
       {
       wsk->nast = lista[7+ILE_PLIKOW_MENU+i];
       wsk=wsk->nast;
       strcpy(operacja[i], slowa["turn.Nowy"]);
       }
     }
   else if (jaki!=12 && jaki!=13)
     sprintf(pliki_info[i],"%d. %s",i,slowa[bledy[6]]);  // zly typ pliku
   else
     {
     sprintf(pliki_info[i],"%d. %s %dx%d, %d %s", i, slowa["Plansza"],
                wx, wy, ile, slowa[odm_gr[ TypLiczby(ile)-1 ]]);
     // kolejnosc ponizej jest wazna! najpierw statystyka...
     wsk->nast = lista[7+2*ILE_PLIKOW_MENU+i];
     wsk=wsk->nast;
     wsk->nast = lista[7+ILE_PLIKOW_MENU+i];
     wsk=wsk->nast;
     strcpy(operacja[i], slowa["Odczytaj"]);
     }
   }
 wsk->nast=NULL;   // koniec listy przyciskow
 OstatniPlikTurn(bledy, odm_gr);   // ostatni przycisk
 // glowna petla
 GrMouseEvent zdarz;
 menu->Rysuj();
 GrFlush();
 for (;;)
   {
   int zd=ZD_NIC;
   GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
   if (zdarz.flags & GR_M_KEYPRESS)
     { zd=menu->DajZdarzenie(zdarz.key, zdarz.flags, -1000,-1000);
     GrFlush(); }
   else if (zdarz.flags & (GR_M_LEFT_DOWN  | GR_M_RIGHT_DOWN))
     { zd=menu->DajZdarzenie(GrKey_Nieistniejacy, 
			     zdarz.flags, zdarz.x,zdarz.y);
     GrFlush(); }
   switch (zd)
     {
     case ZD_ANULUJ:
       ekran.WyswietlWszystko();   // mozna lepiej, jesli wiadomo, gdzie sie wyswietlamy
       GrFlush();
       return 0;
     case ZD_NIC:
       break;
     case ZD_INFOOSTPLIK:
       break;
     case ZD_NAZWAOSTPLIKU:
       // uaktualnij dane
       OstatniPlikTurn(bledy, odm_gr);
       menu->Rysuj();
       GrFlush();
       break;
     default:
       if (zd>=ZD_PLIK_NR && zd<ZD_PLIK_NR+ILE_PLIKOW_MENU) {
	 if (zd-ZD_PLIK_NR < ILE_PLIKOW_MENU-1) {
	   nazwa[7]='0'+(zd-ZD_PLIK_NR);
	   strcpy(pargry.nz1, nazwa);
	 }
	 else strcpy(pargry.nz1, nazwa_ostatni);
	 GrFlush();  
	 return (strcmp(operacja[zd-ZD_PLIK_NR], slowa["Odczytaj"]) ==0) ? 1:2;  // odczytaj:nowy
       } 
       else {
	 if (zd-ZD_PLIK_NR_STAT < ILE_PLIKOW_MENU-1) {
	   nazwa[7]='0'+(zd-ZD_PLIK_NR_STAT);
	   strcpy(pargry.nz1, nazwa);
	 }
	 else strcpy(pargry.nz1, nazwa_ostatni);
	 TStatTurnieju stat(pargry.nz1);
	 if (stat.Pokaz(0,0,ekran.DajRozdzX()-1, ekran.DajRozdzY()-1,
			ekran.DajKolorTla(), ekran.DajKolorMenu(), ekran.DajKolorNieaktMenu(),
			ekran.DajKolorZolty(), ekran.DajKolorGracza(0),ekran.DajKolorGracza(1) ))
	   return 3;
	 ekran.WyswietlWszystko();   // mozna lepiej, jesli wiadomo, gdzie sie wyswietlamy
	 return 0;
       }
       break;
     }
   }
 return 0;
}


TPlikiMenu::TPlikiMenu()
{
 nazwa_ostatni[0]=0;
 menu=lista[0]=new TProstokat(&wsp[0], &kolory[0]);
 TElMenu *wsk=menu;
 // tworz dalsze elementy
 wsk->nast =lista[1]= new TRamka(&wsp[4], TEkran::kolory_suwaka);
 wsk=wsk->nast;
 wsk->nast = lista[2]=new TRamka(&wsp[8], TEkran::kolory_suwaka);
 wsk=wsk->nast;
 wsk->nast = lista[3]=new TPrzycisk(&wsp[12], TEkran::kolory_przycisku,nu[0],ZD_ANULUJ,
                                    GrKey_Escape,GrKey_Escape);
 wsk=wsk->nast;
 wsk->nast = lista[4]=new TNapis(&wsp[16], &kolory[0],naglowek);
 wsk=wsk->nast;
 wsk->nast = lista[5]=new TNapisA(&wsp[18], &kolory[0], pliki_info[ILE_PLIKOW_MENU], ZD_INFOOSTPLIK, KR_ALIGN_LEFT);
 wsk=wsk->nast;
 wsk->nast = lista[6]=new TEdytorLiniowy(&wsp[24], TEkran::kolory_edytora,
					 nazwa_ostatni, ZD_NAZWAOSTPLIKU, 255, 0,0,0, POMOC_DPLIK);
 wsk=wsk->nast;
 for (int i=0; i<ILE_PLIKOW_MENU; i++)
  {
  wsk->nast = lista[7+i]=new TNapis(&wsp[28+2*i], &kolory[0],pliki_info[i],
                                    KR_ALIGN_LEFT);
  wsk=wsk->nast;
  }
 for (int i=0; i<ILE_PLIKOW_MENU; i++)
  {
  wsk->nast = lista[7+ILE_PLIKOW_MENU+i]=
    new TPrzycisk(&wsp[28+2*ILE_PLIKOW_MENU+4*i], TEkran::kolory_przycisku,operacja[i], ZD_PLIK_NR+i, 
		  '0'+i,'0'+i);
  wsk=wsk->nast;
  }
 for (int i=0; i<ILE_PLIKOW_MENU; i++)
  {
  wsk->nast = lista[7+2*ILE_PLIKOW_MENU+i]=
    new TPrzycisk(&wsp[28+6*ILE_PLIKOW_MENU+4*i], TEkran::kolory_przycisku,nu[1],
		  ZD_PLIK_NR_STAT+i,'0'+i,'0'+i, POMOC_TURNST);
  wsk=wsk->nast;
  }
}

TPlikiMenu::~TPlikiMenu()
{
 for (int i=0; i<sizeof(lista)/sizeof(lista[0]); i++) delete lista[i];
}

// ***************************
class TWezKalendarz {
  int ilegr;
  int x,y,kratka,szer_druz;
  int x1ok,x2ok,y1ok,y2ok;
  char kalend[MAX_GRACZY_W_TURN][MAX_GRACZY_W_TURN];
  char druzyna[MAX_GRACZY_W_TURN];
  void Inicjuj();
  void RysujRamke();
  void RysujWnetrze(int,int);
  void RysujWnetrze();
  void RysujDruzyne(int);
  void RysujDruzyne();
  int DajZdarzenie(int myszx, int myszy, int &zdx, int &zdy);
public:
  int Wez(TKalendarzRozgr &kalend_arg, int wspx, int wspy, int wlk_kratki, int ile_graczy);
};

void TWezKalendarz::Inicjuj()
{
  for (int i=0; i<ilegr; i++) {
    druzyna[i]=0;
    for (int j=0; j<ilegr; j++) kalend[i][j]=1;
  }
  //  kratka = ((WYS_FONTU > SZER_FONTU) ? WYS_FONTU : SZER_FONTU) +2 +1;
  szer_druz = SZER_FONTU*12;
  x1ok = x+kratka*(ilegr+3);
  x2ok = x1ok+szer_druz;
  y1ok = y+kratka*(ilegr+8);
  y2ok = y1ok+kratka;
}

void TWezKalendarz::RysujRamke()
{
  GrFilledBox(x,y, x+kratka*(ilegr+3)+szer_druz, y+kratka*(ilegr+5), ekran.DajKolorTla());
  // 1. przebieg -- rysuj czarne
  for (int i=3; i<ilegr+3; i+=3) {
    GrLine(x, y+i*kratka, x+kratka*(ilegr+3) + ((i!=1 && i!=2) ? szer_druz:0), y+i*kratka, ekran.DajKolorNieaktMenu());
    GrVLine(x+i*kratka, y, y+kratka*(ilegr+3), ekran.DajKolorNieaktMenu());
  }
  // 2. przebieg -- rysuj biale
  for (int i=0; i<=ilegr+3; i++) 
    if (!(i%3==0 && i && i<ilegr+3)) {
      GrLine(x, y+i*kratka, x+kratka*(ilegr+3) + ((i!=1 && i!=2) ? szer_druz:0), y+i*kratka, ekran.DajKolorMenu());
      GrVLine(x+i*kratka, y, y+kratka*(ilegr+3),ekran.DajKolorMenu());
    }
  GrVLine(x+kratka*(ilegr+3)+szer_druz, y, y+kratka*(ilegr+3), ekran.DajKolorMenu());
  // napisy pomocy
  Wypisz(x+kratka/2, y+(ilegr+4)*kratka, "$turn.Rozpoczyna", ekran.DajKolorGracza(0), ekran.DajKolorTla(), KR_ALIGN_LEFT);
  Wypisz(x+kratka/2, y+(ilegr+5)*kratka, "$turn.Drugi",      ekran.DajKolorGracza(1), ekran.DajKolorTla(), KR_ALIGN_LEFT);
  Wypisz(x+kratka/2, y+(ilegr+6)*kratka, "$turn.KPomoc1", ekran.DajKolorMenu(), ekran.DajKolorTla(), KR_ALIGN_LEFT);
  Wypisz(x+kratka/2, y+(ilegr+7)*kratka, "$turn.KPomoc2", ekran.DajKolorMenu(), ekran.DajKolorTla(), KR_ALIGN_LEFT);
  // napis ,,Rozpocznij'':
  GrBox(x1ok,y1ok,x2ok,y2ok, ekran.DajKolorZolty());
  Wypisz((x1ok+x2ok)/2, (y1ok+y2ok)/2, "$turn.Rozp", ekran.DajKolorZolty(), ekran.DajKolorTla(), KR_ALIGN_CENTER);
  // +,-,* w narozniku
  char napis[2];  napis[1]=0;
  napis[0]='+';
  Wypisz(x+kratka/2, y+kratka/2, napis, ekran.DajKolorMenu(), ekran.DajKolorTla(), KR_ALIGN_CENTER);
  napis[0]='-';
  Wypisz(x+3*kratka/2, y+3*kratka/2, napis, ekran.DajKolorMenu(), ekran.DajKolorTla(), KR_ALIGN_CENTER);
  napis[0]='*';
  Wypisz(x+5*kratka/2, y+5*kratka/2, napis, ekran.DajKolorMenu(), ekran.DajKolorTla(), KR_ALIGN_CENTER);
  for (int i=0; i<ilegr; i++) {
    napis[0]='+';
    Wypisz(x+kratka/2, y+(i+3)*kratka+kratka/2, napis, ekran.DajKolorMenu(), ekran.DajKolorTla(), KR_ALIGN_CENTER);
    Wypisz(x+(i+3)*kratka+kratka/2, y+kratka/2, napis, ekran.DajKolorMenu(), ekran.DajKolorTla(), KR_ALIGN_CENTER);
    napis[0]='-';
    Wypisz(x+3*kratka/2, y+(i+3)*kratka+kratka/2, napis, ekran.DajKolorMenu(), ekran.DajKolorTla(), KR_ALIGN_CENTER);
    Wypisz(x+(i+3)*kratka+kratka/2, y+3*kratka/2, napis, ekran.DajKolorMenu(), ekran.DajKolorTla(), KR_ALIGN_CENTER);
    napis[0]='A'+i;
    Wypisz(x+5*kratka/2, y+(i+3)*kratka+kratka/2, napis, ekran.DajKolorGracza(0), ekran.DajKolorTla(), KR_ALIGN_CENTER);
    Wypisz(x+(i+3)*kratka+kratka/2, y+5*kratka/2, napis, ekran.DajKolorGracza(1), ekran.DajKolorTla(), KR_ALIGN_CENTER);
    // krzyzyk na przekatnej:
    GrLine(x+(i+3)*kratka, y+(i+4)*kratka, x+(i+4)*kratka, y+(i+3)*kratka, ekran.DajKolorMenu());
  }
  // krzyzyk na przekatnej -- przekatna
  GrLine(x+3*kratka, y+3*kratka, x+(3+ilegr)*kratka, y+(3+ilegr)*kratka, ekran.DajKolorMenu());
  {
    int xsr = x+(ilegr+3)*kratka + szer_druz/2;
    Wypisz(xsr, y+kratka, "$kal.Dodaj", ekran.DajKolorMenu(), ekran.DajKolorTla(), KR_ALIGN_CENTER);
    Wypisz(xsr, y+2*kratka, "$kal.druzyne", ekran.DajKolorMenu(), ekran.DajKolorTla(), KR_ALIGN_CENTER);
  }
}

void TWezKalendarz::RysujWnetrze(int i,int j)
{
  int marg=kratka/4;
  GrFilledBox(x+(i+3)*kratka+marg, y+(j+3)*kratka+marg,  x+(i+4)*kratka-marg, y+(j+4)*kratka-marg,
	      kalend[i][j] ? ekran.DajKolorMenu() : ekran.DajKolorTla());
}

void TWezKalendarz::RysujWnetrze()
{
  for (int i=0; i<ilegr; i++)
    for (int j=0; j<ilegr; j++)
      if (i!=j) RysujWnetrze(i,j);
}

void TWezKalendarz::RysujDruzyne(int i)
{
  int marg=kratka/4;
  GrFilledBox(x+(ilegr+3)*kratka+marg, y+(i+3)*kratka+marg,  x+(ilegr+3)*kratka+szer_druz-marg, y+(i+4)*kratka-marg,
	      druzyna[i] ? ekran.DajKolorMenu() : ekran.DajKolorTla());
}

void TWezKalendarz::RysujDruzyne()
{  for (int i=0; i<ilegr; i++) RysujDruzyne(i); }

int TWezKalendarz::DajZdarzenie(int myszx, int myszy, int &zdx, int &zdy)
{
  if (myszx>x1ok && myszx<x2ok && myszy>y1ok && myszy<y2ok)
    return ZD_OK;
  myszx-=x;  myszy-=y;
  if (myszx<=0 || myszy<=0) return ZD_NIC;
  int krx=myszx/kratka, kry=myszy/kratka;
  if (kry>=ilegr+3 || myszx>=kratka*(ilegr+3)+szer_druz) return ZD_NIC;
  if (myszx>kratka*(ilegr+3)) {
    if (kry<3) { zdx=-1;  return ZD_DRUZYNA; }
    if (myszy % kratka) {
      zdx=kry-3;
      return ZD_DRUZYNA;
    }
    return ZD_NIC;
  }
  if (myszy % kratka==0 || myszx % kratka ==0) return ZD_NIC;
  zdx=krx-3;  zdy=kry-3;
  return ZD_WNETRZE;
}

int TWezKalendarz::Wez(TKalendarzRozgr &kalend_arg, int wspx, int wspy, int wlk_kratki, int ile_graczy)
// zwraca ZD_OK (na razie zawsze, potem mozna dorobic anuluj)
{
  ilegr=ile_graczy;  x=wspx;  y=wspy;  kratka=wlk_kratki;
  Inicjuj();
  RysujRamke();
  RysujDruzyne();
  RysujWnetrze();
  GrFlush();
  for (;;) {
    GrMouseEvent zdarz;
    int zd=ZD_NIC, zdx,zdy;
    GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
    if (zdarz.flags & GR_M_KEYPRESS)
      zd=(zdarz.key==GrKey_Return) ? ZD_OK : ZD_NIC;
    else if (zdarz.flags & (GR_M_LEFT_DOWN))
      zd=DajZdarzenie(zdarz.x,zdarz.y, zdx,zdy);
    switch (zd) {
    case ZD_NIC: break;
    case ZD_OK: {
      pargry.kalendarz.KazdyZKazdym(ilegr);
      int dokad=0;
      for (int i=0; i<pargry.kalendarz.rozgr_w_sezonie; i++)
	if (kalend[pargry.kalendarz.mecze[i].g2][pargry.kalendarz.mecze[i].g1])
	  pargry.kalendarz.mecze[dokad++] = pargry.kalendarz.mecze[i];
      pargry.kalendarz.rozgr_w_sezonie = dokad;
      }
      return ZD_OK;
    case ZD_DRUZYNA:
      if (zdx>=0) {
	druzyna[zdx]^=1;
	RysujDruzyne(zdx);
	GrFlush();
      }
      else { // ustaw druzyne
	for (int i=0; i<ilegr; i++)
	  for (int j=0; j<ilegr; j++)
	    if (i!=j && druzyna[i] && druzyna[j] && kalend[i][j]) {
	      kalend[i][j]=0;
	      RysujWnetrze(i,j);
	    }
	for (int i=0; i<ilegr; i++)
	  if (druzyna[i]) {
	    druzyna[i]=0;
	    RysujDruzyne(i);
	  }
	GrFlush();
      }
      break;
    case ZD_WNETRZE:
      if (zdx>=0)
	if (zdy>=0) {
	  if (zdx!=zdy) {
	    kalend[zdx][zdy]^=1;
	    RysujWnetrze(zdx,zdy);
	    GrFlush();
	  }
	}
	else {  // zdy<0, zdx>=0
	  for (int i=0; i<ilegr; i++)
	    if (i!=zdx) {
	      switch (zdy) {
	      case -1: kalend[zdx][i]^=1; break;
	      case -2: kalend[zdx][i] =0; break;
	      case -3: kalend[zdx][i] =1; break;
	      }
	      RysujWnetrze(zdx,i);
	    }
	  GrFlush();
	}
      else  // zdx<0
	if (zdy>=0) {
	  for (int i=0; i<ilegr; i++)
	    if (i!=zdy) {
	      switch (zdx) {
	      case -1: kalend[i][zdy]^=1; break;
	      case -2: kalend[i][zdy] =0; break;
	      case -3: kalend[i][zdy] =1; break;
	      }
	      RysujWnetrze(i,zdy);
	    }
	  GrFlush();
	}
	else if (zdx==zdy) {  // oba ujemne
	  switch (zdx) {
	  case -1:
	    for (int i=0; i<ilegr; i++)
	      for (int j=0; j<ilegr; j++) 
		if (i!=j) {
		  kalend[i][j] ^=1;
		  RysujWnetrze(i,j);
		}
	    break;
	  case -2:
	    for (int i=0; i<ilegr; i++)
	      for (int j=0; j<ilegr; j++) 
		if (i!=j && kalend[i][j]) {
		  kalend[i][j] =0;
		  RysujWnetrze(i,j);
		}
	    break;
	  case -3:
	    for (int i=0; i<ilegr; i++)
	      for (int j=0; j<ilegr; j++) 
		if (i!=j && !kalend[i][j]) {
		  kalend[i][j] =1;
		  RysujWnetrze(i,j);
		}
	    break;
	  }
	  GrFlush();
	}
      break;
    }
  }
}


// ***************************
class TTurniejMenu
  {
  int     aktywny[MAX_GRACZY_W_TURN];
  TElMenu *menu;
  short int wsp[80+10*MAX_GRACZY_W_TURN];
  // parametry wyswietlania
  TKolor kolory[5];   // [0] tla menu, [1] akt przycisk, [2] nieakt przycisk
                     //  [3] tlo napisu gracza (=[0] automatycznie)
                     //  [4] kolor napisu gracza (=[1] automatycznie)
  void UstawWlk();
  const static char *nu[];   // napis ustalone
  char liczba_gr[30];
  char napis_gr[MAX_GRACZY_W_TURN][21];   // napisy graczy, np. Komp 12/-1/44.2
  const char *wsk_do_nap_gr[2*MAX_GRACZY_W_TURN];
  void UaktNazwyGraczy(int rysuj=1);
  void UaktLiczbeGraczy(int rysuj=1);
  int  Przenumeruj();
  void WstawImie(int i);
  public:
  TTurniejMenu();
  ~TTurniejMenu();
  int Wez(int, int);
  void UstawKolory(int nr, TKolor nk);
  };

const char* TTurniejMenu::nu[] = {"$turn.NowyT", "$turn.Gr",
  "$WlkPl", "$pozioma", "$pionowa",
  "$turn.Przen", "$OK", "$Anuluj",
  "$zasady", "0", "1", "2",
  "$zmien", "$zmien", "$zmien", "$zmien", "$zmien", "$zmien",
  "$zmien", "$zmien", "$zmien", "$zmien", "$zmien", "$zmien",
  "$zmien", "$zmien", "$zmien", "$zmien", "$zmien", "$zmien",
  "$zmien", "$zmien", "$zmien", "$zmien", "$zmien", "$zmien",
  "$zmien", "$zmien", "$zmien", "$zmien", "$zmien", "$zmien",
  "$zmien", "$zmien",
  "Gracz 1", "Gracz 2", "Gracz 3", "Gracz 4", "Gracz 5", "Gracz 6",
  "Gracz 7", "Gracz 8", "Gracz 9", "Gracz 10", "Gracz 11", "Gracz 12",
  "Gracz 13", "Gracz 14", "Gracz 15", "Gracz 16", "Gracz 17", "Gracz 18",
  "Gracz 19", "Gracz 20", "Gracz 21", "Gracz 22", "Gracz 23", "Gracz 24",
  "Gracz 25", "Gracz 26", "Gracz 27", "Gracz 28", "Gracz 29", "Gracz 30",
  "Gracz 31", "Gracz 32" };

TTurniejMenu::TTurniejMenu()
{
 menu=new TProstokat(&wsp[0], &kolory[0]);
 TElMenu *wsk=menu;
 // tworz dalsze elementy
 wsk->nast = new TRamka(&wsp[4], TEkran::kolory_suwaka);
 wsk=wsk->nast;
 wsk->nast = new TRamka(&wsp[8], TEkran::kolory_suwaka);
 wsk=wsk->nast;
 wsk->nast = new TRamka(&wsp[12], TEkran::kolory_suwaka);
 wsk=wsk->nast;
 // napisy
 wsk->nast = new TNapis(&wsp[16], &kolory[0],nu[0]);
 wsk=wsk->nast;
 wsk->nast = new TNapis(&wsp[18], &kolory[0],nu[1]);
 wsk=wsk->nast;
 wsk->nast = new TNapis(&wsp[20], &kolory[0],nu[2]);
 wsk=wsk->nast;
 wsk->nast = new TNapis(&wsp[22], &kolory[0],nu[3]);
 wsk=wsk->nast;
 wsk->nast = new TNapis(&wsp[24], &kolory[0],nu[4]);
 wsk=wsk->nast;
 wsk->nast = new TNapisA(&wsp[26], &kolory[0],liczba_gr, ZDT_LICZBA_GR,
                         KR_ALIGN_LEFT);
 wsk=wsk->nast;
 wsk->nast = new TPrzycisk(&wsp[32], TEkran::kolory_przycisku, nu[5],ZDT_PRZENUMERUJ,
                                    GrKey_Brak,GrKey_Brak, POMOC_PRZENU);
 wsk=wsk->nast;
 wsk->nast = new TPrzycisk(&wsp[36], TEkran::kolory_przycisku, nu[6],ZDT_OK,
                                    GrKey_Brak,GrKey_Brak);
 wsk=wsk->nast;
 wsk->nast = new TPrzycisk(&wsp[40], TEkran::kolory_przycisku, nu[7],ZDT_ANULUJ,
                                    GrKey_Escape,GrKey_Escape);
 wsk=wsk->nast;
 wsk->nast = new TSuwak(&wsp[44], TEkran::kolory_suwaka, ZDT_WLKX, min_bok_planszy,
      max_bok_planszy-min_bok_planszy+1, NULL, NULL, POMOC_WLKPLA);
 wsk=wsk->nast;
 wsk->nast = new TSuwak(&wsp[55], TEkran::kolory_suwaka, ZDT_WLKY, min_bok_planszy,
      max_bok_planszy-min_bok_planszy+1, NULL, NULL, POMOC_WLKPLA);
 wsk=wsk->nast;
 wsk->nast = new TNapis(&wsp[66], &kolory[0],nu[8]);
 wsk=wsk->nast;
 wsk->nast = new TWyborPrzycisku(&wsp[68], TEkran::kolory_wybor_przycisku, &nu[9], 3, ZDT_ZASADY, POMOC_ZASADY);
 wsk=wsk->nast;
 TWyborPrzycisku *drzewo;
 wsk->nast = drzewo =
    new TWyborPrzycisku(&wsp[80], TEkran::kolory_wybor_przycisku,&nu[12], MAX_GRACZY_W_TURN, ZDT_ZMIEN_GR);
 wsk=wsk->nast;
 for (int i=0; i<MAX_GRACZY_W_TURN; i++)
   {
   wsk_do_nap_gr[2*i+1] = wsk_do_nap_gr[2*i] = napis_gr[i];
   wsk->nast = new TPrzyciskKilkaOpcji(&wsp[80+4*MAX_GRACZY_W_TURN+4*i], 
				       TEkran::kolory_przycisku_kilka_opcji, &wsk_do_nap_gr[2*i],
                                       2,ZDT_GRACZ_NR+2*i);
   wsk=wsk->nast;
   }
 // dodaj do drzewa menu graczy
 for (int i=0; i<MAX_GRACZY_W_TURN; i++)
   {
   wsk = new TMenuGracz(&wsp[80+8*MAX_GRACZY_W_TURN+2*i], &kolory[0], &pargry.gr[i],
                        nu[44+i], 12, ZDT_BAZAGR*(i+1));  // 12 - stan
   drzewo->DodajDziecko(i, wsk);
   }
}

TTurniejMenu::~TTurniejMenu()
{
 menu->Zniszcz();
}

void TTurniejMenu::UstawKolory(int nr, TKolor nk)
{ kolory[nr]=nk; }

void TTurniejMenu::UstawWlk()
// uwaga: wszystkie zmienne ozn. liczbe pikseli, czyli dlugosc-1
{
 kolory[3]=kolory[0];   kolory[4]=kolory[1];
 int wys_przyc=2*WYS_FONTU+1, odstep_przyc=WYS_FONTU/2-1;
 int marg=(2*wys_przyc)/3;
 int szer_pudelka = 2+ 3*odstep_przyc   // ramki + odstepy miedzy przyciskami
  +(21+9)*SZER_FONTU  // wielkosci przyciskow
   +6;        // +6 tylko po to, zeby sie potem zmiescil suwak do ust. wlk. planszy
 // prostokat czyszczacy
 wsp[0]=0;  wsp[1]=0;
 wsp[2]=2*marg + szer_pudelka - 1;
 int y=marg;
 // ramka naglowka
 wsp[4]=marg;  wsp[5]=marg;
 wsp[6]=marg + szer_pudelka - 1;
 // napis w naglowku
 wsp[16]=marg + (szer_pudelka - 1)/2;
 wsp[17]=marg + odstep_przyc + (wys_przyc+1)/2;
 y+=wys_przyc+2*odstep_przyc+1;
 wsp[7] =y;  // dol ramki naglowka
 // ramka zewnetrzna pod naglowkiem
 wsp[8]=marg;  wsp[9]= y;
 wsp[10]=marg + szer_pudelka - 1;
 // napis Gracze:
 wsp[18]=marg + (szer_pudelka - 1)/2;
 wsp[19]=y + WYS_FONTU;
 y+=2*WYS_FONTU;
 // przyciski Graczy i Zmien
 int wys_przyc_gr = WYS_FONTU+4;
 for (int i=0; i<MAX_GRACZY_W_TURN; i++)
   {
   // przycisk gracza
   wsp[80+4*MAX_GRACZY_W_TURN+4*i] = marg +1 +odstep_przyc;
   wsp[81+4*MAX_GRACZY_W_TURN+4*i] = y;
   wsp[82+4*MAX_GRACZY_W_TURN+4*i] = marg +1 +odstep_przyc + 20*SZER_FONTU+1;
   wsp[83+4*MAX_GRACZY_W_TURN+4*i] = y+wys_przyc_gr-1;                          
   // przycisk zmien
   wsp[80+4*i] = wsp[82+4*MAX_GRACZY_W_TURN]+odstep_przyc+1;
   wsp[81+4*i] = y;
   wsp[82+4*i] = marg + szer_pudelka-1 -odstep_przyc-1;
   wsp[83+4*i] = y+wys_przyc_gr-1;
   // TMenuGracz
   wsp[80+8*MAX_GRACZY_W_TURN+2*i] = marg + szer_pudelka;
   wsp[81+8*MAX_GRACZY_W_TURN+2*i] = 0;
   y+=wys_przyc_gr; //+odstep_przyc;
   }
     y+=odstep_przyc;
 // napis liczby graczy
 wsp[26] = marg + 1+WYS_FONTU/2;
 wsp[27] = y+WYS_FONTU;
 wsp[28] = marg + WYS_FONTU/2;  // czyszczacy prostokacik
 wsp[29] = y+WYS_FONTU/2-1;
 wsp[30]= marg + szer_pudelka - 2;
 wsp[31] = y+(3*WYS_FONTU)/2+1;
 y+=2*WYS_FONTU;
 // przycisk przenumeruj graczy
 wsp[32] = wsp[80+4*MAX_GRACZY_W_TURN];
 wsp[33] = y;
 wsp[34] = wsp[82];
 wsp[35] = y+wys_przyc-1;
 y+=wys_przyc+odstep_przyc;
 // ramka wielkosci planszy
 wsp[12]=marg;
 wsp[13]=y;
 wsp[14]=marg + szer_pudelka - 1;
 // napis wielkosc planszy
 wsp[20]=marg + (szer_pudelka - 1)/2;
 wsp[21]=y + WYS_FONTU;
 y+=2*WYS_FONTU;
 // napis pozioma
 wsp[22]=marg + (szer_pudelka - 1)/2;
 wsp[23]=y + WYS_FONTU/2;
 y+=WYS_FONTU+2;
 // suwak wlkx
 wsp[44] = wsp[80+4*MAX_GRACZY_W_TURN];                //    [0] = x pocz minusa
 wsp[45] = wsp[80+4*MAX_GRACZY_W_TURN]+wys_przyc-1;    //    [1] = x pocz suwaka
 wsp[46] = wsp[82]-wys_przyc-1;     //    [2] = x pocz plusa
 wsp[47] = wys_przyc-1;             //    [3] = x dlug znaku
// wsp[48] = 0;                     //    [4] = x napisu (napisu nie ma)
 wsp[49] = y;                       //    [5] = y znaku
 wsp[50] = y+(wys_przyc*2)/3;       //    [6] = y suwaka
// wsp[51] = 0;                     //    [7] = y napisu (napisu nie ma)
 wsp[52] = wys_przyc-1;             //    [8] = y dlug znaku
 wsp[53] = 2;                       //    [9] = grub kreski
 wsp[54] = wys_przyc/5;             //    [10] = dlug kreski
 y+=wys_przyc+WYS_FONTU;
 // napis pionowa
 wsp[24]=marg + (szer_pudelka - 1)/2;
 wsp[25]=y;
 y+=WYS_FONTU/2+2;
 // suwak wlky
 for (int i=0; i<11; i++)
   wsp[55+i] = wsp[44+i];  // skopiuj suwak
 wsp[60] = y;                   //    [5] = y znaku
 wsp[61] = y+(wys_przyc*2)/3;   //    [6] = y suwaka
// wsp[62] = 0;                 //    [7] = y napisu (napisu nie ma)
 y+=wys_przyc+odstep_przyc;
 y+=odstep_przyc+1;
 // zasady gry
 wsp[66]=marg + (szer_pudelka - 1)/2;
 wsp[67]=y;
 y+=WYS_FONTU/2+2;
 // wybor zasad gry
 wsp[68]=marg + (szer_pudelka - 1)/2 - (wys_przyc*3)/2-1;
 wsp[70]=wsp[68]+wys_przyc;
 wsp[72]=wsp[70]+1;
 wsp[74]=wsp[72]+wys_przyc;
 wsp[76]=wsp[74]+1;
 wsp[78]=wsp[76]+wys_przyc;
 wsp[69]=wsp[73]=wsp[77]=y;
 wsp[71]=wsp[75]=wsp[79]=y+=wys_przyc-1;
 //
 y+=odstep_przyc+1;
 // dol ramki wielkosci
 wsp[15]=y;
 y+=odstep_przyc+1;
 // przyciski Rozpocznij i Anuluj
 wsp[36]=wsp[80+4*MAX_GRACZY_W_TURN];
 wsp[37]=y;
 wsp[38]=(wsp[80+4*MAX_GRACZY_W_TURN]+wsp[82]-odstep_przyc)/2;
 wsp[39]=y+wys_przyc-1;
 wsp[40]=(wsp[80+4*MAX_GRACZY_W_TURN]+wsp[82]+odstep_przyc)/2;
 wsp[41]=y;
 wsp[42]=wsp[82];
 wsp[43]=y+wys_przyc-1;
 y+=wys_przyc+odstep_przyc;
 // dol zewnetrznej ramki
 wsp[11]=y;
 // dol prostokata
 wsp[3]=y+marg;
}

void TTurniejMenu::UaktNazwyGraczy(int rysuj)
{
 for (int i=0; i<MAX_GRACZY_W_TURN; i++)
   {
   menu->InicjujZdarzeniem(ZDT_GRACZ_NR+2*i+ aktywny[i]);
   if (rysuj)
     menu->RysujJesliZdarzenie(ZDT_GRACZ_NR+2*i);
   }
}

void TTurniejMenu::UaktLiczbeGraczy(int rysuj)
{
 sprintf(liczba_gr, "%s %d%s.", slowa["turn.lgraczy"], pargry.ile,
   (pargry.ile<2) ? slowa["turn.zaMaloGr"]:"");
 if (rysuj)
   menu->RysujJesliZdarzenie(ZDT_LICZBA_GR);
}

int  TTurniejMenu::Przenumeruj()
// zwraca 1, gdy przenumerowano
{
 int wy=0, zamiana=0;
 for (;;)
  { // szukaj dziury
  while (wy<MAX_GRACZY_W_TURN && aktywny[wy]) wy++;
  if (wy<MAX_GRACZY_W_TURN)
    { // jest dziura - szukaj nastepnego akt. gracza, jesli jest
    int we=wy+1;
    while (we<MAX_GRACZY_W_TURN && !aktywny[we]) we++;
    if (we<MAX_GRACZY_W_TURN)
      { // skopiuj we-->wy
      aktywny[we]=0;  aktywny[wy]=1;  zamiana=1;
      TGraczO pom = pargry.gr[we];
      pargry.gr[we] &= pargry.gr[wy];
      pargry.gr[wy] &= pom;
      char poms[21];
      strcpy(poms, napis_gr[we]);
      strcpy(napis_gr[we], napis_gr[wy]);
      strcpy(napis_gr[wy], poms);
      }
    else return zamiana;
    }
  else return zamiana;
  }
}

void TTurniejMenu::WstawImie(int i)
{
  pargry.gr[i].UstawImie();  strcpy(napis_gr[i], pargry.gr[i].imie_k[0]);
 int d = strlen(napis_gr[i]);
 while (d<19) napis_gr[i][d++]=' ';
 napis_gr[i][d  ]=0;  // (d==19)
 napis_gr[i][d+1]=0;   // podwojne konczace zero!
}

int TTurniejMenu::Wez(int x, int y)
{
 UstawWlk();
 { // inicjacja
 menu->InicjujZdarzeniem(ZDT_ZMIEN_GR+0);
 pargry.ile = 4;  // ile graczy
 TGraczO inic;   // inicjator
 inic.komputer=1;
 pargry.x=20;  pargry.y=20;
 pargry.zasady=gra.DZasadyGry();
 menu->InicjujZdarzeniem(ZDT_WLKX + pargry.x-min_bok_planszy);
 menu->InicjujZdarzeniem(ZDT_WLKY + pargry.y-min_bok_planszy);
 menu->InicjujZdarzeniem(ZDT_ZASADY + pargry.zasady);    
 for (int i=0; i<MAX_GRACZY_W_TURN; i++)
   {
   pargry.gr[i] = inic;
   WstawImie(i);
   menu->InicjujZdarzeniem(ZDT_BAZAGR*(i+1));
   aktywny[i] = (i<pargry.ile);
   }
 UaktNazwyGraczy(0);
 UaktLiczbeGraczy(0);
 }
 menu->Przesun(x,y);

 // glowna petla
 GrMouseEvent zdarz;
 menu->Rysuj();
 GrFlush();
 for (;;)
   {
   int zd=ZD_NIC;
   GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
   if (zdarz.flags & GR_M_KEYPRESS)
     zd=menu->DajZdarzenie(zdarz.key, zdarz.flags, -1000,-1000);
   else if (zdarz.flags & (GR_M_LEFT_DOWN  | GR_M_RIGHT_DOWN))
     zd=menu->DajZdarzenie(GrKey_Nieistniejacy, zdarz.flags, zdarz.x,zdarz.y);
   switch (zd)
     {
     case ZDT_ANULUJ:
       ekran.WyswietlWszystko();   // mozna lepiej, jesli wiadomo, gdzie sie wyswietlamy
       GrFlush();
       return 0;
     case ZDT_OK:
       Przenumeruj();
       for (int i=0; i<MAX_GRACZY_W_TURN; i++)
	 menu->InicjujZdarzeniem(ZDT_BAZAGR*(i+1));
       UaktNazwyGraczy();
       {
	 GrFilledBox(wsp[2], y, wsp[2]+SZER_FONTU*40, wsp[3], ekran.DajKolorTla());
	 TWezKalendarz wk;
	 TKalendarzRozgr kal;
	 int kr = wsp[80+4*MAX_GRACZY_W_TURN+4+1] - wsp[80+4*MAX_GRACZY_W_TURN+1];
	 wk.Wez(kal, wsp[2]+SZER_FONTU, wsp[80+4*MAX_GRACZY_W_TURN+1] - 3*kr-1, kr, pargry.ile);
       }
       ekran.WyswietlWszystko();   // mozna lepiej, jesli wiadomo, gdzie sie wyswietlamy
       GrFlush();
       return 1;
     case ZDT_ZASADY:
     case ZDT_ZASADY+1:
     case ZDT_ZASADY+2:
       pargry.zasady = zd-ZDT_ZASADY;
       break;
     case ZDT_PRZENUMERUJ:
       if (Przenumeruj())
         {
         for (int i=0; i<MAX_GRACZY_W_TURN; i++)
           menu->InicjujZdarzeniem(ZDT_BAZAGR*(i+1));
         UaktNazwyGraczy();
         // narysuj ostatniego z graczy
         menu->InicjujZdarzeniem(ZDT_ZMIEN_GR+pargry.ile-1);  // tutaj zawsze pargry.ile>=1
         menu->RysujJesliZdarzenie(ZDT_ZMIEN_GR+pargry.ile-1);
         }
       GrFlush();
       break;
     default:
       if (zd>=ZDT_GRACZ_NR && zd<ZDT_GRACZ_NR+2*MAX_GRACZY_W_TURN)
         {
         int nr=(zd-ZDT_GRACZ_NR)/2;
         if (aktywny[nr]) { aktywny[nr]=0;  pargry.ile--; }
           else           { aktywny[nr]=1;  pargry.ile++; }
         UaktLiczbeGraczy();
         }
       else if (zd>=ZDT_WLKX && zd<=ZDT_WLKX + max_bok_planszy-min_bok_planszy)
         { pargry.x = zd-ZDT_WLKX + min_bok_planszy; }
       else if (zd>=ZDT_WLKY && zd<=ZDT_WLKY + max_bok_planszy-min_bok_planszy)
         { pargry.y = zd-ZDT_WLKY + min_bok_planszy; }
       else if (zd>=ZDT_BAZAGR)
         {  // jakies zmiany w ustawieniu gracza
         int nr= zd/ZDT_BAZAGR -1;
         WstawImie(nr);
         menu->RysujJesliZdarzenie(ZDT_GRACZ_NR+2*nr);
         }
       GrFlush();
       break;
     }
   }
}

// ***************************
#define TWIERSZE_WLKX  50
#define TWIERSZE_WLKY  50
class TWiersze  {
  char wiersze[TWIERSZE_WLKY][TWIERSZE_WLKX+1];
  int  ile_wierszy;    // jest wpisanych do tablicy
  int  ost_wiersz;     // ostatni wpisany
  int  ile_na_ekranie; // ile wierszy do wysw., = max(ile_wierszy, ile_zny)
  int  ile_znx, ile_zny;   // ile znakow sie miesci na ekranie
  short int yinf, ywiersz0, dy;
  short int wsp[4];        // wspolrzedne glownego prostokata
  TKolor    ktla, ktekstu;
  int jest_naglowek; 
  public:
  TWiersze()  { ile_wierszy=0; };
  void Rysuj();
  void PoziomaLinia();    // dodaje pozioma linie: ,,--------''
  void DodajW(const char *w);  // ,,W'' na koncu nazwy pochodzi od ,,wierszy''
  void DopiszDoW(const char *w);
  void DopiszDoWZlam(const char *w);
  int  WezLiczbe();
  void WyczyscW();
  void Ustaw(short int x1, short int y1, short int x2, short int y2, int);
  void UstawKolory(TKolor tlo, TKolor tekst);
  };

void TWiersze::Ustaw(short int x1, short int y1, short int x2, short int y2,
              int naglowek=1)
{ wsp[0]=x1;  wsp[1]=y1;  wsp[2]=x2;  wsp[3]=y2;
 jest_naglowek=naglowek;
 if (jest_naglowek) {
   yinf     = y1 + WYS_FONTU/2;
   ywiersz0 = yinf + (3*WYS_FONTU)/2;
 }
 else ywiersz0 = yinf = y1 + WYS_FONTU/2;
 dy       = (5*WYS_FONTU)/4;
 ile_znx  = (x2-x1+1-(SZER_FONTU & ~1)) / SZER_FONTU;
 if (ile_znx>TWIERSZE_WLKX) ile_znx=TWIERSZE_WLKX;
 ile_zny  = (y2-ywiersz0+1 - WYS_FONTU/2) / dy;   // WYS_FONTU to margines na dole
 if (ile_zny>TWIERSZE_WLKY) ile_zny=TWIERSZE_WLKY;
 if (ile_na_ekranie>ile_zny) ile_na_ekranie=ile_zny;  // wazne gdy zmienia sie rozdzielczosc w trakcie gry
}

void TWiersze::UstawKolory(TKolor tlo, TKolor tekst)
{ ktla=tlo;  ktekstu=tekst; }

void TWiersze::PoziomaLinia()
{
 if (++ost_wiersz==TWIERSZE_WLKY) ost_wiersz=0;
 for (int i=0; i<TWIERSZE_WLKX; i++)
   wiersze[ost_wiersz][i]='-';
 wiersze[ost_wiersz][TWIERSZE_WLKX]=0;
 if (ile_wierszy<TWIERSZE_WLKY)
   if (++ile_wierszy<=ile_zny) ile_na_ekranie=ile_wierszy;
}

void TWiersze::DodajW(const char *w)
{
 // dopisz wiersz
 if (++ost_wiersz==TWIERSZE_WLKY) ost_wiersz=0;
 strncpy(wiersze[ost_wiersz], w, TWIERSZE_WLKX);
 wiersze[ost_wiersz][TWIERSZE_WLKX]=0;
 if (ile_wierszy<TWIERSZE_WLKY)
   if (++ile_wierszy<=ile_zny) ile_na_ekranie=ile_wierszy;
}

void TWiersze::DopiszDoW(const char *w)
{
 if (ile_wierszy)
   strncat(wiersze[ost_wiersz], w, TWIERSZE_WLKX);
 else
   { strncpy(wiersze[ost_wiersz=0], w, TWIERSZE_WLKX); ile_wierszy=1; ile_na_ekranie=1; }
 wiersze[ost_wiersz][TWIERSZE_WLKX]=0;
}

void TWiersze::DopiszDoWZlam(const char *w)
// dopisuje w na koniec, jesli sie zmiesci, jesli nie, to dopisuje nowy wiersz
{
 if (ile_wierszy)
   {
   if (strlen(w)+strlen(wiersze[ost_wiersz]) <= ile_znx)
     strcat(wiersze[ost_wiersz], w);
   else DodajW(w);
   }
 else {
   strncpy(wiersze[ost_wiersz=0], w, TWIERSZE_WLKX);
   wiersze[ost_wiersz][TWIERSZE_WLKX]=0;
   ile_wierszy=1; ile_na_ekranie=1;
 }
}

int  TWiersze::WezLiczbe()
// zwraca liczbe z przedzialu [0, 9999] lub -1 gdy nie wpisano
// wpisywana liczba miesci sie na koncu akt. wiersza
//   i wymaga 5 znakow miejsca (4 na liczbe + 1 na kursor)
{
 int kursor=0, wyjdz=0, wynik;
 int liczba=0;
 GrMouseEvent zdarz;
 int pokaz=1;
 GrFlush();
 for (;;)
   {
   // pokaz
   if (pokaz)
     {
     char s[22];
     strcpy(s, wiersze[ost_wiersz]);   // wez poczatek wiersza
     if (kursor)                       // pisz liczbe
       {
       char s2[20];
       sprintf(s2, "%d", int(liczba));
       strcat(s, s2);
       }
     strcat(s,"_");                       // rysuj kursor
     // wyczysc fragment ekranu
     int y= ywiersz0+dy*(ile_na_ekranie-1);
     GrFilledBox(wsp[0], y, wsp[2], y + WYS_FONTU, ktla);
     // wyswietl
     Wypisz(wsp[0]+SZER_FONTU/2, y, s, ktekstu, ktla, KR_ALIGN_LEFTTOP);
     pokaz=0;
     GrFlush();
     }
   // wez klawisz
   GrMouseGetEvent(GR_M_KEYPRESS, &zdarz);
   if (zdarz.key>='0' && zdarz.key<='9')
     {
     if (liczba<1000)   // da sie dopisac cyfre
       {
       if (liczba==0)
         {
         if (kursor==0)
           { kursor=1;  liczba=Konwersja(zdarz.key)-'0';  pokaz=1; }
         }
       else
         { kursor++;  liczba=liczba*10 + Konwersja(zdarz.key)-'0';  pokaz=1; }
       }
     }
   else switch (Konwersja(zdarz.key))
     {
     case GrKey_BackSpace:
       if (liczba<10)
         {
         if (kursor==1)
           { kursor=0;  liczba=0;  pokaz=1; }
         }
       else
         { liczba/=10;  kursor--;  pokaz=1; }
       break;
     case GrKey_Return:
       return liczba;
     case GrKey_Escape:
       return -1;
     }
   }
}

void TWiersze::WyczyscW()
{ wiersze[ost_wiersz][0]=0; }

void TWiersze::Rysuj()
{
 // z GrMouseBlock() sa klopoty pod mingw
 // int mysz=GrMouseBlock(NULL, wsp[0],wsp[1],wsp[2],wsp[3]);
 // wyczysc fragment ekranu
 GrFilledBox(wsp[0],wsp[1],wsp[2],wsp[3], ktla);
 // wyswietl
 if (ile_wierszy)
   {
   if (jest_naglowek)
     Wypisz((wsp[0]+wsp[2])/2, yinf, slowa["info.nagl"], ktekstu, ktla, KR_ALIGN_TOP);
   int ktory=ost_wiersz;
   for (int i=ile_na_ekranie-1; i>=0; i--)
     {
     char s = wiersze[ktory][ile_znx];   // zapamietaj znak
     wiersze[ktory][ile_znx]=0;          // utnij wiersz
     Wypisz(wsp[0]+SZER_FONTU/2, ywiersz0+i*dy, wiersze[ktory],
               ktekstu, ktla, KR_ALIGN_LEFTTOP);
     wiersze[ktory][ile_znx]=s;          // odtworz wiersz
     if (--ktory<0) ktory=TWIERSZE_WLKY-1;
     }
   }
 // koniec
 // GrMouseUnBlock(mysz);
}

class TWierszeInf : public TWiersze {
  int na_wierzchu;
public:
  void Rysuj() { if (na_wierzchu) TWiersze::Rysuj(); };
  TWierszeInf() : TWiersze() { na_wierzchu=1; };
  void Wlacz() { if (!na_wierzchu) { na_wierzchu=1; TWiersze::Rysuj(); } };
  void Wylacz() { na_wierzchu=0; };
};
  
// ***************************

class TPokazAnalize
{
  struct TWatek {
    TSekwencjaRuchow ruchy;
    int ocena;
    TStatystykaDlaAnalizy stat_pocz, stat_kon;
    int gleb, ile_ruchow, czy_jest;     // czy_jest==1: jest; ==-1: jest, ale nieaktualny
    int max_gleb;            // = glebokosc analizy + glebokosc sing. ext.
    char napis[15];
    int x1,y1,x2,y2;         // wspolrzedne PG, LD rogu
  } najlepszy, poprzedni;
  struct {
    TSekwencjaRuchow ruchy;
    int ocena, czy_jest, ile_ruchow;
  } kontynuacja[8];
  struct TTeraz {
    TJedenRuch ruch;
    int ktoryr, iler;
    int co;               // == 0: tekst, == 1: sekwencja ruchow
    char tekst[30];
    int x1,y1,x2,y2;         // wspolrzedne PG, LD rogu
  } teraz;
  char suma_napis[40];          // dolny wiersz z lacznym czasem i o+h
  struct {
    int pokazuj_an;
    int max_ruchow;
    short int wsp[4];
    int dy, yan;
    TKolor ktla, ktekstu;
    int na_wierzchu;     // czy widac analize?
  } wysw;                     // parametry wyswietlania
  int akt_gleb;               // dla funkcji OcenionyRuch()
  TStoper st_minimax, st_gleb; 
  int ost_gleb;               // dla funkcji NowyRuch()
  int odswiez_sek, odswiez_ssek;
  int odswiez_suma_sek, odswiez_suma_ssek;
  int prog_ssek, prog_suma_ssek;
  int spr_klaw;               // do spr. klawiatury (na zewnatrz TPokazAnalize())
  TStatystykaDlaAnalizy stat_gleb, stat_minimax;
  TWiersze *wiersze;
  struct TOpcje {
    short int wsp[58];
    TKolor kol[3];
    static const char* napisy[12];
  } opcje;
  void PokazWatek(const TWatek &w, int);
  void PokazTeraz();
  void PokazOstGleb(int gleb);
  int  PokazSume(int spr=1);
  void RysujSume();
 public:
  TPokazAnalize();
  ~TPokazAnalize() { delete wiersze; };
  void Ustaw(short int x1, short int y1, short int x2, short int y2);
  void UstawKolory(TKolor tlo, TKolor tekst);
  void Rysuj();
  void Poczatek();
  void MinimaxPoczatek();
  void JeszczeRazAktGleb();
  void OcenionyRuch(int gleb, int maxg, int ocena, TSekwencjaRuchow *r, int ile_r);
  void NowyRuch(int gleb, TJedenRuch r, int ktoryr, int ile_pierw_r, int ile_r);
  void WyswietlUCT(char **s, int n);
  void Koniec();
  void Wlacz() { if (!wysw.na_wierzchu) { wysw.na_wierzchu=1; Rysuj(); }};
  void Wylacz() { wysw.na_wierzchu=0; };
  int CzyNaWierzchu() { return wysw.na_wierzchu; };
  int DowiazOpcje(TElMenu *&wsk, int x1, int x2, int y, 
		  int wys_przyc, int odstep_przyc, int marg, TKolor*);
  void UstawOpcje(TElMenu*);
  void UstawOpcje(TSlowa&);
  int  CzyJuzSprKlaw();
};

const char* TPokazAnalize::TOpcje::napisy[12] = {
  "$opcje.wyswA", "$opcje.nwyswA",
  "$opcje.max_watek", "1", "2", "3", "4",
  "$opcje.akt_ruch",
  "$opcje.co1/4s", "$opcje.co1/2s", "$opcje.co1s",
  "$opcje.laczny" };

int TJedenRuch::operator==(const TJedenRuch r)
{ return (r.x==x && r.y==y); }

TJedenRuch::TJedenRuch(int nx, int ny, int nile_zam) { x=nx; y=ny; ile_zam=nile_zam; };
TJedenRuch::TJedenRuch() {};

TPokazAnalize::TPokazAnalize()
{
  teraz.co=0;  teraz.tekst[0]=0;
  wysw.pokazuj_an=1;  wysw.max_ruchow=2;
  wysw.na_wierzchu=0;
  najlepszy.czy_jest=0;
  poprzedni.czy_jest=0;
  strcpy(najlepszy.napis, "Najlepszy");  // tak ma byc! -- pozniej jest slowa[napis]
  strcpy(poprzedni.napis, "Poprzedni");  //
  suma_napis[0]=0;
  prog_ssek=100; prog_suma_ssek=100;
  wiersze = new TWiersze;
}

void TPokazAnalize::Ustaw(short int x1, short int y1, short int x2, short int y2)
{ wysw.wsp[0]=x1;  wysw.wsp[1]=y1;  wysw.wsp[2]=x2;  wysw.wsp[3]=y2;
  wysw.dy      = (5*WYS_FONTU)/4;
  wysw.yan = y1+WYS_FONTU;
  teraz.x1 = najlepszy.x1 = poprzedni.x1 = x1;
  teraz.x2 = najlepszy.x2 = poprzedni.x2 = x2;
  najlepszy.y1 = wysw.yan + (3*WYS_FONTU)/2;
  najlepszy.y2 = najlepszy.y1+WYS_FONTU+3*wysw.dy;
  poprzedni.y1 = najlepszy.y2+1;
  poprzedni.y2 = poprzedni.y1+WYS_FONTU+3*wysw.dy;  
  teraz.y1     = poprzedni.y2+1;
  teraz.y2     = teraz.y1 + WYS_FONTU/2 +2*wysw.dy;
  wiersze->Ustaw(x1, teraz.y2 +1, x2, y2-wysw.dy-2, 0);  // jesli
  // zmieniasz powyzej czwarty parametr (y2), zmien tez PokazSume()
}

void TPokazAnalize::UstawKolory(TKolor tlo, TKolor tekst)
{
  wysw.ktla=tlo;  
  wysw.ktekstu = tekst;
  wiersze->UstawKolory(tlo, tekst);
}

void TPokazAnalize::PokazWatek(const TWatek &w, int pokazuj_stat=1)
{
  if (!wysw.na_wierzchu) return;
  GrFilledBox(w.x1,w.y1,w.x2,w.y2, wysw.ktla);
  if (w.czy_jest) {
    int y=w.y1;
    char s[40];
    sprintf(s, "%s (%d):", slowa[w.napis], w.ocena);
    Wypisz(w.x1+SZER_FONTU/2,y, s, wysw.ktekstu, wysw.ktla, KR_ALIGN_LEFTTOP);
    sprintf(s, "%d%+d: ", w.gleb, w.max_gleb-w.gleb);
    char rt[10];
    for (int i=0; i<w.ile_ruchow; i++)
      sprintf(&s[strlen(s)], "%s%c", TEkran::RuchTekst(rt, w.ruchy.r[i].x, w.ruchy.r[i].y),
	      w.ruchy.r[i].ile_zam ? '+':' ');
    Wypisz(w.x1+SZER_FONTU/2,y+=wysw.dy, s, wysw.ktekstu, wysw.ktla, KR_ALIGN_LEFTTOP);
    /*
    // test:
    if (&w==&najlepszy) {
      FILE *f=fopen("test","a+");
      fprintf(f,"%s ocena=%d\n",s,int(w.ocena));
      fclose(f);
      } */
    if (pokazuj_stat) {
      char ot[20], ht[20];
      {
	long long int ileo = w.stat_kon.funk_ocen - w.stat_pocz.funk_ocen;
#ifdef __MINGW32__
	if (ileo>=1000000000l) sprintf(ot, "%I64dk", (long long) ((ileo+500)/1000));
	else sprintf(ot, "%ld", long(ileo));
#else
	if (ileo>=1000000000l) sprintf(ot, "%lldk", (long long) ((ileo+500)/1000));
	else sprintf(ot, "%ld", long(ileo));
#endif
	long long int ileh = w.stat_kon.wez_ht - w.stat_pocz.wez_ht;
#ifdef __MINGW32__
	if (ileh>=1000000000l) sprintf(ht, "%I64dk", (long long) ((ileh+500)/1000));
	else sprintf(ht, "%ld", long(ileh));
#else
	if (ileh>=1000000000l) sprintf(ht, "%lldk", (long long) ((ileh+500)/1000));
	else sprintf(ht, "%ld", long(ileh));
#endif
      }
      sprintf(s,"o=%s, h=%s", ot, ht);
      Wypisz(w.x1+SZER_FONTU/2,y+=wysw.dy, s, wysw.ktekstu, wysw.ktla, KR_ALIGN_LEFTTOP);
    }
  }
}

void TPokazAnalize::PokazTeraz()
{
  if (!wysw.na_wierzchu) return;
  GrFilledBox(teraz.x1,teraz.y1,teraz.x2,teraz.y2, wysw.ktla);
  if (teraz.co==0) {
    Wypisz(teraz.x1+SZER_FONTU/2,teraz.y1, teraz.tekst, 
	      wysw.ktekstu, wysw.ktla, KR_ALIGN_LEFTTOP);
  }
  else {
    Wypisz(teraz.x1+SZER_FONTU/2,teraz.y1, slowa["an.Teraz"],
	      wysw.ktekstu, wysw.ktla, KR_ALIGN_LEFTTOP);
    char s[40], rt[10];
    sprintf(s, "%d: %s%c - %s %d/%d", ost_gleb,
	    TEkran::RuchTekst(rt, teraz.ruch.x, teraz.ruch.y),
	    teraz.ruch.ile_zam ? '+':' ',
	    slowa["an.ruchnr"], teraz.ktoryr+1,teraz.iler);
    Wypisz(teraz.x1+SZER_FONTU/2,teraz.y1+wysw.dy, s, 
	      wysw.ktekstu, wysw.ktla, KR_ALIGN_LEFTTOP);
  }
  GrFlush();
}

void TPokazAnalize::Rysuj()
{
  if (!wysw.na_wierzchu) return;
  GrFilledBox(wysw.wsp[0],wysw.wsp[1],wysw.wsp[2],wysw.wsp[3], wysw.ktla);
  Wypisz((wysw.wsp[0]+wysw.wsp[2])/2, wysw.yan, slowa["an.nagl"], wysw.ktekstu, wysw.ktla, KR_ALIGN_TOP);
  PokazTeraz();  
  PokazWatek(najlepszy);
  // tutaj nie trzeba rysowac obwodki, bo ta funkcja nigdy nie jest wywolywana
  // podczas trwania analizy (a tylko wtedy jest rysowana obwodka)
  PokazWatek(poprzedni);
  wiersze->Rysuj();
  RysujSume();
}

void TPokazAnalize::Poczatek()
{
  if (!wysw.pokazuj_an) return;
  strcpy(teraz.tekst, slowa["an.Inic"]);
  teraz.co=0;
  najlepszy.czy_jest=0;
  poprzedni.czy_jest=0;
  Rysuj();
}

void TPokazAnalize::MinimaxPoczatek()
{ // tu mozna by mierzyc czas inicjacji
  if (!wysw.pokazuj_an) return;
  stat_minimax = stat_gleb = poprzedni.stat_kon = statystyka_dla_analizy;
  for (int i=0; i<8; i++) kontynuacja[i].czy_jest=0;
  ost_gleb=akt_gleb=0;
  st_minimax.Stop();
  st_gleb.Stop();
  odswiez_sek = odswiez_ssek = 0;
  odswiez_suma_sek = 0;
  odswiez_suma_ssek = prog_suma_ssek;
  spr_klaw=1;        // ustaw sprawdzanie klawiatury
  st_minimax.Start();
  st_gleb.Start();
}

void TPokazAnalize::JeszczeRazAktGleb()
{
  // zeruj watki kontynuacji
  for (int i=0; i<8; i++) kontynuacja[i].czy_jest=0;
  if (najlepszy.czy_jest==1) najlepszy.czy_jest=-1;  // zaznacz, ze nieaktualny
}

void TPokazAnalize::OcenionyRuch(int gleb, int maxg, int ocena, TSekwencjaRuchow *ruchy, int ile_r)
{
  /*
  FILE *f=fopen("krdeb.txt","a+t");
  fprintf(f,"g=%d/%d ",gleb,maxg);
  for (int i=0; i<ile_r; i++)
    fprintf(f, "(%d,%d)%c", int(ruchy->r[i].x), int(ruchy->r[i].y),
      ruchy->r[i].ile_zam ? '+':' ' );
  fprintf(f, "  o=%d.\n",ocena);
  fclose(f);
  */
  if (!wysw.pokazuj_an || ile_r>wysw.max_ruchow) return;
  if (akt_gleb != gleb) {
    akt_gleb = gleb;
    // zeruj watki kontynuacji
    for (int i=0; i<8; i++) kontynuacja[i].czy_jest=0;
    // dodaj akt. watek
    kontynuacja[ile_r].czy_jest=1;
    kontynuacja[ile_r].ruchy = *ruchy;
    kontynuacja[ile_r].ile_ruchow = ile_r;
    kontynuacja[ile_r].ocena = ocena;
  }
  else if (ile_r>1) {
    if (ocena>kontynuacja[ile_r].ocena || !kontynuacja[ile_r].czy_jest) {
      // zapamietaj aktualna kontynuacje
      if (kontynuacja[ile_r+1].czy_jest) {
	kontynuacja[ile_r] = kontynuacja[ile_r+1];
	for (int i=ile_r+1; i<8; i++)
	  kontynuacja[i].czy_jest = 0;
      } 
      else {
	kontynuacja[ile_r].czy_jest=1;
	kontynuacja[ile_r].ruchy = *ruchy;
	kontynuacja[ile_r].ile_ruchow = ile_r;
      }
      kontynuacja[ile_r].ocena = ocena;   // w [ile_r+1] mogla byc -ocena
    }
    else
      for (int i=ile_r+1; i<8; i++)
	kontynuacja[i].czy_jest = 0;
  }
  else {  // ile_r==1
    if (kontynuacja[2].czy_jest && kontynuacja[2].ruchy.r[0]==ruchy->r[0]) {
      kontynuacja[1] = kontynuacja[2];
      for (int i=2; i<8; i++)
	kontynuacja[i].czy_jest = 0;
    }
    else {
      kontynuacja[1].czy_jest=1;
      kontynuacja[1].ruchy = *ruchy;
      kontynuacja[1].ile_ruchow = 1;
    }
    kontynuacja[1].ocena = ocena;
  }
  // zapamietaj ruch w poprzednim i w byc moze najlepszym
  if (ile_r==1) {
    poprzedni.ruchy = kontynuacja[1].ruchy;
    poprzedni.ocena = kontynuacja[1].ocena;
    poprzedni.ile_ruchow= kontynuacja[1].ile_ruchow;
    poprzedni.czy_jest  = 1;   
    poprzedni.stat_pocz = poprzedni.stat_kon;
    poprzedni.stat_kon  = statystyka_dla_analizy;
    poprzedni.gleb      = gleb;
    poprzedni.max_gleb  = maxg;
    PokazWatek(poprzedni);
    if (ocena>najlepszy.ocena || gleb>najlepszy.gleb || najlepszy.czy_jest!=1) {
      if (wysw.na_wierzchu && najlepszy.czy_jest)
	ekran.WyswietlObwodke(najlepszy.ruchy.r[0].x, najlepszy.ruchy.r[0].y, 0);
      najlepszy.ruchy = kontynuacja[1].ruchy;
      najlepszy.ocena = kontynuacja[1].ocena;
      najlepszy.ile_ruchow= kontynuacja[1].ile_ruchow;
      najlepszy.czy_jest  = 1;   
      najlepszy.stat_pocz = poprzedni.stat_pocz;
      najlepszy.stat_kon  = poprzedni.stat_kon;
      najlepszy.gleb      = gleb;
      najlepszy.max_gleb  = maxg;
      PokazWatek(najlepszy);
      if (wysw.na_wierzchu)
	ekran.WyswietlObwodke(najlepszy.ruchy.r[0].x, najlepszy.ruchy.r[0].y, 1);
    }
    if (wysw.na_wierzchu) GrFlush();
  }
}

void TPokazAnalize::PokazOstGleb(int gleb)
{
  char s[40], cz[15];
  st_gleb.Stop();
  //sprintf(s, "%d: %ss", gleb-2, st_gleb.IleTrwalo(cz));
  //wiersze->DodajW(s);
  //sprintf(s,"   o=%ld, h=%ld", long(statystyka_dla_analizy.funk_ocen - stat_gleb.funk_ocen),
  //	  long(statystyka_dla_analizy.wez_ht -stat_gleb.wez_ht ));
  char ot[20], ht[20];
  {
  long long int ileo = statystyka_dla_analizy.funk_ocen - stat_gleb.funk_ocen;
#ifdef __MINGW32__
  if (ileo>=1000000l) sprintf(ot, "%I64dk", (long long) ((ileo+500)/1000));
  else sprintf(ot, "%ld", long(ileo));
#else
  if (ileo>=1000000l) sprintf(ot, "%lldk", (long long) ((ileo+500)/1000));
  else sprintf(ot, "%ld", long(ileo));
#endif
  long long int ileh = statystyka_dla_analizy.wez_ht -stat_gleb.wez_ht;
#ifdef __MINGW32__
  if (ileh>=1000000l) sprintf(ht, "%I64dk", (long long) ((ileh+500)/1000));
  else sprintf(ht, "%ld", long(ileh));
#else
  if (ileh>=1000000l) sprintf(ht, "%lldk", (long long) ((ileh+500)/1000));
  else sprintf(ht, "%ld", long(ileh));
#endif
  }
  //  stare: sprintf(s,"%d: %ss o=%s h=%s",  gleb-1, st_gleb.IleTrwalo(cz), ot, ht);
  sprintf(s,"%d: ", gleb-1);
  if (najlepszy.czy_jest) {
    char rt[10];
    sprintf(&s[strlen(s)],"%s%c",
	    TEkran::RuchTekst(rt, najlepszy.ruchy.r[0].x, najlepszy.ruchy.r[0].y),
	    najlepszy.ruchy.r[0].ile_zam ? '+':' ');
  }
  strcat(s, st_gleb.IleTrwalo(cz));
  strcat(s, "s");
  wiersze->DodajW(s);
  sprintf(s," o=%s h=%s", ot, ht);
  wiersze->DopiszDoWZlam(s);
  stat_gleb = statystyka_dla_analizy;
  if (wysw.na_wierzchu) wiersze->Rysuj();
  ost_gleb=gleb;
  st_gleb.Start();
}

void TPokazAnalize::NowyRuch(int gleb, TJedenRuch r, int ktoryr, int ile_pierw_r, int ile_r)
{
  if (!wysw.pokazuj_an || ile_r>wysw.max_ruchow) return;
  int pokaz=0;
  if (gleb>ost_gleb) { PokazOstGleb(gleb); pokaz=1; }
  if (!pokaz)
    if (st_minimax.CzyJuz(odswiez_sek, odswiez_ssek))
      { pokaz=1;  spr_klaw=1;
      if ((odswiez_ssek+=prog_ssek)>=100) {
	odswiez_ssek-=100;  odswiez_sek++;
      }
      }
  if (PokazSume() && !pokaz && wysw.na_wierzchu) GrFlush();
  if (pokaz) {
    teraz.iler  = ile_pierw_r;
    teraz.ruch  = r;
    teraz.ktoryr= ktoryr;
    teraz.co   = 1;
    PokazTeraz();
  }
}

void TPokazAnalize::RysujSume()
{
  GrFilledBox(wysw.wsp[0], wysw.wsp[3]-wysw.dy-1, wysw.wsp[2], wysw.wsp[3], wysw.ktla);
  Wypisz(wysw.wsp[0]+SZER_FONTU/2, wysw.wsp[3]-1, suma_napis,
	    wysw.ktekstu, wysw.ktla, KR_ALIGN_LEFTBOTTOM);
}

int TPokazAnalize::PokazSume(int spr)
  // zwraca 1, gdy trzeba wywolac GrFlush()
{
  if (spr)
    if (st_minimax.CzyJuz(odswiez_suma_sek, odswiez_suma_ssek)) {
      spr_klaw=1;
      if ((odswiez_suma_ssek+=prog_suma_ssek)>=100) {
	odswiez_suma_ssek-=100;  odswiez_suma_sek++;
      }
    }
    else return 0;
  // pokaz sume
  char cz[15];
  long long int ifo = statystyka_dla_analizy.funk_ocen - stat_minimax.funk_ocen;
  long long int iht = statystyka_dla_analizy.wez_ht -stat_minimax.wez_ht;
  int setnych;
  int sekund = st_minimax.IleTrwalo(setnych);
  long long int pozycji = ifo+iht;
  int szybkosc = (sekund+setnych) ? (pozycji/ (100*sekund+setnych)) : 0;
#ifdef __MINGW32__
  sprintf(suma_napis,"%d.%02ds o+h=%I64d %d.%d k/s", sekund, setnych, pozycji,
	  szybkosc/10, szybkosc%10);
#else
  sprintf(suma_napis,"%d.%02ds o+h=%lld %d.%d k/s", sekund, setnych, pozycji,
	  szybkosc/10, szybkosc%10);
#endif
  if (!wysw.na_wierzchu) return 0;
  RysujSume();
  if (spr) GrFlush();
  return !spr;
}


void TPokazAnalize::WyswietlUCT(char **s, int n)
// s==NULL = koniec analizy
{ 
  spr_klaw=1;        // ustaw sprawdzanie klawiatury
  if (!wysw.pokazuj_an || !wysw.na_wierzchu) return;
  if (s!=NULL) {
    GrFilledBox(wysw.wsp[0], wysw.wsp[1], wysw.wsp[2], wysw.wsp[3], wysw.ktla);
    int y=wysw.wsp[1] + WYS_FONTU;
    for (int i=0; i<n; i++) {
      Wypisz(wysw.wsp[0]+SZER_FONTU/2, y, s[i], wysw.ktekstu, wysw.ktla, KR_ALIGN_LEFTTOP);
      y+=wysw.dy;
    }
    if (PokazSume(0))
      GrFlush();
  }
  else {   // s==NULL, czyli koniec analizy
    st_minimax.Stop();
    PokazSume(1);
    spr_klaw = 0;
  }
}

void TPokazAnalize::Koniec()
{
  if (!wysw.pokazuj_an) return;
  st_minimax.Stop();
  if (wysw.na_wierzchu && najlepszy.czy_jest)
    ekran.WyswietlObwodke(najlepszy.ruchy.r[0].x, najlepszy.ruchy.r[0].y, 0);
  strcpy(teraz.tekst, slowa["an.kon"]);
  if (ost_gleb) {
    PokazOstGleb(ost_gleb+1);
    char s[40];
    PokazSume(0);
    long long int ifo = statystyka_dla_analizy.funk_ocen - stat_minimax.funk_ocen;
    long long int iht = statystyka_dla_analizy.wez_ht -stat_minimax.wez_ht;
#ifdef __MINGW32__
    sprintf(s,"%s o=%I64d, h=%I64d", slowa["Razem"], ifo, iht);
#else
    sprintf(s,"%s o=%lld, h=%lld", slowa["Razem"], ifo, iht);
#endif
    wiersze->DodajW(s);
    if (wysw.na_wierzchu) wiersze->Rysuj();
  }
  teraz.co=0;
  PokazTeraz();
}

int TPokazAnalize::DowiazOpcje(TElMenu *&wsk, int x1, int x2, int y, 
			       int wys_przyc, int odstep_przyc, int marg, TKolor *kolory)
{
  wsk->nast = new TWyborPrzycisku(&opcje.wsp[0], TEkran::kolory_wybor_przycisku, opcje.napisy, 2, ZD_POKAZ_AN);
  wsk=wsk->nast;
  {
    TElMenu *pom;
    pom = new TNapis(&opcje.wsp[8], opcje.kol, opcje.napisy[2], KR_ALIGN_LEFTTOP);
    ((TWyborPrzycisku*) wsk)->DodajDziecko(0, pom);
    pom->nast = new TWyborPrzycisku(&opcje.wsp[10], TEkran::kolory_wybor_przycisku, &opcje.napisy[3], 4, ZD_ILE_R_W_WATKU);
    pom = pom->nast;
    pom->nast = new TNapis(&opcje.wsp[26], opcje.kol, opcje.napisy[7], KR_ALIGN_LEFTTOP);
    pom = pom->nast;
    pom->nast = new TWyborPrzycisku(&opcje.wsp[28], TEkran::kolory_wybor_przycisku,
				    &opcje.napisy[8], 3, ZD_ODSW_AKT_WATKU);
    pom = pom->nast;
    pom->nast = new TNapis(&opcje.wsp[40], opcje.kol, opcje.napisy[11], KR_ALIGN_LEFTTOP);
    pom = pom->nast;
    pom->nast = new TWyborPrzycisku(&opcje.wsp[42], TEkran::kolory_wybor_przycisku,
				    &opcje.napisy[8], 3, ZD_ODSW_LACZNY_CZAS);
    // dodaj czysczenie
    pom = new TProstokat(&opcje.wsp[54], opcje.kol);
    ((TWyborPrzycisku*) wsk)->DodajDziecko(1, pom);
  }
  wsk->InicjujZdarzeniem(ZD_POKAZ_AN + 1-wysw.pokazuj_an);
  wsk->InicjujZdarzeniem(ZD_ILE_R_W_WATKU + wysw.max_ruchow-1);
  wsk->InicjujZdarzeniem(ZD_ODSW_AKT_WATKU + (prog_ssek>50) + (prog_ssek>25));
  wsk->InicjujZdarzeniem(ZD_ODSW_LACZNY_CZAS + (prog_suma_ssek>50) + (prog_suma_ssek>25));
  for(int i=0; i<3; i++) opcje.kol[i]=kolory[i];
  opcje.wsp[0] = x1+marg;
  opcje.wsp[1] = y+=WYS_FONTU+odstep_przyc;
  opcje.wsp[4] = opcje.wsp[2] = (x1+x2)/2;
  opcje.wsp[5] = y;
  opcje.wsp[6] = x2-marg;
  opcje.wsp[3] = opcje.wsp[7] = y+=wys_przyc;
  // napis: Maksymalna liczba ruchow w watku
  opcje.wsp[8] = x1+marg;
  opcje.wsp[9] = y+=odstep_przyc+WYS_FONTU;
  y+=WYS_FONTU+odstep_przyc;
  // Liczby ruchow: 1,2,3,4
  for (int i=0; i<4; i++) {
    opcje.wsp[10+4*i] = x1+marg+i*3*SZER_FONTU;  //((x1+marg)*(4-i) + (x2-marg)*i) / 4;
    opcje.wsp[11+4*i] = y;
    opcje.wsp[12+4*i] = x1+marg+(i+1)*3*SZER_FONTU; //((x1+marg)*(3-i) + (x2-marg)*(i+1)) / 4;
    opcje.wsp[13+4*i] = y+wys_przyc;
  }
  // napis: Wyswietlaj akt. analizowany ruch
  opcje.wsp[26] = x1+marg;
  opcje.wsp[27] = y+=wys_przyc+odstep_przyc+WYS_FONTU;
  y+=WYS_FONTU+odstep_przyc;
  // Czas odswiezania: 0.25, 0.5, 1 sekunda
  for (int i=0; i<3; i++) {
    opcje.wsp[42+4*i] = opcje.wsp[28+4*i] = ((x1+marg)*(3-i) + (x2-marg)*i) / 3;
    opcje.wsp[29+4*i] = y;
    opcje.wsp[44+4*i] = opcje.wsp[30+4*i] = ((x1+marg)*(2-i) + (x2-marg)*(i+1)) / 3;
    opcje.wsp[31+4*i] = y+wys_przyc;
  }
  // napis: Wyswietlaj laczny czas
  opcje.wsp[40] = x1+marg;
  opcje.wsp[41] = y+=wys_przyc+odstep_przyc+WYS_FONTU;
  y+=WYS_FONTU+odstep_przyc;
  // Czas odswiezania: 0.25, 0.5, 1 sekunda, tylko wsp. y (x sa wczesniej)
  for (int i=0; i<3; i++) {
    opcje.wsp[43+4*i] = y;
    opcje.wsp[45+4*i] = y+wys_przyc;
  }
  // czyszczenie
  opcje.wsp[54]=x1;  opcje.wsp[56]=x2;
  opcje.wsp[55]=opcje.wsp[3]+1;
  opcje.wsp[57]=opcje.wsp[45]+1;
  y+=wys_przyc+odstep_przyc;
  return y;
}

void TPokazAnalize::UstawOpcje(TElMenu *menu)
{
  wysw.pokazuj_an = 1-(menu->DajWartosc(ZD_POKAZ_AN)-ZD_POKAZ_AN);
  // wlacz chwilowo pokazywanie analizy, zeby dostac poprawne
  // wartosci roznych parametrow (mozna by tez nie zmieniac wartosci
  // tych parametrow przy wylaczonej analizie)
  menu->InicjujZdarzeniem(ZD_POKAZ_AN);
  wysw.max_ruchow = menu->DajWartosc(ZD_ILE_R_W_WATKU) -ZD_ILE_R_W_WATKU +1;
  const static int tabelka[3]= {25,50,100};
  prog_ssek       = tabelka[menu->DajWartosc(ZD_ODSW_AKT_WATKU) - ZD_ODSW_AKT_WATKU];
  prog_suma_ssek  = tabelka[menu->DajWartosc(ZD_ODSW_LACZNY_CZAS) - ZD_ODSW_LACZNY_CZAS];
}

void TPokazAnalize::UstawOpcje(TSlowa &opcje)
{
  int pom;
  pom = atoi(opcje["analiza.dlug_watku"]);
  if (pom>=1 && pom<=4) wysw.max_ruchow=pom;
  pom = atoi(opcje["analiza.odsw_akt_ruch"]);
  if (pom==25 || pom==50 || pom==100)  prog_ssek=pom;
  pom = atoi(opcje["analiza.odsw_laczny_czas"]);
  if (pom==25 || pom==50 || pom==100)  prog_suma_ssek=pom;
}

int TPokazAnalize::CzyJuzSprKlaw()
{
  if (spr_klaw) {
    spr_klaw=0;
    return 1;
  }
  return 0;
}

// ***************************
int kolory_rgb_stand[4][KOLOR_OSTATNI+1] = {
  {
    0xfcfc54, 0x545454, 0xa8a8a8, 0x34a8c8, 0xd06c4c,
    0x4ecc4e, 0x276627, 0x545454, 0, 0,
    0x545454, 0xa8a8a8, 0, 0xfcfc54, 0x1f6478, 0x864531, 0, 0xa8a8a8,
    0xffffff, 0xc7c7c7, 0x555555, 0, 0xefefef,
    0x888888, 0xe8e8e8, 0x444444, 0x888888},
  { 0xfcfc54, 0x777777, 0xcccccc, 0x00008b, 0xb22222,
    0x4ecc4e, 0x276627, 0xcccccc, 0xaaaaaa, 0,
    0x777777, 0xcccccc, 0, 0xfcfc54, 0xbbbbff, 0xddc4c4, 0, 0,
    0xffffff, 0xc7c7c7, 0x555555, 0, 0xefefef,
    0x888888, 0xe8e8e8, 0x444444, 0x888888},
  { 0xfcfc54, 0x777777, 0xdcd4c9, 0x0736bc, 0xcb0a0a,
    0x4ecc4e, 0x276627, 0xffffff, 0xcecfce, 0,
    0x888888, 0xdcd4c9, 0, 0, 0xe8ecf8, 0xfae8e8, 0, 0,
    0xffffff, 0xc7c7c7, 0x555555, 0, 0xefefef,
    0x888888, 0xe8e8e8, 0x444444, 0x888888}};
const char *kolory_rgb_stand_nazwy[4] = {"$opcje.kolory1\0", "$opcje.kolory2\0", "$opcje.kolory3\0", "$opcje.kolory4\0"};


TEkran::TEkran()
{
#ifdef XWIN_BEZ_GRX
 paleta=1;
#else
 paleta=3;      // pod grx ustaw palete z pliku, bo nie da sie zmieniac kolorow...
#endif
 anty_idle.Start();
 czy_anty_idle=0;
 opcje_zaawansowane=0;
 czcionka_bold=1;
 // inicjuj kolory_rgb:
  for (int i=0; i<KOLOR_OSTATNI+1; i++)
    kolory_rgb[i] = kolory_rgb_stand[paleta][i];
  /*
 kolory_rgb[0]= 0xfcfc54;   //  kolor_zolty / YELLOW
 kolory_rgb[1]= 0x545454;   //  kolor_tla / DARKGRAY
 kolory_rgb[2]= 0xa8a8a8;   //  kolor_menu / LIGHTGRAY
 kolory_rgb[3]= 0xd06c4c;   //  kolor1 / ceglasty
 kolory_rgb[4]= 0x34a8c8;   //  kolor2 / blekitny
 kolory_rgb[5]= 0x4ecc4e;   //  kolor_zielony
 kolory_rgb[6]= 0x276627;   //  kolor_zielony_tla
 kolory_rgb[7]= 0x545454;   //  kolor_tla_planszy
 kolory_rgb[8]= 0;          //  kolor_kratek
 kolory_rgb[9]= 0;          //  kolor_wyl_menu
 kolory_rgb[10]= 0x545454;  //  kolor_tla_gr / DARKGRAY
 kolory_rgb[11]= 0xa8a8a8;  //  kolor_menu_gr / LIGHTGRAY
 kolory_rgb[12]= 0;         //  kolor_wyl_menu_gr
 kolory_rgb[13]= 0xfcfc54;  //  kolor_obwodki / YELLOW
 kolory_rgb[14]= 0x864531;   //  kolor1_cien / ciemnoceglasty
 kolory_rgb[15]= 0x1f6478;   //  kolor2_cien / ciemnoblekitny
 kolory_rgb[16]= 0;          //  kolor_ramki
  [17] kolor wspolrzednych
  */
 //
 plansza = new TRysujPlansze;
 gracze = new TRysujGraczy;
 pliki_menu = new TPlikiMenu;
 turniej_menu = new TTurniejMenu;
 informacje = new TWierszeInf;
 analiza = new TPokazAnalize;
 krotkie_imie=1;
 jaki_font=0;
}

void TEkran::SkonstruujMenu()
{
 // skonstruuj glowne_menu
 static const char *napisy[] = {"Kropki", "$menu.Kon", "$menu.Ngr", "$menu.Opr",
      "$menu.Odc", "$menu.Zap", "$menu.OpW",
      "$menu.blok0a\0$menu.blok0b", "$menu.blok1a\0$menu.blok1b", "$menu.Tryb",
      "$menu.Gra", "$menu.Edycja", "$menu.Tur", "$menu.TestS",
      "$menu.Pauza\0", "$menu.Pauza\0", "$menu.Info", 
      "$menu.An", "$menu.Stop\0", "$menu.Stop\0",
      "*", "$menu.RTekst", "X", "O"};   // [19-22]
 //      "$menu.Gra", "$menu.Edycja"};    // [23-24]
 //
 TElMenu *wsk = glowne_menu = new TProstokat(&wgm[0], &kgm[0]);
 wsk->nast = new TNapis(&wgm[4], &kgm[0], napisy[0], KR_ALIGN_LEFT);
 wsk=wsk->nast;
 // dorob 6 przyciskow:
 int zdarzgm[6]={ZD_KONIEC, ZD_NOWAGRA, ZD_OPROGRAMIE,
                 ZD_ODCZYT, ZD_ZAPIS, ZD_OPCJEW};
 TKlawisz klawgm[12] = {GrKey_Escape, GrKey_Brak, GrKey_Brak, GrKey_Brak,
                 GrKey_Brak, GrKey_Brak, GrKey_o, GrKey_O,
                 GrKey_z, GrKey_Z, GrKey_Brak, GrKey_Brak };
 short int pomocgm[6] = {-1,-1,POMOC_OPROGR,-1,-1,-1};
 for (int i=1; i<=6; i++)
   {
   wsk->nast = new TPrzycisk(&wgm[2+i*4], TEkran::kolory_przycisku, napisy[i],
                             zdarzgm[i-1], klawgm[2*i-2],klawgm[2*i-1],pomocgm[i-1]);
   wsk=wsk->nast;
   }
 if (opcje_zaawansowane) {
   // dorob przycisk blokady
   wsk->nast = new TPrzyciskKilkaOpcjiOpozn(&wgm[30], TEkran::kolory_przycisku_kilka_opcji,
					    &napisy[7], 2, ZD_BLOKADA, POMOC_BLOKAD);
   wsk=wsk->nast;
 }
 // dorob napis ,,tryb''
 wsk->nast = new TNapis(&wgm[34], &kgm[0], napisy[9]);
 wsk=wsk->nast;
 if (opcje_zaawansowane) {
   // dorob 4 przyciski wyboru trybu
   wsk->nast = new TWyborPrzyciskuOpozn(&wgm[36], TEkran::kolory_wybor_przycisku, &napisy[10], 4, ZD_TRYB, POMOC_TRYB);
   wsk=wsk->nast;
 }
 /*
 else {
   // dorob 2 przyciski wyboru trybu
   wsk->nast = new TWyborPrzyciskuOpozn(&wgm[36], TEkran::kolory_wybor_przycisku, &napisy[10], 2, ZD_TRYB, POMOC_TRYB);
   wsk=wsk->nast;
 }
 */
 // i przycisk pauzy
 wsk->nast = new TPrzyciskKilkaOpcjiOpozn(&wgm[52], TEkran::kolory_przycisku_kilka_opcji, &napisy[14], 2,
                                          ZD_TRYB + TRYB_PAUZA, POMOC_PAUZA);
 wsk=wsk->nast;
 // wybor okna informacji/analizy
 wsk->nast = new TWyborPrzycisku(&wgm[56], TEkran::kolory_wybor_przycisku, &napisy[16], 2, ZD_INFORMACJE, POMOC_INFOAN);
 // stop
 wsk=wsk->nast;
 wsk->nast = new TPrzyciskKilkaOpcjiOpoznDeakt(&wgm[64], TEkran::kolory_przycisku_kilka_opcji, &napisy[18], 2,
					       ZD_STOP_AKT, POMOC_STOP);
 if (opcje_zaawansowane) {
   tekst_rysuj[0]='a';  tekst_rysuj[1]=0; 
   wsk=wsk->nast;
   wsk->nast =new TEdytorLiniowy(&wgm[72], TEkran::kolory_edytora,
				 tekst_rysuj, ZD_TEKST_RYSUJ, sizeof(tekst_rysuj)-1);
   wsk=wsk->nast;
   wsk->nast = new TPrzycisk(&wgm[76], TEkran::kolory_przycisku, napisy[20],
			     ZD_RYSOW_ZERUJ, GrKey_Brak, GrKey_Brak, POMOC_RYS_ZER);
   wsk=wsk->nast;
   wsk->nast = new TWyborPrzycisku(&wgm[80], TEkran::kolory_wybor_przycisku, &napisy[21], 3, ZD_RYSOWANIE, POMOC_RYS);
 }
}

TEkran::~TEkran()
{
#ifndef XWIN_BEZ_GRX
 if (jaki_font) GrUnloadFont(akt_font);
#endif
 delete plansza;  delete gracze;  delete pliki_menu;
 delete turniej_menu;
 delete informacje;
 delete analiza; 
 while (glowne_menu!=NULL)
   {
   TElMenu *wsk = glowne_menu->nast;
   delete glowne_menu;
   glowne_menu = wsk;
   }
}

int TEkran::WezNowaGre()
{
 int x=1, y=1;   // temporary position of left upper corner (whole window will be centered)
 gra.DGracza(0,pargry.gr[0]);   gra.DGracza(1,pargry.gr[1]);
 // skonstruuj menu
 short int wsp[58];
 TKolor  kolory_ng[13];
 /*
 kolory_ng[0]=kolory[KOLOR_TLA]; //fon pershogo
 kolory_ng[1]=kolory[KOLOR_MENU];// kolor liter aktivnykh
 kolory_ng[2]=kolory[KOLOR_WYL_MENU]; //pasiv 1
 kolory_ng[3]=kolory[KOLOR_WYL_MENU]; //????
 kolory_ng[4]=kolory[KOLOR_1];
 kolory_ng[5]=kolory[KOLOR_TLA];//fon 2
 kolory_ng[6]=kolory[KOLOR_MENU]; //kolor liter aktyvn
 kolory_ng[7]=kolory[KOLOR_WYL_MENU]; // kolir fonu nyzu i pasyvu 2 gravcya
 kolory_ng[8]=kolory[KOLOR_MENU];//??? 
 kolory_ng[9]=kolory[KOLOR_2];
 kolory_ng[10]=kolory[KOLOR_MENU];//aktiv gry
 */

 kolory_ng[0]=kolory[KOLOR_TLA];  kolory_ng[1]=kolory[KOLOR_MENU];
 kolory_ng[2]=kolory[KOLOR_WYL_MENU];
 kolory_ng[3]=kolory[KOLOR_TLA];  kolory_ng[4]=kolory[KOLOR_1];
 kolory_ng[5]=kolory[KOLOR_TLA];  kolory_ng[6]=kolory[KOLOR_MENU];
 kolory_ng[7]=kolory[KOLOR_WYL_MENU];
 kolory_ng[8]=kolory[KOLOR_TLA];  kolory_ng[9]=kolory[KOLOR_2];
 // ciemny dol:
 kolory_ng[10]=kolory[KOLOR_WYL_MENU];
 kolory_ng[11]=kolory[KOLOR_MENU];
 kolory_ng[12]=kolory[KOLOR_TLA];
 TElMenu *menu=new TProstokat(&wsp[0], &kolory_ng[7]);
 TElMenu *wsk=menu;
 // tworz dalsze elementy
 const char* nu[] = {"$gr1", "$gr2", "$rozpNG", "$Anuluj",
                     "$WlkPl", "$pozioma", "$pionowa", "$zasady", "0", "1", "2"};
 int dlx, dly;
 // int old_y=y, old_x=x;
 wsp[4]=x;       wsp[5]=y;   // gracz 1
 {
 TMenuGracz *gr;
 wsk->nast = gr = new TMenuGracz(&wsp[4], &kolory_ng[0], &pargry.gr[0], nu[0],
				 (opcje_zaawansowane ? 9 : 1));
 dlx = gr->DajWlkX();   dly = gr->DajWlkY();
 }
 wsp[6]=x+dlx+1;   wsp[7]=y;   // gracz 2
 wsk=wsk->nast;
 wsk->nast = new TMenuGracz(&wsp[6], &kolory_ng[5], &pargry.gr[1], nu[1], 
			    (opcje_zaawansowane ? 9 : 1));
 wsk=wsk->nast;
 wsk->nast = new TPrzycisk(&wsp[8], TEkran::kolory_przycisku,nu[2],ZDT_OK,
                                    GrKey_Brak,GrKey_Brak);
 wsk=wsk->nast;
 wsk->nast = new TPrzycisk(&wsp[12], TEkran::kolory_przycisku,nu[3],ZDT_ANULUJ,
                                    GrKey_Escape,GrKey_Escape);
 wsk=wsk->nast;
 wsk->nast = new TNapis(&wsp[16], &kolory_ng[10],nu[4]);
 wsk=wsk->nast;
 wsk->nast = new TNapis(&wsp[18], &kolory_ng[10],nu[5]);
 wsk=wsk->nast;
 wsk->nast = new TNapis(&wsp[20], &kolory_ng[10],nu[6]);
 wsk=wsk->nast;
 wsk->nast = new TSuwak(&wsp[22], TEkran::kolory_ciemnego_suwaka, ZDT_WLKX, min_bok_planszy,
      max_bok_planszy-min_bok_planszy+1, NULL, NULL, POMOC_WLKPLA);
 wsk=wsk->nast;
 wsk->nast = new TSuwak(&wsp[33], TEkran::kolory_ciemnego_suwaka, ZDT_WLKY, min_bok_planszy,
      max_bok_planszy-min_bok_planszy+1, NULL, NULL, POMOC_WLKPLA);
 wsk=wsk->nast;
 wsk->nast = new TNapis(&wsp[44], &kolory_ng[10],nu[7], KR_ALIGN_LEFT);
 wsk=wsk->nast;
 wsk->nast = new TWyborPrzycisku(&wsp[46], TEkran::kolory_wybor_przycisku, &nu[8], 3, ZDT_ZASADY, POMOC_ZASADY);
 // wsk=wsk->nast;
 // wsk->nast = new TRamkaGruba(&wsp[58], &kolory_ng[1], 2);
 // ustaw wielkosci
//   dlx=350;  dly=350;
 wsp[0]=x;       wsp[1]=y;
 wsp[2]=x+2*dlx;
 int wys_przyc=2*WYS_FONTU+1, odstep_przyc=WYS_FONTU/2-1;
 int marg=(2*wys_przyc)/3;
 y+=dly+odstep_przyc;
 // napis wielkosc planszy
 int dls = (dlx*3)/4;
 wsp[16]=wsp[4]+dls;
 wsp[17]=y + WYS_FONTU;
 y+=2*WYS_FONTU;
 // napis pozioma
 wsp[18]=wsp[4]+dls/2;
 wsp[19]=y - WYS_FONTU/2;
 // napis pionowa
 wsp[20]=wsp[18]+dls;
 wsp[21]=wsp[19];
 y+=WYS_FONTU+2;
 // suwak wlkx
 wsp[22] = wsp[0]+marg;             //    [0] = x pocz minusa
 wsp[23] = wsp[22]+3*SZER_FONTU;  //wys_przyc-1;      //    [1] = x pocz suwaka
 wsp[24] = wsp[0]+dls-marg-wys_przyc;  //    [2] = x pocz plusa
 wsp[25] = 3*SZER_FONTU; //wys_przyc-1;             //    [3] = x dlug znaku
// wsp[26] = 0;                     //    [4] = x napisu (napisu nie ma)
 wsp[27] = y;                       //    [5] = y znaku
 wsp[28] = y+wys_przyc/2;       //    [6] = y suwaka
// wsp[29] = 0;                     //    [7] = y napisu (napisu nie ma)
 wsp[30] = wys_przyc-1;             //    [8] = y dlug znaku
 wsp[31] = 2;                       //    [9] = grub kreski
 wsp[32] = wys_przyc/5;             //    [10] = dlug kreski
 // suwak wlky
 for (int i=0; i<11; i++)
   wsp[33+i] = wsp[22+i];  // skopiuj suwak
 wsp[33]+=dls;   wsp[34]+=dls;   wsp[35]+=dls;
 // napis ,,zasady gry''
 wsp[44]=wsp[35] + 4*(wsp[34]-wsp[33]);
 wsp[45]=wsp[17]+WYS_FONTU;
 // wybor zasad gry
 wsp[46]=wsp[44];
 wsp[48]=wsp[46]+wys_przyc;
 wsp[50]=wsp[48]+1;
 wsp[52]=wsp[50]+wys_przyc;
 wsp[54]=wsp[52]+1;
 wsp[56]=wsp[54]+wys_przyc;
 wsp[47]=wsp[51]=wsp[55]=wsp[27];
 wsp[49]=wsp[53]=wsp[57]=wsp[47]+wys_przyc-1;
 //
 y+=wys_przyc+odstep_przyc;
 y+=wys_przyc-1;
 // przyciski
 wsp[8]=wsp[4]+marg;
 wsp[10]=wsp[4]+dlx-marg;
 wsp[12]=wsp[6]+marg;
 wsp[14]=wsp[2]-marg;
 wsp[9]=wsp[13]=y;   wsp[11]=wsp[15]=y+wys_przyc-1;
 y+=wys_przyc-1;
 wsp[3]=y+marg;
 // wsp[58] = wsp[0]-1;   wsp[59] = wsp[1]-1;
 // wsp[60] = wsp[2];     wsp[61] = wsp[3];
 // make the rectangle 2 pixels larger, to have border...
 wsp[0]-=2;  wsp[1]-=2;  wsp[2]+=2;
 pargry.x=gra.DWlkX();  pargry.y=gra.DWlkY();
 pargry.zasady=gra.DZasadyGry();

 // coordinates of New Game rectangle is in wsp[0--4], move
 // it to the center...
 {
   int marg_x1 = wsp[0], marg_x2 = DajRozdzX()-wsp[2];
   int dx = (marg_x2-marg_x1)/2;
   int marg_y1 = wsp[1], marg_y2 = DajRozdzY()-wsp[3];
   int dy = (marg_y2-marg_y1)/2;
   menu->Przesun(dx, dy);
 }

 menu->InicjujZdarzeniem(ZDT_WLKX + pargry.x-min_bok_planszy);
 menu->InicjujZdarzeniem(ZDT_WLKY + pargry.y-min_bok_planszy);
 menu->InicjujZdarzeniem(ZDT_ZASADY + pargry.zasady);
 // glowna petla
 GrMouseEvent zdarz;
 menu->Rysuj();
 /*
 // this is now drawn by a larger TProstokat
 GrVLine(x+dlx,old_y+6,old_y+328,kolory_ng[2]);//!
 GrBox (old_x+1,old_y+1,old_x+631,old_y+424,0);//!
 GrBox (old_x,old_y,old_x+632,old_y+425,0);//!
 */
 GrFlush();
 for (;;)
   {
   int zd=ZD_NIC;
   GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
   if (zdarz.flags & GR_M_KEYPRESS)
     { zd=menu->DajZdarzenie(zdarz.key, zdarz.flags, -1000,-1000);
     GrFlush(); }
   else if (zdarz.flags & (GR_M_LEFT_DOWN  | GR_M_RIGHT_DOWN))
     { zd=menu->DajZdarzenie(GrKey_Nieistniejacy, 
			     zdarz.flags, zdarz.x,zdarz.y);
     GrFlush(); }
   switch (zd)
     {
     case ZD_ANULUJ:
     case ZD_OK:
       menu->Zniszcz();
       ekran.WyswietlWszystko();
       GrFlush();
       return zd==ZD_OK ? ZD_NOWAGRA : ZD_NIC;
     case ZDT_ZASADY:
     case ZDT_ZASADY+1:
     case ZDT_ZASADY+2:
       pargry.zasady = zd-ZDT_ZASADY;
       break;
     default:
       if (zd>=ZDT_WLKX && zd<=ZDT_WLKX + max_bok_planszy-min_bok_planszy)
         { pargry.x = zd-ZDT_WLKX + min_bok_planszy; }
       else if (zd>=ZDT_WLKY && zd<=ZDT_WLKY + max_bok_planszy-min_bok_planszy)
         { pargry.y = zd-ZDT_WLKY + min_bok_planszy; }
       break;
     }
   }
}


int TEkran::UstawSzerGlMenu(int szer)
// uwaga: wszystkie zmienne ozn. liczbe pikseli, czyli dlugosc-1
// zwraca wsp. y dolnej krawedzi
{
// int wys_przyc=szer/12, marg_max=szer/50, odstep_pion_przyc=szer/50;
 int wys_przyc=2*WYS_FONTU+1, marg_max=szer/50, odstep_pion_przyc=WYS_FONTU/2-1;
 // oblicz szerokosc przycisku
 int szer_przyc=SZER_FONTU*11+4;
 if (szer-2*szer_przyc > 3*marg_max)
   szer_przyc = (szer-3*marg_max+1)/2;
 int zostaje = szer-2*szer_przyc;
 int x1 = zostaje/3;
 int x2 = x1+szer_przyc-1;
 int x4 = szer-x1-1;
 int x3 = x4-szer_przyc+1;
 int y  = odstep_pion_przyc+1;
 // napis Kropki
 wgm[4]=x1+3;  wgm[5]=y+wys_przyc/2;
 // przycisk Koniec
 wgm[6]=x3;  wgm[7]=y;
 wgm[8]=x4;  wgm[9]=y+wys_przyc-1;
 y += wys_przyc + odstep_pion_przyc;
 // nastepne 2 pary przyciskow: (Nowa,O prog) + (Odczyt,Zapis)
 for (int i=0; i<2; i++)
   {
   wgm[10+8*i]=x1;  wgm[11+8*i]=y;
   wgm[12+8*i]=x2;  wgm[13+8*i]=y+wys_przyc-1;
   wgm[14+8*i]=x3;  wgm[15+8*i]=y;
   wgm[16+8*i]=x4;  wgm[17+8*i]=y+wys_przyc-1;
   y += wys_przyc + odstep_pion_przyc;
   }
 // opcje wysw
 wgm[26]=x1;  wgm[27]=y;
 wgm[28]=x4;  wgm[29]=y+wys_przyc-1;
 y += wys_przyc + odstep_pion_przyc +WYS_FONTU;
/*
 // blokada wysw
 wgm[30]=x1;  wgm[31]=y;
 wgm[32]=x4;  wgm[33]=y+wys_przyc-1;
 y += wys_przyc + odstep_pion_przyc +WYS_FONTU;
 */
 // napis ,,tryb''
 wgm[34]=szer/2;  wgm[35]=y+WYS_FONTU/2;
 y += (3*WYS_FONTU)/2;
 // 4 przyciski trybow
 int xtr = wgm[34];
 if (x4-xtr-1 < 14*SZER_FONTU + 2)
   xtr = x4-14*SZER_FONTU -3;
 for (int i=0; i<4; i++)
   {
   wgm[36+4*i]=xtr; wgm[37+4*i]=y;
   wgm[38+4*i]=x4;  wgm[39+4*i]=y+wys_przyc-1;
   y += wys_przyc-1;
   }
 // Pauza
 wgm[52]=x1;    wgm[53]=wgm[37];
 wgm[54]=xtr-1; wgm[55]=wgm[39];
 // blokada wysw
 wgm[30]=x1;    wgm[31]=wgm[55]+1;
 wgm[32]=xtr-1; wgm[33]=wgm[47];
 // stop
 wgm[64]=wgm[68]=wgm[52];
 wgm[66]=wgm[70]=wgm[54];
 wgm[65]=wgm[69]=(opcje_zaawansowane ? wgm[33]:wgm[55])+1;
 wgm[67]=wgm[71] =y = wgm[65]+wys_przyc-1;
 if (!opcje_zaawansowane) {
   // ustaw pauze i stop obok siebie
   // pauze daj na prawo:
   wgm[52]=wgm[36];
   wgm[54]=wgm[38];
   // a stop w gore:
   wgm[65]=wgm[69]=wgm[53];
   wgm[67]=wgm[71]= y = wgm[65]+wys_przyc-1;
 }
 // tutaj przebieg gry
 y+=1*(WYS_FONTU+2);   // ale na razie nie ma, wiec tylko 1*...
 // Informacje/Analiza
 y+=odstep_pion_przyc;
 wgm[56]=x1;   wgm[58]=x2;
 wgm[60]=x3;   wgm[62]=x4;
 wgm[57]=wgm[61]=y;
 wgm[59]=wgm[63] =  y+=wys_przyc-1;
 y+=odstep_pion_przyc;
 // rysowanie: wspolrzedne y:
 for (int i=0; i<20; i+=4) {
   wgm[73+i] = y;
   wgm[75+i] = y+wys_przyc-1;
 }
 // wybor: tekst (/X/O)
 wgm[80]=x1;
 wgm[82]=x1 + (x4-x1)/3;
 // edytor symbolu:
 wgm[72]=wgm[82]+1;
 wgm[74]=wgm[72]+(x4-x1)/3;
 // i X/O
 wgm[84]=wgm[74]+2;
 int d = (x4 - wgm[84]) / 2 - 1;
 wgm[86]=wgm[84]+d;
 wgm[88]=wgm[86]+1;
 wgm[90]=x4;
 // zerowanie
 wgm[76]=wgm[90]+wys_przyc;
 wgm[78]=wgm[76]+wys_przyc-1;
 y+=wys_przyc-1;
 //
 y+=odstep_pion_przyc;
 // prostokat czyszczacy:
 wgm[0]=0;       wgm[1]=0;
 wgm[2]=szer-1;  wgm[3]=y;
 return y;
}

TKolor GrAllocColor_rgb(int n)
{  return GrAllocColor( (n>>16) & 0xff, (n>>8) & 0xff, n & 0xff); }

void TEkran::UstawRozdzielczosc(int x, int y, int nowa_wys_fontu, int nowa_szer_fontu)
// np. (x,y)==(640,480)
{
 if (nowa_wys_fontu)
   WYS_FONTU = nowa_wys_fontu;
 if (nowa_szer_fontu)
   SZER_FONTU = nowa_szer_fontu;
 // wszystkie kolory:
 UstawKolory();
 //
 rozdz_x=x; rozdz_y=y;
 wys_graczy = (7*WYS_FONTU)/2;
 gracze->UstawParW(0, 1);          // lewa
 gracze->UstawParW(1, 1);          // gora
 gracze->UstawParW(2, y-wys_graczy-3);   // prawo
 gracze->UstawParW(3, wys_graczy); // dol
 // plansza
 plansza->UstawParW(0, 1);          // lewa
 plansza->UstawParW(1, wys_graczy+2);       // gora
 plansza->UstawParW(2, y-wys_graczy-3);     // prawo
 plansza->UstawParW(3, y-2);        // dol
 plansza->UstawParW(4, y-wys_graczy-1);    // lewa napisow
 plansza->UstawParW(5, y-2-WYS_FONTU-SZER_FONTU); // gora
 plansza->UstawParW(6, x-2);               // prawa
 plansza->UstawParW(7, y-2);               // dol
 plansza->UstawParW(8, 2*WYS_FONTU+2);   // margines  (bylo x/70)
 int ydol=UstawSzerGlMenu(rozdz_x-rozdz_y+wys_graczy)+1;
 glowne_menu->Przesun(y-wys_graczy-1, 1);
 int wys_inf = 12*(5*WYS_FONTU/4);
 informacje->Ustaw(y-wys_graczy-1,ydol+1, rozdz_x-2, rozdz_y-2*WYS_FONTU);
 analiza   ->Ustaw(y-wys_graczy-1,ydol+1, rozdz_x-2, rozdz_y-2*WYS_FONTU);
 // analiza->Ustaw(y-wys_graczy-1,ydol+wys_inf+1, rozdz_x-2, rozdz_y-2*WYS_FONTU);
}

void TEkran::UstawKolory()
{
 // ustawia na nowo kolory
  for (int i=0; i<sizeof(kolory_rgb)/sizeof(kolory_rgb[0]); i++) {
    int jest=0;
    for (int j=0; j<i; j++)
      if (kolory_rgb[i]==kolory_rgb[j])
	{ kolory[i]=kolory[j]; jest=1; break; }
    if (!jest)
      kolory[i]=GrAllocColor_rgb(kolory_rgb[i]);
  }
 gracze->UstawKolory(0, kolory[KOLOR_TLA_GR]);
 gracze->UstawKolory(1, kolory[KOLOR_MENU_GR]);
 gracze->UstawKolory(2, kolory[KOLOR_1]);
 gracze->UstawKolory(3, kolory[KOLOR_2]);
 gracze->UstawKolory(4, kolory[KOLOR_TLA]);
 gracze->UstawKolory(5, kolory[KOLOR_MENU]);
 gracze->UstawKolory(6, kolory[KOLOR_WYL_MENU]);
 // menu plikow
 pliki_menu->UstawKolory(0, kolory[KOLOR_TLA]);
 pliki_menu->UstawKolory(1, kolory[KOLOR_MENU]);
 turniej_menu->UstawKolory(0, kolory[KOLOR_TLA]);
 turniej_menu->UstawKolory(1, kolory[KOLOR_MENU]);
 turniej_menu->UstawKolory(2, kolory[KOLOR_WYL_MENU]);
 plansza->UstawKolory(0, kolory[KOLOR_TLA_PLANSZY]); 
 plansza->UstawKolory(1, kolory[KOLOR_KRATEK]);
 plansza->UstawKolory(2, kolory[KOLOR_TLA]);
 plansza->UstawKolory(3, kolory[KOLOR_MENU]);
 plansza->UstawKolory(4, kolory[KOLOR_1]);
 plansza->UstawKolory(5, kolory[KOLOR_2]);
 plansza->UstawKolory(6, kolory[KOLOR_CIEN1]);
 plansza->UstawKolory(7, kolory[KOLOR_CIEN2]);
 plansza->UstawKolory(8, kolory[KOLOR_OBWODKI]);
 plansza->UstawKolory(9, kolory[KOLOR_WSPOLRZ]);
 kgm[0]=kolory[KOLOR_TLA];  kgm[1]=kolory[KOLOR_MENU];        kgm[2]=kolory[KOLOR_WYL_MENU];
 kgm[3]=kolory[KOLOR_TLA];  kgm[4]=kolory[KOLOR_WYL_MENU];    kgm[5]=kolory[KOLOR_ZOLTY];
 informacje->UstawKolory(kolory[KOLOR_TLA], kolory[KOLOR_MENU]);
 analiza   ->UstawKolory(kolory[KOLOR_TLA], kolory[KOLOR_MENU]);
 kolory_suwaka[0] = kolory[KOLOR_TLA];
 kolory_suwaka[1] = kolory[KOLOR_MENU];
 kolory_suwaka[2] = kolory[KOLOR_BUTTON_UP_BORDER];
 kolory_suwaka[3] = kolory[KOLOR_BUTTON_DOWN_BORDER];
 kolory_suwaka[4] = kolory[KOLOR_BUTTON_BORDER];
 kolory_suwaka[5] = kolory[KOLOR_BUTTON_TEXT];
 kolory_suwaka[6] = kolory[KOLOR_BUTTON_FON];
 kolory_ciemnego_suwaka[0]= kolory[KOLOR_WYL_MENU];
 for (int i=1; i<7; i++)
   kolory_ciemnego_suwaka[i]= kolory_suwaka[i];
 for (int i=0; i<7; i++)
   kolory_przycisku[i] = kolory_suwaka[i];
 kolory_edytora[0] = kolory[KOLOR_EDITOR_FON];
 kolory_edytora[1] = kolory[KOLOR_BUTTON_TEXT];
 kolory_edytora[2] = kolory[KOLOR_BUTTON_UP_BORDER];
 kolory_edytora[3] = kolory[KOLOR_BUTTON_DOWN_BORDER];
 kolory_edytora[4] = kolory[KOLOR_BUTTON_BORDER];
 kolory_przycisku_dwie_opcje[0] = kolory[KOLOR_BUTTON_FON];
 kolory_przycisku_dwie_opcje[1] = kolory[KOLOR_BUTTON_BORDER];
 kolory_przycisku_dwie_opcje[2] = kolory[KOLOR_BUTTON_TEXT];
 kolory_przycisku_dwie_opcje[3] = kolory[KOLOR_BUTTON_FON_INACTIVE];
 kolory_przycisku_dwie_opcje[4] = kolory[KOLOR_BUTTON_BORDER_INACTIVE];
 kolory_przycisku_dwie_opcje[5] = kolory[KOLOR_BUTTON_TEXT_INACTIVE];
 for (int i=0; i<6; i++) {
   kolory_przycisku_kilka_opcji[i] = kolory_przycisku_dwie_opcje[i];
   kolory_wybor_przycisku[i] = kolory_przycisku_dwie_opcje[i];
 }
 kolory_przycisku_kilka_opcji[6] = kolory[KOLOR_TLA];   // dla TPrzyciskKilkaOpcjiOpoznDeakt
}

/*
void TEkran::LosoweKolory()
{
  for (int i=0; i<sizeof(kolory_rgb)/sizeof(kolory_rgb[0]); i++)
    kolory_rgb[i]=random() & 0xffffff;
  UstawKolory();
}*/

void TEkran::WyswietlPlansze(int co)
{ gracze->RysujWyniki(co);  plansza->Rysuj(co); WyswietlStop(); }

void TEkran::WyswietlGraczy()
{ gracze->RysujGraczy(); }

void TEkran::WyswietlStop()
{
  if (/*gra.DZasadyGry()!=2 ||*/ gra.DKomputerNaRuchu())
    glowne_menu->InicjujZdarzeniem(ZD_STOP_AKT + 0);  // wylacz
  else
    glowne_menu->InicjujZdarzeniem(ZD_STOP_AKT + 1);  // wlacz
  switch (gra.DStop()) {
  case 0:  
    glowne_menu->InicjujZdarzeniem(ZD_STOP + 0);  break;
  case 1:
  case 2:
    glowne_menu->InicjujZdarzeniem(ZD_STOP + 1);  break;
  }
  glowne_menu->RysujJesliZdarzenie(ZD_STOP);
}

void TEkran::WyswietlTryb()
{
 switch (gra.DTryb() & ~TRYB_PAUZA)
   {
   case TRYB_GRA:      glowne_menu->InicjujZdarzeniem(ZD_TRYB + TRYB_GRA);  break;
   case TRYB_TURNIEJ:  glowne_menu->InicjujZdarzeniem(ZD_TRYB + TRYB_TURNIEJ);  break;
   case TRYB_CZAS:     glowne_menu->InicjujZdarzeniem(ZD_TRYB + TRYB_CZAS);  break;
   }
 glowne_menu->InicjujZdarzeniem(ZD_TRYB+TRYB_PAUZA + ((gra.DTryb() & TRYB_PAUZA)!=0));
 glowne_menu->RysujJesliZdarzenie(ZD_TRYB);
 glowne_menu->RysujJesliZdarzenie(ZD_TRYB+TRYB_PAUZA);
}

void TEkran::WyswietlBlokade()
{
 int jest=gra.DBlokada();
 int byla=glowne_menu->DajWartosc(ZD_BLOKADA)-ZD_BLOKADA;
 if (!jest && byla)
   { gracze->RysujGraczy();  plansza->Rysuj(WS_CALAPLANSZA); }
 if (jest!=byla)
   {
   glowne_menu->InicjujZdarzeniem(ZD_BLOKADA + gra.DBlokada());
   glowne_menu->RysujJesliZdarzenie(ZD_BLOKADA);
   }
}

void TEkran::WyswietlInformacje(int co)
// co == WS_NOWYZARODEK, WS_BLADPLIKU
{
 char s[70];
 switch (co)
 {
 case WS_NOWYZARODEK:
   informacje->DodajW(slowa["info.nowyZ"]);
   sprintf(s," (%d,",int(pargry.x));
   informacje->DopiszDoWZlam(s);
   sprintf(s," %d)",int(pargry.y));
   informacje->DopiszDoWZlam(s);
   break;
 case WS_BLADPLIKU:
   informacje->DodajW(slowa["info.bladPlik"]);
   break;
 case WS_ODCZYTMECZU:
   sprintf(s,"%s %d.%d",slowa["info.wczM"], int(pargry.x+1), int(pargry.y+1));
   informacje->DodajW(s);
   if (pargry.data_utw!=-1) {
     sprintf(s,"Data utw: %s", ctime(&pargry.data_utw));
     for (int i=strlen(s)-1; i>=0; i--)
       if (s[i]=='\n') { s[i]='.'; s[i+1]=0; break; }
     informacje->DodajW(s);
   }
   break;
 default:
   informacje->DodajW(slowa["info.inf"]);
   sprintf(s," %d.",int(co));
   informacje->DopiszDoWZlam(s);
   break;
 }
 informacje->Rysuj();
}

void TEkran::WyswietlInfoOMeczu()
{
 if (gra.DNaRuchu()==-1)
   { // info na koniec meczu
   informacje->DodajW(slowa["info.wynik"]);
   char pom[20];
   sprintf(pom, " %d:%d", gra.DIleZd(0),gra.DIleZd(1));
   informacje->DopiszDoWZlam(pom);
   }
 else
   { // info na poczatek meczu
   informacje->PoziomaLinia();
   informacje->DodajW(slowa["info.mecz"]);
   char pom[30];
   //
   sprintf(pom, " %d.%d  %c vs %c", gra.DNrSezonu(), gra.DNrMeczu(),
	   'A'+gra.DNrGracza(0), 'A'+gra.DNrGracza(1));
   informacje->DopiszDoWZlam(pom);
   TGraczO gr;
   gra.DGracza(0,gr);
   gr.UstawImie();
   informacje->DodajW(gr.imie_k[0]);
   informacje->DopiszDoWZlam(" ");
   informacje->DopiszDoWZlam(slowa["vs"]);
   gra.DGracza(1,gr);  pom[0]=' ';
   gr.UstawImie();
   strcpy(&pom[1], gr.imie_k[0]);
   informacje->DopiszDoWZlam(pom);
   }
 informacje->Rysuj();
}

void TEkran::WyswietlCzasGry()
{
 informacje->DodajW(slowa["info.czasG"]);
 char pom[25];
 informacje->DopiszDoWZlam(strcat(stoper[2].IleTrwalo(pom), "s"));
 char pom2[25], pom3[25];
 sprintf(pom, " (%s+%s)", stoper[0].IleTrwalo(pom2), stoper[1].IleTrwalo(pom3));
 informacje->DopiszDoWZlam(pom);
 for (int i=0; i<32; i++)
   if (gra.DSStoper(i,pom))
    informacje->DodajW(pom);
 informacje->Rysuj();
}

void TEkran::WyswietlWszystko()
{
 GrFilledBox(0,0,rozdz_x-1,rozdz_y-1,kolory[KOLOR_TLA]);
 // ramki
 GrBox(0,0,rozdz_y-wys_graczy-2,rozdz_y-1, kolory[KOLOR_RAMKI]);
 GrHLine(0,rozdz_y-wys_graczy-2,wys_graczy+1,kolory[KOLOR_RAMKI]);
 GrBox(rozdz_y-wys_graczy-2,0,rozdz_x-1,rozdz_y-1,kolory[KOLOR_RAMKI]);
 WyswietlPlansze(WS_NOWAPLANSZA);
 WyswietlGraczy();
 glowne_menu->Rysuj();
 //WyswietlTryb();
 WyswietlBlokade();
 informacje->Rysuj();
 analiza->Rysuj();
}

void TEkran::PokazJakasTablice()
{
 gra.StoperyWstrzymaj();
 if (gra.DBlokada()) WyswietlPlansze(WS_CALAPLANSZA);
 analiza->Wylacz();
 informacje->Wlacz();
 glowne_menu->InicjujZdarzeniem(ZD_INFORMACJE);
 glowne_menu->Rysuj();
 informacje->DodajW("Za\263aduj tablic\352:");
 informacje->DodajW("F1: obszary");
 informacje->DodajW("F2: ang[0].ciete");
 informacje->DodajW("F3: terytoria...");
 informacje->DodajW("F4: bezpieczne");
 informacje->DodajW("F5: lista ruch\363w");
 informacje->DodajW("F6: gro\274by");
 informacje->DodajW("F7: r\363\277ne");
 informacje->DodajW("F8: podstawowe");
 informacje->DodajW("F9: robaki-oceny");
 informacje->DodajW("s : statystyki");
 informacje->Rysuj();
 GrFlush();
 GrMouseEvent zdarz;
 int kod=-1;
 char opis_bitow[16 << 5];
 do
  {
  GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
  if (zdarz.flags & GR_M_KEYPRESS)
  switch (Konwersja(zdarz.key))
    {
    case GrKey_F1:
     informacje->DodajW("\243aduje obszary");  kod=0;
     break;
    case GrKey_F2:
     informacje->DodajW("\243aduje ang[0].ciete");  kod=1;
     break;
    case GrKey_F3:
     informacje->DodajW("\243aduje terytoria...");  kod=2;
     break;
    case GrKey_F4:
     informacje->DodajW("\243aduje bezpieczne");  kod=3;
     break;
    case GrKey_F5:
     informacje->DodajW("\243aduje list\352 ruch\363w");  kod=4;
     break;
    case GrKey_F6:
     informacje->DodajW("\243aduje gro\274by");  kod=5;
     break;
    case GrKey_F7:
     informacje->DodajW("\243aduje r\363\277ne");  kod=6;
     break;
    case GrKey_F8:
     informacje->DodajW("\243aduje podstawowe");  kod=7;
     break;
    case GrKey_F9:
     informacje->DodajW("\243aduje robaki-oceny");  kod=8;
     break;
    case 's': case 'S': {
      informacje->PoziomaLinia();
      informacje->DodajW("$info.hash");
      char s[30];
      int ile_kilo = (wersja.HTABZ_ile * wersja.HTABZ_wlk * wersja.HTABZ_klucz) >> 10;
      sprintf(s,"oc %dx%dx%d = %d.%d MB",wersja.HTABZ_ile, wersja.HTABZ_wlk, wersja.HTABZ_klucz,
	      (ile_kilo>>10), (ile_kilo & 1023) / 102);
      informacje->DodajW(s);
      long long int suma=0;
      for (int i=0; i<4; i++) suma+= statystyki_prog.ht_kolizja[i];
      if (suma) {
#ifdef __MINGW32__
	sprintf(s,"ht: %I64d", suma);
#else
	sprintf(s,"ht: %lld", suma);
#endif
	informacje->DodajW(s);
	for (int i=0; i<4; i++) {
	  sprintf(s,"%d: %d", i, int(statystyki_prog.ht_kolizja[i]*10000 / suma));
	  informacje->DodajW(s);
	}
      }
      sprintf(s,"akt_czas = %u",gra.DHTAktCzas());
      informacje->DodajW(s);
      informacje->DodajW("$info.tabl");
      int wlkm = ile_planszy * (gra.DWlkX()+4) * (gra.DWlkY()+4);
      sprintf(s,"pl: %d/%d  %d.%d MB", int(ile_planszy-plansze.IleWolnych()), int(ile_planszy),
	      int(wlkm >> 20), int( (wlkm/ (0x100000/10)) % 10) );
      informacje->DodajW(s);
      wlkm = ile_skladowych * 2 * (gra.DWlkX()+4) * (gra.DWlkY()+4);
      sprintf(s,"sk: %d/%d  %d.%d MB", int(ile_skladowych-skladowe.IleWolnych()), 
	      int(ile_skladowych),
	      int(wlkm >> 20), int( (wlkm/ (0x100000/10)) % 10) );
      informacje->DodajW(s);
      wlkm = ILE_TABLIC_LI * 4 * (gra.DWlkX()+4) * (gra.DWlkY()+4);
      sprintf(s,"LI: %d/%d  %d.%d MB", ILE_TABLIC_LI-tabliceLI.IleWolnych(), ILE_TABLIC_LI,
	      int(wlkm >> 20), int( (wlkm/ (0x100000/10)) % 10) );
      informacje->DodajW(s);
      informacje->PoziomaLinia();
      int wynik = gra.OszacujWynik();
      sprintf(s, "%s: %d", slowa["info.szwynik"], wynik);
      informacje->DodajW(s);      
      wynik = gra.OszacujWynikMC();
      sprintf(s, "%s MC: %d", slowa["info.szwynik"], wynik);
      informacje->DodajW(s);      
      informacje->PoziomaLinia();
      }
      goto Koniec_stat;
    case GrKey_Escape:
    case GrKey_Space:
     goto Koniec_nie_czysc;
    }
  }
 while (kod==-1);
 {
 krint *tabl = skladowe.PrzydzielSkladowa();
 gra.DJakasTablice(tabl, opis_bitow, kod);
 krint maska=0;
 for (int i=0; i<16; i++)
   if (opis_bitow[i<<5])
     {
     informacje->DodajW(&opis_bitow[i<<5]);
     if (maska==0) maska=(1<<i);
     }
 char maskatxt[] = "Maska: 0000   ";
 informacje->DodajW(maskatxt);
 for (;;)
   {
   // pokaz tablice
   for (int i=0; i<gra.DWlkX(); i++)
    for (int j=0; j<gra.DWlkY(); j++)
     if (gra.DElTabl(tabl,i,j) & maska)
       plansza->RysujObwodke(i,j);
     else plansza->CzyscObwodke(i,j);
   // pokaz maske
   sprintf(maskatxt, "Maska: %04x", maska);
   informacje->WyczyscW();
   informacje->DopiszDoW(maskatxt);
   informacje->Rysuj();
   GrFlush();
   // wez klawisz
   GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
   if (zdarz.flags & GR_M_KEYPRESS)
   switch (Konwersja(zdarz.key))
     {
     case '0': maska^=0x0001; break;
     case '1': maska^=0x0002; break;
     case '2': maska^=0x0004; break;
     case '3': maska^=0x0008; break;
     case '4': maska^=0x0010; break;
     case '5': maska^=0x0020; break;
     case '6': maska^=0x0040; break;
     case '7': maska^=0x0080; break;
     case '8': maska^=0x0100; break;
     case '9': maska^=0x0200; break;
     case 'A': case 'a': maska^=0x0400; break;
     case 'B': case 'b': maska^=0x0800; break;
     case 'C': case 'c': maska^=0x1000; break;
     case 'D': case 'd': maska^=0x2000; break;
     case 'E': case 'e': maska^=0x4000; break;
     case 'F': case 'f': maska^=0x8000; break;
     case GrKey_Space: case GrKey_Escape:
       goto Koniec;
     }
   }
 skladowe.ZwolnijSkladowa(tabl);
 }
 Koniec:
 plansza->CzyscObwodki();
 Koniec_nie_czysc:
 informacje->WyczyscW();
 informacje->DopiszDoW("(ok/koniec)");
 Koniec_stat:
 informacje->Rysuj();
 GrFlush();
 gra.StoperyWznow();
}

/*
void TEkran::JakisTestSzybkosci()
{
 gra.StoperyWstrzymaj();
 if (gra.DBlokada()) WyswietlPlansze(WS_CALAPLANSZA);
 analiza->Wylacz();
 informacje->Wlacz();
 glowne_menu->InicjujZdarzeniem(ZD_INFORMACJE);
 glowne_menu->Rysuj();
 informacje->DodajW("Test szybko\266ci:");
 informacje->DodajW("F1: ocena12, optymistycznie");
 informacje->DodajW("F2: ocena12, pesymistycznie");
 // informacje->DodajW("F3: odczyt z ht, optymistycznie");
 // informacje->DodajW("F4: odczyt z ht, pesymistycznie");
 informacje->DodajW("F5: Bouzy 2/1");
 informacje->DodajW("F6: Bouzy 5/13");
 int tys_iteracji = 100;
 int tabelka[]={10,20,50,100,200,500,1000,2000,5000,10000,20000,50000,100000,200000,500000,1000000};
 {
 char s[40];
 sprintf(s,"Iteracji: %dk (p lub m)", tys_iteracji);
 informacje->DodajW(s);
 }
 informacje->Rysuj();
 GrFlush();
 GrMouseEvent zdarz;
 int kod=-1;
 do
  {
  GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
  if (zdarz.flags & GR_M_KEYPRESS)
  switch (Konwersja(zdarz.key))
    {
    case 'p':
    case 'P':
      if (tys_iteracji<1000000) {
	for (int i=0; i<sizeof(tabelka)/sizeof(tabelka[0]); i++)
	  if (tys_iteracji==tabelka[i])
	    { tys_iteracji=tabelka[i+1]; break; }
	informacje->WyczyscW();
	char s[40];
	sprintf(s,"Iteracji: %dk (p lub m)", tys_iteracji);
	informacje->DopiszDoW(s);
	informacje->Rysuj();
	GrFlush();
      }
      break;
    case 'm':
    case 'M':
      if (tys_iteracji>tabelka[0]) {
	for (int i=0; i<sizeof(tabelka)/sizeof(tabelka[0]); i++)
	  if (tys_iteracji==tabelka[i])
	    { tys_iteracji=tabelka[i-1]; break; }
	informacje->WyczyscW();
	char s[40];
	sprintf(s,"Iteracji: %dk (p lub m)", tys_iteracji);
	informacje->DopiszDoW(s);
	informacje->Rysuj();
	GrFlush();
      }
      break;
    case GrKey_F1:
     informacje->DodajW("--"); 
     informacje->DodajW("Test oceny12 optymistycznie");  kod=0;
     break;
    case GrKey_F2:
     informacje->DodajW("--"); 
     informacje->DodajW("Test oceny12 pesymistycznie");  kod=1;
     break;
//     case GrKey_F3:
//      informacje->DodajW("--"); 
//      informacje->DodajW("Test odczytu z ht optymistycznie");  kod=2;
//      break;
//     case GrKey_F4:
//      informacje->DodajW("--"); 
//      informacje->DodajW("Test odczytu z ht pesymistycznie");  kod=3;
//      break;
    case GrKey_F5:
     informacje->DodajW("--"); 
     informacje->DodajW("Test Bouzy 2/1");  kod=4;
     break;
    case GrKey_F6:
     informacje->DodajW("--"); 
     informacje->DodajW("Test Bouzy 5/13");  kod=5;
     break;
    case GrKey_Escape:
    case GrKey_Space:
     goto Koniec;
    }
  }
 while (kod==-1);
 {
   TStoper czas;
   informacje->Rysuj();
   GrFlush();
   if (gra.TestSzybkosci(kod, 1000*tys_iteracji, czas)==0)
     informacje->DodajW("niestety, nie mozna");
   else {
     char s[40], sc[20];
     sprintf(s,"czas: %ss",czas.IleTrwalo(sc));
     informacje->DodajW(s);
   }
 }
 Koniec:;
 informacje->DodajW("---");
 informacje->Rysuj();
 GrFlush();
 gra.StoperyWznow();
}
*/

void TEkran::PokazStopy(int nr_maski)
// nr_maski == 0,1,2,3,4,5,6
// wykorzystywane tylko nr_maski==2,3 (brzuszki) (83.34+)
{
 gra.StoperyWstrzymaj();
 if (gra.DBlokada()) WyswietlPlansze(WS_CALAPLANSZA);
 int maska = (1<<nr_maski);
 // rysuj
 for (int i=0; i<gra.DWlkX(); i++)
  for (int j=0; j<gra.DWlkY(); j++)
   if (gra.DPlanszP(i,j) & maska)
     plansza->RysujObwodke(i,j);
 const char *s[] = {"Pa\361stwa gracza 1", "Pa\361stwa gracza 2", "Brzuszki gracza 1",
        "Brzuszki gracza 2", "Wewn\352trzne gracza 1", "Wewn\352trzne gracza 2",
        "Punktowane"};
 informacje->DodajW(s[nr_maski]);
 informacje->DopiszDoW(" -- ");
 informacje->DopiszDoWZlam(slowa["PrzCos"]);
 informacje->Rysuj();
 GrFlush();
 // czekaj
 GrMouseEvent zdarz;
 GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
 plansza->CzyscObwodki();
 informacje->WyczyscW();
 informacje->DopiszDoW("(ok)");
 informacje->Rysuj();
 GrFlush();
 gra.StoperyWznow();
}

void TEkran::PokazWolnePola()
{
 gra.StoperyWstrzymaj();
 if (gra.DBlokada()) WyswietlPlansze(WS_CALAPLANSZA);
 // rysuj
 for (int i=0; i<gra.DWlkX(); i++)
  for (int j=0; j<gra.DWlkY(); j++)
   if ((gra.DPlanszP(i,j) & 15) == 0 && gra.DKropka(i,j)==0)
     plansza->RysujObwodke(i,j);
 informacje->DodajW("Wolne pola");
 informacje->DopiszDoW(" -- ");
 informacje->DopiszDoWZlam(slowa["PrzCos"]);
 informacje->Rysuj();
 GrFlush();
 // czekaj
 GrMouseEvent zdarz;
 GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
 plansza->CzyscObwodki();
 informacje->WyczyscW();
 informacje->DopiszDoW("(ok)");
 informacje->Rysuj();
 GrFlush();
 gra.StoperyWznow();
}

int TEkran::DajOpcjeZaawansowane()
{ return opcje_zaawansowane; }

int TEkran::CzyCzcionkaBold()
{ return czcionka_bold; }

void TEkran::WezOpcje()
{
  // skonstruuj menu
  static const char *napisy[] = {"$menu.OpW", "$OK","$Anuluj", "$opcje.krotkie_im" };
  short int wom[22];
  TKolor kom[8];
  wom[0]=(rozdz_x-510)/2+1;//! 1
  wom[1]=(rozdz_y-273)/2+1;//! wys_graczy+2;
  wom[2]=(rozdz_x-510)/2+1+510;//rozdz_x-wys_graczy-3;
  // wom[3] will be fixed later...
  /*
  if (opcje_zaawansowane)
    wom[3]=(rozdz_y-273)/2+1+273; //rozdz_y-2;
  else
    wom[3]=(rozdz_y-273)/2+1+173; //rozdz_y-2;
  GrBox(wom[0]-1,wom[1]-1,wom[2],wom[3],0);//ramku malyuyu
  GrBox(wom[0]-2,wom[1]-2,wom[2]+1,wom[3]+1,0);//ramku malyuyu
  */
  kom[0]=kolory[KOLOR_TLA];
  kom[1]=kolory[KOLOR_MENU];
  kom[2]=kolory[KOLOR_WYL_MENU];
  kom[3]= kolory[KOLOR_TLA];
  for(int i=4; i<=7; i++) kom[i]=kolory[KOLOR_MENU];
  TElMenu *menu;
  TElMenu *wsk = menu = new TProstokat(&wom[0], &kom[0]);
  wsk->nast = new TNapis(&wom[4], &kom[0], napisy[0], KR_ALIGN_CENTER);
  int wys_przyc=2*WYS_FONTU+1, odstep_przyc=WYS_FONTU/2-1;
  int marg=(2*wys_przyc)/3;
  wom[4]=(wom[0]+wom[2])/2;   wom[5]=wom[1] + wys_przyc/2;
  int y=wom[1] + wys_przyc;
  wsk=wsk->nast;
  y = plansza->DowiazOpcje(wsk, wom[0], wom[2], y+odstep_przyc, wys_przyc, odstep_przyc, marg, kom); 
  short int wsp[4];
  if (opcje_zaawansowane) {
    wsk->nast =
      new TPrzyciskDwieOpcje(&wsp[0], TEkran::kolory_przycisku_dwie_opcje, napisy[3], ZD_KROTKIE_IMIE, POMOC_KIMIE);
    wsk=wsk->nast;
  }
#ifdef XWIN_BEZ_GRX
  // jak jestesmy pod X Windows, to umozliwiaj zmiane kolorow
  wsk->nast = new TPrzyciskKilkaOpcji(&wom[14], TEkran::kolory_przycisku_kilka_opcji, kolory_rgb_stand_nazwy, 4,
				      ZD_KOLORY, POMOC_OPKOLOR);
  wsk=wsk->nast;
#endif
  wsp[1]=y+=wys_przyc-odstep_przyc;  wsp[3]=y+=wys_przyc;  y+=odstep_przyc;
  if (opcje_zaawansowane) {
    y = analiza->DowiazOpcje(wsk, wom[0], wom[2], y+odstep_przyc, wys_przyc, odstep_przyc, marg, kom); 
  }
  y+= odstep_przyc+WYS_FONTU;
  wom[6] = wom[0]+marg;
  wom[12]= wom[2]-marg;
  wom[8]= (wom[6]+wom[12]-marg)/2;
  wom[10]=wom[8]+marg;
  wom[7]=wom[11]=y;
  wom[9]=wom[13]=y+=wys_przyc;
  wsp[0]=wom[6];  wsp[2]=wom[8];
  wom[14]=wsp[2]+marg;
  wom[16]=wom[14]+wsp[2]-wsp[0];
  if (opcje_zaawansowane) {
    wom[15]=wsp[1];  wom[17]=wsp[3];
  }
  else {
    wom[15]=wom[1] + wys_przyc + WYS_FONTU+2*odstep_przyc;  wom[17]=wom[15] + wys_przyc;
  }
  wsk->nast = new TPrzycisk(&wom[6], TEkran::kolory_przycisku,napisy[1],ZDT_OK,
			    GrKey_Brak,GrKey_Brak);
  wsk=wsk->nast;
  wsk->nast = new TPrzycisk(&wom[10], TEkran::kolory_przycisku,napisy[2],ZDT_ANULUJ,
                                    GrKey_Escape,GrKey_Escape);
  wsk=wsk->nast;
  wsk->nast = new TRamkaGruba(&wom[18], &kom[1], 2);
  wsk=wsk->nast;
  menu->InicjujZdarzeniem(ZD_KROTKIE_IMIE+1-krotkie_imie);
#ifdef XWIN_BEZ_GRX
  menu->InicjujZdarzeniem(ZD_KOLORY+paleta);
#endif
  //  if (wom[3]>y+marg) 
  wom[3]=y+marg;
  wom[18]=wom[0]-1;  wom[19]=wom[1]-1;
  wom[20]=wom[2]-1;    wom[21]=wom[3]-1;
  
  // menu skonstruowane, petla
  // glowna petla
  GrMouseEvent zdarz;
  menu->Rysuj();
  GrFlush();
  for (;;) {
    int zd=ZD_NIC;
    GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
    if (zdarz.flags & GR_M_KEYPRESS)
      { zd=menu->DajZdarzenie(zdarz.key, zdarz.flags, -1000,-1000);
      GrFlush(); }
    else if (zdarz.flags & (GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN))
      { zd=menu->DajZdarzenie(GrKey_Nieistniejacy, 
			      zdarz.flags, zdarz.x,zdarz.y);
      GrFlush(); }
    switch (zd)
      {
	/*
      case ZD_KOLORY:
      case ZD_KOLORY+1:
      case ZD_KOLORY+2:
      case ZD_KOLORY+3:
	{
	  int nr = menu->DajWartosc(ZD_KOLORY) - ZD_KOLORY;
	  for (int i=0; i<sizeof(kolory_rgb)/sizeof(kolory_rgb[0]); i++)
	    kolory_rgb[i]=kolory_rgb_stand[nr][i];
	  UstawKolory();
	  kom[0]=kolory[KOLOR_TLA];
	  kom[1]=kolory[KOLOR_MENU];
	  kom[2]=kolory[KOLOR_WYL_MENU];
	  kom[3]= kolory[KOLOR_TLA];
	  for(int i=4; i<=7; i++) kom[i]=kolory[KOLOR_MENU];
	  ekran.WyswietlWszystko();
	  menu->Rysuj();
	  GrFlush();
	}
	break;
	*/
      case ZD_ANULUJ:
	/*
	for (int i=0; i<sizeof(kolory_rgb)/sizeof(kolory_rgb[0]); i++)
	  kolory_rgb[i]=kolory_rgb_stand[paleta][i];
	  UstawKolory(); */
	menu->Zniszcz();
	ekran.WyswietlWszystko();
	GrFlush();
	return;
      case ZD_OK:
	plansza->UstawOpcje(menu);
	analiza->UstawOpcje(menu);
	krotkie_imie = 1- (menu->DajWartosc(ZD_KROTKIE_IMIE) - ZD_KROTKIE_IMIE);
#ifdef XWIN_BEZ_GRX
	{
	  paleta = menu->DajWartosc(ZD_KOLORY) - ZD_KOLORY;
	  for (int i=0; i<sizeof(kolory_rgb)/sizeof(kolory_rgb[0]); i++)
	    kolory_rgb[i]=kolory_rgb_stand[paleta][i];
	  UstawKolory();
	}
#endif
	menu->Zniszcz();
	ekran.WyswietlWszystko();
	GrFlush();
	return;
      }
  }
}

int TEkran::WezListeRuchow(unsigned char* tabl)
// we: tabl[...] & 1: pole jest na liscie ruchow
//               & 2: pole jest na liscie ruchow po wywaleniu symetrycznych
// wy: tabl[...] & 4: wybrane ruchy (zawsze jakies sa)
// zwraca 0, gdy wcisnieto escape,
//       -1, gdy enter, ale wybrane wszystkie ruchy,
//        1, gdy enter, i nie wszystkie ruchy wybrane
// Gdy zwraca cos !=0, to lista wybr. ruchow bedzie niepusta!
{
 gra.StoperyWstrzymaj();
 if (gra.DBlokada()) WyswietlPlansze(WS_CALAPLANSZA);
 int analiza_na_wierzchu = analiza->CzyNaWierzchu();
 if (analiza_na_wierzchu) {
   analiza->Wylacz();
   informacje->Wlacz();
   glowne_menu->InicjujZdarzeniem(ZD_INFORMACJE);
   glowne_menu->Rysuj();
 }
 int zaakceptowane;
 // ustaw standardowe ruchy
 int ile_wybr =0, ile_ruchow=0;
 for (int i=0; i<gra.DWlkX(); i++)
   for (int j=0; j<gra.DWlkY(); j++)
     if (gra.DElTabl(tabl,i,j)) {
       ile_ruchow++;
       if (gra.DElTabl(tabl,i,j) & 2) {
	 gra.DElTabl(tabl,i,j) |= 4;
         ile_wybr++;
       }
     }
 // dodaj info
 informacje->DodajW("Wybierz list\352 ruch\363w:");
 informacje->DodajW(" 0: skasuj wszystkie");
 informacje->DodajW(" s: standardowe");
 informacje->DodajW(" 1: ustaw wszystkie");
 informacje->DodajW(" Enter: akceptacja");
 informacje->DodajW(" ");
 // glowna petla
 for (;;) {
   int kod=-1;
   // narysuj obwodki
   for (int i=0; i<gra.DWlkX(); i++)
     for (int j=0; j<gra.DWlkY(); j++)
       if (gra.DElTabl(tabl,i,j) & 4)
	 plansza->RysujObwodke(i,j, kolory[KOLOR_OBWODKI]);
       else 
	 if (gra.DElTabl(tabl,i,j) & 1)
	   plansza->RysujObwodke(i,j, kolory[KOLOR_TLA_POMOCY]);
   char tekst[40];
   sprintf(tekst, "Ruch\363w: %d/%d.",ile_wybr, ile_ruchow);
   informacje->WyczyscW();
   informacje->DopiszDoW(tekst);
   informacje->Rysuj();
   GrFlush();
   // wez klawisz
   GrMouseEvent zdarz;
   GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
   if (zdarz.flags & GR_M_LEFT_DOWN) {
     int x,y;
     int zd=plansza->DajZdarzenie(zdarz.key, zdarz.flags, zdarz.x, zdarz.y, x, y);
     if (zd!=ZD_NIC) {
       if (gra.DElTabl(tabl, x,y) & 1) {
	 ile_wybr += (gra.DElTabl(tabl, x,y) & 4) ? -1: 1;
	 gra.DElTabl(tabl, x,y)  ^= 4;
       }
     }
   }
   else if (zdarz.flags & GR_M_KEYPRESS)
   switch (Konwersja(zdarz.key))
     {
     case '0':
       for (int i=0; i<gra.DWlkX(); i++)
	 for (int j=0; j<gra.DWlkY(); j++)
	   if (gra.DElTabl(tabl,i,j) & 1)
	     gra.DElTabl(tabl,i,j) &= ~4;
       ile_wybr=0;
       break;
     case '1':
       for (int i=0; i<gra.DWlkX(); i++)
	 for (int j=0; j<gra.DWlkY(); j++)
	   if (gra.DElTabl(tabl,i,j) & 1)
	     gra.DElTabl(tabl,i,j) |= 4;
       ile_wybr=ile_ruchow;
       break;
     Ustaw_stand:
     case 's':
     case 'S':
       ile_wybr=0;
       for (int i=0; i<gra.DWlkX(); i++)
	 for (int j=0; j<gra.DWlkY(); j++)
	   if (gra.DElTabl(tabl,i,j) & 1)
	     if (gra.DElTabl(tabl,i,j) & 2) {
	       gra.DElTabl(tabl,i,j) |= 4;
	       ile_wybr++;
	     }
	     else
	       gra.DElTabl(tabl,i,j) &= ~4;
       break;
     case GrKey_Return:
       if (ile_wybr==0) goto Ustaw_stand;
       zaakceptowane = (ile_wybr==ile_ruchow) ? -1:1;
       goto Koniec;
     case GrKey_Escape:
       informacje->WyczyscW();
       informacje->DopiszDoW("(anulowano: zwyk\263a analiza)");
       zaakceptowane=0;
       goto Koniec;
     }
 }
 Koniec:
 plansza->CzyscObwodki();
 informacje->Rysuj();
 if (analiza_na_wierzchu) {
   informacje->Wylacz();
   analiza->Wlacz();
   glowne_menu->InicjujZdarzeniem(ZD_INFORMACJE+1);
   glowne_menu->Rysuj();
 }
 GrFlush();
 gra.StoperyWznow();
 return zaakceptowane;
}

int TEkran::JakiKomentarz()
{
  return (glowne_menu->DajWartosc(ZD_RYSOWANIE) - ZD_RYSOWANIE)+1;
}

int TEkran::Cofnij()
// zwraca liczbe ruchow, ktore uzytkownik chce cofnac
// (-1 = nie cofaj)
{
 if (gra.DIleKropek()>0)  // jest sens?
   {
   analiza->Wylacz();
   informacje->Wlacz();
   glowne_menu->InicjujZdarzeniem(ZD_INFORMACJE);
   glowne_menu->Rysuj();
   informacje->DodajW(slowa["info.wroc"]);
   informacje->Rysuj();
   int cofnij_do = informacje->WezLiczbe();
   informacje->WyczyscW();
   if (cofnij_do<0)
     informacje->DopiszDoW(slowa["info.nieC"]); // "(nie cofam)"
   else if (cofnij_do>=gra.DIleKropek())
     {
     char s[50];
     sprintf(s,"(%s %d)", slowa["info.max_to"], int(gra.DIleKropek()-1));
     informacje->DopiszDoW(s);
     cofnij_do=-1;
     }
   else
     {
     char s[50];
     sprintf(s,"%s %d.", slowa["info.wracam"], int(cofnij_do));
     informacje->DopiszDoW(s);
     }
   informacje->Rysuj();
   GrFlush();
   return cofnij_do;
   }
 else return -1;
}

void TEkran::WyswietlInfoOProgramie()
{
  informacje->PoziomaLinia();
  char s[50];
  sprintf(s,"Kropki %s %d.%d", slowa["info.wersja"],
	  int(wersja.WERSJA_KROPEK), int(wersja.WERSJA_KROPEK_LOW));
  informacje->DodajW(s);
  informacje->DodajW("Copyright 1999,2001-2009");
  informacje->DodajW("  Bartek Dyda");
  informacje->DodajW("  <kropki@yahoo.co.uk>");
  informacje->DodajW("GUI enhancements by");
  informacje->DodajW(" Alexander Mishchenko (2009)");
  informacje->DodajW("SGF code from Gnu GO,");
  informacje->DodajW(" copyright 1999-2004 by the FSF.");

  informacje->DodajW("$info.Wsp");
  informacje->DodajW("  Rafa\263 Piku\263a");
  informacje->DodajW("");
#ifdef __DJGPP__
  informacje->DodajW("$info.gpl1dos");
  informacje->DodajW("$info.gpl2dos");
  informacje->DodajW("$info.gpl3dos");
#else
  informacje->DodajW("$info.gpl1");
  informacje->DodajW("$info.gpl2");
#endif
  informacje->DodajW("");
#ifdef __DJGPP__
  informacje->DodajW("$info.dos1");
  informacje->DodajW("$info.dos2");
  informacje->DodajW(" http://www.delorie.com/djgpp/");
#endif
#ifndef XWIN_BEZ_GRX
  informacje->DodajW("$info.dos4");
  informacje->DodajW("$info.dos5");
  informacje->DodajW(" http://www.gnu.de/");
  informacje->DodajW("   software/GRX/");
  informacje->DodajW("");
#endif
  informacje->DodajW("$info.hash");
  int ile_kilo = (wersja.HTABZ_ile * wersja.HTABZ_wlk * wersja.HTABZ_klucz) >> 10;
  sprintf(s,"oc %dx%dx%d = %d.%d MB",wersja.HTABZ_ile, wersja.HTABZ_wlk, wersja.HTABZ_klucz,
	  (ile_kilo>>10), (ile_kilo & 1023) / 102);
  informacje->DodajW(s);
  //  informacje->DodajW("$info.zasady");
  sprintf(s, "%s = %d", slowa["info.zasady"], gra.DZasadyGry());
  informacje->DodajW(s);
  //  informacje->DopiszDoW(s);
  informacje->PoziomaLinia();
  informacje->Rysuj();
  GrFlush();
}


void TEkran::PoczatekAnalizy()
{ if (!gra.DBlokada()) analiza->Poczatek(); }

void TEkran::MinimaxPoczatek()
{ if (!gra.DBlokada()) analiza->MinimaxPoczatek(); }

void TEkran::JeszczeRazAktGleb()
{ if (!gra.DBlokada()) analiza->JeszczeRazAktGleb(); }

void TEkran::OcenionyRuch(int gleb, int maxg, int ocena, TSekwencjaRuchow *r, int ile_r)
{ if (!gra.DBlokada()) analiza->OcenionyRuch(gleb, maxg, ocena, r, ile_r); }

void TEkran::NowyRuch(int gleb, TJedenRuch r, int ktoryr, int ile_pierw_r, int ile_r)
{ if (!gra.DBlokada()) analiza->NowyRuch(gleb, r, ktoryr, ile_pierw_r, ile_r); }

void TEkran::WyswietlUCT(char **s, int n)
{ if (!gra.DBlokada()) analiza->WyswietlUCT(s,n); }

void TEkran::KoniecAnalizy()
{ if (!gra.DBlokada()) analiza->Koniec(); }

// zmienne globalne ponizej to syf -- lepiej to jakos zrobic w X2grx.cc
// (cos innego zamiast symulacji GrMouseGetEv... pod X)
int ile_zd_na_pozniej=0;
GrMouseEvent zd_na_pozniej[16];

int TEkran::CzyPrzerwacAnalize()
// zwraca: -1 -- anuluj przerywanie, 1 -- przerwij po glebokosci, 2 -- przerwij po ruchu,
//         3 -- przerwij natychmiast
{
  if (!analiza->CzyJuzSprKlaw())
    return 0;
  GrMouseEvent zdarz;
  GrMouseGetEventT((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz, 0L);
  if (zdarz.flags & GR_M_KEYPRESS)
    switch (Konwersja(zdarz.key)) {
    case 'g':
    case 'G': 
      ile_zd_na_pozniej=0;
      return 1;
    case 'r':
    case 'R': 
      ile_zd_na_pozniej=0;
      return 2;
    case 'n':
    case 'N': 
      ile_zd_na_pozniej=0;      
      return 3;
    default:  
      if (ile_zd_na_pozniej<16)
	zd_na_pozniej[ile_zd_na_pozniej++] = zdarz;
      return -1;
    }
  if (zdarz.flags & (GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN)) {
    if (ile_zd_na_pozniej<16)
      zd_na_pozniej[ile_zd_na_pozniej++] = zdarz;
    return -1;
  }
  return 0;
}

void TEkran::WezOpcje(TSlowa &opcje)
{
  if (strcmp(opcje["wlkkropki"],"???"))
    plansza->UstawWlkKropki(atoi(opcje["wlkkropki"]));
  if (strcmp(opcje["cieniowanie"],"???"))
    plansza->UstawCieniowanie((strcasecmp(opcje["cieniowanie"], "tak")==0));
  analiza->UstawOpcje(opcje);
  if (strcmp(opcje["krotkie_imie"],"???"))
    krotkie_imie = (strcasecmp(opcje["krotkie_imie"], "tak")==0);
  if (strcmp(opcje["anty_idle"],"???"))
    czy_anty_idle = (strcasecmp(opcje["anty_idle"], "tak")==0);
  if (strcmp(opcje["opcje_zaawansowane"],"???"))
    opcje_zaawansowane = (strcasecmp(opcje["opcje_zaawansowane"], "tak")==0);
  if (strcmp(opcje["boldfont"],"???"))
    czcionka_bold = (strcasecmp(opcje["boldfont"], "tak")==0);
  gracze->UstawZaawansowane(opcje_zaawansowane);
  // ustaw kolory
  const char *nazwy[KOLOR_OSTATNI+1] = {"kolor_podkr", "kolor_tla", "kolor_menu", "kolor1",
			   "kolor2", "kolor_pomocy", "kolor_tla_pomocy",
			   "kolor_tla_planszy", "kolor_kratek", "kolor_wyl_menu",
			   "kolor_tla_gr", "kolor_menu_gr", "kolor_wyl_menu_gr",
			   "kolor_obwodki", "kolor1_cien", "kolor2_cien", "kolor_ramki",
			   "kolor_wspolrz",
			   "kolor_button_up_border", "kolor_button_down_border", "kolor_button_border",
					"kolor_button_text", "kolor_button_fon", "kolor_button_border_inactive",
					"kolor_editor_fon",
					"kolor_button_fon_inactive", "kolor_button_text_inactive"};
  for (int i=0; i<KOLOR_OSTATNI+1; i++)
    if (strcmp(opcje[nazwy[i]],"???"))
      kolory_rgb_stand[3][i] = TGra::Str2Int(opcje[nazwy[i]]);
  if (strcmp(opcje["paleta"],"???")) {
    int nr = TGra::Str2Int(opcje["paleta"]);
    if (nr>=0 && nr<4) {
      paleta = nr;
      for (int i=0; i<sizeof(kolory_rgb)/sizeof(kolory_rgb[0]); i++)
	kolory_rgb[i]=kolory_rgb_stand[paleta][i];
    }
  }
}

void TEkran::WyswietlObwodke(int x, int y, int co)
{ plansza->Obwodka(x,y,co); }

void TEkran::WyswietlNapis(const char *napis)
{
 informacje->DodajW(napis);
 informacje->Rysuj();
}


int TEkran::byla_pomoc = 0;

void TEkran::WyswietlPomoc(int zd)
{
  switch (zd) {
  case ZD_STOP:
    if (!byla_pomoc) {
      WyswietlNapis("$info.stop1");
      WyswietlNapis("$info.stop2");
      WyswietlNapis("$info.stop3");
      WyswietlNapis("$info.stop4");
      WyswietlNapis("$info.stop5");
      WyswietlNapis("$info.stop6");
      WyswietlNapis("$info.stop7");
      WyswietlNapis("$info.stop8");
      byla_pomoc=1;
    }
    break;
  }
}

int  TEkran::DajZdarzenie()
{ return CzekajNaZdarzenie(0); }

int  TEkran::CzekajNaZdarzenie(int czekaj)
{
 GrMouseEvent zdarz;
 int zd=ZD_NIC;
 do
   {
   if (ile_zd_na_pozniej)
     zdarz = zd_na_pozniej[--ile_zd_na_pozniej];
   else
   if (czekaj) {GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz); }  // {} sa z powodu bledu w grx20.h
   else {
     if (czy_anty_idle) {
       if (gra.DBlokada() && !anty_idle.CzyJuz(0, 33))
	 return ZD_NIC;    // jeszcze nie...
       anty_idle.Zeruj();  anty_idle.Start();
     }
     GrMouseGetEventT((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz, 0L);
   }
   if ((zdarz.flags & (GR_M_KEYPRESS | GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN)) ==0)
     continue;  // nic nie zostalo przycisniete
   if (zdarz.flags & GR_M_KEYPRESS)
     zdarz.x=zdarz.y=-1000;
   else if (zdarz.flags & (GR_M_LEFT_DOWN  | GR_M_RIGHT_DOWN))
     zdarz.key=GrKey_Nieistniejacy;
   if (zdarz.flags & (GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS)) {
     zd=plansza->DajZdarzenie(zdarz.key, zdarz.flags, zdarz.x, zdarz.y, pargry.x, pargry.y);
     if (zd!=ZD_NIC) {
       pargry.kod = (zdarz.kbstat & GR_KB_SHIFT) ? -1:0;
       return zd;
     }
     zd=gracze->DajZdarzenie(zdarz.key, zdarz.flags, zdarz.x, zdarz.y);
     if (zd!=ZD_NIC) return zd;
   }
   zd=glowne_menu->DajZdarzenie(zdarz.key, zdarz.flags, zdarz.x, zdarz.y);
   Symulacja_gmenu:;
   switch (zd)
     {
     case ZD_KONIEC:
       return ZD_KONIEC;
     case ZD_NOWAGRA:
       gra.StoperyWstrzymaj();
       //if (WezNowaGre(1, wys_graczy+2))
       if (WezNowaGre()) //(rozdz_x-634)/2+1,(rozdz_y-427)/2+1))
         { gra.StoperyWznow(); return ZD_NOWAGRA; }
       gra.StoperyWznow();
       break;
     case ZD_OPROGRAMIE:
       WyswietlInfoOProgramie();
       break;
     case ZD_ODCZYT:
       gra.StoperyWstrzymaj();
       //if (pliki_menu->OdczytWezNazwe(pargry.nz1, rozdz_y-wys_graczy-3,wys_graczy+2))
       if (pliki_menu->OdczytWezNazwe(pargry.nz1, rozdz_y-wys_graczy-3, (rozdz_y-311)/2+1)) //!
         { gra.StoperyWznow(); return ZD_ODCZYT; }
       gra.StoperyWznow();
       break;
     case ZD_ZAPIS:
       gra.StoperyWstrzymaj();
       //if (pliki_menu->ZapisWezNazwe(pargry.nz1, rozdz_y-wys_graczy-3,wys_graczy+2))
       if (pliki_menu->ZapisWezNazwe(pargry.nz1, rozdz_y-wys_graczy-3,(rozdz_y-311)/2+1))//!
         { gra.StoperyWznow(); return ZD_ZAPIS; }
       gra.StoperyWznow();
       break;
     case ZD_OPCJEW:
       gra.StoperyWstrzymaj();
       WezOpcje();
       WyswietlPlansze(WS_CALAPLANSZA);
       gra.StoperyWznow();
       break;
     case ZD_INFORMACJE:
       analiza->Wylacz();
       informacje->Wlacz();
       GrFlush();
       break;
     case ZD_INFORMACJE+1:
       informacje->Wylacz();
       analiza->Wlacz();
       GrFlush();
       break;
     case ZD_RYSOW_ZERUJ:
       gra.StoperyWstrzymaj();
       plansza->ZerujKomentarze();
       GrFlush();
       gra.StoperyWznow();
       break;
     case ZD_STOP:
     case ZD_STOP+1:
       WyswietlPomoc(ZD_STOP);
       return zd;
     case ZD_BLOKADA:
       pargry.blokada=0;
       return ZD_BLOKADA;
     case ZD_BLOKADA+1:
       pargry.blokada=1;
       return ZD_BLOKADA;
     case ZD_TRYB:
       pargry.tryb = TRYB_GRA;
       return ZD_TRYB;
     case ZD_TRYB+TRYB_TURNIEJ:
       gra.StoperyWstrzymaj();
       pargry.kod=pliki_menu->WezTurniej(rozdz_y-wys_graczy-3,(rozdz_y-311)/2+1);  //,wys_graczy+2);
       if (pargry.kod==1 ||                              // odczytaj turniej
	   (pargry.kod==2 && turniej_menu->Wez(1,1/*wys_graczy+2*/)))   // nowy turniej
         {
         pargry.tryb = TRYB_TURNIEJ;
         gra.StoperyWznow();
         return ZD_TRYB;
         }
       if (pargry.kod==3)
	 return ZD_ODCZYT_MECZU;
       gra.StoperyWznow();
       break;
     case ZD_TRYB+TRYB_CZAS:
       pargry.tryb = TRYB_CZAS;
       return ZD_TRYB;
     case ZD_TRYB+TRYB_PAUZA:
     case ZD_TRYB+TRYB_PAUZA+1:
       pargry.tryb = zd - ZD_TRYB;
       return ZD_TRYB;
     }
   zd=ZD_NIC;  // potrzebne, gdy cos anulowano (np. odczyt zapisanej gry)
   // sprawdz klawiature (raczej dla testu, pozniej pewnie inaczej to sie zrobi)
   switch (Konwersja(zdarz.key))
     {
     case GrKey_Tab   :
       if (opcje_zaawansowane) return ZD_OPUSCRUCH;
       break;
     case GrKey_Control_L:
       gra.StoperyWstrzymaj();
#ifdef XWIN_BEZ_GRX
       GrRePaint();
#else
       WyswietlWszystko();
       GrFlush();
#endif
       gra.StoperyWznow();
       break;
     case GrKey_F5:
       if (opcje_zaawansowane) return ZD_USTAWZARODEKLOSOWY;
       break;
     case GrKey_F6:
       if (opcje_zaawansowane) { pargry.x=15666; pargry.y=0; return ZD_USTAWZARODEK; }
       break;
     case GrKey_BackSpace:
       gra.StoperyWstrzymaj();
       if ((pargry.ile=Cofnij()) >=0)
         { gra.StoperyWznow(); return ZD_COFNIJ; }
       gra.StoperyWznow();
       break;
     case GrKey_Space:
       plansza->UstawObwodkaOstKropka(1-plansza->DajObwodkaOstKropka());
       break;
     case 'p':
     case 'P':
       pargry.tryb = glowne_menu->DajWartosc(ZD_TRYB + TRYB_PAUZA) - ZD_TRYB;
       if (pargry.tryb == TRYB_PAUZA)
         pargry.tryb++; else pargry.tryb--;  // zmien tryb na przeciwny
       return ZD_TRYB;
     case 's':
     case 'S':
       if (opcje_zaawansowane && glowne_menu->DajWartosc(ZD_TRYB) != ZD_TRYB+TRYB_CZAS)
         {
         pargry.tryb = TRYB_CZAS;
         return ZD_TRYB;
         }
       break;
     case 't':
     case 'T':
       if (opcje_zaawansowane && glowne_menu->DajWartosc(ZD_TRYB) != ZD_TRYB+TRYB_TURNIEJ) {
	 zd = ZD_TRYB+TRYB_TURNIEJ;
	 zdarz.key=GrKey_Nieistniejacy;  // wyzeruj wcisniety klawisz
 	 goto Symulacja_gmenu;
       }
       break;
     case GrKey_F11: WyswietlCzasGry();  break;
     case GrKey_F12:
       if (opcje_zaawansowane) PokazJakasTablice();
       break;
       //     case GrKey_F11: JakisTestSzybkosci();   break;
     case GrKey_Home:
       return ZD_ROZGR_POCZ;
     case GrKey_End:
       return ZD_ROZGR_KON;
     case GrKey_Down:
       return ZD_ROZGR_NAST;
     case GrKey_Up:
       return ZD_ROZGR_POP;
     case '1': PokazStopy(2); break;   // stoper jest wstrzymywany wewnatrz
     case '2': PokazStopy(3); break;   // a plansza wyswietlana, gdy zablokowane wyswietlanie
     case '3': PokazWolnePola(); break;
     case 'b':
     case 'B':
       if (opcje_zaawansowane) {
	 pargry.blokada = (glowne_menu->DajWartosc(ZD_BLOKADA) == ZD_BLOKADA);  // wlacz/wylacz BLOKADE
	 return ZD_BLOKADA;
       }
       break;
     case 'w':
     case 'W':
       if (!opcje_zaawansowane) break;
     case 'a':
     case 'A':  // analiza
       if (gra.DTryb()==TRYB_PAUZA || !gra.DKomputerNaRuchu()) {
	 int x,y, ilenr;
	 krint *bufor = new krint[gra.DWlkX()*gra.DWlkY()+2];
	 if (ilenr=gra.DNajlepszyRuch(bufor, x,y,   // =, nie ==
	       (Konwersja(zdarz.key)=='w' || Konwersja(zdarz.key)=='W')  )) { // nie koniec gry?
	   WyswietlObwodke(x-2,y-2,1);
	   char s[100], rt[10];
	   sprintf(s,"%s %s%s.",slowa["info.najl"],
		   TEkran::RuchTekst(rt, x-2,y-2),
		   ilenr<=1?"":"+");
	   informacje->DodajW(s);
	   informacje->DodajW("$PrzCos");
	   informacje->Rysuj();
	   GrFlush();
	   // czekaj
	   GrMouseEvent zdarz;
	   GrMouseGetEvent((GR_M_LEFT_DOWN | GR_M_RIGHT_DOWN | GR_M_KEYPRESS), &zdarz);
	   WyswietlObwodke(x-2,y-2,0);
	   informacje->WyczyscW();
	   informacje->DopiszDoWZlam("---");
	   informacje->Rysuj();
	   GrFlush();
	 }
	 delete []bufor;
       }
       break;

	 
     }
   }
 while (czekaj && zd!=ZD_NIC);
 return zd;
}


void TEkran::ZaladujFont(char *nazwa)
{
#ifndef XWIN_BEZ_GRX
 akt_font = GrLoadFont(nazwa);
 jaki_font=1;
 SZER_FONTU = GrFontCharWidth(akt_font,'M');
 WYS_FONTU  = GrFontCharHeight(akt_font,'M');
#endif
}

TKolor TEkran::DajKolorTla() { return kolory[KOLOR_TLA]; }
TKolor TEkran::DajKolorMenu() { return kolory[KOLOR_MENU]; }
TKolor TEkran::DajKolorNieaktMenu() { return kolory[KOLOR_WYL_MENU]; }
TKolor TEkran::DajKolorZolty() { return kolory[KOLOR_ZOLTY]; }
TKolor TEkran::DajKolorGracza(int ktory) { return ktory ? kolory[KOLOR_2]:kolory[KOLOR_1]; }
TKolor TEkran::DajKolorZielony() { return kolory[KOLOR_POMOCY]; }
TKolor TEkran::DajKolorZielonyTla() { return kolory[KOLOR_TLA_POMOCY]; }

int TEkran::DajRozdzX() { return rozdz_x; }
int TEkran::DajRozdzY() { return rozdz_y; }


#else
// tryb tekstowy

int  TEkran::UstawSzerGlMenu(int szer) {}
int  TEkran::Cofnij(){}
int  TEkran::WezNowaGre(){}
void TEkran::PokazStopy(int nr_maski){}
void TEkran::PokazWolnePola(){}
void TEkran::PokazJakasTablice(){}
void TEkran::ZaladujFont(char*){}
void TEkran::UstawRozdzielczosc(int x, int y, int nowa_wys_fontu, int nowa_szer_fontu){}
void TEkran::WyswietlPlansze(int co){}
void TEkran::WyswietlGraczy(){}
void TEkran::WyswietlTryb(){}
void TEkran::WyswietlStop(){}
void TEkran::WyswietlBlokade(){}
void TEkran::WyswietlWszystko(){}
void TEkran::WyswietlInfoOProgramie(){}
  void TEkran::WyswietlNapis(const char *){}  // do testow
TEkran::TEkran(){ krotkie_imie=0; }
TEkran::~TEkran(){}

int blad=0;

void TEkran::WyswietlInformacje(int co)
// co == WS_NOWYZARODEK, WS_BLADPLIKU
{
 char s[50];
 switch (co)
 {
 case WS_NOWYZARODEK:
   printf("%s (%d, %d)\n", slowa["info.nowyZ"], int(pargry.x),int(pargry.y));
   break;
 case WS_BLADPLIKU:
   printf("%s\n", slowa["info.bladPlik"]);
   blad=1;
   break;
 default:
   printf("%s: %d.\n",slowa["info.inf"], int(co));
   break;
 }
}

void TEkran::WyswietlInfoOMeczu()
{
 if (gra.DNaRuchu()==-1)
   { // info na koniec meczu
   printf("Wynik: %d:%d\n", gra.DIleZd(0),gra.DIleZd(1));
   }
 else
   { // info na poczatek meczu
   printf("-------------------------------\n");
   //   printf("M %d.%d   ", gra.DNrSezonu(), gra.DNrMeczu());
   printf(" %d.%d  %c vs %c: ", gra.DNrSezonu(), gra.DNrMeczu(),
	  'A'+gra.DNrGracza(0), 'A'+gra.DNrGracza(1));
   TGraczO gr;
   gra.DGracza(0,gr);
   gr.UstawImie();
   printf("%s vs ",gr.imie_k[0]);
   gra.DGracza(1,gr);
   gr.UstawImie();
   printf("%s\n",gr.imie_k[0]);
   }
}

void TEkran::WyswietlCzasGry()
{
 char pom[25];
 printf("Czas: %ss", stoper[0].IleTrwalo(pom));
 printf(" + %ss"   , stoper[1].IleTrwalo(pom));
 printf(" = %ss\n" , stoper[2].IleTrwalo(pom));
 for (int i=0; i<32; i++)
   if (gra.DSStoper(i,pom))
    printf("%s\n",pom);
}

int  TEkran::DajZdarzenie() { return blad ? ZD_KONIEC: ZD_NIC; }
int  TEkran::CzekajNaZdarzenie(int czekaj) { return ZD_KONIEC; }

#endif
