/*   Programik do gry w kropki.
 *
 *  Copyright (C) 1999,2001,2002,2003,2004,2005,2006 Bartek Dyda <kropki@yahoo.co.uk>.
 * 
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "stoper.h"

void TStoper::Start()
{
 if (!wlaczony)
   {
   wlaczony=1;
   gettimeofday(&startt, NULL);
   }
}

void TStoper::Stop()
{
 if (wlaczony==1)
   gettimeofday(&koniect, NULL);
 else if (wlaczony==-1)
   { koniect=startt;  startt.tv_usec=0;  startt.tv_sec=0; }
 wlaczony=0;
}

void TStoper::Odejmij()
// wstaw: startt = koniect - startt
{
 long int mikros = koniect.tv_usec, sek = koniect.tv_sec - startt.tv_sec;
 if (mikros < startt.tv_usec)
   {
   mikros += 1000000 - startt.tv_usec;
   sek--;
   }
 else mikros -= startt.tv_usec;
 startt.tv_usec = mikros;
 startt.tv_sec  = sek;
}

void TStoper::Zeruj()
{
  wlaczony=0;
  startt.tv_usec=0;   startt.tv_sec=0;
  koniect.tv_usec=0;  koniect.tv_sec=0;
}

void TStoper::Wstrzymaj()
{
 if (wlaczony==1)
   {
   gettimeofday(&koniect, NULL);
   Odejmij();   // startt = koniect - startt
   wlaczony=-1;
   }
}

void TStoper::Wznow()
{
 if (wlaczony==-1)
   {
   gettimeofday(&koniect, NULL);
   Odejmij();   // startt = koniect - startt
   wlaczony=1;
   }
}

int TStoper::IleTrwalo(int &setnych)
{
 struct timeval kont;
 if (wlaczony==-1)   // wstrzymany stoper
   {
     setnych = startt.tv_usec/10000;
     return startt.tv_sec;
   }
 if (wlaczony)
   gettimeofday(&kont, NULL);
 else
   kont=koniect;
 long int mikros = kont.tv_usec;
 if (mikros < startt.tv_usec)
   {
   mikros += 1000000 - startt.tv_usec;
   kont.tv_sec--;
   }
 else mikros -= startt.tv_usec;
 setnych = mikros/10000;
 return kont.tv_sec-startt.tv_sec;
}

char* TStoper::IleTrwalo(char* s)
{
 int setnych;
 int iles = IleTrwalo(setnych);
 sprintf(s, "%d.%02d", iles, setnych);
 return s;
}

char* TStoper::IleTrwaloSkr(char* s)
  // daje ciag najwyzej 6 znakow, chyba ze czas >= 100'000 godzin (> 11 lat)
{
 struct timeval kont;
 long int mikros, sek;
 if (wlaczony==-1)   // wstrzymany stoper
   {
     sek=startt.tv_sec; 
     mikros=startt.tv_usec;
   }
 else {
   if (wlaczony)
     gettimeofday(&kont, NULL);
   else
     kont=koniect;
   mikros = kont.tv_usec;
   if (mikros < startt.tv_usec)
     {
       mikros += 1000000 - startt.tv_usec;
       kont.tv_sec--;
     }
   else mikros -= startt.tv_usec;
   sek = kont.tv_sec-startt.tv_sec;
 }
 if (sek<100) {    
   sprintf(s, "%ld.%02ds", sek, int(mikros/10000));
   return s;
 }
 if (sek<1000) {
   sprintf(s, "%ld.%ds", sek, int(mikros/100000));
   return s;
 }
 if (mikros>=500000) sek++;  // przyblizenie
 if (sek<100000) {
   sprintf(s, "%lds", sek);
   return s;
 }
 int minut = (sek/60) + (sek%60 > 30);   // tutaj >30, bo juz mikros zaokr. w gore
 if (minut<100000) {
   sprintf(s, "%dm", minut);
   return s;
 }
 int godz = (minut/60) + (minut%60 > 30);
 sprintf(s, "%dh", godz);
 return s;
}

int TStoper::CzyJuz(long int czy_sekund, int czy_ssek)
{
 long int sekund, mikros;
 if (wlaczony==-1)
   {
   sekund = startt.tv_sec;   mikros = startt.tv_usec;
   }
 else
   {
   struct timeval kont;
   if (wlaczony) gettimeofday(&kont, NULL);
     else kont=koniect;
   mikros = kont.tv_usec;
   if (mikros < startt.tv_usec)
     {
     mikros += 1000000 - startt.tv_usec;
     kont.tv_sec--;
     }
   else mikros -= startt.tv_usec;
   sekund = kont.tv_sec-startt.tv_sec;
   }
 return (sekund>czy_sekund || (sekund==czy_sekund && mikros>10000*czy_ssek));
}


void ZapiszTimeval(FILE *f, struct timeval &s)
{
  unsigned long int sek = s.tv_sec, msek = s.tv_usec;
  unsigned char buf[8];
  for (int i=0; i<4; i++) {
    buf[i] = (sek & 0xff);
    sek >>= 8;
  }
  for (int i=4; i<8; i++) {
    buf[i] = (msek & 0xff);
    msek >>= 8;
  }
  fwrite(buf, 1, sizeof(buf), f);
}

void TStoper::Zapisz(FILE *f)
{
  switch (wlaczony) {
  case 1:  // chodzi
    Wstrzymaj();
    ZapiszTimeval(f, startt);
    Wznow();
    break;
  case 0:  // wylaczony
    Odejmij();
    ZapiszTimeval(f, startt);
    koniect = startt;
    startt.tv_sec = startt.tv_usec=0;
    break;
  case -1: // wstrzymany
    ZapiszTimeval(f, startt);
    break;
  }
}

void TStoper::Odczytaj(FILE *f)
{
  int wlacz = (wlaczony==1);
  wlaczony=-1;
  unsigned char buf[8];
  fread(buf, 1, sizeof(buf), f);
  unsigned long int sek=0, msek=0;
  for (int i=0; i<4; i++) {
    sek <<= 8;
    sek |= buf[3-i];
    msek <<= 8;
    msek |= buf[7-i];
  }
  startt.tv_sec = sek;    startt.tv_usec = msek;
  //  fread(&startt, 1, sizeof(startt), f);
  if (wlacz) Wznow();
}

long long TStoper::IleTrwalo()
{
  long long cz;
  switch (wlaczony) {
  case 1: // chodzi
    Wstrzymaj();
    cz = startt.tv_sec;
    cz *= 1000000;
    cz += startt.tv_usec;
    Wznow();
    return cz;
  case 0: // wylaczony
    cz = koniect.tv_sec;
    cz *= 1000000;
    cz += koniect.tv_usec;
    return cz;
  case -1:
    cz = startt.tv_sec;
    cz *= 1000000;
    cz += startt.tv_usec;
    return cz;
  }
}

TStoper& TStoper::operator+=(const TStoper& arg)
{
  TStoper pom = arg;
  if (pom.wlaczony!=0) pom.Wstrzymaj(); 
  else pom.Zeruj();
  switch (wlaczony) {
  case 1: // chodzi
    Wstrzymaj();
    startt.tv_usec += pom.startt.tv_usec;
    if (startt.tv_usec>=1000000) {
      startt.tv_usec-=1000000; startt.tv_sec ++;
    }
    startt.tv_sec += pom.startt.tv_sec;
    Wznow();
    break;
  case 0: // wylaczony
    startt.tv_sec = pom.startt.tv_sec;
    startt.tv_usec = pom.startt.tv_usec;
    wlaczony = -1;  // wstrzymaj, zeby bylo wiadomo, ze jest cos zapamietane
    break;
  case -1:
    startt.tv_usec += pom.startt.tv_usec;
    if (startt.tv_usec>=1000000) {
      startt.tv_usec-=1000000; startt.tv_sec ++;
    }
    startt.tv_sec += pom.startt.tv_sec;
    break;
  }
  return *this;
}

TStoper& TStoper::operator/=(int arg)
{
  if (arg<=0) return *this;
  switch (wlaczony) {
  case 1: // chodzi
    {
    Wstrzymaj();
    long long msek = IleTrwalo() / arg;
    startt.tv_sec  = msek / 1000000;
    startt.tv_usec = msek % 1000000;
    Wznow();
    }
    break;
  case 0: // wylaczony
    {
    long long msek = IleTrwalo() / arg;
    koniect.tv_sec  = msek / 1000000;
    koniect.tv_usec = msek % 1000000;
    startt.tv_sec = startt.tv_usec = 0;
    }
    break;
  case -1:
    {
    long long msek = IleTrwalo() / arg;
    startt.tv_sec  = msek / 1000000;
    startt.tv_usec = msek % 1000000;
    }
    break;
  }
  return *this;
}

int TStoper::operator>(TStoper& arg)
{  return (IleTrwalo() > arg.IleTrwalo()); }

int TStoper::operator<(TStoper& arg)
{  return IleTrwalo() < arg.IleTrwalo(); }
