/*   Programik do gry w kropki -- plik X2grx.h.
 *
 *  Copyright (C) 2003,2004,2005,2006 Bartek Dyda <kropki@yahoo.co.uk>.
 * 
 *  This file is part of Kropki.
 *
 *  Part of this file comes from:
 *   grxkeys.h ---- platform independent key definitions
 *   Copyright (c) 1997 Hartmut Schirmer
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

// w KR_ALIGN_xxx pamietamy xalign w starszej cyfrze i yalign w mlodszej:
#ifndef X2GRX__H
#define X2GRX__H

#define KR_ALIGN_CENTER 0x11
#define KR_ALIGN_LEFT   0x01
#define KR_ALIGN_RIGHT  0x21
#define KR_ALIGN_LEFTTOP    0x00
#define KR_ALIGN_RIGHTTOP    0x20
#define KR_ALIGN_CENTERTOP  0x10
#define KR_ALIGN_CENTERBOTTOM  0x12
#define KR_ALIGN_LEFTBOTTOM  0x02
#define KR_ALIGN_TOP    0x10

void GrZapamietajObszar(int x, int y, int szer, int wys);
void GrOdtworzObszar();
void GrClose();

#ifdef XWIN_BEZ_GRX

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/keysym.h>

#define GR_width_height_color_graphics  0
#define GR_width_height_bpp_graphics    1

#define GR_M_LEFT_DOWN      2      /* mouse button index bits */
#define GR_M_RIGHT_DOWN     8   // zamienione  (a wszystko pomnozone przez 2)
#define GR_M_MIDDLE_DOWN    4   // !!
#define GR_M_KEYPRESS       0x080 
// stale stanow:
#define GR_M_BUTTON_LEFT    Button1Mask
#define GR_M_BUTTON_RIGHT   Button3Mask
#define GR_M_BUTTON_MIDDLE  Button2Mask
#define GR_KB_SHIFT          ShiftMask
#define GR_KB_CTRL           ControlMask


typedef unsigned long TKolor;
typedef int GrKeyType;

extern TKolor WHITE,BLACK;

int GrSetMode(int tryb, int x, int y, int kolor);
void GrLine(int x1, int y1, int x2, int y2, TKolor kolor);
void GrHLine(int x1, int x2, int y, TKolor kolor);
void GrVLine(int x, int y1, int y2, TKolor kolor);
void outtextxy(int x, int y, const char *tekst, TKolor kolor=WHITE, 
               TKolor kolortla=BLACK, int align=KR_ALIGN_LEFT);
void GrFlush();
void GrRePaint();
void GrBox(int x1, int y1, int x2, int y2, TKolor kolor);
void GrFilledBox(int x1, int y1, int x2, int y2, TKolor kolor);
void GrFilledTrojkat(int x1, int y1, int x2, int y2, int x3, int y3, TKolor kolor);
void GrPlot(int x, int y, TKolor kolor);
int GrKeyRead();
TKolor GrAllocColor(int r, int g, int b);
void GrClearScreen(TKolor kolor);
int GrMaxX();
int GrMaxY();
int GrSizeX();
int GrSizeY();
void GrXor();
void GrCopy();

inline int GrMouseBlock(void*, int,int,int,int) { return 0; }
inline void GrMouseUnBlock(int) {}
inline void GrMouseInit() {}
inline void GrMouseUnInit() {}
inline void GrMouseDisplayCursor() {}
inline void GrMouseEraseCursor() {}
inline int  GrMouseDetect() { return 1; }

void GrSetWindowTitle(char*);

class TKlawisz
{
  int state, key;
 public:
  int operator==(const TKlawisz);
  int operator>=(const TKlawisz);
  int operator<=(const TKlawisz);
  int operator!=(const TKlawisz);
  int operator>(const TKlawisz);
  int operator<(const TKlawisz);
  TKlawisz& operator=(int);
  TKlawisz(int);
  void KonwersjaKS(int,int);
  TKlawisz() {};
  friend int Konwersja(TKlawisz);
};

struct GrMouseEvent
{
  TKlawisz key;
  int flags;
  unsigned int kbstat;
  int x,y;
};
 
void GrMouseGetEvent(int,GrMouseEvent*);
void GrMouseGetEventT(int,GrMouseEvent*, int);

#define GrKey_Brak           XK_VoidSymbol
#define GrKey_Nieistniejacy  0xffffffff

#define GrKey_Alt_0                ((Mod1Mask << 16) | XK_0 )
#define GrKey_Alt_1                ((Mod1Mask << 16) | XK_1 )
#define GrKey_Alt_2                ((Mod1Mask << 16) | XK_2 )
#define GrKey_Alt_3                ((Mod1Mask << 16) | XK_3 )
#define GrKey_Alt_4                ((Mod1Mask << 16) | XK_4 )
#define GrKey_Alt_5                ((Mod1Mask << 16) | XK_5 )
#define GrKey_Alt_6                ((Mod1Mask << 16) | XK_6 )
#define GrKey_Alt_7                ((Mod1Mask << 16) | XK_7 )
#define GrKey_Alt_8                ((Mod1Mask << 16) | XK_8 )
#define GrKey_Alt_9                ((Mod1Mask << 16) | XK_9 )
#define GrKey_Alt_A                ((Mod1Mask << 16) | XK_a )
#define GrKey_Alt_At               ((Mod1Mask << 16) | XK_at )
#define GrKey_Alt_B                ((Mod1Mask << 16) | XK_b )
#define GrKey_Alt_Backquote        ((Mod1Mask << 16) | XK_quoteright )
#define GrKey_Alt_Backslash        ((Mod1Mask << 16) | XK_backslash )
#define GrKey_Alt_Backspace        ((Mod1Mask << 16) | XK_BackSpace )
#define GrKey_Alt_C                ((Mod1Mask << 16) | XK_c )
#ifdef XK_KP_Begin
#define GrKey_Alt_Center           ((Mod1Mask << 16) | XK_KP_Begin )
#endif
#define GrKey_Alt_Comma            ((Mod1Mask << 16) | XK_comma )
#define GrKey_Alt_D                ((Mod1Mask << 16) | XK_d )
#define GrKey_Alt_Dash             ((Mod1Mask << 16) | XK_minus )
#ifdef XK_KP_Delete
#define GrKey_Alt_Delete           ((Mod1Mask << 16) | XK_KP_Delete )
#endif
#define GrKey_Alt_Down             ((Mod1Mask << 16) | XK_Down )
//#ifdef XK_KP_Down
//#define GrKey_Alt_Down             ((Mod1Mask << 16) | XK_KP_Down )
//#endif
#define GrKey_Alt_E                ((Mod1Mask << 16) | XK_e )
#ifdef XK_KP_End
#define GrKey_Alt_End              ((Mod1Mask << 16) | XK_KP_End )
#endif
#ifdef XK_KP_Enter
#define GrKey_Alt_Enter            ((Mod1Mask << 16) | XK_KP_Enter )
#endif
#define GrKey_Alt_Equals           ((Mod1Mask << 16) | XK_equal )
#define GrKey_Alt_Escape           ((Mod1Mask << 16) | XK_Escape )
#define GrKey_Alt_F                ((Mod1Mask << 16) | XK_f )
#define GrKey_Alt_F1               ((Mod1Mask << 16) | XK_F1 )
#define GrKey_Alt_F2               ((Mod1Mask << 16) | XK_F2 )
#define GrKey_Alt_F3               ((Mod1Mask << 16) | XK_F3 )
#define GrKey_Alt_F4               ((Mod1Mask << 16) | XK_F4 )
#define GrKey_Alt_F5               ((Mod1Mask << 16) | XK_F5 )
#define GrKey_Alt_F6               ((Mod1Mask << 16) | XK_F6 )
#define GrKey_Alt_F7               ((Mod1Mask << 16) | XK_F7 )
#define GrKey_Alt_F8               ((Mod1Mask << 16) | XK_F8 )
#define GrKey_Alt_F9               ((Mod1Mask << 16) | XK_F9 )
#define GrKey_Alt_F10              ((Mod1Mask << 16) | XK_F10 )
#define GrKey_Alt_F11              ((Mod1Mask << 16) | XK_F11 )
#define GrKey_Alt_F12              ((Mod1Mask << 16) | XK_F12 )
#define GrKey_Alt_G                ((Mod1Mask << 16) | XK_g )
#define GrKey_Alt_H                ((Mod1Mask << 16) | XK_h )
#ifdef XK_KP_Home
#define GrKey_Alt_Home             ((Mod1Mask << 16) | XK_KP_Home )
#endif
#define GrKey_Alt_I                ((Mod1Mask << 16) | XK_i )
#ifdef XK_KP_Insert
#define GrKey_Alt_Insert           ((Mod1Mask << 16) | XK_KP_Insert )
#endif
#define GrKey_Alt_J                ((Mod1Mask << 16) | XK_j )
#define GrKey_Alt_K                ((Mod1Mask << 16) | XK_k )
#ifdef XK_KP_Subtract
#define GrKey_Alt_KPMinus          ((Mod1Mask << 16) | XK_KP_Subtract )
#endif
#ifdef XK_KP_Add
#define GrKey_Alt_KPPlus           ((Mod1Mask << 16) | XK_KP_Add )
#endif
#ifdef XK_KP_Divide
#define GrKey_Alt_KPSlash          ((Mod1Mask << 16) | XK_KP_Divide )
#endif
//#ifdef XK_KP_Multiply
//#define GrKey_Alt_KPStar           ((Mod1Mask << 16) | XK_KP_Multiply )
//#endif
#define GrKey_Alt_KPStar           ((Mod1Mask << 16) | XK_multiply )
#define GrKey_Alt_L                ((Mod1Mask << 16) | XK_l )
#define GrKey_Alt_LAngle           ((Mod1Mask << 16) | XK_less )
#define GrKey_Alt_LBrace           ((Mod1Mask << 16) | XK_braceleft )
#define GrKey_Alt_LBracket         ((Mod1Mask << 16) | XK_bracketleft )
//#ifdef XK_KP_Left
//#define GrKey_Alt_Left             ((Mod1Mask << 16) | XK_KP_Left )
//#endif
#define GrKey_Alt_Left             ((Mod1Mask << 16) | XK_Left )
#define GrKey_Alt_M                ((Mod1Mask << 16) | XK_m )
#define GrKey_Alt_N                ((Mod1Mask << 16) | XK_n )
#define GrKey_Alt_O                ((Mod1Mask << 16) | XK_o )
#define GrKey_Alt_P                ((Mod1Mask << 16) | XK_p )
#ifdef XK_KP_Next
#define GrKey_Alt_PageDown         ((Mod1Mask << 16) | XK_KP_Next )
#endif
//#ifdef XK_KP_Page_Down
//#define GrKey_Alt_PageDown         ((Mod1Mask << 16) | XK_KP_Page_Down )
//#endif
//#ifdef XK_KP_Page_Up
//#define GrKey_Alt_PageUp           ((Mod1Mask << 16) | XK_KP_Page_Up )
//#endif
#ifdef XK_KP_Prior
#define GrKey_Alt_PageUp           ((Mod1Mask << 16) | XK_KP_Prior )
#endif
#define GrKey_Alt_Period           ((Mod1Mask << 16) | XK_period )
#define GrKey_Alt_Pipe             ((Mod1Mask << 16) | XK_bar )
#define GrKey_Alt_Q                ((Mod1Mask << 16) | XK_q )
#define GrKey_Alt_Quote            ((Mod1Mask << 16) | XK_quoteleft )
#define GrKey_Alt_R                ((Mod1Mask << 16) | XK_r )
#define GrKey_Alt_RAngle           ((Mod1Mask << 16) | XK_greater )
#define GrKey_Alt_RBrace           ((Mod1Mask << 16) | XK_braceright )
#define GrKey_Alt_RBracket         ((Mod1Mask << 16) | XK_bracketright )
#define GrKey_Alt_Return           ((Mod1Mask << 16) | XK_Return )
//#ifdef XK_KP_Right
//#define GrKey_Alt_Right            ((Mod1Mask << 16) | XK_KP_Right )
//#endif
#define GrKey_Alt_Right            ((Mod1Mask << 16) | XK_Right )
#define GrKey_Alt_S                ((Mod1Mask << 16) | XK_s )
#define GrKey_Alt_Semicolon        ((Mod1Mask << 16) | XK_semicolon )
#define GrKey_Alt_Slash            ((Mod1Mask << 16) | XK_slash )
#define GrKey_Alt_T                ((Mod1Mask << 16) | XK_t )
#define GrKey_Alt_Tab              ((Mod1Mask << 16) | XK_Tab )
#define GrKey_Alt_U                ((Mod1Mask << 16) | XK_u )
//#ifdef XK_KP_Up
//#define GrKey_Alt_Up               ((Mod1Mask << 16) | XK_KP_Up )
//#endif
#define GrKey_Alt_Up               ((Mod1Mask << 16) | XK_Up )
#define GrKey_Alt_V                ((Mod1Mask << 16) | XK_v )
#define GrKey_Alt_W                ((Mod1Mask << 16) | XK_w )
#define GrKey_Alt_X                ((Mod1Mask << 16) | XK_x )
#define GrKey_Alt_Y                ((Mod1Mask << 16) | XK_y )
#define GrKey_Alt_Z                ((Mod1Mask << 16) | XK_z )
#ifdef XK_ISO_Left_Tab
#define GrKey_BackTab              ((ShiftMask << 16) | XK_ISO_Left_Tab )
#endif
#define GrKey_Center               XK_5 
//#ifdef XK_KP_Begin
//#define GrKey_Center               XK_KP_Begin 
//#endif
#define GrKey_Control_At           ((ControlMask << 16) | XK_at )
#define GrKey_Control_Center       ((ControlMask << 16) | XK_5 )
//#ifdef XK_KP_Begin
//#define GrKey_Control_Center       ((ControlMask << 16) | XK_KP_Begin )
//#endif
#define GrKey_Control_Delete       ((ControlMask << 16) | XK_Delete )
//#ifdef XK_KP_Delete
//#define GrKey_Control_Delete       ((ControlMask << 16) | XK_KP_Delete )
//#endif
#define GrKey_Control_Down         ((ControlMask << 16) | XK_Down )
//#ifdef XK_KP_Down
//#define GrKey_Control_Down         ((ControlMask << 16) | XK_KP_Down )
//#endif
#define GrKey_Control_End          ((ControlMask << 16) | XK_End )
//#ifdef XK_KP_End
//#define GrKey_Control_End          ((ControlMask << 16) | XK_KP_End )
//#endif
#define GrKey_Control_F1           ((ControlMask << 16) | XK_F1 )
#define GrKey_Control_F2           ((ControlMask << 16) | XK_F2 )
#define GrKey_Control_F3           ((ControlMask << 16) | XK_F3 )
#define GrKey_Control_F4           ((ControlMask << 16) | XK_F4 )
#define GrKey_Control_F5           ((ControlMask << 16) | XK_F5 )
#define GrKey_Control_F6           ((ControlMask << 16) | XK_F6 )
#define GrKey_Control_F7           ((ControlMask << 16) | XK_F7 )
#define GrKey_Control_F8           ((ControlMask << 16) | XK_F8 )
#define GrKey_Control_F9           ((ControlMask << 16) | XK_F9 )
#define GrKey_Control_F10          ((ControlMask << 16) | XK_F10 )
#define GrKey_Control_F11          ((ControlMask << 16) | XK_F11 )
#define GrKey_Control_F12          ((ControlMask << 16) | XK_F12 )
#define GrKey_Control_Home         ((ControlMask << 16) | XK_Home )
//#ifdef XK_KP_Home
//#define GrKey_Control_Home         ((ControlMask << 16) | XK_KP_Home )
//#endif
#define GrKey_Control_Insert       ((ControlMask << 16) | XK_Insert )
//#ifdef XK_KP_Insert
//#define GrKey_Control_Insert       ((ControlMask << 16) | XK_KP_Insert )
//#endif
#ifdef XK_KP_Subtract
#define GrKey_Control_KPDash       ((ControlMask << 16) | XK_KP_Subtract )
#endif
#ifdef XK_KP_Add
#define GrKey_Control_KPPlus       ((ControlMask << 16) | XK_KP_Add )
#endif
#define GrKey_Control_KPSlash      ((ControlMask << 16) | XK_slash )
#define GrKey_Control_KPStar       ((ControlMask << 16) | XK_multiply )
#define GrKey_Control_Left         ((ControlMask << 16) | XK_Left )
//#ifdef XK_KP_Left
//#define GrKey_Control_Left         ((ControlMask << 16) | XK_KP_Left )
//#endif
#define GrKey_Control_PageDown     ((ControlMask << 16) | XK_Next )
//#ifdef XK_KP_Next
//#define GrKey_Control_PageDown     ((ControlMask << 16) | XK_KP_Next )
//#endif
#define GrKey_Control_PageUp       ((ControlMask << 16) | XK_Prior )
//#ifdef XK_KP_Prior
//#define GrKey_Control_PageUp       ((ControlMask << 16) | XK_KP_Prior )
//#endif
#define GrKey_Control_Right        ((ControlMask << 16) | XK_Right )
//#ifdef XK_KP_Right
//#define GrKey_Control_Right        ((ControlMask << 16) | XK_KP_Right )
//#endif
#define GrKey_Control_Up           ((ControlMask << 16) | XK_Up )
//#ifdef XK_KP_Up
//#define GrKey_Control_Up           ((ControlMask << 16) | XK_KP_Up )
//#endif
#ifdef XK_KP_Subtract
#define GrKey_Dash                  XK_KP_Subtract 
#endif
#define GrKey_Delete                XK_Delete 
//#ifdef XK_KP_Delete
//#define GrKey_Delete                XK_KP_Delete 
//#endif
#define GrKey_Down                  XK_Down 
//#ifdef XK_KP_Down
//#define GrKey_Down                  XK_KP_Down 
//#endif
#define GrKey_End                   XK_End 
//#ifdef XK_KP_End
//#define GrKey_End                   XK_KP_End 
//#endif
#define GrKey_F1                    XK_F1 
#define GrKey_F2                    XK_F2 
#define GrKey_F3                    XK_F3 
#define GrKey_F4                    XK_F4 
#define GrKey_F5                    XK_F5 
#define GrKey_F6                    XK_F6 
#define GrKey_F7                    XK_F7 
#define GrKey_F8                    XK_F8 
#define GrKey_F9                    XK_F9 
#define GrKey_F10                   XK_F10 
#define GrKey_F11                   XK_F11 
#define GrKey_F12                   XK_F12 
#define GrKey_Home                  XK_Home 
//#ifdef XK_KP_Home
//#define GrKey_Home                  XK_KP_Home 
//#endif
#define GrKey_Insert                XK_Insert 
//#ifdef XK_KP_Insert
//#define GrKey_Insert                XK_KP_Insert 
//#endif
#define GrKey_Left                  XK_Left 
//#ifdef XK_KP_Left
//#define GrKey_Left                  XK_KP_Left 
//#endif
#define GrKey_PageDown              XK_Next 
//#ifdef XK_KP_Next
//#define GrKey_PageDown              XK_KP_Next 
//#endif
#define GrKey_PageUp                XK_Prior 
//#ifdef XK_KP_Prior
//#define GrKey_PageUp                XK_KP_Prior 
//#endif
//#ifdef XK_KP_Add
//#define GrKey_Plus                  XK_KP_Add 
//#endif
#define GrKey_Print                 XK_Print 
#define GrKey_Right                 XK_Right 
//#ifdef XK_KP_Right
//#define GrKey_Right                 XK_KP_Right 
//#endif
#define GrKey_Shift_Down           ((ShiftMask << 16) | XK_Down )
#define GrKey_Shift_End            ((ShiftMask << 16) | XK_End )
#define GrKey_Shift_F1             ((ShiftMask << 16) | XK_F1 )
#define GrKey_Shift_F2             ((ShiftMask << 16) | XK_F2 )
#define GrKey_Shift_F3             ((ShiftMask << 16) | XK_F3 )
#define GrKey_Shift_F4             ((ShiftMask << 16) | XK_F4 )
#define GrKey_Shift_F5             ((ShiftMask << 16) | XK_F5 )
#define GrKey_Shift_F6             ((ShiftMask << 16) | XK_F6 )
#define GrKey_Shift_F7             ((ShiftMask << 16) | XK_F7 )
#define GrKey_Shift_F8             ((ShiftMask << 16) | XK_F8 )
#define GrKey_Shift_F9             ((ShiftMask << 16) | XK_F9 )
#define GrKey_Shift_F10            ((ShiftMask << 16) | XK_F10 )
#define GrKey_Shift_F11            ((ShiftMask << 16) | XK_F11 )
#define GrKey_Shift_F12            ((ShiftMask << 16) | XK_F12 )
#define GrKey_Shift_Home           ((ShiftMask << 16) | XK_Home )
#define GrKey_Shift_Insert         ((ShiftMask << 16) | XK_Insert )
#define GrKey_Shift_Left           ((ShiftMask << 16) | XK_Left )
#define GrKey_Shift_PageDown       ((ShiftMask << 16) | XK_Next )
#define GrKey_Shift_PageUp         ((ShiftMask << 16) | XK_Prior )
#define GrKey_Shift_Right          ((ShiftMask << 16) | XK_Right )
#define GrKey_Shift_Up             ((ShiftMask << 16) | XK_Up )
#define GrKey_Up                    XK_Up 
//#ifdef XK_KP_Up
//#define GrKey_Up                    XK_KP_Up 
//#endif

#define GrKey_Control_A            ((ControlMask << 16) | XK_a)
#define GrKey_Control_B            ((ControlMask << 16) | XK_b)
#define GrKey_Control_C            ((ControlMask << 16) | XK_c)
#define GrKey_Control_D            ((ControlMask << 16) | XK_d)
#define GrKey_Control_E            ((ControlMask << 16) | XK_e)
#define GrKey_Control_F            ((ControlMask << 16) | XK_f)
#define GrKey_Control_G            ((ControlMask << 16) | XK_g)
#define GrKey_Control_H            ((ControlMask << 16) | XK_h)
#define GrKey_Control_I            ((ControlMask << 16) | XK_i)
#define GrKey_Control_J            ((ControlMask << 16) | XK_j)
#define GrKey_Control_K            ((ControlMask << 16) | XK_k)
#define GrKey_Control_L            ((ControlMask << 16) | XK_l)
#define GrKey_Control_M            ((ControlMask << 16) | XK_m)
#define GrKey_Control_N            ((ControlMask << 16) | XK_n)
#define GrKey_Control_O            ((ControlMask << 16) | XK_o)
#define GrKey_Control_P            ((ControlMask << 16) | XK_p)
#define GrKey_Control_Q            ((ControlMask << 16) | XK_q)
#define GrKey_Control_R            ((ControlMask << 16) | XK_r)
#define GrKey_Control_S            ((ControlMask << 16) | XK_s)
#define GrKey_Control_T            ((ControlMask << 16) | XK_t)
#define GrKey_Control_U            ((ControlMask << 16) | XK_u)
#define GrKey_Control_V            ((ControlMask << 16) | XK_v)
#define GrKey_Control_W            ((ControlMask << 16) | XK_w)
#define GrKey_Control_X            ((ControlMask << 16) | XK_x)
#define GrKey_Control_Y            ((ControlMask << 16) | XK_y)
#define GrKey_Control_Z            ((ControlMask << 16) | XK_z)

#define GrKey_a     XK_a
#define GrKey_b     XK_b
#define GrKey_c     XK_c
#define GrKey_d     XK_d
#define GrKey_e     XK_e
#define GrKey_f     XK_f
#define GrKey_g     XK_g
#define GrKey_h     XK_h
#define GrKey_i     XK_i
#define GrKey_j     XK_j
#define GrKey_k     XK_k
#define GrKey_l     XK_l
#define GrKey_m     XK_m
#define GrKey_n     XK_n
#define GrKey_o     XK_o
#define GrKey_p     XK_p
#define GrKey_q     XK_q
#define GrKey_r     XK_r
#define GrKey_s     XK_s
#define GrKey_t     XK_t
#define GrKey_u     XK_u
#define GrKey_v     XK_v
#define GrKey_w     XK_w
#define GrKey_x     XK_x
#define GrKey_y     XK_y
#define GrKey_z     XK_z
#define GrKey_A     XK_A
#define GrKey_B     XK_B
#define GrKey_C     XK_C
#define GrKey_D     XK_D
#define GrKey_E     XK_E
#define GrKey_F     XK_F
#define GrKey_G     XK_G
#define GrKey_H     XK_H
#define GrKey_I     XK_I
#define GrKey_J     XK_J
#define GrKey_K     XK_K
#define GrKey_L     XK_L
#define GrKey_M     XK_M
#define GrKey_N     XK_N
#define GrKey_O     XK_O
#define GrKey_P     XK_P
#define GrKey_Q     XK_Q
#define GrKey_R     XK_R
#define GrKey_S     XK_S
#define GrKey_T     XK_T
#define GrKey_U     XK_U
#define GrKey_V     XK_V
#define GrKey_W     XK_W
#define GrKey_X     XK_X
#define GrKey_Y     XK_Y
#define GrKey_Z     XK_Z

#define GrKey_Return               XK_Return
#define GrKey_BackSpace            XK_BackSpace
#define GrKey_Escape               XK_Escape
#define GrKey_Tab                  XK_Tab
#define GrKey_Space                XK_space

#ifdef XK_KP_Add
#define GrKey_KPPlus           (XK_KP_Add )
#endif
#ifdef XK_KP_Divide
#define GrKey_KPSlash          (XK_KP_Divide )
#endif
#ifdef XK_KP_Multiply
#define GrKey_KPStar           (XK_KP_Multiply )
#endif
#define GrKey_Star           (XK_multiply )
#define GrKey_Plus           (XK_plus )
#define GrKey_Minus           (XK_minus )
#define GrKey_Slash           (XK_divide )


#else
// NIE MA X Windows !

#include "grx20.h"
#include "grxkeys.h"

#define GrKey_Brak           0x1000
#define GrKey_Nieistniejacy  0x1001
#define GrKey_Minus           (-1000 )
#define GrKey_KPPlus           (-1001 )
#define GrKey_KPStar           (-1002 )

extern GrFont mojfont;
extern GrFont *akt_font;

typedef int     TKlawisz;   // do pamietania przycisku na klawiaturze
typedef GrColor TKolor;     // typ do pamietania koloru

inline int Konwersja(TKlawisz k) { return k; }
#define GrFlush() 
void outtextxy(int x, int y, const char *tekst, int kolor, int kolortla, int align);
void GrFilledTrojkat(int x1, int y1, int x2, int y2, int x3, int y3, TKolor kolor);

#define BLACK  GrBlack()
#define WHITE  GrWhite()

#endif


#endif


