/*  Programik do gry w kropki.
 *  szabl2_chwil: generator (stalych) bezsensownych szablonow przy bandzie
 *
 *  Copyright (C) 2003 Bartek Dyda <bkropki@yahoo.co.uk>.
 * 
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include <stdio.h>

// szablony:
char sz[][10] ={
  "bbb"
  "1.2"
  "1 2",   // numer 0

  "bbb"
  "2.1"
  "2 1",   // numer 1

  "bbb"
  "0.0"
  "111",   // numer 2

  "bbb"
  "0.0"
  "222",   // numer 3

  "bbb"
  "1. "
  "11 ",   // numer 4

  "bbb"
  " .1"
  " 11",   // numer 5

  "bbb"
  "2. "
  "22 ",   // numer 6

  "bbb"
  " .2"
  " 22",   // numer 7
   };
int ile_sz=8;

// numeracja pol:
//   0 1 2 (banda)
//   3 4 5
//   6 7 8
// oczywiscie nie ma znaczenia, gdzie jest os x, a gdzie y (symetria)

int CzyOK(int nr_sz, int co, int pole)
// czy na polu (pole) w szablonie (nr_sz) moze stac (co)
//  co==0 -- puste pole, co==1,2 -- kropka gracza 1,2
{
 if (sz[nr_sz][pole]==' ')
   return 1;
 switch (co)
   {
   case 0:  return (sz[nr_sz][pole]=='.' || sz[nr_sz][pole]=='0');
   case 1:  return (sz[nr_sz][pole]=='1');
   case 2:  return (sz[nr_sz][pole]=='2');
   }
}

void UstawBit(unsigned long int& maska, int nrb)
{
 maska |= (((unsigned long) 1)<<nrb);
}

int main()
{
 for (int pole=0; pole<9; pole++)
   {
   printf("{");
   for (int co=0; co<=2; co++)
     {
     unsigned long int maska=0;
     for (int nr_sz=0; nr_sz<ile_sz; nr_sz++)
       if (CzyOK(nr_sz, co, pole))
         UstawBit(maska, nr_sz);
     printf("0x%04lx%s ",maska, co<2?",":"");
     }
   printf("},\n");
   }
return 0;
}
