/*   Programik do gry w kropki.
 *
 *  Copyright (C) 1999,2001,2002,2003,2004,2005,2006 Bartek Dyda <bkropki@yahoo.co.uk>.
 * 
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#if !defined(__PLA_SKL8_H)
#define __PLA_SKL8_H
// rozmiar planszy
#define max_powierzchnia_planszy 6400
#define max_bok_planszy          80
#define min_bok_planszy          7

#define sizeof_krint  2
typedef unsigned short int krint;
typedef   signed short int skrint;

// klasa przydzielajaca pamiec dla skladowych (spojnosci)  (260 jeszcze dziala szybciej, 340 nie)
#define ile_skladowych (55+13*MAX_GLEB_ANALIZY)
// klasa przydzielajaca pamiec dla planszy
#define ile_planszy (50+7*MAX_GLEB_ANALIZY)
// klasa przydzielajaca pamiec dla tablic long int'ow
#define ILE_TABLIC_LI  (10+MAX_GLEB_ANALIZY)

#ifdef USTALONA_WLK_PLANSZY
#ifndef wlkx4wlky4
#define wlkx4wlky4 ((wlkx+4)*(wlky+4))
#endif
#else
extern unsigned short int wlkx;
extern unsigned short int wlky;
extern unsigned int wlkx4wlky4;
#endif
extern unsigned char upl_x[(max_bok_planszy+4)*(max_bok_planszy+4)];
extern unsigned char upl_y[(max_bok_planszy+4)*(max_bok_planszy+4)];
extern unsigned char upl_marg[(max_bok_planszy+4)*(max_bok_planszy+4)];

#define W_G (-1)
#define W_D   1
#define W_L (-wlky-4)
#define W_P (wlky+4)

#define W_LG    (-wlky-5)
#define W_LD    (-wlky-3)
#define W_PG    (wlky+3)
#define W_PD    (wlky+5)

#define W_LLGG    (-2*wlky-10)
#define W_LLG     (-2*wlky-9)
#define W_LL      (-2*wlky-8)
#define W_LLD     (-2*wlky-7)
#define W_LLDD    (-2*wlky-6)

#define W_LGG    (-wlky-6)
#define W_LDD    (-wlky-2)
#define W_GG     (-2)
#define W_DD      2
#define W_PGG    (wlky+2)
#define W_PDD    (wlky+6)

#define W_PPGG    (2*wlky+6)
#define W_PPG     (2*wlky+7)
#define W_PP      (2*wlky+8)
#define W_PPD     (2*wlky+9)
#define W_PPDD    (2*wlky+10)

struct Tup {   // ustalone pomocnicze
  int lg, pd;
  int dind[24];
  void Ustaw();
};

class TSkladowe
  {
  public:
  krint* skladowe[ile_skladowych];
  int czy_zajete[ile_skladowych];
  int ktore_wolne[ile_skladowych], gdzie_w_wolne[ile_skladowych];
  int ile_wolnych;
  int pam;   // ile pamieci na jedna tablice (=wlkx4wlky4 zaokraglone w gore do parzystej)
  TSkladowe();
  ~TSkladowe();
  krint* PrzydzielSkladowa();
  skrint* PrzydzielSkladowaI();
  void ZwolnijSkladowa(krint* co);
  void ZwolnijSkladowa(skrint* co);
  void PrzydzielPamiec();
  void ZwolnijPamiec();
  int IleWolnych() { return ile_wolnych; };
  };

class TPlansze
  {
  public:
  unsigned char* plansze[ile_planszy];
  int czy_zajete[ile_planszy];
  int ktore_wolne[ile_planszy], gdzie_w_wolne[ile_planszy];
  int ile_wolnych;
  int pam;   // ile pamieci na jedna tablice (=wlkx4wlky4 zaokraglone w gore do podzielnej przez 4)
  TPlansze();
  ~TPlansze();
  unsigned char* PrzydzielPlansze();
  void ZwolnijPlansze(unsigned char* co);
  void PrzydzielPamiec();
  void ZwolnijPamiec();
  int IleWolnych() { return ile_wolnych; };
  };

class TTabliceLI
  {
  long int* tab[ILE_TABLIC_LI];
  unsigned char zajete [ILE_TABLIC_LI];
  public:
  TTabliceLI();
  ~TTabliceLI();
  long int* Przydziel();
  void Zwolnij(long int* co);
  void PrzydzielPamiec();
  void ZwolnijPamiec();
  int IleWolnych();
  };

#endif

