/***************************************************************************
                          knfskonqiplugin.cpp  -  description
                             -------------------
    begin                : Don Apr 25 20:47:01 CEST 2002
    copyright            : (C) 2002 by Jan Schfer
    email                : janschaefer@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <pwd.h>

#include <qtabdialog.h>
#include <qradiobutton.h>
#include <qlistview.h>
#include <qcheckbox.h>


#include <klocale.h>
#include <kurl.h>
#include <kprocess.h>
#include <kmessagebox.h>

#include "knfskonqiplugin.h"
#include "nfsdialogimpl.h"
#include "nfsfile.h"

KNfsKonqiPlugin::KNfsKonqiPlugin(QWidget *parent, const char *name) : QWidget(parent, name)
{

  QTabDialog *dialog = new QTabDialog(this);

  NFSFile *file = new NFSFile(KURL("/etc/exports"));
  file->load();

  QString path = "/pub/upload";

  nfsEntry = file->getEntryByPath(path);

  NFSDialogImpl *nfsTab;

  if (nfsEntry)
     nfsTab = new NFSDialogImpl(this,nfsEntry);
  else
     nfsTab = new NFSDialogImpl(this,file,path);

  dialog->addTab(nfsTab,i18n("NFS"));

  dialog->exec();

  if (nfsTab->modified)
  {
    file->save();
  }
}


KNfsKonqiPlugin::~KNfsKonqiPlugin()
{
  if (nfsEntry)
      delete nfsEntry;
}
