/* -*- c++ -*-
 *
 * $Id: submit.h,v 1.4 2003/07/23 18:03:47 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: submit.h,v $
 * Revision 1.4  2003/07/23 18:03:47  gibreel
 * Support for multiple host definitions using HostManager.
 *
 * Revision 1.3  2003/05/01 21:24:21  gibreel
 * Added option --read-html to control whether to attempt to read and parse
 * HTTP URLs for ed2k content, or simply send them directly to the donkey (as
 * would be the case with BitTorrent URLs).
 *
 * Revision 1.2  2003/03/10 14:52:02  gibreel
 * Support for GUI protocol 14. Specifically: Authentication with username, new
 * download file state "Queued", and support for the new message types in the
 * DonkeyProtocol class.
 *
 * Revision 1.1  2003/03/07 20:53:17  gibreel
 * Removed the ed2k handler Python scripts, and replaced them with a KDE/C++
 * application.
 *
 */

#ifndef __submit_h__
#define __submit_h__

#include <qobject.h>
#include <qintdict.h>
#include <qvaluelist.h>
#include <qstring.h>
#include <kio/job.h>
#include "donkeyprotocol.h"
#include "hostmanager.h"

class Submitter : public QObject
{

Q_OBJECT

public:

    Submitter(bool recursive, QObject* parent = NULL, char* name = NULL);

public slots:

    void submitURL(KURL& url);
    void allDone();

protected slots:

    void donkeyDisconnected(int err);
    void donkeyConnected();
    void donkeyAuthenticating();
    void jobData(KIO::Job* job, const QByteArray& data);
    void jobResult(KIO::Job* job);

private:

    void sendURLs();

    DonkeyProtocol* donkey;
    HostManager* hostManager;
    QString host, uname, pwd;
    int port, done, auth;
    QValueList<KURL> list;
    QIntDict<QString> dict;
    bool isRecursive;

signals:

    void quit();

};

#endif
