/* -*- c++ -*-
 *
 * $Id: serverinfo.h,v 1.5 2003/07/23 18:06:12 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: serverinfo.h,v $
 * Revision 1.5  2003/07/23 18:06:12  gibreel
 * Added API doc generation using the KDE doc generation build system. Briefly
 * documented as many classes as necessary to produce useful documentation.
 *
 * Revision 1.4  2003/06/28 21:17:00  gibreel
 * The file info dialog now displays file sources. Libkmldonkey received a
 * number of updates and bugfixes to facilitate this.
 *
 * Revision 1.3  2003/06/13 18:20:02  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.2  2003/03/23 23:34:59  gibreel
 * A lot of API additions, especially lists keeping track of shared files and
 * clients.
 *
 * Revision 1.1.1.1  2003/03/07 11:50:21  gibreel
 * Initial import.
 *
 */

#ifndef __libkmldonkey_serverinfo_h__
#define __libkmldonkey_serverinfo_h__

#include <qstring.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include "donkeymessage.h"

//! Representation of a server.

class ServerInfo
{

public:

    //! Server state.
    enum State {
	NotConnected = 0,
	Connecting,
	Initiating,
	Downloading,
	Connected,
	Connected2,
	NewHost,
	Removed,
	Blacklisted,
	NotConnected2
    };

    ServerInfo(DonkeyMessage* msg, int proto);
    ~ServerInfo();

    void updateServerState(DonkeyMessage* msg, int proto);

    //! The numerical ID of this server.
    const int serverNo();
    //! The name of the server.
    const QString& serverName();
    //! The network the server is on.
    const int serverNetwork();
    //! The server's description.
    const QString& serverDescription();
    //! The network address of the server.
    const QString& serverAddress();
    //! The port the server listens on.
    const short int serverPort();
    //! The server's score.
    const int serverScore();
    //! The number of users connected to the server.
    const int serverNUsers();
    //! The number of files the server is indexing.
    const int serverNFiles();
    //! The state of the server.
    const State serverState();

private:

    int num, network;
    QString name, description, address;
    short int port;
    int score;
    int nusers, nfiles;
    State state;

};

#endif
