/*
 * $Id: serverinfo.cpp,v 1.5 2003/06/13 18:20:02 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: serverinfo.cpp,v $
 * Revision 1.5  2003/06/13 18:20:02  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.4  2003/04/02 22:39:29  gibreel
 * Applied a bug fix from the mldonkey CVS tree.
 *
 * Revision 1.3  2003/03/23 23:34:59  gibreel
 * A lot of API additions, especially lists keeping track of shared files and
 * clients.
 *
 * Revision 1.2  2003/03/08 20:13:21  gibreel
 * Switched readString/writeString in DonkeyMessage from using pointers to
 * QStrings to using references, which leads to far less hassle, shorter code,
 * and less chance of memory leaks.
 *
 * Revision 1.1.1.1  2003/03/07 11:50:21  gibreel
 * Initial import.
 *
 */

#include "serverinfo.h"



ServerInfo::ServerInfo(DonkeyMessage* msg, int proto)
{
    int i,j;
    num = msg->readInt32();
    network = msg->readInt32();
    address = msg->readAddress();
    port = msg->readInt16();
    score = msg->readInt32();
    j = msg->readInt16();
    for (i=0; i<j; i++) {
	msg->readString();
	switch (msg->readInt8()) {
	case 0:
	case 1:
	    msg->readInt32();
	    break;
	case 2:
	    msg->readString();
	    break;
	case 3:
	    if (msg->readInt8())
		msg->readString();
	    else
		msg->readInt32();
	    break;
	}
    }
    nusers = msg->readInt32();
    nfiles = msg->readInt32();
    updateServerState(msg, proto);
    name = msg->readString();
    description = msg->readString();
}

ServerInfo::~ServerInfo()
{
}

void ServerInfo::updateServerState(DonkeyMessage* msg, int proto)
{
    state = (State)msg->readInt8();
    if (proto >= 12 && (state == 5 || state == 9)) msg->readInt32();
}

const int ServerInfo::serverNo()
{
    return num;
}

const QString& ServerInfo::serverName()
{
    return name;
}

const int ServerInfo::serverNetwork()
{
    return network;
}

const QString& ServerInfo::serverDescription()
{
    return description;
}

const QString& ServerInfo::serverAddress()
{
    return address;
}

const short int ServerInfo::serverPort()
{
    return port;
}

const int ServerInfo::serverScore()
{
    return score;
}

const int ServerInfo::serverNUsers()
{
    return nusers;
}

const int ServerInfo::serverNFiles()
{
    return nfiles;
}

const ServerInfo::State ServerInfo::serverState()
{
    return state;
}

