/* -*- c++ -*-
 *
 * $Id: searchinfo.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: searchinfo.h,v $
 * Revision 1.7  2003/07/23 18:06:12  gibreel
 * Added API doc generation using the KDE doc generation build system. Briefly
 * documented as many classes as necessary to produce useful documentation.
 *
 * Revision 1.6  2003/07/14 19:14:45  dipesh
 * display multible filenames as tooltip
 *
 * Revision 1.5  2003/06/30 23:30:35  gibreel
 * Preliminary friend list support. A ton of updates to the libkmldonkey API to
 * accommodate this, most notably improvements to the search handling
 * necessitated by mldonkey's somewhat awkward reporting of friend shares.
 *
 * Revision 1.4  2003/06/13 18:20:02  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.3  2003/06/13 09:50:53  dipesh
 * optional coloured server- and search lists
 *
 * Revision 1.2  2003/05/17 17:27:22  dipesh
 * More search-stuff; added avaibility-column, use the listfont, some smaller fixes
 *
 * Revision 1.1  2003/05/11 08:33:01  dipesh
 * Added initial Search-functionality.
 *
 *
 */

#ifndef __libkmldonkey_searchinfo_h__
#define __libkmldonkey_searchinfo_h__

#include <qstring.h>
#include <qintdict.h>
#include "donkeymessage.h"

//! Representation of a search result.

class ResultInfo
{
public:
    ResultInfo(DonkeyMessage* msg);
    ~ResultInfo();

    //! The numerical ID of the result.
    int resultNo() const;
    //! The file name of the result.
    const QString& resultName() const;
    //! Alternative file names found on the network.
    const QStringList& resultNames() const;
    //! The size of the result in bytes.
    int32 resultSize() const;
    //! The numerical ID of the network the file was found on.
    int32 resultNetwork() const;
    //! The file format of the result.
    const QString& resultFormat() const;
    //! Result tags.
    const QMap<QString,QVariant>& resultTags() const;
    //! A comment found for the result.
    const QString& resultComment() const;
    //! The MD4 hash of the result.
    const QByteArray& resultMD4() const;
    //! Returns true if this file has already been downloaded.
    bool resultAlreadyDone() const;

private:
    int32 num;
    int32 net;
    QString name;
    QStringList names;
    QByteArray md4;
    int32 size;
    QString format;
    QString t;
    QMap<QString,QVariant> tags;
    QString comment;
    bool already_done;
};

class SearchInfo
{
public:
    SearchInfo(int id);

    int searchNo() const;
    const QIntDict<ResultInfo>& searchResults() const;

    void addResult(ResultInfo* result);

private:
    int32 num;
    QIntDict<ResultInfo> results;
};

#endif
