/*
 * $Id: network.h,v 1.3 2003/07/23 18:06:12 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: network.h,v $
 * Revision 1.3  2003/07/23 18:06:12  gibreel
 * Added API doc generation using the KDE doc generation build system. Briefly
 * documented as many classes as necessary to produce useful documentation.
 *
 * Revision 1.2  2003/06/13 18:20:02  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.1  2003/03/08 17:08:12  gibreel
 * Lots of minor API changes.
 *
 */

#ifndef __libkmldonkey_network_h__
#define __libkmldonkey_network_h__

#include <qstring.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include "donkeymessage.h"

//! Representation of a network.

class Network
{

public:

    Network(DonkeyMessage* msg, int proto);
    ~Network();

    //! The numerical ID of the network.
    const int networkNo();
    //! The name of the network.
    const QString& networkName();
    //! Determine if the network is currently enabled.
    const bool networkEnabled();
    //! The name of the network's configuration file.
    const QString& networkConfigFile();
    //! Number of bytes uploaded to the network.
    const int64 networkUploaded();
    //! Number of bytes downloaded from the network.
    const int64 networkDownloaded();

private:

    int num;
    QString name, config_file;
    bool enabled;
    int64 uploaded, downloaded;

};

#endif
