/*
 * $Id: network.cpp,v 1.5 2003/06/13 18:20:02 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: network.cpp,v $
 * Revision 1.5  2003/06/13 18:20:02  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.4  2003/06/06 19:26:01  gibreel
 * Removed some unnecessary includes from network.cpp.
 *
 * Revision 1.3  2003/06/06 18:34:50  gibreel
 * Updated the admin directory to the latest cvs in order to support building
 * on OS X, and made a few tiny code tweaks needed for OS X. Updated README
 * with instructions on how to build on OS X.
 *
 * Revision 1.2  2003/03/08 20:13:21  gibreel
 * Switched readString/writeString in DonkeyMessage from using pointers to
 * QStrings to using references, which leads to far less hassle, shorter code,
 * and less chance of memory leaks.
 *
 * Revision 1.1  2003/03/08 17:08:12  gibreel
 * Lots of minor API changes.
 *
 */

#include "network.h"



Network::Network(DonkeyMessage* msg, int)
{
    num = msg->readInt32();
    name = msg->readString();
    enabled = msg->readInt8();
    config_file = msg->readString();
    uploaded = msg->readInt64();
    downloaded = msg->readInt64();
}

Network::~Network()
{
}

const int Network::networkNo() { return num; }
const QString& Network::networkName() { return name; }
const bool Network::networkEnabled() { return enabled; }
const QString& Network::networkConfigFile() { return config_file; }
const int64 Network::networkUploaded() { return uploaded; }
const int64 Network::networkDownloaded() { return downloaded; }
