/* -*- c++ -*-
 *
 * $Id: hostmanager.h,v 1.2 2003/07/23 18:06:12 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: hostmanager.h,v $
 * Revision 1.2  2003/07/23 18:06:12  gibreel
 * Added API doc generation using the KDE doc generation build system. Briefly
 * documented as many classes as necessary to produce useful documentation.
 *
 * Revision 1.1  2003/07/22 21:01:55  gibreel
 * Added the HostManager class for dealing with mldonkeyrc (MLDonkey connection
 * definitions as written by kcmdonkey).
 *
 */

#ifndef __libkmldonkey_hostmanager_h__
#define __libkmldonkey_hostmanager_h__

#include <qstring.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qobject.h>

class KDirWatch;

//! Representation of an MLDonkey host.

class DonkeyHost
{

public:

    DonkeyHost(const QString& h_name, const QString& h_address, int h_telnetPort, int h_guiPort,
	       const QString& h_username, const QString& h_password);
    DonkeyHost(const DonkeyHost&);
    DonkeyHost();

    //! The host ID (descriptive name) of the host.
    const QString& name() const;
    //! The network address the host.
    const QString& address() const;
    //! The telnet port.
    const int telnetPort() const;
    //! The GUI port.
    const int guiPort() const;
    //! The username to authenticate with.
    const QString& username() const;
    //! The password to authenticate with.
    const QString& password() const;

private:

    QString m_name, m_address, m_username, m_password;
    int m_telnetPort, m_guiPort;

};

//! Interface to the KMLDonkey host configuration.

class HostManager : public QObject
{
    Q_OBJECT

public:

    //! Construct a new HostManager.
    HostManager(QObject* parent = 0, const char* name = 0);

    //! Re-read the configuration from disk.
    void refreshHostList();
    //! Return a list of host IDs.
    QStringList hostList();
    //! Verify that the given string is a valid host ID.
    bool validHostName(const QString& hostName);
    //! Get the host ID of the default host.
    const QString& defaultHostName();
    //! Get a DonkeyHost object describing the default host.
    const DonkeyHost& defaultHost();
    //! Get a DonkeyHost object describing the named host.
    const DonkeyHost& hostProperties(const QString& hostName);

signals:

    //! Emitted when the host list has changed, usually because the configuration file has been updated.
    void hostListUpdated();

private slots:

    void fileChanged(const QString&);

private:

    QMap<QString,DonkeyHost> m_hosts;
    QString m_default;

    KDirWatch* configWatcher;

};

#endif
