/* -*- c++ -*-
 *
 * $Id: clientinfo.h,v 1.5 2003/07/23 18:06:12 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: clientinfo.h,v $
 * Revision 1.5  2003/07/23 18:06:12  gibreel
 * Added API doc generation using the KDE doc generation build system. Briefly
 * documented as many classes as necessary to produce useful documentation.
 *
 * Revision 1.4  2003/06/30 14:53:42  gibreel
 * Still hunting bugs in source management: implemented a lot of missing
 * message handlers pertaining to cleanup of client records. Quite a few bug
 * fixes. Protocol object now emits *Removed() signals corresponding to
 * *Updated() signals instead of sending update signals for removed records and
 * leaving the user to determine whether to remove the records.
 *
 * Revision 1.3  2003/06/28 21:17:00  gibreel
 * The file info dialog now displays file sources. Libkmldonkey received a
 * number of updates and bugfixes to facilitate this.
 *
 * Revision 1.2  2003/06/13 18:20:01  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.1  2003/03/23 23:34:59  gibreel
 * A lot of API additions, especially lists keeping track of shared files and
 * clients.
 *
 */

#ifndef __libkmldonkey_clientinfo_h__
#define __libkmldonkey_clientinfo_h__

#include <qstring.h>
#include <qmap.h>
#include <qvariant.h>
#include "donkeymessage.h"

/** Representation of a client.
 */

class ClientInfo
{

    public:

    /** Client state.
     */
    enum State {
	NotConnected = 0,
	Connecting,
	Initiating,
	Downloading,
	Connected,
	Connected2,
	NewHost,
	Removed,
	Blacklisted,
	NotConnected2
    };

    /** Client type.
     */
    enum Type {
	NormalClient = 0,
	FriendClient,
	ContactClient
    };

    ClientInfo(DonkeyMessage* msg, int proto);
    ~ClientInfo();

    //! The numerical ID of the client.
    const int clientNo();
    //! The network the client is on.
    const int clientNetwork();
    //! String describing the kind of client, either DIRECT or INDIRECT.
    const QString& clientKind();
    //! The state of the client.
    const State clientState();
    //! If the client is in state Connected, this is the position we are in the client's queue.
    const int clientQueuePosition();
    //! The client type.
    const Type clientType();
    //! Client tags.
    const QMap<QString,QVariant>& clientTags();
    //! The name of the client.
    const QString& clientName();
    //! The client's rating.
    const int clientRating();
    //! The client's chat port.
    const int clientChatPort();

    void setClientState(State newstate, int newqueue = 0);
    void setClientState(DonkeyMessage* msg, int proto);
    void setClientType(Type newtype);
    void setClientType(DonkeyMessage* msg, int proto);

private:

    int num, network;
    QString kind;
    State state;
    int queue;
    Type type;
    QMap<QString,QVariant> tags;
    QString name;
    int rating;
    int chatPort;
};

#endif
