/*
 * $Id: clientinfo.cpp,v 1.6 2003/06/30 14:53:42 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: clientinfo.cpp,v $
 * Revision 1.6  2003/06/30 14:53:42  gibreel
 * Still hunting bugs in source management: implemented a lot of missing
 * message handlers pertaining to cleanup of client records. Quite a few bug
 * fixes. Protocol object now emits *Removed() signals corresponding to
 * *Updated() signals instead of sending update signals for removed records and
 * leaving the user to determine whether to remove the records.
 *
 * Revision 1.5  2003/06/28 21:17:00  gibreel
 * The file info dialog now displays file sources. Libkmldonkey received a
 * number of updates and bugfixes to facilitate this.
 *
 * Revision 1.4  2003/06/26 23:38:52  gibreel
 * Applied patch #1665 from savannah, which fixes a compile error on some
 * platforms.
 *
 * Revision 1.3  2003/06/13 18:20:01  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.2  2003/04/02 22:39:29  gibreel
 * Applied a bug fix from the mldonkey CVS tree.
 *
 * Revision 1.1  2003/03/23 23:34:59  gibreel
 * A lot of API additions, especially lists keeping track of shared files and
 * clients.
 *
 */


#include "clientinfo.h"
#include "fileinfo.h"



ClientInfo::ClientInfo(DonkeyMessage* msg, int proto)
{
    num = msg->readInt32();
    network = msg->readInt32();
    switch (msg->readInt8()) {
    case 0: {
        QString ip = msg->readIPAddress();
        int port = msg->readInt16();
        kind = ip + ":" + QString::number(port);
    } break;
    case 1: {
        QString name = msg->readString();
        QByteArray md4(16);
        for (int i = 0; i < 16; i++)
            md4[i] = msg->readInt8();
        kind = "INDIRECT:" + FileInfo::md4ToString(md4) + ":" + name;
    } break;
    default:
        kind = "UNKNOWN";
        break;
    }
    setClientState(msg, proto);
    type = (Type)msg->readInt8();
    for (int i = msg->readInt16(); i; i--) {
        msg->readTag(tags);
    }
    name = msg->readString();
    rating = msg->readInt32();
    chatPort = msg->readInt32();
}

ClientInfo::~ClientInfo()
{
}

void ClientInfo::setClientState(ClientInfo::State newstate, int newqueue)
{
    state = newstate;
    queue = newqueue;
}

void ClientInfo::setClientState(DonkeyMessage* msg, int proto)
{
    ClientInfo::State st = (State)msg->readInt8();
    if (proto >= 12 && (st == 5 || st == 9)) setClientState(st, msg->readInt32());
    else setClientState(st);
}

void ClientInfo::setClientType(ClientInfo::Type newtype)
{
    type = newtype;
}

void ClientInfo::setClientType(DonkeyMessage* msg, int)
{
    type = (Type)msg->readInt8();
}

const int ClientInfo::clientNo() { return num; }
const int ClientInfo::clientNetwork() { return network; }
const QString& ClientInfo::clientKind() { return kind; }
const ClientInfo::State ClientInfo::clientState() { return state; }
const int ClientInfo::clientQueuePosition() { return queue; }
const ClientInfo::Type ClientInfo::clientType() { return type; }
const QMap<QString,QVariant>& ClientInfo::clientTags() { return tags; }
const QString& ClientInfo::clientName() { return name; }
const int ClientInfo::clientRating() { return rating; }
const int ClientInfo::clientChatPort() { return chatPort; }
