/* -*- c++ -*-
 *
 * $Id: webservices.cpp,v 1.2 2003/07/01 22:37:55 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: webservices.cpp,v $
 * Revision 1.2  2003/07/01 22:37:55  gibreel
 * Web services only start loading when or if they're first shown, which is
 * more economical on the network traffic.
 *
 * Revision 1.1  2003/06/30 00:34:03  gibreel
 * Added an embedded web browser class, and through it added Jigle and Bitzi
 * lookups to the file info dialog.
 *
 */

#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <fileinfo.h>

#include "kmldonkey.h"
#include "webservices.h"
#include "webservices.moc"


FileInfoWebBrowser::FileInfoWebBrowser(int fileno, QWidget* parent, const char* name)
    : WebBrowser(parent, name)
{
    fn = fileno;
    loaded = false;
}

void FileInfoWebBrowser::handleED2K(const ED2KURL& url)
{
    FileInfo* fi = KMLDonkey::App->donkey->findDownloadFileNo(fn);

    if (url.isSameFile(fi)) {
	QString body = i18n("Do you want to rename \"%1\" to \"%2\"?").arg(fi->fileName()).arg(url.fileName());
	if (KMessageBox::questionYesNo(this, body, i18n("Rename download")) == KMessageBox::Yes) {
	    QString foo = "rename " + QString::number(fn) + " \"" + url.fileName() + "\"";
	    KMLDonkey::App->sendConsoleMessage(foo);
	    KMLDonkey::App->donkey->refreshFileInfo(fn);
	}
    }
    else WebBrowser::handleED2K(url);
}

void FileInfoWebBrowser::showEvent(QShowEvent* event)
{
    WebBrowser::showEvent(event);
    if (loaded) return;
    loaded = true;
    loadWebPage();
}



BitziFileInfo::BitziFileInfo(int fileno, QWidget* parent)
    : FileInfoWebBrowser(fileno, parent, "BitziFileInfo")
{
}

void BitziFileInfo::loadWebPage()
{
    FileInfo* fi = KMLDonkey::App->donkey->findDownloadFileNo(fn);
    if (!fi) {
	openURL(KURL("http://www.bitzi.com/"));
	return;
    }

    KURL url(QString("http://www.bitzi.com/lookup/ed2k:") + FileInfo::md4ToString(fi->fileMD4()));
    openURL(url);
}

JigleFileInfo::JigleFileInfo(int fileno, QWidget* parent)
    : FileInfoWebBrowser(fileno, parent, "JigleFileInfo")
{
}

void JigleFileInfo::loadWebPage()
{
    FileInfo* fi = KMLDonkey::App->donkey->findDownloadFileNo(fn);
    if (!fi) {
	openURL(KURL("http://jigle.com/"));
	return;
    }

    KURL url(QString("http://jigle.com/search?p=ed2k:") + QString::number(fi->fileSize()) + ":" + FileInfo::md4ToString(fi->fileMD4()));
    openURL(url);
}
