/* -*- c++ -*-
 *
 * $Id: webbrowser.h,v 1.2 2003/06/30 23:30:35 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: webbrowser.h,v $
 * Revision 1.2  2003/06/30 23:30:35  gibreel
 * Preliminary friend list support. A ton of updates to the libkmldonkey API to
 * accommodate this, most notably improvements to the search handling
 * necessitated by mldonkey's somewhat awkward reporting of friend shares.
 *
 * Revision 1.1  2003/06/30 00:34:03  gibreel
 * Added an embedded web browser class, and through it added Jigle and Bitzi
 * lookups to the file info dialog.
 *
 */

#ifndef __kmldonkey_webbrowser_h__
#define __kmldonkey_webbrowser_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qcstring.h>
#include <qvaluelist.h>
#include <kurl.h>
#include <khtml_part.h>
#include <donkeymessage.h>

class KSqueezedTextLabel;
class KProgress;
class FileInfo;
class KPushButton;

class ED2KURL
{
public:

    ED2KURL(const KURL& u);
    ED2KURL(FileInfo*);
    ED2KURL(ShareInfo*);
    ED2KURL(ResultInfo*);
    ED2KURL(ServerInfo*);

    QString ed2kType() const;

    QString serverAddress() const;
    int16 serverPort() const;

    QString fileName() const;
    int64 fileSize() const;
    QByteArray fileHash() const;

    bool isSameFile(const ED2KURL& u) const;

    QString toString() const;

    bool isInvalid() const;

private:

    QString type, address, name;
    QByteArray hash;
    int64 size;
    int16 port;

};

class WebBrowser : public QWidget
{
    Q_OBJECT
public:

    WebBrowser(QWidget* parent = 0, const char* name = 0);

    virtual void handleED2K(const ED2KURL& url);

public slots:

    void openURL(const QString& url);
    void openURL(const KURL& url);

protected slots:

    void slotUrlSelected(const KURL& url, const KParts::URLArgs& args);
    void setStatusBarText(const QString& text);
    void loadingProgress(int percent);

    void backState();
    void forwardState();
    void goHome();

private:
    void restoreState(const QByteArray& state);
    QByteArray saveState();
    void pushState();

    KHTMLPart* browser;
    KSqueezedTextLabel* statusbar;
    KProgress* progressbar;
    KPushButton *backButton, *forwardButton, *homeButton;

    QValueList<QByteArray> history;
    uint hpos;
    KURL initialURL;
    bool initialState;
};


#endif // __kmldonkey_webbrowser_h__
