/* -*- c++ -*-
 *
 * $Id: search.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: search.h,v $
 * Revision 1.26  2003/07/27 20:24:26  gibreel
 * Added KActions for switching between pages.
 *
 * Revision 1.25  2003/07/19 20:20:32  gibreel
 * Uses autoconf to detect the presence of KTabWidget, rather than guessing its
 * presence using KDE_IS_VERSION.
 *
 * Revision 1.24  2003/07/19 14:18:22  gibreel
 * Uses KTabWidget instead of QTabWidget/ClosableTabWidget if available (KDE
 * 3.2 or CVS). ClosableTabWidget API changed to match KTabWidget's.
 *
 * Revision 1.23  2003/07/14 19:14:45  dipesh
 * display multible filenames as tooltip
 *
 * Revision 1.22  2003/06/30 23:30:35  gibreel
 * Preliminary friend list support. A ton of updates to the libkmldonkey API to
 * accommodate this, most notably improvements to the search handling
 * necessitated by mldonkey's somewhat awkward reporting of friend shares.
 *
 * Revision 1.21  2003/06/29 10:56:30  dipesh
 * converted search-pref "Ask for filename on starting a new download" to the
 * KAction "Download as..." to be more flexible and remember some more
 * searchpage values.
 *
 * Revision 1.20  2003/06/28 10:42:25  dipesh
 * Added search-pref "Ask for filename on starting a new download".
 *
 * Revision 1.19  2003/06/27 12:50:39  dipesh
 * added search-pref to optional display numbers of files found on tabs,
 * searchfilter does understand filesizes (fe. >2MB), use function-inline
 * where it make sense and some other things.
 *
 * Revision 1.18  2003/06/23 18:26:29  dipesh
 * Added initial search-prefs, more later
 *
 * Revision 1.17  2003/06/23 12:59:51  dipesh
 * Added KAction's "Copy search URL/HTML/Hash to Clipboard"
 *
 * Revision 1.16  2003/06/20 00:05:44  dipesh
 * use restoreState/saveState, great work done with the last commits Petter! :-)
 *
 * Revision 1.15  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 * Revision 1.14  2003/06/19 17:04:32  gibreel
 * Minor code cleanups and attempt to fix the crash bugs on
 * disconnect/reconnect. Both kmldonkey and libkmldonkey now clean out their
 * state data when the connection with the core is lost.
 *
 * Revision 1.13  2003/06/18 21:37:12  dipesh
 * Some small corrections
 *
 * Revision 1.12  2003/06/14 12:12:57  dipesh
 * Corrected update of networklist
 *
 * Revision 1.11  2003/06/14 02:46:41  dipesh
 * specify which network to search if the GUI protocol is >= 16
 *
 * Revision 1.10  2003/06/13 18:20:01  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.9  2003/06/13 09:50:53  dipesh
 * optional coloured server- and search lists
 *
 * Revision 1.8  2003/05/20 17:00:17  dipesh
 * Added search-result filter
 *
 * Revision 1.7  2003/05/18 17:58:22  dipesh
 * Added KAction's Download, ForceDownload and RemoveServers
 *
 * Revision 1.6  2003/05/17 17:27:22  dipesh
 * More search-stuff; added avaibility-column, use the listfont, some smaller fixes
 *
 * Revision 1.5  2003/05/17 15:00:04  dipesh
 * fixed sorting of column "Size" in SearchResultItem and made the sorting
 * case-insensitive in InfoItem
 *
 * Revision 1.4  2003/05/17 10:52:24  dipesh
 * Added more search-options
 *
 * Revision 1.3  2003/05/12 00:21:11  gibreel
 * Added a close button to the search result tabs.
 *
 * Revision 1.2  2003/05/11 18:55:15  dipesh
 * Replaced the used KTabCtl with a QTabWidget to get more flexibility and fix
 * a small repaint-Bug.
 *
 * Revision 1.1  2003/05/11 08:34:09  dipesh
 * Adding initial Search-functionality
 *
 */

#ifndef __kmldonkey_search_h__
#define __kmldonkey_search_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "infolist.h"
#include "page.h"
#include "clipboard.h"

#include <qvbox.h>
#include <qintdict.h>
#include <qstringlist.h>
#include <qtooltip.h>

class KListView;
class KComboBox;
class KLineEdit;

#ifdef HAVE_KTABWIDGET
class KTabWidget;
#else
class ClosableTabWidget;
#endif

class SearchResultItem : public InfoItem
{
public:
    SearchResultItem(KListView *parent, int num, int32 avail, const ResultInfo *searchinfo);
    ~SearchResultItem();

    virtual double numeric(int col) const;
    virtual bool isNumeric(int col) const;
    void paintCell(QPainter* p, const QColorGroup& cg, int col, int w, int align);

    inline int getNum();
    inline QStringList getNames();
    inline int64 getSize();

private:
    int number;
    QStringList names;
    int64 filesize;
    int32 availability;
    bool alreadydone;
};

class SearchResultView : public InfoList, QToolTip
{
    Q_OBJECT
public:
    SearchResultView(QWidget *parent = 0, const char *name = 0);
protected:
    virtual void maybeTip(const QPoint&);
};

class SearchResult : public QVBox
{
    Q_OBJECT
public:
    SearchResult(int sno, const QString &tabLabel, QWidget *parent);
    ~SearchResult();

    inline int searchNo();
    inline const QString& getTabLabel();
    inline void setSearchLabel(const QString &text);
    inline void setListFont(const QFont& font);

    void AddItem(const ResultInfo* searchinfo);
    void DownloadSelectedItems(bool force, bool askForFilename);

    SearchResultView *resultView;

private:
    int id;
    QString tabLabel;
    int visibleCount;

    QHBox *statusBox;
    QStringList filters;
    KLineEdit *filterEdit;
    QTimer *filterTimer;
    QLabel *searchLabel;
    QLabel *statusLabel;

    inline void setStatusLabel();
    bool filterItem(SearchResultItem *item);

protected slots:
    void filterChanged();
    void filterTimerDone();
    void contextSearchResult(KListView*,QListViewItem*,const QPoint&);
};

class SearchPage : public QVBox, public KMLDonkeyPage, public ClipboardHelper
{
    Q_OBJECT
public:
    SearchPage(QWidget *parent);

    virtual void setupActions(KActionCollection*);
    virtual void configurePrefsDialog(KMLDonkeyPreferences*);
    virtual void applyPreferences(KMLDonkeyPreferences*);
    virtual void saveState(KConfig*);
    virtual void restoreState(KConfig*);
    virtual void clear();

private:
#ifdef HAVE_KTABWIDGET
    KTabWidget *resultTabs;
#else
    ClosableTabWidget *resultTabs;
#endif
    QSplitter *splitter;
    KLineEdit *keywordsEdit;
    KComboBox *minsizeCombo;
    KComboBox *maxsizeCombo;
    KComboBox *mediaCombo;
    KComboBox *formatCombo;
    KLineEdit *mp3ArtistEdit;
    KLineEdit *mp3TitleEdit;
    KLineEdit *mp3AlbumEdit;
    KComboBox *mp3BitrateCombo;
    KLineEdit *maxhitsEdit;
    KComboBox *searchtypeCombo;
    KComboBox *searchnetCombo;

    int searchNum;
    QIntDict<SearchResult> Results;
    int maxHits;
    int searchType;
    QString searchNetwork;    

    bool activateNewTabs;
    bool closeTabsOnDisconnect;
    bool showNumbersOnTabs;

    inline QString getTabLabel(SearchResult *tab);

protected:
    void copySearchToClipboard(ClipFormat format);

protected slots:
    void setNetworks(int);
    void startSearch();
    void closeSearch(QWidget*);
    void searchUpdated(int, const ResultInfo*);
    void closeAllSearches();

public slots:
    void actionDownload();
    void actionDownloadAs();
    void actionForceDownload();
    void actionCopyURL();
    void actionCopyHTML();
    void actionCopyHash();

    void actionActivatePage();
};

#endif // __kmldonkey_search_h__
