/*
 * $Id: renamedialog.h,v 1.1 2003/03/24 15:36:52 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: renamedialog.h,v $
 * Revision 1.1  2003/03/24 15:36:52  gibreel
 * More work; still not complete, but getting there.
 *
 */

#ifndef __kmldonkey_renamedialog_h__
#define __kmldonkey_renamedialog_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>
#include <klineedit.h>
#include <kcombobox.h>

#include <donkeyprotocol.h>

class RenameDialog : public KDialogBase
{
    Q_OBJECT
public:
    RenameDialog(DonkeyProtocol* protocol, int file);

protected slots:
    virtual void slotDefault();
    virtual void slotTry();
    virtual void slotOk();

signals:
    void renameFile(int fileno, QString& name);

private:
    DonkeyProtocol* donkey;
    int fileno;

    KLineEdit *nameView, *sizeView, *hashView, *formatView;
    KComboBox* nameEdit;

};

#endif // __kmldonkey_renamedialog_h__
