/*
 * $Id: prefs.cpp,v 1.20 2003/07/23 18:04:39 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: prefs.cpp,v $
 * Revision 1.20  2003/07/23 18:04:39  gibreel
 * Support for multiple host definitions using HostManager. Configurable
 * charset encoding.
 *
 * Revision 1.19  2003/06/30 14:59:22  gibreel
 * Updated lists to support libkmldonkey's new removed signals. Moved pages'
 * connect statements out of KMLDonkey's constructor into their own
 * constructors. Added a debug console displaying dumps of unhandled messages.
 *
 * Revision 1.18  2003/06/29 10:56:30  dipesh
 * converted search-pref "Ask for filename on starting a new download" to the
 * KAction "Download as..." to be more flexible and remember some more
 * searchpage values.
 *
 * Revision 1.17  2003/06/28 21:55:13  gibreel
 * Configurable coloured source list.
 *
 * Revision 1.16  2003/06/28 10:42:25  dipesh
 * Added search-pref "Ask for filename on starting a new download".
 *
 * Revision 1.15  2003/06/27 12:50:39  dipesh
 * added search-pref to optional display numbers of files found on tabs,
 * searchfilter does understand filesizes (fe. >2MB), use function-inline
 * where it make sense and some other things.
 *
 * Revision 1.14  2003/06/23 18:26:28  dipesh
 * Added initial search-prefs, more later
 *
 * Revision 1.13  2003/06/19 22:21:09  gibreel
 * A saner fix for the disconnect/reconnect bug, which in turn solves a bug
 * introduced by the previous fix.
 *
 * Revision 1.12  2003/06/19 22:05:52  gibreel
 * Merged the General and Donkey prefs pages back together.
 *
 * Revision 1.11  2003/06/19 17:04:32  gibreel
 * Minor code cleanups and attempt to fix the crash bugs on
 * disconnect/reconnect. Both kmldonkey and libkmldonkey now clean out their
 * state data when the connection with the core is lost.
 *
 * Revision 1.10  2003/06/13 09:50:53  dipesh
 * optional coloured server- and search lists
 *
 * Revision 1.9  2003/06/09 23:45:36  gibreel
 * Availability threshold config uses a KIntNumInput instead of a QSlider.
 *
 * Revision 1.8  2003/06/09 18:10:23  gibreel
 * Configurable availability display colours. Extended the DCOP interface and
 * improved the interaction between the GUI and the applet. Added colour for
 * the download list's queued state. Cleanups, bugfixes all round.
 *
 * Revision 1.7  2003/05/30 12:18:32  dipesh
 * Forgot to add Tooltips to the new Widgets, sorry
 *
 * Revision 1.6  2003/05/30 11:53:00  dipesh
 * Optional colored Downloadlist
 *
 * Revision 1.5  2003/05/26 15:49:46  gibreel
 * Improved connect/disconnect code: added KActions for connecting to and
 * disconnecting from the mldonkey core, and an option for trying to stay
 * connected at all times (behaving essentially like the applet does).
 *
 * Revision 1.4  2003/05/26 14:31:46  dipesh
 * Added prefs; Statusbar-label's + save on exit
 *
 * Revision 1.3  2003/05/03 13:33:42  dipesh
 * *** empty log message ***
 *
 * Revision 1.2  2003/04/27 16:10:08  gibreel
 * Applied another patch from dipesh <dipesh@gmx.de> which adds the Show All
 * Servers action to the prefs dialog, and cleans up prefs handling a little.
 * The prefs dialog now also remembers its size.
 *
 * Revision 1.1  2003/03/23 23:40:01  gibreel
 * Preliminary version of standalone GUI.
 *
 */

#include "prefs.h"

#include <kglobal.h>
#include <kconfig.h>
#include <klocale.h>
#include <kdebug.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qgroupbox.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include <kpushbutton.h>
#include <kfontdialog.h>
#include <kfontcombo.h>
#include <kiconloader.h>
#include <knuminput.h>
#include <kcharsets.h>

KMLDonkeyPrefGeneralPage::KMLDonkeyPrefGeneralPage(QWidget *parent)
    : QVBox(parent)
{
    ShowToolbarCheckbox = new QCheckBox(i18n("Show toolbar"), this, "ShowToolbar");
    QToolTip::add(ShowToolbarCheckbox, i18n("Show or hide the toolbar"));

    ShowStatusbarCheckbox = new QCheckBox(i18n("Show statusbar"), this, "ShowStatusbar");
    QToolTip::add(ShowStatusbarCheckbox, i18n("Show or hide the statusbar"));

    StatusbarLabelsCheckbox = new QCheckBox(i18n("Show labels in statusbar"), this, "ShowStatusbarLabels");
    QToolTip::add(StatusbarLabelsCheckbox, i18n("Show or hide the labels in the statusbar"));

    SaveStatCheckbox = new QCheckBox(i18n("Save status on exit"), this, "SaveStatCheckbox");
    QToolTip::add(SaveStatCheckbox, i18n("Save status on exit"));

    ShowAllServersCheckbox = new QCheckBox(i18n("Show all servers"), this, "ShowAllServersCheckbox");
    QToolTip::add(ShowAllServersCheckbox, i18n("Show all servers in the server list or just the connected ones"));

    PersistentReconnectCheckbox = new QCheckBox(i18n("Always stay connected"), this, "PersistentReconnectCheckbox");
    QToolTip::add(PersistentReconnectCheckbox,
                  i18n("If connection to the core fails or is lost, should KMLDonkey keep trying to reestablish contact until it succeeds?"));

    DebugConsoleCheckbox = new QCheckBox(i18n("Enable debug console"), this, "DebugConsoleCheckbox");
    QToolTip::add(DebugConsoleCheckbox,
		  i18n("Show the debug console. You won't ever need this unless you're a KMLDonkey developer. Honest."));

    QHBox* hbox = new QHBox(this);
    QLabel* encodingLabel = new QLabel(i18n("Text encoding:"), hbox);
    encodingSelector = new KComboBox(hbox, "encodingSelector");
    encodingLabel->setBuddy(encodingSelector);
    QToolTip::add(encodingSelector, i18n("The character set to use to decode the strings sent to us by the core."));
    QWhatsThis::add(encodingSelector, i18n("<p>While MLDonkey doesn't understand about character encodings, you may well "
					   "encounter text on the Donkey network that has been encoded in various "
					   "national character sets. While you should, in general, use the ISO 8859-1 "
					   "encoding, which is the de facto network standard, you can choose a different "
					   "character encoding here if you expect most of the text you encounter to be "
					   "encoded in a certain national character set.</p>"
					   "<p><b>Note:</b> Changing this causes KMLDonkey to reconnect to the core. "
					   "Changing it to something incompatible with the ISO 8859-1 character set "
					   "<em>may</em> cause unpredictable behaviour.</p>"));
    encodingSelector->insertStringList(KGlobal::charsets()->descriptiveEncodingNames());

    setStretchFactor(new QWidget(this), 1);
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
    setMinimumSize(sizeHint());
}

void KMLDonkeyPrefGeneralPage::setEncoding(const QString& name)
{
    int i;
    QString encoding = "( " + name.lower() + " )";
    for (i = 0; i < encodingSelector->count(); i++)
	if (encodingSelector->text(i).lower().find(encoding) != -1) {
	    encodingSelector->setCurrentItem(i);
	    return;
	}
}

QString KMLDonkeyPrefGeneralPage::getEncoding()
{
    return KGlobal::charsets()->encodingForName(encodingSelector->currentText());
}

KMLDonkeyPrefSearchPage::KMLDonkeyPrefSearchPage(QWidget *parent)
    : QVBox(parent)
{
    activateNewTabsCheckbox = new QCheckBox(i18n("Bring new searchtabs to front"), this, "activateNewSearchTabs");
    //QToolTip::add(activateNewTabsCheckbox, i18n(""));

    closeTabsOnDisconnectCheckbox = new QCheckBox(i18n("Close searchtabs on disconnect"), this, "closeSearchesOnDisconnect");
    //QToolTip::add(closeSearchesOnDisconnectCheckbox, i18n(""));

    showNumbersOnTabsCheckbox = new QCheckBox(i18n("Show numbers of files found on tabs"), this, "showNumbersOnTabs");
    //QToolTip::add(showNumbersOnTabsCheckbox, i18n(""));

    setStretchFactor(new QWidget(this), 1);
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
    setMinimumSize(sizeHint());
}

KMLDonkeyPrefColorPage::KMLDonkeyPrefColorPage(QWidget *parent)
    : QTabWidget(parent)
{
    // Page "Server"
    QVBox *svBox = new QVBox();
    svBox->setSpacing(6);
    svBox->setMargin(11);
    addTab(svBox, i18n("Server"));

    colorServerCheckbox = new QCheckBox(svBox);
    colorServerCheckbox->setText(i18n("Coloured server list"));
    QToolTip::add(colorServerCheckbox, i18n("Colourise items in the server list according to their status"));
    connect(colorServerCheckbox, SIGNAL(toggled(bool)), this, SLOT(colorServer(bool)));

    serverPage = new QVBox(svBox);
    serverPage->setSpacing(6);
    colorServerNotConnected = new ColorSelector(serverPage, "colorNotConnected", i18n("Not connected:"), i18n("Colour for disconnected servers") );
    colorServerBlacklisted = new ColorSelector(serverPage, "colorBlacklisted", i18n("Blacklisted:"), i18n("Colour for blacklisted servers") );
    colorServerConnecting = new ColorSelector(serverPage, "colorConnecting", i18n("Connecting:"), i18n("Colour for connecting or initiating servers") );
    colorServerConnected = new ColorSelector(serverPage, "colorConnected", i18n("Connected:"), i18n("Colour for connected servers") );

    svBox->setStretchFactor(new QWidget(svBox), 1);

    // Page "Search"
    QVBox *srBox = new QVBox();
    srBox->setSpacing(6);
    srBox->setMargin(11);
    addTab(srBox, i18n("Search"));

    colorSearchCheckbox = new QCheckBox(srBox);
    colorSearchCheckbox->setText(i18n("Coloured search list"));
    QToolTip::add(colorSearchCheckbox, i18n("Colourise items in the searchresult lists according to their status"));
    connect(colorSearchCheckbox, SIGNAL(toggled(bool)), this, SLOT(colorSearch(bool)));

    searchPage = new QVBox(srBox);
    searchPage->setSpacing(6);
    colorSearchFewSources = new ColorSelector(searchPage, "colorFewSources", i18n("Few sources:"), i18n("The colour indicating few sources") );
    colorSearchManySources = new ColorSelector(searchPage, "colorManySources", i18n("Many sources:"), i18n("The colour indicating many sources") );
    colorSearchAlreadyDone = new ColorSelector(searchPage, "colorAlreadydone", i18n("Already done:"), i18n("Colour for already downloaded sources") );

    QHBox *srtBox = new QHBox(searchPage);
    new QLabel(i18n("Threshold:"), srtBox);
    searchSourcesThresholdSlider = new KIntNumInput(srtBox, "searchSourcesThreshold");
    searchSourcesThresholdSlider->setRange(2, 100, 10, true);
    QToolTip::add(searchSourcesThresholdSlider, i18n("The number of sources that will produce the full 'many sources' colour"));

    srBox->setStretchFactor(new QWidget(srBox), 1);

    // Page "Download"
    QVBox *dlBox = new QVBox();
    dlBox->setSpacing(6);
    dlBox->setMargin(11);
    addTab(dlBox, i18n("Downloaded"));

    colorDownloadCheckbox = new QCheckBox(dlBox);
    colorDownloadCheckbox->setText(i18n("Coloured download list"));
    QToolTip::add(colorDownloadCheckbox, i18n("Colourise items in the download list according to their status"));
    connect(colorDownloadCheckbox, SIGNAL(toggled(bool)), this, SLOT(colorDownload(bool)));

    downloadPage = new QVBox(dlBox);
    downloadPage->setSpacing(6);
    downloadingColorSelect = new ColorSelector(downloadPage, "colorDownloading", i18n("Downloading:"), i18n("Colour for active downloads (receiving data)") );
    lookingColorSelect = new ColorSelector(downloadPage, "colorLooking", i18n("Looking:"), i18n("Colour for inactive downloads (looking for sources)") );
    queuedColorSelect = new ColorSelector(downloadPage, "colorQueued", i18n("Queued:"), i18n("Colour for queued downloads") );
    pausedColorSelect = new ColorSelector(downloadPage, "colorPaused", i18n("Paused:"), i18n("Colour for paused downloads") );

    dlBox->setStretchFactor(new QWidget(dlBox), 1);

    // Page "Availability"
    QVBox *avBox = new QVBox();
    avBox->setSpacing(6);
    avBox->setMargin(11);
    addTab(avBox, i18n("Availability"));

    fewSourcesColorSelect = new ColorSelector(avBox, "colorFewSources", i18n("Few sources:"), i18n("The colour indicating few sources") );
    manySourcesColorSelect = new ColorSelector(avBox, "colorManySources", i18n("Many sources:"), i18n("The colour indicating many sources") );
    completeColorSelect = new ColorSelector(avBox, "colorComplete", i18n("Complete:"), i18n("The colour indicating a complete chunk") );
    noSourcesColorSelect = new ColorSelector(avBox, "colorNoSources", i18n("No sources:"), i18n("The colour indicating no sources found"));

    QHBox *avtBox = new QHBox(avBox);
    new QLabel(i18n("Threshold:"), avtBox);
    availabilityThresholdSlider = new KIntNumInput(avtBox, "availabilityThreshold");
    availabilityThresholdSlider->setRange(2, 100, 10, true);
    QToolTip::add(availabilityThresholdSlider, i18n("The number of sources that will produce the full 'many sources' colour"));

    avBox->setStretchFactor(new QWidget(avBox), 1);

    // Page "Sources"
    QVBox *srcBox = new QVBox();
    srcBox->setSpacing(6);
    srcBox->setMargin(11);
    addTab(srcBox, i18n("Sources"));

    colorSourcesCheckbox = new QCheckBox(srcBox);
    colorSourcesCheckbox->setText(i18n("Coloured file source list"));
    QToolTip::add(colorSourcesCheckbox, i18n("Colourise items in the file source list according to their status"));
    connect(colorSourcesCheckbox, SIGNAL(toggled(bool)), this, SLOT(colorSources(bool)));

    sourcePage = new QVBox(srcBox);
    sourcePage->setSpacing(6);
    colorSourceNotConnected = new ColorSelector(sourcePage, "colorNotConnected", i18n("Not connected:"), i18n("Colour for disconnected sources") );
    colorSourceBlacklisted = new ColorSelector(sourcePage, "colorBlacklisted", i18n("Blacklisted:"), i18n("Colour for blacklisted sources") );
    colorSourceConnecting = new ColorSelector(sourcePage, "colorConnecting", i18n("Connecting:"), i18n("Colour for connecting or initiating sources") );
    colorSourceQueued = new ColorSelector(sourcePage, "colorQueued", i18n("Queued:"), i18n("Colour for queued sources") );
    colorSourceDownloading = new ColorSelector(sourcePage, "colorDownloading", i18n("Downloading:"), i18n("Colour for sources being downloaded from") );

    srcBox->setStretchFactor(new QWidget(srcBox), 1);

    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
    setMinimumSize(sizeHint());
}

void KMLDonkeyPrefColorPage::colorServer(bool on) { serverPage->setEnabled(on); }
void KMLDonkeyPrefColorPage::colorSearch(bool on) { searchPage->setEnabled(on); }
void KMLDonkeyPrefColorPage::colorDownload(bool on) { downloadPage->setEnabled(on); }
void KMLDonkeyPrefColorPage::colorSources(bool on) { sourcePage->setEnabled(on); }

KMLDonkeyPrefFontPage::KMLDonkeyPrefFontPage(QWidget *parent)
    : QFrame(parent)
{
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
    QGridLayout *layout = new QGridLayout(this, 3, 2, 6);

    layout->addWidget(new QLabel(i18n("Console Font:"), this), 0, 0);
    consoleFontSelect = new FontSelector(this, "consoleFontSelect", true);
    QToolTip::add(consoleFontSelect, i18n("Font used for the console"));
    layout->addWidget(consoleFontSelect, 0, 1);

    layout->addWidget(new QLabel(i18n("List Font:"), this), 1, 0);
    listFontSelect = new FontSelector(this, "listFontSelect");
    QToolTip::add(listFontSelect, i18n("Font used for the lists"));
    layout->addWidget(listFontSelect, 1, 1);

    setMinimumSize(sizeHint());
}

KMLDonkeyPreferences::KMLDonkeyPreferences(QWidget* parent)
    : KDialogBase(IconList, i18n("KMLDonkey Preferences"),
                  Help|Ok|Apply|Cancel, Ok, parent) // |Default
{
    KIconLoader* icons = KGlobal::iconLoader();

    generalPage = new KMLDonkeyPrefGeneralPage((QWidget*) addVBoxPage(i18n("General"), i18n("General Configuration"), icons->loadIcon("configure", KIcon::Desktop)) );
    searchPage = new KMLDonkeyPrefSearchPage((QWidget*) addVBoxPage(i18n("Search"), i18n("Search Configuration"), icons->loadIcon("find", KIcon::Desktop)) );
    colorPage = new KMLDonkeyPrefColorPage( (QWidget*) addVBoxPage(i18n("Colors"), i18n("Colour Configuration"), icons->loadIcon("colors", KIcon::Desktop)) );
    fontPage = new KMLDonkeyPrefFontPage((QWidget*) addVBoxPage(i18n("Fonts"), i18n("Font Configuration"), icons->loadIcon("fonts", KIcon::Desktop)) );

    setInitialSize(configDialogSize("PrefsDialog"));
    connect(this, SIGNAL(finished()), this, SLOT(saveSize()));

    showPage(0);
}

void KMLDonkeyPreferences::saveSize()
{
    saveDialogSize("PrefsDialog");
}

#include "prefs.moc"
