/*
 * $Id: main.cpp,v 1.7 2003/06/23 13:09:00 dipesh Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: main.cpp,v $
 * Revision 1.7  2003/06/23 13:09:00  dipesh
 * Added a "Developer" note to myself :-)
 *
 * Revision 1.6  2003/06/09 18:10:23  gibreel
 * Configurable availability display colours. Extended the DCOP interface and
 * improved the interaction between the GUI and the applet. Added colour for
 * the download list's queued state. Cleanups, bugfixes all round.
 *
 * Revision 1.5  2003/05/29 20:37:54  gibreel
 * Cleaned up KAboutData structures for console display.
 *
 * Revision 1.4  2003/05/22 11:36:05  gibreel
 * Updated icon names.
 *
 * Revision 1.3  2003/05/11 08:34:09  dipesh
 * Adding initial Search-functionality
 *
 * Revision 1.2  2003/05/01 16:59:09  gibreel
 * Removed the GUI functionality from the applet, and reimplemented the GUI
 * button as a launcher and hide button (over DCOP) for the standalone GUI.
 *
 * Revision 1.1  2003/03/23 23:40:01  gibreel
 * Preliminary version of standalone GUI.
 *
 */

#include <stdlib.h>
#include <kuniqueapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kdebug.h>

#include "config.h"
#include "kmldonkey.h"

static KCmdLineOptions options[] =
{
    { 0, 0, 0 }
};

int main(int argc, char **argv)
{
    KAboutData about("kmldonkey", I18N_NOOP("KMLDonkey"), VERSION,
		     I18N_NOOP("An MLDonkey frontend for the KDE desktop."),
                     KAboutData::License_GPL_V2, I18N_NOOP("Copyright (C) 2003 Petter E. Stokke"),
		     I18N_NOOP("Part of the KMLDonkey package."),
		     "http://www.gibreel.net/projects/kmldonkey/", "gibreel@gibreel.net");
    about.addAuthor("Petter E. Stokke", I18N_NOOP("Lead developer"), "gibreel@gibreel.net");
    about.addAuthor("Sebastian Sauer", I18N_NOOP("Developer"), "mail@dipesh.de");
    about.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"), I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KUniqueApplication::addCmdLineOptions();

    if (!KUniqueApplication::start()) {
	QByteArray data;
	QDataStream arg(data, IO_WriteOnly);
	arg << true;
	DCOPClient client;
	client.registerAs("kmldonkeyLauncher");
	client.send("kmldonkey", "KMLDonkey", "setShown(bool)", data);
	exit(0);
    }

    KUniqueApplication app;

    // register ourselves as a dcop client
    app.dcopClient()->registerAs(app.name(), false);

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    args->clear();

    KMLDonkey *widget = new KMLDonkey;
    widget->show();

    return app.exec();
}
