/* -*- c++ -*-
 *
 * $Id: infolist.h,v 1.8 2003/06/30 23:30:35 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: infolist.h,v $
 * Revision 1.8  2003/06/30 23:30:35  gibreel
 * Preliminary friend list support. A ton of updates to the libkmldonkey API to
 * accommodate this, most notably improvements to the search handling
 * necessitated by mldonkey's somewhat awkward reporting of friend shares.
 *
 * Revision 1.7  2003/06/28 21:17:00  gibreel
 * The file info dialog now displays file sources. Libkmldonkey received a
 * number of updates and bugfixes to facilitate this.
 *
 * Revision 1.6  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 * Revision 1.5  2003/06/13 09:50:53  dipesh
 * optional coloured server- and search lists
 *
 * Revision 1.4  2003/06/09 18:10:23  gibreel
 * Configurable availability display colours. Extended the DCOP interface and
 * improved the interaction between the GUI and the applet. Added colour for
 * the download list's queued state. Cleanups, bugfixes all round.
 *
 * Revision 1.3  2003/04/13 17:59:46  gibreel
 * File info dialog and coloured availability bars.
 *
 * Revision 1.2  2003/03/24 15:36:52  gibreel
 * More work; still not complete, but getting there.
 *
 * Revision 1.1  2003/03/23 23:40:01  gibreel
 * Preliminary version of standalone GUI.
 *
 * Revision 1.1.1.1  2003/03/07 11:50:11  gibreel
 * Initial import.
 *
 */

#ifndef __infolist_h__
#define __infolist_h__

#include <klistview.h>
#include "availability.h"


class InfoList : public KListView

{
public:
    InfoList(QWidget* parent = 0, const char* name = 0);
    ~InfoList();

    int addColumn(const QString& label, int width = -1);
};


class InfoItem : public KListViewItem

{
public:
    InfoItem( KListView *parent, int file );
    ~InfoItem();

    void setFileNo( int file );
    int fileNo();
    int compare(QListViewItem*, int, bool) const;
    virtual double numeric(int) const;
    virtual bool isNumeric(int) const;

protected:
    int fileno;
};



class DownloadFile : public InfoItem, public AvailabilityRenderer

{
public:
    DownloadFile( KListView *parent, int file )
	: InfoItem(parent,file)
	, AvailabilityRenderer(file) {}
    ~DownloadFile() {}

    QString text( int column ) const;
    double numeric( int col ) const;
    bool isNumeric(int col) const;

    virtual void paintCell(QPainter* p, const QColorGroup& cg, int col, int w, int align);
    virtual int width(const QFontMetrics& fm, const QListView* lv, int c) const;
};

class DownloadedFile : public InfoItem

{
public:
    DownloadedFile( KListView *parent, int file ) : InfoItem(parent,file) {}
    ~DownloadedFile() {}

    QString text( int column ) const;
    double numeric( int col ) const;
    bool isNumeric(int col) const;

};


class ServerInfoItem : public InfoItem

{
public:
    ServerInfoItem( KListView *parent, int server ) : InfoItem(parent,server) {}
    ~ServerInfoItem() {}

    QString text( int column ) const;
    double numeric( int col ) const;
    bool isNumeric(int col) const;

    virtual void paintCell(QPainter* p, const QColorGroup& cg, int col, int w, int align);
};

class SharedFile : public InfoItem

{
public:
    SharedFile( KListView *parent, int share ) : InfoItem(parent,share) {}
    ~SharedFile() {}

    QString text( int column ) const;
    double numeric( int col ) const;
    bool isNumeric(int col) const;

};

class ClientItem : public InfoItem

{
public:
    ClientItem( KListView *parent, int client ) : InfoItem(parent,client) { filesListed = false; }
    ~ClientItem() {}

    QString text( int column ) const;

    virtual void paintCell(QPainter* p, const QColorGroup& cg, int col, int w, int align);

    void setFilesListed(bool listed);

private:
    bool filesListed;
};

class ResultInfo;

class ClientFile : public InfoItem
{
public:
    ClientFile(KListView* parent, int file) : InfoItem(parent, file) {}
    ~ClientFile() {}

    QString text(int column) const;
    double numeric( int col ) const;
    bool isNumeric(int col) const;
};

QString humanReadableSize(int64 rsz);
QString humanReadableSpeed(double sp);
QString calculateETA(FileInfo* fi);
QString humanReadablePriority(int pri);

#endif
