/* -*- c++ -*-
 *
 * $Id: infodialog.h,v 1.6 2003/06/28 21:17:00 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: infodialog.h,v $
 * Revision 1.6  2003/06/28 21:17:00  gibreel
 * The file info dialog now displays file sources. Libkmldonkey received a
 * number of updates and bugfixes to facilitate this.
 *
 * Revision 1.5  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 * Revision 1.4  2003/06/09 18:10:23  gibreel
 * Configurable availability display colours. Extended the DCOP interface and
 * improved the interaction between the GUI and the applet. Added colour for
 * the download list's queued state. Cleanups, bugfixes all round.
 *
 * Revision 1.3  2003/05/11 20:02:26  gibreel
 * Added some missing fields to the info dialog.
 *
 * Revision 1.2  2003/05/01 17:09:37  gibreel
 * File info dialog keeps and updates a percentage in the window caption.
 *
 * Revision 1.1  2003/04/13 17:59:46  gibreel
 * File info dialog and coloured availability bars.
 *
 */

#ifndef __kmldonkey_infodialog_h__
#define __kmldonkey_infodialog_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>
#include <klineedit.h>
#include <ktextbrowser.h>

#include "availability.h"
#include "infolist.h"

class QColorGroup;
class ClientList;

class FileInfoDialog : public KDialogBase
{
    Q_OBJECT
public:
    FileInfoDialog(int file);

protected slots:
    void saveSize();
    void updateFile(int file);
    void updateCaption(FileInfo* fi);

private:
    int fileno;

    KLineEdit *nameView, *sizeView, *hashView, *formatView,
	*totalSizeView, *etaView, *speedView, *networkView;
    KTextBrowser *namesView;
    AvailabilityWidget* availView;
    ClientList* clientList;

};

#endif // __kmldonkey_infodialog_h__
