/* -*- c++ -*-
 *
 * $Id: downloadpage.h,v 1.3 2003/07/27 20:24:26 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: downloadpage.h,v $
 * Revision 1.3  2003/07/27 20:24:26  gibreel
 * Added KActions for switching between pages.
 *
 * Revision 1.2  2003/06/30 14:59:22  gibreel
 * Updated lists to support libkmldonkey's new removed signals. Moved pages'
 * connect statements out of KMLDonkey's constructor into their own
 * constructors. Added a debug console displaying dumps of unhandled messages.
 *
 * Revision 1.1  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 */

#ifndef __kmldonkey_downloadpage_h__
#define __kmldonkey_downloadpage_h__

#include <qobject.h>
#include <qvbox.h>
#include <qintdict.h>

#include "clipboard.h"
#include "page.h"

class QSplitter;
class KActionCollection;

class InfoList;

class DownloadPage : public QVBox, public KMLDonkeyPage, public ClipboardHelper
{
    Q_OBJECT
public:
    DownloadPage(QWidget* parent = 0);

    virtual void setupActions(KActionCollection*);

    virtual void applyPreferences(KMLDonkeyPreferences* prefs = 0);
    virtual void saveState(KConfig* conf);
    virtual void restoreState(KConfig* conf);

    virtual void clear();

    InfoList* downloadView;
    InfoList* downloadedView;

public slots:
    void fileUpdated(int fn);
    void fileRemoved(int fn);

    // Download actions
    void actionPauseFile();
    void actionResumeFile();
    void actionCancelFile();
    void actionFilePriorityVeryLow();
    void actionFilePriorityLow();
    void actionFilePriorityNormal();
    void actionFilePriorityHigh();
    void actionFilePriorityVeryHigh();
    void actionRenameFile();
    void renameFile(int fileno, QString& name);
    void actionRetryConnect();
    void actionPreviewFile();
    void actionVerifyFile();
    void actionGetFileFormat();
    void actionFileInformation();
    void actionFileCopyURL();
    void actionFileCopyHash();
    void actionFileCopyHTML();

    // Complete actions
    void actionCommitFile();
    void actionCommitFileAs();
    void commitFileAs(int fileno, QString& name);
    void actionCompleteCopyURL();
    void actionCompleteCopyHash();
    void actionCompleteCopyHTML();

    void actionActivatePage();

protected slots:
    void contextDownload(KListView*, QListViewItem*, const QPoint&);
    void contextDownloaded(KListView*, QListViewItem*, const QPoint&);
    void downloadDoubleClick(QListViewItem*, const QPoint&, int);

protected:
    void copyFileToClipboard(ClipFormat format);
    void copyCompleteToClipboard(ClipFormat format);
    void setFilePriority(int);


private:
    QSplitter* downloadSplitter;

    QIntDict<DownloadFile> downloadFileList;
    QIntDict<DownloadedFile> downloadedFileList;
};

#endif
