/* -*- c++ -*-
 *
 * $Id: consolepage.h,v 1.3 2003/07/27 20:24:26 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: consolepage.h,v $
 * Revision 1.3  2003/07/27 20:24:26  gibreel
 * Added KActions for switching between pages.
 *
 * Revision 1.2  2003/07/19 13:13:42  gibreel
 * Extended URL regexp, and added code to keep from inserting multiple hr's
 * when trying to stay connected to a core that's gone away.
 *
 * Revision 1.1  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 */

#ifndef __kmldonkey_consolepage_h__
#define __kmldonkey_consolepage_h__

#include <qobject.h>
#include <qvbox.h>

#include "page.h"

class KMLDonkeyPreferences;
class KTextBrowser;
class KLineEdit;

class ConsolePage : public QVBox, public KMLDonkeyPage
{
    Q_OBJECT
public:
    ConsolePage(QWidget* parent = 0);

    virtual void setupActions(KActionCollection*);

    virtual void applyPreferences(KMLDonkeyPreferences* = 0);
    virtual void clear();

public slots:
    void consoleMessage(const QString& msg);
    void sendConsoleMessage(const QString&);

    void actionActivatePage();

private:
    KTextBrowser* consoleView;
    KLineEdit* consoleEntry;
    bool alreadyClear;
};

#endif
