/*
 * $Id: colorselector.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: colorselector.h,v $
 * Revision 1.1  2003/05/30 11:53:00  dipesh
 * Optional colored Downloadlist
 *
 *
 */

#ifndef __kmldonkey_colorselector_h__
#define __kmldonkey_colorselector_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qfont.h>
#include <qhbox.h>
#include <ksqueezedtextlabel.h>
#include <kpushbutton.h>

class ColorSelector : public QHBox
{
    Q_OBJECT
public:
    ColorSelector(QWidget* parent, const QString caption, const char* name);

    QColor& getColor();
    void setColor(QColor& col);

protected slots:
    void selectColor();

private:
    KSqueezedTextLabel* preview;
    KPushButton* chooseButton;
    QColor color;
};

#endif // __kmldonkey_colorselector_h__
