/* -*- c++ -*-
 *
 * $Id: closabletab.h,v 1.2 2003/07/19 14:18:22 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: closabletab.h,v $
 * Revision 1.2  2003/07/19 14:18:22  gibreel
 * Uses KTabWidget instead of QTabWidget/ClosableTabWidget if available (KDE
 * 3.2 or CVS). ClosableTabWidget API changed to match KTabWidget's.
 *
 * Revision 1.1  2003/05/12 00:21:11  gibreel
 * Added a close button to the search result tabs.
 *
 */

#ifndef __kmldonkey_closabletab_h__
#define __kmldonkey_closabletab_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qtabbar.h>
#include <qtabwidget.h>

class ClosableTabBar : public QTabBar
{
    Q_OBJECT

public:
    ClosableTabBar(QWidget *parent = 0, const char *name = 0);

signals:
    void iconPressed();

protected:
    void mouseReleaseEvent(QMouseEvent *e);

private:
    bool withinIcon(const QTab * t, const QPoint & point);

};

class ClosableTabWidget : public QTabWidget 
{
    Q_OBJECT

public:
    ClosableTabWidget(QWidget *parent = 0, const char *name = 0);

    virtual void addTab(QWidget* child, const QIconSet& iconset, const QString& label);

signals:
    void closeRequest(QWidget*);
    void sigCurrentChanged(QWidget*);

public slots:
    void slotCurrentChanged(QWidget*);
    void slotIconPressed();

};

#endif // __kmldonkey_closabletab_h__
