/* -*- c++ -*-
 *
 * $Id: clipboard.cpp,v 1.1 2003/06/19 21:50:45 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: clipboard.cpp,v $
 * Revision 1.1  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 */

#include <qclipboard.h>
#include <kapplication.h>

#include "clipboard.h"

void ClipboardHelper::copyToClipboard(QStringList& values, ClipFormat format)
{
    QClipboard* clip = KApplication::clipboard();
    QStringList out;
    for ( QStringList::Iterator it = values.begin(); it != values.end(); ++it ) {
        QString name = *it;
        ++it;
        QString hash = *it;
        ++it;
        QString size = *it;
        switch (format) {
        case Hash:
            out.append(hash);
            break;
        case URL:
            out.append("ed2k://|file|" + name + "|" + size + "|" + hash + "|/");
            break;
        case HTML:
            out.append("<a href=\"ed2k://|file|" + name + "|" + size + "|" + hash + "|/\">" + name + "</a>");
            break;
        default:
            break;
        }
    }
    clip->setText(out.join("\n"), QClipboard::Selection);
}

