/* -*- c++ -*-
 *
 * $Id: clientlist.h,v 1.3 2003/06/30 23:30:35 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: clientlist.h,v $
 * Revision 1.3  2003/06/30 23:30:35  gibreel
 * Preliminary friend list support. A ton of updates to the libkmldonkey API to
 * accommodate this, most notably improvements to the search handling
 * necessitated by mldonkey's somewhat awkward reporting of friend shares.
 *
 * Revision 1.2  2003/06/30 14:59:22  gibreel
 * Updated lists to support libkmldonkey's new removed signals. Moved pages'
 * connect statements out of KMLDonkey's constructor into their own
 * constructors. Added a debug console displaying dumps of unhandled messages.
 *
 * Revision 1.1  2003/06/28 21:56:27  gibreel
 * Adding before committing is always a good idea.
 *
 */

#ifndef __kmldonkey_clientlist_h__
#define __kmldonkey_clientlist_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <klistview.h>

#include "availability.h"

class SourceItem;

class ClientList : public KListView
{
    Q_OBJECT

public:

    ClientList(int file, QWidget* parent = 0, const char* name = 0);

public slots:

    void fileSourceUpdated(int fileno, int source);
    void fileSourceRemoved(int fileno, int source);
    void clientUpdated(int client);
    void clientRemoved(int client);
    void contextSource(KListView*, QListViewItem* item, const QPoint& pt);

protected slots:

    void addToFriends();

private:

    int fn;
    QIntDict<SourceItem> sources;

};

class SourceItem : public KListViewItem, public AvailabilityRenderer
{
public:
    SourceItem(ClientList* parent, int fileno, int clientno);

    int fileNo() const;
    int clientNo() const;

    virtual QString text(int column) const;

    virtual void paintCell(QPainter* p, const QColorGroup& cg, int col, int w, int align);
    virtual int width(const QFontMetrics& fm, const QListView* lv, int c) const;

private:
    int fn, cn;
};


#endif // __kmldonkey_clientlist_h__
