/* -*- c++ -*-
 *
 * $Id: availability.h,v 1.4 2003/06/28 21:17:00 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: availability.h,v $
 * Revision 1.4  2003/06/28 21:17:00  gibreel
 * The file info dialog now displays file sources. Libkmldonkey received a
 * number of updates and bugfixes to facilitate this.
 *
 * Revision 1.3  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 * Revision 1.2  2003/06/09 18:10:23  gibreel
 * Configurable availability display colours. Extended the DCOP interface and
 * improved the interaction between the GUI and the applet. Added colour for
 * the download list's queued state. Cleanups, bugfixes all round.
 *
 * Revision 1.1  2003/04/13 17:59:46  gibreel
 * File info dialog and coloured availability bars.
 *
 */

#ifndef __kmldonkey_availability_h__
#define __kmldonkey_availability_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qframe.h>
#include <qcolor.h>
#include <qpalette.h>
#include <donkeyprotocol.h>

class AvailabilityRenderer
{
public:
    AvailabilityRenderer(int file);
    AvailabilityRenderer(int file, int source);
    FileInfo* fileInfo();
    int chunks() const;

protected:
    void paintAvailability(QPainter& p, QRect& r);
    int rfileno, clno, chunkNo;
    bool isClientRenderer;

private:
    void paintChunk(QPainter& p, QRect& r, int chunk);
    void updateFileInfo();
};

class AvailabilityWidget : public QFrame, public AvailabilityRenderer
{
    Q_OBJECT
public:
    AvailabilityWidget(int file, QWidget* parent = 0, const char* name = 0, bool frame = true);

    QSizePolicy sizePolicy() const;
    QSize minimumSizeHint() const;

protected:
    void paintEvent(QPaintEvent*);

};

#include <fileinfo.h>


#endif // __kmldonkey_availability_h__
