/* -*- c++ -*-
 *
 * mmconnection.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_mobilemule_mmconnection_h__
#define __kmldonkey_mobilemule_mmconnection_h__

#include "mmpacket.h"

#include <qobject.h>
#include <qcstring.h>
#include <qhttp.h>

class KExtendedSocket;
class MMServer;

class MMConnection : public QObject
{
    Q_OBJECT

public:
    MMConnection(KExtendedSocket* sock, MMServer* parent);
    ~MMConnection();

    void sendPacket(const MMPacket& p);
    void sendPacket(MMPacket* p);

protected:
    void processBuffer();
    void httpError(int err, const QString& msg);

signals:
    void processMessage(MMConnection* sender, MMPacket* p);

protected slots:
    void readData();
    void socketClosed(int);

private:
    void discardBuffer();
    void discardBuffer(uint len);

    MMServer* m_server;
    KExtendedSocket* m_sock;
    QByteArray m_inbuf;
};

#endif
