/* -*- c++ -*-
 *
 * searchinfo.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __libkmldonkey_searchinfo_h__
#define __libkmldonkey_searchinfo_h__

#include <qstring.h>
#include <qstringlist.h>
#include <qvariant.h>
#include <qintdict.h>

#include "donkeytypes.h"

class DonkeyMessage;

//! Representation of a search result.

class ResultInfo
{
public:
    ResultInfo(DonkeyMessage* msg);
    ResultInfo(const ResultInfo&);
    ~ResultInfo();

    //! The numerical ID of the result.
    int resultNo() const;
    //! The file name of the result.
    const QString& resultName() const;
    //! Alternative file names found on the network.
    const QStringList& resultNames() const;
    //! The size of the result in bytes.
    int32 resultSize() const;
    //! The numerical ID of the network the file was found on.
    int32 resultNetwork() const;
    //! The file format of the result.
    const QString& resultFormat() const;
    //! Result tags.
    const QMap<QString,QVariant>& resultTags() const;
    //! A comment found for the result.
    const QString& resultComment() const;
    //! The MD4 hash of the result.
    const QByteArray& resultMD4() const;
    //! Returns true if this file has already been downloaded.
    bool resultAlreadyDone() const;

private:
    int32 num;
    int32 net;
    QString name;
    QStringList names;
    QByteArray md4;
    int32 size;
    QString format;
    QString t;
    QMap<QString,QVariant> tags;
    QString comment;
    bool already_done;
};

class SearchInfo
{
public:
    SearchInfo(int id);

    int searchNo() const;
    const QIntDict<ResultInfo>& searchResults() const;

    void addResult(ResultInfo* result);

private:
    int32 num;
    QIntDict<ResultInfo> results;
};

#endif
