/* -*- c++ -*-
 *
 * preview.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include <qlayout.h>
#include <qlabel.h>
#include <qcursor.h>
#include <qhbox.h>

#include <kdebug.h>
#include <klocale.h>
#include <kmimetype.h>
#include <ktrader.h>
#include <klibloader.h>
#include <kapplication.h>
#include <ktoolbar.h>
#include <kxmlguifactory.h>

#include "preview.h"
#include "preview.moc"



PreviewWidget::PreviewWidget(const KURL& url, const QString& realName, QWidget* parent, const char* name)
    : QWidget(parent, name)
    , KXMLGUIBuilder(this)
    , m_url(url)
    , m_name(realName)
{
    layout = new QVBoxLayout(this);
    part = 0;
    na = 0;

    toolbarContainer = new QHBox(this);
    toolbarContainer->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    layout->addWidget(toolbarContainer);

    fac = new KXMLGUIFactory(this, this, "preview_factory");

    loading = new QLabel(i18n("Loading preview component..."), this);
    loading->setAlignment(Qt::AlignCenter);
    layout->addWidget(loading);
}

PreviewWidget::~PreviewWidget()
{
    if (part) {
	/*
	KActionPtrList foo(part->actionCollection()->actions());
	KActionPtrList::iterator it;
	for (it = foo.begin(); it != foo.end(); ++it) {
	    KAction* action = *it;
	    if (action->isPlugged(toolbar)) {
		kdDebug() << "Unplugging action name \"" << action->name() << "\" label \"" << action->text() << "\"" << endl;
		action->unplug(toolbar);
	    }
	}
	*/
	delete part;
    }
}

void PreviewWidget::loadPlayer()
{
    if (loading) {
	delete loading;
	loading = 0;
    }

    if (part) {
	delete part;
	part = 0;
    }

    if (na) {
	delete na;
	na = 0;
    }

    KApplication::setOverrideCursor(QCursor(Qt::WaitCursor));

    KMimeType::Ptr mimeType = KMimeType::findByURL(KURL("file:/" + m_name));
    KTrader::OfferList offers = KTrader::self()->query(mimeType->property("Name").toString(),
						       "'KParts/ReadOnlyPart' in ServiceTypes");
    KService::Ptr ptr = offers.first();
    if (!ptr) {
	na = new QLabel(i18n("No display component available for %1").arg(mimeType->property("Name").toString()), this);
	na->setAlignment(Qt::AlignCenter);
	layout->addWidget(na);
	na->show();
	KApplication::restoreOverrideCursor();
	return;
    }

    KLibFactory *factory = KLibLoader::self()->factory( ptr->library().local8Bit() );
    if (!factory) {
	na = new QLabel(i18n("Error loading display component for %1").arg(mimeType->property("Name").toString()), this);
	na->setAlignment(Qt::AlignCenter);
	layout->addWidget(na);
	na->show();
	KApplication::restoreOverrideCursor();
	return;
    }

    kdDebug() << "For mime type " << mimeType->property("Name").toString() << ": loading part " << ptr->name() << endl;
    part = static_cast<KParts::ReadOnlyPart*>(factory->create(this, ptr->name().local8Bit(), "KParts::ReadOnlyPart"));
    layout->addWidget(part->widget());
    part->widget()->show();
    part->openURL(m_url);

    fac->addClient(part);

    QPtrList<QWidget> bar = fac->containers("toolbar");
    QPtrListIterator<QWidget> flarp(bar);
    kdDebug() << "These are the toolbar widgets found:" << endl;
    for (; flarp.current(); ++flarp) {
	kdDebug() << "  Toolbar widget: \"" << (*flarp)->name() << "\"" << endl;
	(*flarp)->reparent(toolbarContainer, QPoint(), true);
    }

    bar = fac->containers("menubar");
    QPtrListIterator<QWidget> wombat(bar);
    kdDebug() << "These are the menu bar widgets found:" << endl;
    for (; wombat.current(); ++wombat) {
	kdDebug() << "  Menu bar widget: \"" << (*wombat)->name() << "\"" << endl;
	(*wombat)->hide();
    }

    KApplication::restoreOverrideCursor();
}

void PreviewWidget::showEvent(QShowEvent* event)
{
    QWidget::showEvent(event);
    if (loading) loadPlayer();
}
