/* -*- c++ -*-
 *
 * statspage.cpp
 *
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include <qlabel.h>
#include <qvbox.h>
#include <qcheckbox.h>
#include <qtimer.h>

#include <kdebug.h>
#include <klocale.h>
#include <kconfig.h>
#include <kaction.h>

#include "kmldonkey.h"
#include "prefs.h"
#include "statspagerates.h"
#include "statspageclients.h"
#include "statspageovernet.h"
#include "statspagegnutella.h"

#include "statspage.h"
#include "statspage.moc"

StatsPage::StatsPage(QWidget *parent)
    : QTabWidget(parent, "statsPage")
    , KMLDonkeyPage()
{
    tabpos = 2;
    setMargin(6);

    // Rates
    ratespage = new StatsPageRates(this);

    ratespage->statswidget->setStatEnable("tdl", true);
    ratespage->statswidget->setStatColor("tdl", Qt::blue);

    ratespage->statswidget->setStatEnable("tul", true);
    ratespage->statswidget->setStatColor("tul", Qt::red);

    addTab(ratespage, i18n("Rates"));

    // other optional pages, handled at show()
    clientspage = 0;
    overnetpage = 0;
    gnutellapage = 0;

    connect(KMLDonkey::App->donkey, SIGNAL(optionsUpdated()), this, SLOT(updatePages()));

    /*TODO
    cs
    upstats : statistics on upload
    version : print mldonkey version
    mem_stats : print memory stats
    vu : view upload credits
    id : print ID on connected servers
    dump_reliability : display the reliability of sources
    */
}

void StatsPage::setupActions(KActionCollection*)
{
}

void StatsPage::configurePrefsDialog(KMLDonkeyPreferences *prefs)
{
    prefs->generalPage->enableStatsCheckbox->setChecked(enabled);
}

void StatsPage::applyPreferences(KMLDonkeyPreferences *prefs)
{
    if (prefs) {
        if (enabled == prefs->generalPage->enableStatsCheckbox->isChecked()) return;
        enabled = prefs->generalPage->enableStatsCheckbox->isChecked();
    }

    /*TODO: handle insertTab/removePage in KMLDonkey
    if(parent() && parent()->parent()) {
        QTabWidget *w = dynamic_cast<QTabWidget*>(parent()->parent());
        if(w) {
            if(enabled) {
                w->insertTab(this, i18n("Statistics"), tabpos);
            }
            else {
                tabpos = w->indexOf(this);
                w->removePage(this);
            }
        }
    }
    */

    if (enabled) {
        connect(KMLDonkey::App->donkey, SIGNAL(clientStats(int64, int64, int64, int, int, int, int, int, int, int, QMap<int,int>)),
                this, SLOT(updateStatus(int64, int64, int64, int, int, int, int, int, int, int, QMap<int,int>)));
    }
    else {
        disconnect(KMLDonkey::App->donkey, SIGNAL(clientStats(int64, int64, int64, int, int, int, int, int, int, int, QMap<int,int>)),
                   this, SLOT(updateStatus(int64, int64, int64, int, int, int, int, int, int, int, QMap<int,int>)));
    }
}

void StatsPage::saveState(KConfig *conf)
{
    conf->setGroup("Stats");
    conf->writeEntry("Enabled", enabled);
}

void StatsPage::restoreState(KConfig *conf)
{
    conf->setGroup("Stats");
    enabled = conf->readBoolEntry("Enabled", false);
    applyPreferences();
}

void StatsPage::clear()
{
    //rateStats->clear();
    updatePages();
}


void StatsPage::actionActivatePage()
{
    KMLDonkey::App->activatePage(this);
}

void StatsPage::show()
{
    QTabWidget::show();
    updatePages();
}

void StatsPage::updateStatus(int64, int64, int64, int, int tul, int tdl, int, int, int, int, QMap<int,int>)
{
    if (ratespage) {
        ratespage->statswidget->addStatValue("tdl", (long)tdl);
        ratespage->statswidget->addStatValue("tul", (long)tul);
    }
}

void StatsPage::updatePages()
{
    bool enableOvernet = false;
    bool enableGnutella = false;

    if (KMLDonkey::App->donkey->isConnected()) {
        enableOvernet  = ( KMLDonkey::App->donkey->getOption("enable_overnet") == "true" );
        enableGnutella = ( KMLDonkey::App->donkey->getOption("enable_gnutella") == "true" ||
                           KMLDonkey::App->donkey->getOption("enable_gnutella2") == "true" );
    }

    // Clients
    if (KMLDonkey::App->donkey->isConnected()) {
        if (! clientspage && isVisible()) {
            clientspage = new StatsPageClients(this);
            addTab(clientspage, i18n("Clients"));
        }
    }
    else if (clientspage) {
        delete clientspage;
        clientspage = 0;
    }

    // Overnet
    if (enableOvernet) {
        if (! overnetpage && isVisible()) {
            overnetpage = new StatsPageOvernet(this);
            addTab(overnetpage, "Overnet");
        }
    }
    else if (overnetpage) {
        delete overnetpage;
        overnetpage = 0;
    }

    // Gnutella
    if (enableGnutella) {
        if (! gnutellapage && isVisible()) {
            gnutellapage = new StatsPageGnutella(this);
            addTab(gnutellapage, "Gnutella");
        }
    }
    else if (gnutellapage) {
        delete gnutellapage;
        gnutellapage = 0;
    }
}
