/* -*- c++ -*-
 *
 * debugpage.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include <klocale.h>
#include <ktextbrowser.h>

#include <donkeyprotocol.h>

#include "kmldonkey.h"
#include "debugpage.h"
#include "debugpage.moc"

DebugPagePlugin::DebugPagePlugin(KMLDonkey* app, QWidget* parent, const char* name)
    : KMLDonkeyPlugin(app, parent, name)
{
}

QString DebugPagePlugin::pluginName()
{
    return "debugPage";
}

QString DebugPagePlugin::pluginTitle()
{
    return i18n("Debug Page");
}

QString DebugPagePlugin::pluginIcon()
{
    return "debug";
}

QString DebugPagePlugin::pluginDescription()
{
    return i18n("A debug page which provides hex dumps of any core messages "
		"libkmldonkey doesn't know how to handle.");
}

KMLDonkeyPage* DebugPagePlugin::addPage(QWidget* parent)
{
    DebugPage* dpage = new DebugPage(m_app, parent);
    KMLDonkeyPage* page = static_cast<KMLDonkeyPage*>(dpage);
    if (page) return page;
    delete dpage;
    return 0;
}



DebugPage::DebugPage(KMLDonkey* app, QWidget* parent)
    : QVBox(parent, "debugPage")
    , KMLDonkeyPage()
{
    m_app = app;
    debugView = new KTextBrowser(this, "debugView");
    debugView->setFocusPolicy(QTextBrowser::ClickFocus);
    debugView->setTextFormat(QTextBrowser::PlainText);

    connect(m_app->donkey, SIGNAL(unhandledMessage(const DonkeyMessage*)),
	    this, SLOT(write(const DonkeyMessage*)));
}

void DebugPage::clear()
{
}

void DebugPage::applyPreferences(KMLDonkeyPreferences*)
{
    debugView->setFont(m_app->consoleFont);
}

void DebugPage::write(const DonkeyMessage* msg)
{
    debugView->append(msg->dumpArray());
}

void DebugPage::write(const QString& msg)
{
    debugView->append(msg);
}

