/* -*- c++ -*-
 *
 * friendpage.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_friendpage_h__
#define __kmldonkey_friendpage_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>
#include <qvbox.h>
#include <qdict.h>
#include <qintdict.h>

#include <searchinfo.h>

#include "clipboard.h"
#include "page.h"

#include <kdeversion.h>

class KActionCollection;
class KTextBrowser;
class KLineEdit;

class KMLDonkeyPreferences;
class InfoList;
class ClientFile;

#if KDE_IS_VERSION(3,1,90)
class KTabWidget;
#else
class ClosableTabWidget;
#endif

class FriendShares
{
public:
    QMap<QString,QValueList<int> > dirs;
};

class ChatWidget : public QWidget
{
    Q_OBJECT
public:
    ChatWidget(int client, QWidget* parent = 0);

public slots:
    void messageFromClient(int client, const QString& message);

protected slots:
    void messageEntered(const QString& message);

private:
    void setupChatWidget(int client);

    int clno;
    KTextBrowser* output;
    KLineEdit* input;
};

class FriendPage : public QVBox, public KMLDonkeyPage, public ClipboardHelper
{
    Q_OBJECT
public:
    FriendPage(QWidget* parent = 0);

    virtual void setupActions(KActionCollection*);
    virtual QStringList supportedGenericActions();
    virtual void handleGenericAction(const QString&);
    virtual void plugGenericActions(QObject*, const char*);
    virtual void deactivatePageActions();

    virtual void applyPreferences(KMLDonkeyPreferences* prefs = 0);
    virtual void saveState(KConfig* conf);
    virtual void restoreState(KConfig* conf);

    virtual void clear();

signals:
    void genericActionsChanged(KMLDonkeyPage*);

public slots:
    void friendUpdated(int client);
    void friendRemoved(int client);

protected slots:
    void closeAllFileLists();
    void openFileList(int client);
    void closeFileList(QWidget*);

    void openFriendFiles(QListViewItem* item);

    void contextFriend(KListView*,QListViewItem*,const QPoint&);
    void contextFile(KListView*,QListViewItem*,const QPoint&);

    void actionAddFriend();
    void actionRemoveFriend();
    void actionRemoveAllFriends();
    void actionConnectFriend();
    void actionOpenChat();

    void fileDoubleClick(QListViewItem*);
    void actionDownload();
    void actionForceDownload();
    void actionDownloadAs();

    void actionActivatePage();

    void receiveShare(int clno, const QString& dir, int result);

    void mightUpdateShareList();

    void pleaseUpdateActions();

    void messageReceived(int client, const QString& message);
    void closeChat(QWidget*);

private:
    void constructFileList(int clno);
    QPtrList<QListViewItem> currentFileListSelection();
    void downloadSelected(bool force, bool ask);
    void copyFileToClipboard(ClipFormat format);

    QSplitter *friendVSplitter, *friendHSplitter;
    InfoList *friendView;
#if KDE_IS_VERSION(3,1,90)
    KTabWidget* fileTab;
    KTabWidget* chatTab;
#else
    ClosableTabWidget* fileTab;
    ClosableTabWidget* chatTab;
#endif

    QIntDict<ChatWidget> chats;
    QIntDict<InfoList> fileViews;

    QIntDict<ClientItem> friendList;
    QIntDict<FriendShares> shares;

    QMap<int,bool> pleaseUpdateShareList;

    QPtrList<KAction> friendActions, shareActions;
    KAction* m_removeAllAction;
    KAction* m_chatAction;
};

#endif
