/* -*- c++ -*-
 *
 * consolepage.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include <qstylesheet.h>
#include <qregexp.h>

#include <klocale.h>
#include <ktextbrowser.h>
#include <klineedit.h>
#include <kaction.h>

#include <donkeyprotocol.h>

#include "version.h"
#include "kmldonkey.h"
#include "consolepage.h"
#include "consolepage.moc"

ConsolePage::ConsolePage(QWidget* parent)
    : QVBox(parent, "consolePage")
    , KMLDonkeyPage()
{
    alreadyClear = true;

    consoleView = new KTextBrowser(this, "consoleView");
    consoleView->setFocusPolicy(QTextBrowser::ClickFocus);
    consoleView->setTextFormat(QTextBrowser::RichText);
    consoleView->setLinkUnderline(true);

    consoleView->append(QString("<b>KMLDonkey ") + KMLDONKEY_VERSION + "</b>, Copyright  2003-2004 Petter E. Stokke and Sebastian Sauer");
    consoleView->append(QString("<p>This program is free software; you can redistribute it and/or modify "
                                "it under the terms of the GNU General Public License as published by "
                                "the Free Software Foundation; either version 2 of the License, or "
                                "(at your option) any later version.</p>"
                                "<p>This program is distributed in the hope that it will be useful, "
                                "but WITHOUT ANY WARRANTY; without even the implied warranty of "
                                "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
                                "GNU General Public License for more details.</p>"
                                "<p>You should have received a copy of the GNU General Public License "
                                "along with this program; if not, write to the Free Software "
                                "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA</p><hr>"));

    consoleEntry = new KLineEdit(this, "consoleEntry");
    connect(consoleEntry, SIGNAL(returnPressed(const QString&)),
	    consoleEntry->completionObject(), SLOT(addItem(const QString&)));
    connect(consoleEntry, SIGNAL(returnPressed(const QString&)),
            this, SLOT(sendConsoleMessage(const QString&)));

    connect(KMLDonkey::App->donkey, SIGNAL(consoleMessage(const QString&)), this, SLOT(consoleMessage(const QString&)));
}

void ConsolePage::clear()
{
    if (!alreadyClear) {
	consoleView->append("<hr>");
	alreadyClear = true;
    }
}

void ConsolePage::applyPreferences(KMLDonkeyPreferences*)
{
    consoleView->setFont(KMLDonkey::App->consoleFont);
}

void ConsolePage::setupActions(KActionCollection* actionCollection)
{
    (void)new KAction(i18n("Activate Console Page"), 0, 0, this, SLOT(actionActivatePage()),
		      actionCollection, "activate_page_console");
}

void ConsolePage::consoleMessage(const QString& msg)
{
    alreadyClear = false;

    QString txt = QStyleSheet::escape(msg);

    QRegExp rxurl("[^\">]((https|http|ftp|news)://[\\w\\.\\-\\_/~?=&%;:@+$,!*'\\(\\)\\|\\^\\[\\]\\`\\{\\}]+)");
    int pos = 0;
    QString url;
    while ((pos = rxurl.search(txt, pos)) >= 0) {
        url = rxurl.cap(1);
        txt.replace(pos + 1, url.length(), "<a href=\"" + url + "\">" + url + "</a>");
    }

    if (txt.startsWith("\n+--"))
        txt = "<b>" + txt + "</b>";
    else if (txt.startsWith("CORRUPTION DETECTED"))
        txt = "<p><b>" + txt + "</b></p>";

    txt.replace(QRegExp("\n(?!$)"), "<br>");

    consoleView->append(txt);
}

void ConsolePage::sendConsoleMessage(const QString& txt)
{
    alreadyClear = false;

    QString foo = "<p><b>" + txt + "</b></p>";
    consoleView->append(foo);
    consoleEntry->clear();
    foo = txt;
    KMLDonkey::App->donkey->sendConsoleMessage(foo);
}

void ConsolePage::actionActivatePage()
{
    KMLDonkey::App->activatePage(this);
}

