/* -*- c++ -*-
 *
 * infoiface.h
 *
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __libkmldonkey_infoiface_h__
#define __libkmldonkey_infoiface_h__

#include <qobject.h>
#include <qvariant.h>
#include <qintdict.h>

class InfoInterface
{
public:
    InfoInterface() {}
    ~InfoInterface() {}

    QVariant getProperty(const QString& key) {
        return properties[key];
    }
    QVariant getProperty(const QString& key, const QVariant defaultproperty) {
        return hasProperty(key) ? properties[key] : defaultproperty;
    }
    bool hasProperty(const QString& key) {
        return properties.contains(key);
    }
    void setProperty(const QString& key, const QVariant property) {
        properties.replace(key, property);
    }
    void removeProperty(const QString& key) {
        properties.remove(key);
    }

    const QMap<QString, QVariant> getProperties() {
        return properties;
    }
    void setProperties(const QMap<QString, QVariant> p) {
        properties = p;
    }
    void clearProperties() {
        properties.clear();
    }

protected:
    QMap<QString, QVariant> properties;
};

typedef QIntDict<InfoInterface*> InfoDict;
typedef QMap<QString, InfoDict> InfoMap;

#endif
