/* -*- c++ -*-
 *
 * donkeyhost.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "donkeyhost.h"
//#include "donkeyhost.moc" // don't know why the hell I got compile errors there again?!

DonkeyHost::DonkeyHost(const QString& h_name, const QString& h_address,
		       int h_telnetPort, int h_guiPort,
		       const QString& h_username, const QString& h_password,
		       const bool h_local, const KURL& temp, const KURL& incoming)
    : HostInterface(h_name, h_address, h_guiPort)
    , m_username(h_username)
    , m_password(h_password)
    , m_telnetPort(h_telnetPort)
    , m_temp(temp)
    , m_incoming(incoming)
{
    /*HostInterface::*/setType( h_local ? typeLocal : typeRemote );
}

DonkeyHost::DonkeyHost(DonkeyHost& host)
    : HostInterface()
{
    /*HostInterface::*/setName(host.name());
    /*HostInterface::*/setAddress(host.address());
    /*HostInterface::*/setPort(host.guiPort());
    m_telnetPort = host.telnetPort();
    m_username = host.username();
    m_password = host.password();
    m_temp = host.tempDirectory();
    m_incoming = host.incomingDirectory();
}

DonkeyHost::DonkeyHost()
    : HostInterface()
    , m_telnetPort(0)
{
}

const int DonkeyHost::telnetPort() const { return m_telnetPort; }
const QString& DonkeyHost::username() const { return m_username; }
const QString& DonkeyHost::password() const { return m_password; }
const KURL& DonkeyHost::tempDirectory() const { return m_temp; }
const KURL& DonkeyHost::incomingDirectory() const { return m_incoming; }
