/* -*- c++ -*-
 *
 * prefs.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include <kglobal.h>
#include <kconfig.h>
#include <klocale.h>
#include <kdebug.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qgroupbox.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include <kpushbutton.h>
#include <kfontdialog.h>
#include <kfontcombo.h>
#include <kiconloader.h>
#include <knuminput.h>
#include <kcharsets.h>
#include <kmessagebox.h>
#include <kstdguiitem.h>

#include "prefs.h"
#include "prefs.moc"


#include <qscrollview.h>

ColorSelector::ColorSelector(QWidget* parent, const char* name, const QString caption, const QString tooltip)
    : QHBox(parent, name)
{
    QLabel* label = new QLabel(caption, this);
    button = new KColorButton(this, "colorButton");
    label->setBuddy(button);
    QToolTip::add(this, tooltip);
}

const QColor ColorSelector::color()
{
    return button->color();
}

void ColorSelector::setColor(const QColor &color)
{
    button->setColor(color);
}



KMLDonkeyPrefRenamerPage::KMLDonkeyPrefRenamerPage(QWidget *parent)
    : QVBox(parent)
{
    enableAutorenameCheckbox = new QCheckBox(i18n("&Enable automatic renaming of downloading files"), this);
    QToolTip::add(enableAutorenameCheckbox, i18n("Should downloading files be automatically renamed according to the search and replace list?"));
    connect(enableAutorenameCheckbox, SIGNAL(toggled(bool)), this, SLOT(enableAutorename(bool)));

    renlisteditor = new AutoRenamerListEditor(this);
}

void KMLDonkeyPrefRenamerPage::enableAutorename(bool on)
{
    renlisteditor->setEnabled(on);
}

KMLDonkeyPrefColorPage::KMLDonkeyPrefColorPage(QWidget *parent)
    //: QTabWidget(parent)
    : QVBox(parent)
{
    coloredListsCheckbox = new QCheckBox(this);
    coloredListsCheckbox->setText(i18n("&Colored list"));
    QToolTip::add(coloredListsCheckbox, i18n("Colorize items in the lists according to their status"));
    connect(coloredListsCheckbox, SIGNAL(toggled(bool)), this, SLOT(coloredLists(bool)));

    QScrollView *scroll = new QScrollView(this);
    scroll->setResizePolicy(QScrollView::AutoOneFit);
    scroll->viewport()->setBackgroundMode(PaletteBackground);

    QVBox *box = new QVBox();
    box->setSpacing(6);
    box->setMargin(11);
    scroll->addChild(box);
    //scroll->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
    //scroll->setMinimumSize(scroll->sizeHint());

    QVBoxLayout *layout;

    // Server
    grpServer = new QGroupBox(i18n("Server"), box);
    layout = new QVBoxLayout(grpServer, 20);

    colorServerNotConnected = new ColorSelector(grpServer, "colorNotConnected", i18n("&Not connected:"), i18n("Color for disconnected servers") );
    colorServerBlacklisted = new ColorSelector(grpServer, "colorBlacklisted", i18n("&Blacklisted:"), i18n("Color for blacklisted servers") );
    colorServerConnecting = new ColorSelector(grpServer, "colorConnecting", i18n("Connectin&g:"), i18n("Color for connecting or initiating servers") );
    colorServerConnected = new ColorSelector(grpServer, "colorConnected", i18n("C&onnected:"), i18n("Color for connected servers") );

    layout->addWidget( colorServerNotConnected );
    layout->addWidget( colorServerBlacklisted );
    layout->addWidget( colorServerConnecting );
    layout->addWidget( colorServerConnected );

    // Search
    grpSearch = new QGroupBox(i18n("Search"), box);
    layout = new QVBoxLayout(grpSearch, 20);

    colorSearchFewSources = new ColorSelector(grpSearch, "colorFewSources", i18n("&Few sources:"), i18n("The color indicating few sources") );
    colorSearchManySources = new ColorSelector(grpSearch, "colorManySources", i18n("&Many sources:"), i18n("The color indicating many sources") );
    colorSearchAlreadyDone = new ColorSelector(grpSearch, "colorAlreadydone", i18n("&Already done:"), i18n("Color for already downloaded sources") );

    QHBox *srtBox = new QHBox(grpSearch);
    new QLabel(i18n("&Threshold:"), srtBox);
    searchSourcesThresholdSlider = new KIntNumInput(srtBox, "searchSourcesThreshold");
    searchSourcesThresholdSlider->setRange(2, 100, 10, true);
    QToolTip::add(searchSourcesThresholdSlider, i18n("The number of sources that will produce the full 'many sources' color"));

    layout->addWidget( colorSearchFewSources );
    layout->addWidget( colorSearchManySources );
    layout->addWidget( colorSearchAlreadyDone );
    layout->addWidget( srtBox );

    // Downloaded
    grpDown = new QGroupBox(i18n("Downloaded"), box);
    layout = new QVBoxLayout(grpDown, 20);

    downloadingColorSelect = new ColorSelector(grpDown, "colorDownloading", i18n("&Downloading:"), i18n("Color for active downloads (receiving data)") );
    lookingColorSelect = new ColorSelector(grpDown, "colorLooking", i18n("&Looking:"), i18n("Color for inactive downloads (looking for sources)") );
    queuedColorSelect = new ColorSelector(grpDown, "colorQueued", i18n("&Queued:"), i18n("Color for queued downloads") );
    pausedColorSelect = new ColorSelector(grpDown, "colorPaused", i18n("&Paused:"), i18n("Color for paused downloads") );

    layout->addWidget( downloadingColorSelect );
    layout->addWidget( lookingColorSelect );
    layout->addWidget( queuedColorSelect );
    layout->addWidget( pausedColorSelect );

    // Availability
    grpAvail = new QGroupBox(i18n("Availability"), box);
    layout = new QVBoxLayout(grpAvail, 20);

    fewSourcesColorSelect = new ColorSelector(grpAvail, "colorFewSources", i18n("&Few sources:"), i18n("The color indicating few sources") );
    manySourcesColorSelect = new ColorSelector(grpAvail, "colorManySources", i18n("&Many sources:"), i18n("The color indicating many sources") );
    completeColorSelect = new ColorSelector(grpAvail, "colorComplete", i18n("&Complete:"), i18n("The color indicating a complete chunk") );
    noSourcesColorSelect = new ColorSelector(grpAvail, "colorNoSources", i18n("&No sources:"), i18n("The color indicating no sources found"));

    QHBox *avtBox = new QHBox(grpAvail);
    new QLabel(i18n("&Threshold:"), avtBox);
    availabilityThresholdSlider = new KIntNumInput(avtBox, "availabilityThreshold");
    availabilityThresholdSlider->setRange(2, 100, 10, true);
    QToolTip::add(availabilityThresholdSlider, i18n("The number of sources that will produce the full 'many sources' color"));

    layout->addWidget( fewSourcesColorSelect );
    layout->addWidget( manySourcesColorSelect );
    layout->addWidget( completeColorSelect );
    layout->addWidget( noSourcesColorSelect );
    layout->addWidget( avtBox );

    // Sources
    grpSources = new QGroupBox(i18n("Sources"), box);
    layout = new QVBoxLayout(grpSources, 20);

    colorSourceNotConnected = new ColorSelector(grpSources, "colorNotConnected", i18n("&Not connected:"), i18n("Color for disconnected sources") );
    colorSourceBlacklisted = new ColorSelector(grpSources, "colorBlacklisted", i18n("&Blacklisted:"), i18n("Color for blacklisted sources") );
    colorSourceConnecting = new ColorSelector(grpSources, "colorConnecting", i18n("Connectin&g:"), i18n("Color for connecting or initiating sources") );
    colorSourceQueued = new ColorSelector(grpSources, "colorQueued", i18n("&Queued:"), i18n("Color for queued sources") );
    colorSourceDownloading = new ColorSelector(grpSources, "colorDownloading", i18n("&Downloading:"), i18n("Color for sources being downloaded from") );

    layout->addWidget( colorSourceNotConnected );
    layout->addWidget( colorSourceBlacklisted );
    layout->addWidget( colorSourceConnecting );
    layout->addWidget( colorSourceQueued );
    layout->addWidget( colorSourceDownloading );

    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
    setMinimumSize(sizeHint());
}

void KMLDonkeyPrefColorPage::coloredLists(bool on)
{
    grpServer->setEnabled(on);
    grpSearch->setEnabled(on);
    grpDown->setEnabled(on);
    grpSources->setEnabled(on);
}

KMLDonkeyPrefFontPage::KMLDonkeyPrefFontPage(QWidget *parent)
    : QFrame(parent)
{
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
    QGridLayout *layout = new QGridLayout(this, 3, 2, 6);

    layout->addWidget(new QLabel(i18n("Console font:"), this), 0, 0);
    consoleFontSelect = new FontSelector(this, "consoleFontSelect", true);
    QToolTip::add(consoleFontSelect, i18n("Font used for the console"));
    layout->addWidget(consoleFontSelect, 0, 1);

    layout->addWidget(new QLabel(i18n("List font:"), this), 1, 0);
    listFontSelect = new FontSelector(this, "listFontSelect");
    QToolTip::add(listFontSelect, i18n("Font used for the lists"));
    layout->addWidget(listFontSelect, 1, 1);

    setMinimumSize(sizeHint());
}

KMLDonkeyPreferences::KMLDonkeyPreferences(QWidget* parent)
    : KDialogBase(IconList, i18n("KMLDonkey Preferences"),
                  Help|Ok|Apply|Cancel, Ok, parent) // |Default
{
    KIconLoader* icons = KGlobal::iconLoader();

    generalPage = new KMLDonkeyPrefGeneralPage((QWidget*) addVBoxPage(i18n("General"), i18n("General Configuration"), icons->loadIcon("configure", KIcon::Desktop)) );
    listsPage = new KMLDonkeyPrefListsPage((QWidget*) addVBoxPage(i18n("Lists"), i18n("List Configuration"), icons->loadIcon("view_detailed", KIcon::Desktop)) );
    searchPage = new KMLDonkeyPrefSearchPage((QWidget*) addVBoxPage(i18n("Search"), i18n("Search Configuration"), icons->loadIcon("find", KIcon::Desktop)) );
    renamerPage = new KMLDonkeyPrefRenamerPage((QWidget*) addVBoxPage(i18n("Autorename"), i18n("Autorename Configuration"), icons->loadIcon("filesaveas", KIcon::Desktop)) );
    colorPage = new KMLDonkeyPrefColorPage( (QWidget*) addVBoxPage(i18n("Colors"), i18n("Color Configuration"), icons->loadIcon("colors", KIcon::Desktop)) );
    fontPage = new KMLDonkeyPrefFontPage((QWidget*) addVBoxPage(i18n("Fonts"), i18n("Font Configuration"), icons->loadIcon("fonts", KIcon::Desktop)) );

    generalPage->initPage();

    setInitialSize(configDialogSize("PrefsDialog"));
    connect(this, SIGNAL(finished()), this, SLOT(saveSize()));

    showPage(0);
}

void KMLDonkeyPreferences::saveSize()
{
    saveDialogSize("PrefsDialog");
}

