// Kinetophone_vox_config.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_VOX_CONFIG_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_VOX_CONFIG_HPP_

#include <string>

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error_param;
    class Speech_synthesizer_config;
  }

  namespace Kinetophone_app
  {
    // Helper struct to store vox application settings.
    // It is a struct instead of a class since it primarily only
    // aggregates various data
    struct Kinetophone_vox_config
    {
    public:
      // constructor/destructor/copy
      Kinetophone_vox_config();
      Kinetophone_vox_config(const Kinetophone_vox_config& config);
      Kinetophone_vox_config& operator=(const Kinetophone_vox_config& config);
      virtual ~Kinetophone_vox_config();
      // typedef
      // structure members
      std::string help_message;
      std::string image_source_path;
      struct Vox_generation_struct
      {
        Vox_generation_struct();
        std::string input_session_file;
        std::string output_session_file;
        bool input_session_file_is_PDF;
        bool quiet;
        bool verbose;
        bool skip_generate_warnings;
        bool overwrite_output_session_file;
        bool output_empty_slides;
      } vox_generation;
      bool detailed_error;
      bool quit_on_pregenerate_warnings;
      std::string custom_installation_dir;
      Roan_trail::Kinetophone::Speech_synthesizer_config* speech_synthesizer_config;
      // command class constants
      static const int command_error          = 0;
      static const int command_synthesize     = 1;
      static const int command_help           = 2;
      static const int command_output_version = 4;
      //
      int parse_program_options(int argc,
                                const char** argv,
                                Roan_trail::Kinetophone::Error_param& return_error);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_VOX_CONFIG_HPP_
