// Scaled_image_widget.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_SCALED_IMAGE_WIDGET_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_SCALED_IMAGE_WIDGET_HPP_

#include <gtkmm/widget.h>
#include <kinetophone/View.hpp>

namespace Gdk
{
  class Pixbuf;
  class Rectangle;
  class Window;
}

namespace Glib
{
  template <class T> class RefPtr;
}

namespace Gtk
{
  class Widget;
}

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error_param;
    class View;
  }

  namespace Kinetophone_app
  {
    class Scaled_image_widget : public Roan_trail::Kinetophone::View, public Gtk::Widget
    {
    public:
      // constructor/destructor
      Scaled_image_widget();
      virtual ~Scaled_image_widget();
      // view update
      virtual bool update(Roan_trail::Kinetophone::Error_param& return_error);
      // accessors/mutators
      const Gdk::Rectangle& image_rect() const { return m_image_rect; };
      void set_image(const Glib::RefPtr<Gdk::Pixbuf>& image);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
      // signal handlers
      virtual void on_size_request(Gtk::Requisition* return_requisition);
      virtual void on_size_allocate(Gtk::Allocation& allocation);
      virtual bool on_expose_event(GdkEventExpose* event);
      virtual void on_map();
      virtual void on_unmap();
      virtual void on_realize();
      virtual void on_unrealize();
      //
      Glib::RefPtr<Gdk::Window> m_ref_window;
      Gdk::Rectangle m_image_rect;
      Glib::RefPtr<Gdk::Pixbuf> m_image;
      Glib::RefPtr<Gdk::Pixbuf> m_scaled_image;
    private:
      bool m_widget_sized;
      // prevent compiler from generating
      Scaled_image_widget(const Scaled_image_widget& fraction_bar);
      Scaled_image_widget& operator=(const Scaled_image_widget& fraction_bar);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_SCALED_IMAGE_WIDGET_HPP_
