// Kinetophone_narrator_window.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_NARRATOR_WINDOW_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_NARRATOR_WINDOW_HPP_

#include <gtkmm/window.h>

namespace Gtk
{
  class AspectFrame;
  class Button;
  class ComboBoxText;
  class HButtonBox;
  class Image;
  class InfoBar;
  class Label;
  class MenuItem;
  class Statusbar;
  class TextView;
  class ToggleButton;
  class ToggleToolButton;
  class ToolButton;
  class ToolItem;
  class Widget;
}


namespace Roan_trail
{
  namespace Kinetophone_app
  {
    class Fraction_bar_widget;
    class Kinetophone_narrator_config;
    class Level_meter_widget;
    class Scaled_image_widget;

    class Kinetophone_narrator_window : public Gtk::Window
    {
    public:
      // constructor/destructor/copy
      explicit Kinetophone_narrator_window(const Kinetophone_narrator_config& config);
      ~Kinetophone_narrator_window();
      // commands
      void setup() { m_setup = true; }
      // widgets
      //   standard
      Gtk::ToolButton* retake_tool_button() { return m_retake_tool_button; }
      Gtk::ToolButton* previous_tool_button() { return m_previous_tool_button; }
      Gtk::ToolButton* next_tool_button() { return m_next_tool_button; }
      Gtk::ToggleToolButton* mute_toggle_tool_button() { return m_mute_toggle_tool_button; }
      Gtk::ToggleToolButton* pause_toggle_tool_button() { return m_pause_toggle_tool_button; }
      Gtk::ToggleToolButton* record_toggle_tool_button() { return m_record_toggle_tool_button; }
      Gtk::ComboBoxText* slide_combo_box_text() { return m_slide_combo_box_text; }
      Gtk::ToggleButton* level_toggle_button() { return m_level_toggle_button; }
      Gtk::MenuItem* file_export_session_menu_item() { return m_file_export_session_menu_item; }
      Gtk::MenuItem* file_quit_menu_item() { return m_file_quit_menu_item; }
      Gtk::MenuItem* edit_cut_menu_item() { return m_edit_cut_menu_item; }
      Gtk::MenuItem* edit_copy_menu_item() { return m_edit_copy_menu_item; }
      Gtk::MenuItem* edit_paste_menu_item() { return m_edit_paste_menu_item; }
      Gtk::MenuItem* help_about_menu_item() { return m_help_about_menu_item; }
      Gtk::InfoBar* session_info_bar() { return m_session_info_bar; }
      Gtk::Label* session_info_label() { return m_session_info_label; }
      Gtk::Label* space_time_label() { return m_space_time_label; }
      Gtk::Statusbar* statusbar() { return m_statusbar; }
      Gtk::AspectFrame* image_aspectframe() { return m_image_aspectframe; }
      Gtk::Label* record_time_label() { return m_record_time_label; }
      Gtk::TextView* notes_text_view() { return m_notes_text_view; }
      Gtk::Button* notes_editing_done_button() { return m_notes_editing_done_button; }
      Gtk::HButtonBox* thumbnail_browser_hbutton_box() { return m_thumbnail_browser_hbutton_box; }
      //   custom
      Level_meter_widget* audio_level_meter_widget() { return m_audio_level_meter_widget; }
      Fraction_bar_widget* space_available_widget() { return m_space_available_widget; }
      Scaled_image_widget* slide_image_widget() { return m_slide_image_widget; }
      Gtk::Image* record_icon_start() { return m_record_icon_start; }
      Gtk::Image* record_icon_stop() { return m_record_icon_stop; }
      Gtk::Image* record_icon() { return m_record_icon; }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      bool m_setup;
      // widgets
      //   standard
      Gtk::ToolButton* m_retake_tool_button;
      Gtk::ToolButton* m_previous_tool_button;
      Gtk::ToolButton* m_next_tool_button;
      Gtk::ToggleToolButton* m_mute_toggle_tool_button;
      Gtk::ToggleToolButton* m_pause_toggle_tool_button;
      Gtk::ToggleToolButton* m_record_toggle_tool_button;
      Gtk::ComboBoxText* m_slide_combo_box_text;
      Gtk::ToggleButton* m_level_toggle_button;
      Gtk::MenuItem* m_file_export_session_menu_item;
      Gtk::MenuItem* m_file_quit_menu_item;
      Gtk::MenuItem* m_edit_cut_menu_item;
      Gtk::MenuItem* m_edit_copy_menu_item;
      Gtk::MenuItem* m_edit_paste_menu_item;
      Gtk::MenuItem* m_help_about_menu_item;
      Gtk::InfoBar* m_session_info_bar;
      Gtk::Label* m_session_info_label;
      Gtk::Label* m_space_time_label;
      Gtk::Statusbar* m_statusbar;
      Gtk::AspectFrame* m_image_aspectframe;
      Gtk::Label* m_record_time_label;
      Gtk::TextView* m_notes_text_view;
      Gtk::Button* m_notes_editing_done_button;
      Gtk::HButtonBox* m_thumbnail_browser_hbutton_box;
      //   custom
      Level_meter_widget *m_audio_level_meter_widget;
      Fraction_bar_widget *m_space_available_widget;
      Scaled_image_widget* m_slide_image_widget;
      //   icon
      Gtk::Image* m_record_icon_start;
      Gtk::Image* m_record_icon_stop;
      Gtk::Image* m_record_icon;
      // window setup functions
      void mf_setup(const Kinetophone_narrator_config& config);
      Gtk::Widget* mf_setup_menu_bar();
      Gtk::Widget* mf_setup_control_toolbar();
      Gtk::Widget* mf_setup_session_info_bar();
      Gtk::Widget* mf_setup_viewer();
      Gtk::Widget* mf_setup_accessories(const Kinetophone_narrator_config& config);
      Gtk::Widget* mf_setup_thumbnail_browser();
      Gtk::Widget* mf_setup_statusbar();
      void mf_setup_accelerators();
      // prevent compiler from generating
      Kinetophone_narrator_window(const Kinetophone_narrator_window& w);
      Kinetophone_narrator_window& operator=(const Kinetophone_narrator_window& w);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_NARRATOR_WINDOW_HPP_
