// Kinetophone_narrator_error_dialog.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_NARRATOR_ERROR_DIALOG_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_NARRATOR_ERROR_DIALOG_HPP_

#include <gtkmm/dialog.h>

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error;
  }

  namespace Kinetophone_app
  {
    class Kinetophone_narrator_error_dialog : public Gtk::Dialog
    {
    public:
      // constructor/destructor
      Kinetophone_narrator_error_dialog(const Roan_trail::Kinetophone::Error& dialog_error,
                                        Window& parent,
                                        bool is_warning = false);
      virtual ~Kinetophone_narrator_error_dialog();
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      void mf_setup_widgets(const Roan_trail::Kinetophone::Error& dialog_eror, bool is_warning);
      // prevent compiler from generating
      Kinetophone_narrator_error_dialog(const Kinetophone_narrator_error_dialog& level_meter);
      Kinetophone_narrator_error_dialog& operator=(const Kinetophone_narrator_error_dialog& level_meter);
    };
  }
}

#endif // ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_NARRATOR_ERROR_DIALOG_HPP_
