// Kinetophone_narrator_error_dialog.cpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include "Kinetophone_narrator_error_dialog.hpp"

// include *mm first to avoid conflicts
#include <gdkmm/drawable.h>
#include <gdkmm/general.h>
#include <gtkmm/alignment.h>
#include <gtkmm/box.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/expander.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/stock.h>

#include <kinetophone/common.hpp>
#include <kinetophone/error/Error.hpp>
#include <string>

using Gtk::Alignment;
using Gtk::ButtonBox;
using Gtk::Expander;
using Gtk::HBox;
using Gtk::Image;
using Gtk::Label;
using Gtk::VBox;
using std::string;
using Roan_trail::Kinetophone::Error;
using namespace Roan_trail::Kinetophone_app;

//
// Internal constants
//

namespace
{
  const int ic_default_border = 5;
  const int ic_dialog_vbox_spacing = 14;
  const int ic_description_padding = 10;
  const int ic_action_area_spacing = 6;
}

// Note: The GType name will be gtkmm__CustomObject_Kinetophone_narrator_error_dialog
//
// Note: This shows the GType name, which must be used in the RC file.
// shown with  std::cout << "GType name: " << G_OBJECT_TYPE_NAME(gobj()) << std::endl;
//
// Note: This show that the GType still derives from GtkWidget:
// std::cout << "Gtype is a GtkWidget?:" << GTK_IS_WIDGET(gobj()) << std::endl;

Kinetophone_narrator_error_dialog::Kinetophone_narrator_error_dialog(const Error& dialog_error,
                                                                     Window& parent,
                                                                     bool is_warning)
  : ObjectBase("Kinetophone_narrator_error_dialog"),
    Dialog(is_warning ? "Kinetophone Narrator Warning" : "Kinetophone Narrator Error",
           parent,
           true,
           true)
{
  mf_setup_widgets(dialog_error, is_warning);

  postcondition(mf_invariant(false));
}

Kinetophone_narrator_error_dialog::~Kinetophone_narrator_error_dialog()
{
  precondition(mf_invariant(false));
}

//
// Protected member functions
//

bool Kinetophone_narrator_error_dialog::mf_invariant(bool check_base_class) const
{
  static_cast<void>(check_base_class); // avoid unused warning

  bool return_value = false;

  return_value = true;

  goto exit_point;

 exit_point:
  return return_value;
}

//
// Private member functions
//

void Kinetophone_narrator_error_dialog::mf_setup_widgets(const Error& dialog_error, bool is_warning)
{
  set_border_width(ic_default_border);
  set_resizable(false);

  VBox* dialog_vbox = get_vbox();
  dialog_vbox->set_spacing(ic_dialog_vbox_spacing);
  HBox* main_hbox = manage(new HBox);
  main_hbox->set_border_width(ic_default_border);
  dialog_vbox->pack_start(*main_hbox, Gtk::PACK_SHRINK);

  // dialog image
  Alignment* dialog_image_alignment = manage(new Alignment);
  dialog_image_alignment->set_padding(0, 0, 0, ic_default_border);
  main_hbox->pack_start(*dialog_image_alignment, Gtk::PACK_SHRINK);
  Image* dialog_image = manage(new Image((is_warning ? Gtk::Stock::DIALOG_WARNING
                                          : Gtk::Stock::DIALOG_ERROR),
                                         Gtk::ICON_SIZE_DIALOG));
  dialog_image->set_alignment(0.5, 0.0);
  dialog_image_alignment->add(*dialog_image);
  VBox* message_vbox = manage(new VBox);
  main_hbox->pack_start(*message_vbox);

  // fill in message fields
  const Error::Error_dictionary& error_dictionary = dialog_error.error_dictionary();
  //   brief description
  Error::Error_dictionary::const_iterator brief_description_search
    = error_dictionary.find(Error::brief_description_error_key);
  string brief_description;
  if (error_dictionary.end() != brief_description_search)
  {
    brief_description = brief_description_search->second;
  }
  else
  {
    brief_description = "Unknown error.";
  }
  Alignment *brief_description_alignment = manage(new Alignment);
  brief_description_alignment->set_padding(0, ic_description_padding, 0, 0);
  message_vbox->pack_start(*brief_description_alignment, false, false);
  Label *brief_description_label = manage(new Label(brief_description, 0.0, 0.0));
  int brief_description_base_size = brief_description_label->get_style()->get_font().get_size();
  Pango::FontDescription brief_description_font_description;
  brief_description_font_description.set_weight(Pango::WEIGHT_BOLD);
  brief_description_font_description.set_size(brief_description_base_size * Pango::SCALE_LARGE);
  brief_description_label->modify_font(brief_description_font_description);
  brief_description_label->set_line_wrap(true);
  brief_description_label->set_selectable(true);
  brief_description_alignment->add(*brief_description_label);
  //   recovery description
  Error::Error_dictionary::const_iterator recovery_description_search
    = error_dictionary.find(Error::recovery_description_error_key);
  if (error_dictionary.end() != recovery_description_search)
  {
    Alignment *recovery_description_alignment = manage(new Alignment);
    recovery_description_alignment->set_padding(0, ic_description_padding, 0, 0);
    message_vbox->pack_start(*recovery_description_alignment, Gtk::PACK_SHRINK);
    string recovery_description = recovery_description_search->second;
    Label *recovery_description_label = manage(new Label(recovery_description));
    recovery_description_label->set_line_wrap(true);
    recovery_description_label->set_selectable(true);
    recovery_description_alignment->add(*recovery_description_label);
  }
  //   detailed description
  Error::Error_dictionary::const_iterator detailed_description_search
    = error_dictionary.find(Error::detailed_description_error_key);
  if (error_dictionary.end() != detailed_description_search)
  {
    Alignment *details_alignment = manage(new Alignment);
    details_alignment->set_padding(0, ic_description_padding, 0, 0);
    message_vbox->pack_start(*details_alignment, Gtk::PACK_SHRINK);
    Expander* details_expander = manage(new Expander("_Details"));
    details_expander->set_use_underline();
    string detailed_description = detailed_description_search->second;
    details_alignment->add(*details_expander);
    Label *detailed_description_label = manage(new Label(detailed_description));
    detailed_description_label->set_line_wrap(true);
    detailed_description_label->set_selectable(true);
    details_expander->add(*detailed_description_label);
  }

  ButtonBox* action_area = get_action_area();
  action_area->set_border_width(ic_default_border);
  action_area->set_spacing(ic_action_area_spacing);

  show_all_children();
}
