// Kinetophone_narrator_app.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_NARRATOR_APP_HPP_
#define ROAN_TRAIL_KINETOPHONE_APP_KINETOPHONE_NARRATOR_APP_HPP_

#include <kinetophone/Application.hpp>
#include <string>

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Error_param;
  }

  namespace Kinetophone_app
  {
    class Kinetophone_narrator_config;
    class Kinetophone_narrator_model;
    class Kinetophone_narrator_controller;
    class Kinetophone_narrator_view;

    class Kinetophone_narrator_app : public Roan_trail::Kinetophone::Application
    {
    public:
      // Constructor/destructor/copy
      Kinetophone_narrator_app(int argc, const char** argv);
      virtual ~Kinetophone_narrator_app();
      //
      virtual int run();
      virtual void terminate(int code, const std::string& message);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Kinetophone_narrator_config* m_config;
      Kinetophone_narrator_model *m_model;
      //
      void mf_connect_signals(Kinetophone_narrator_controller& controller,
                              Kinetophone_narrator_view& view);
      bool mf_narrate(Roan_trail::Kinetophone::Error_param& return_error);
      bool mf_run_GUI(Roan_trail::Kinetophone::Error_param& return_error);
      // prevent compiler from generating
      Kinetophone_narrator_app(const Kinetophone_narrator_app& app);
      Kinetophone_narrator_app& operator=(const Kinetophone_narrator_app& app);
    };
  }
}

#endif // KINETOPHONE_NARRATOR_APP_HPP_
